/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.thread;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;

public class ThreadCatcher
extends Thread {
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(ThreadCatcher.class);
    public static final int MAX_FOLDERS_TDUMP_TO_KEEP = 3;
    public static final String DUMP_FILENAME_PREFIX = "ThreadDump_";
    public static final String THREAD_DUMP_FILE_EXT = ".tdump";
    private final String label;
    private final long timeout;
    private final long startAtLong;
    private Long finishedAt;
    private final Long id;
    private static final Map<String, Long> idSequences = new HashMap<String, Long>();
    private static Boolean habilitado;
    private static final Thread monitorThread;
    protected static final String LOG_PREFIX_PATH = "logs";
    protected static final String LOG_FOLDER_TDUMPS = "tdumps";
    public static final int THREAD_DUMP_INTERVAL = 15000;
    private static String currentPID;

    public static String getCurrentPID() {
        if (currentPID == null) {
            currentPID = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        }
        return currentPID;
    }

    private ThreadCatcher(String label, Long timeout, Long id) {
        this.label = label;
        this.timeout = timeout;
        this.finishedAt = null;
        this.startAtLong = System.currentTimeMillis();
        this.id = id;
    }

    public static synchronized boolean getHabilitado() {
        return BooleanUtils.isTrue(habilitado);
    }

    public static synchronized Long getNewId(String label) {
        Long newId = idSequences.get(label) == null ? 1L : 1L + idSequences.get(label);
        idSequences.put(label, newId);
        return newId;
    }

    public boolean isFinished() {
        return this.finishedAt != null;
    }

    public String getLabel() {
        return this.label;
    }

    public long getStartAtLong() {
        return this.startAtLong;
    }

    static ThreadCatcher getInstance(String label, Long timeout) {
        return new ThreadCatcher(label, timeout, ThreadCatcher.getNewId(label));
    }

    Thread createMonitorThread() {
        return new Thread(() -> {
            File pidTCFile = null;
            while (true) {
                try {
                    while (true) {
                        if (ThreadCatcher.getHabilitado()) {
                            if (pidTCFile == null) {
                                pidTCFile = ThreadCatcher.buildFileNameAndCreateFolders();
                            }
                            ThreadCatcher.saveThreadDumpToFile(pidTCFile);
                        }
                        ThreadCatcher threadCatcher = this;
                        synchronized (threadCatcher) {
                            this.wait(15000L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (IOException e) {
                    logger.debug((Object)"Monitor de thread dump falha em logar", e);
                    continue;
                }
                break;
            }
        });
    }

    public static void saveThreadDumpToFile(File pidTCFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(pidTCFile, false));
        writer.write(ThreadCatcher.getThreadsDump().toString());
        writer.close();
    }

    public static File buildFileNameAndCreateFolders() {
        Date dateToday = Calendar.getInstance().getTime();
        File tdumpFolder = new File(Paths.get(LOG_PREFIX_PATH, LOG_FOLDER_TDUMPS).toString());
        File dayFolder = new File(Paths.get(tdumpFolder.getPath(), new SimpleDateFormat("yyyyMMdd").format(dateToday)).toString());
        File pidTCFile = new File(ThreadCatcher.buildFileName(dateToday, dayFolder));
        if (!tdumpFolder.exists()) {
            logger.debug("Cria\u00e7\u00e3o de pasta do thread thump realizada={}", tdumpFolder.mkdirs());
        }
        if (!dayFolder.exists()) {
            logger.debug("Remo\u00e7\u00e3o de pastas antigas de thread dumps realizada na integra={}", ThreadCatcher.removeOldThreadDumpFiles(tdumpFolder));
            logger.debug("Cria\u00e7\u00e3o de pasta do thread thump do dia atual={}", dayFolder.mkdir());
        }
        return pidTCFile;
    }

    static String buildFileName(Date dateToday, File dayFolder) {
        return Paths.get(dayFolder.getPath(), DUMP_FILENAME_PREFIX + new SimpleDateFormat("yyyyMMddHHmmss").format(dateToday) + "_" + ThreadCatcher.getCurrentPID() + THREAD_DUMP_FILE_EXT).toString();
    }

    public static boolean removeOldThreadDumpFiles(File directory) {
        List<Object> folders = Arrays.asList((Object[])Objects.requireNonNull(directory.listFiles()));
        folders.sort(Comparator.comparing(File::getName));
        boolean rtn = true;
        if (folders.size() >= 3) {
            for (int i = 0; i < folders.size() - 3 + 1; ++i) {
                File folder = (File)folders.get(i);
                for (File file : Objects.requireNonNull(folder.listFiles())) {
                    rtn = rtn && file.delete();
                }
                rtn = rtn && folder.delete();
            }
        }
        return rtn;
    }

    public static synchronized void setHabilitado(Boolean habilitado) {
        ThreadCatcher.habilitado = habilitado;
        if (habilitado.booleanValue() && !monitorThread.isAlive()) {
            logger.debug("Monitor de thread dump iniciado");
            monitorThread.start();
        } else {
            monitorThread.interrupt();
        }
        logger.debug("Log de thread dump " + (habilitado != false ? "ativado" : "desativado"));
    }

    public void logInfoEtapa(String metodo, String etapa) {
        this.logInfoEtapa(metodo, etapa, null);
    }

    public void logInfoEtapa(String metodo, String etapa, Long elapseTime) {
        logger.debug("ThreadCatcher(" + this.label + " #" + this.id + ") -> " + metodo + " - " + etapa + " - timeout: " + this.timeout + (elapseTime != null ? " - tempo usado: " + elapseTime : "") + (this.finishedAt != null ? " - finalizado em : " + (this.finishedAt - this.startAtLong) : ""));
    }

    public static synchronized ThreadCatcher start(String label, Long timeWaitingInMiliSeconds) {
        ThreadCatcher threadCatcher = new ThreadCatcher(label, timeWaitingInMiliSeconds, ThreadCatcher.getNewId(label));
        if (ThreadCatcher.getHabilitado()) {
            threadCatcher.logInfoEtapa("construtor", "criado o objeto");
            try {
                threadCatcher.setPriority(10);
                threadCatcher.start();
                return threadCatcher;
            }
            catch (IllegalThreadStateException e) {
                logger.debug((Object)"N\u00e3o foi possivel lan\u00e7ar a thread do ThreadCatcher", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.logInfoEtapa("start", "run iniciado antes do lock com prioridade " + this.getPriority());
            ThreadCatcher threadCatcher = this;
            synchronized (threadCatcher) {
                if (!this.isFinished()) {
                    this.logInfoEtapa("start", "wait");
                    this.wait(this.timeout);
                    this.notifyAll();
                }
                long elapsedTime = this.finishedAt != null ? this.finishedAt - this.startAtLong : System.currentTimeMillis() - this.startAtLong;
                boolean toMuchSlow = elapsedTime > this.timeout;
                this.logInfoEtapa("start", "liberado do wait", elapsedTime);
                if (this.finishedAt == null) {
                    this.logInfoEtapa("start", "imprimindo o thread dump");
                    logger.debug(ThreadCatcher.getThreadsDump().toString());
                } else {
                    this.logInfoEtapa("start", "finalizado corretamente " + (toMuchSlow ? "porem depois do tempo esperado" : ""));
                }
                this.logInfoEtapa("start", "final");
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalMonitorStateException e) {
            logger.debug((Object)"Erro no salvamento das threads", e);
        }
    }

    public synchronized void finish() {
        if (ThreadCatcher.getHabilitado()) {
            this.logInfoEtapa("finish", "final");
            this.finishedAt = System.currentTimeMillis();
            try {
                this.notifyAll();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    public static StringBuffer getThreadsDump() {
        StringBuffer threadDump = new StringBuffer(System.lineSeparator());
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        threadDump.append(ThreadCatcher.formatLockedThreadIds(threadMXBean));
        threadDump.append("\r\n");
        for (ThreadInfo threadInfo : threadMXBean.dumpAllThreads(true, true)) {
            threadDump.append(threadInfo.toString());
        }
        return threadDump;
    }

    public static String formatLockedThreadIds(ThreadMXBean threadMXBean) {
        long[] idsArr = threadMXBean.findDeadlockedThreads();
        if (idsArr != null) {
            return "Locked Threads ids: " + Arrays.stream(idsArr).mapToObj(String::valueOf).collect(Collectors.joining(" - "));
        }
        return "N\u00e3o foram encontradas threads em estado LOCKED";
    }

    static {
        monitorThread = ThreadCatcher.getInstance("MonitorTD", 0L).createMonitorThread();
    }
}

