/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.pagseguro;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.EncryptedDataFlags;
import br.com.auttar.util.encrypted.CryptoInput;
import br.com.auttar.util.encrypted.Encrypter;
import br.com.auttar.util.pagseguro.PagSeguroCryptoInput;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoHexaInvalido;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaEncryptBufferEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PagSeguroEncrypter
extends Encrypter {
    protected static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(PagSeguroEncrypter.class);
    private static final int CARD_BIN_SIZE = 6;
    private static final int CARD_HOLDER_SIZE = 4;
    private static PagSeguroEncrypter instance;

    private PagSeguroEncrypter() {
    }

    public static PagSeguroEncrypter getInstance() {
        if (instance == null) {
            instance = new PagSeguroEncrypter();
        }
        return instance;
    }

    @Override
    protected byte[] encryptMethodInitializationVector(CryptoInput pagSeguroCryptoInput) {
        logger.info("Realizando criptografia do m\u00e9todo 2 com IV");
        byte[] pinpadSerialNumberBytes = this.getFirstEightBytes(((PagSeguroCryptoInput)pagSeguroCryptoInput).getPinpadSerialNumber());
        byte[] establishmentLogicalNumberBytes = this.getFirstEightBytes(((PagSeguroCryptoInput)pagSeguroCryptoInput).getEstablishmentLogicalNumber());
        byte[] r1 = this.xor(pinpadSerialNumberBytes, establishmentLogicalNumberBytes);
        byte[] transactionDataBytes = this.getTransactionBytes(((PagSeguroCryptoInput)pagSeguroCryptoInput).getTransactionValue(), pagSeguroCryptoInput.getCardPan());
        return this.xor(r1, transactionDataBytes);
    }

    @Override
    protected void encryptMethod(CryptoInput pagSeguroCryptoInput, PinEMV pin, Cartao card, EntradaApiTefC inputApiTef, int cryptographyType, int masterKeyIndex) throws ExcecaoPerifericos, ExcecaoNaoLocal {
        logger.info("Definindo algoritmo de criptografia");
        byte[] IV = this.encryptMethodInitializationVector(pagSeguroCryptoInput);
        EncryptedDataFlags encryptedDataFlags = new EncryptedDataFlags();
        byte[] result = null;
        if (Cartao.DIGITADO.equals((Object)card)) {
            result = this.encryptPagSeguroMethod2TypedTransaction((PagSeguroCryptoInput)pagSeguroCryptoInput, encryptedDataFlags);
            this.setEncryptedDataFlags(inputApiTef, encryptedDataFlags);
        } else if (!StringUtils.isBlank(pagSeguroCryptoInput.getTrack1Data()) && !StringUtils.isBlank(pagSeguroCryptoInput.getTrack2Data())) {
            result = this.encryptPagSeguroMethod2Trail1And2((PagSeguroCryptoInput)pagSeguroCryptoInput, encryptedDataFlags);
            this.setEncryptedDataFlags(inputApiTef, encryptedDataFlags);
        } else if (!StringUtils.isBlank(pagSeguroCryptoInput.getTrack2Data())) {
            result = this.encryptPagSeguroMethod2Trail2Only((PagSeguroCryptoInput)pagSeguroCryptoInput, encryptedDataFlags);
            this.setEncryptedDataFlags(inputApiTef, encryptedDataFlags);
        }
        if (result == null) {
            throw new ExcecaoNaoLocal("PSE1", "Nao foi possivel montar o bloco de dados PagSeguro.", null);
        }
        SaidaEncryptBufferEMV encryptBufferEmvOutput = this.getSaidaEncryptBufferEMV((BibliotecaPinpad)pin, cryptographyType, masterKeyIndex, IV, result);
        String encryptBuffer = encryptBufferEmvOutput.getDadosCriptografados();
        String keySerialNumber = encryptBufferEmvOutput.getKeySerialNumber();
        inputApiTef.setEncryptedDataBlock(encryptBuffer);
        inputApiTef.setNumeroSerieChaveDadosDUKPT3DES(keySerialNumber);
        inputApiTef.setMetodoCriptografiaDados(cryptographyType);
    }

    protected byte[] encryptPagSeguroMethod2Trail2Only(PagSeguroCryptoInput pagSeguroCryptoInput, EncryptedDataFlags encryptedDataFlags) {
        logger.info("Realizando criptografia de dados para apenas trilha 2");
        try {
            String trail2HexString = ByteUtil.toZonedString(pagSeguroCryptoInput.getTrack2Data());
            String binData = this.getBinData(pagSeguroCryptoInput);
            String data = String.format("%s%s%s", trail2HexString, "23", binData);
            byte[] result = this.PKCSPadding(data);
            encryptedDataFlags.setTrack2(true);
            encryptedDataFlags.setChavePresente(true);
            return result;
        }
        catch (Exception e) {
            logger.error((Object)("Erro ao gerar bloco criptografado com m\u00e9todo 2, trilha 2, para PagSeguro: " + e.getMessage()), e);
            return null;
        }
    }

    protected String returnCodigoCvv2(PagSeguroCryptoInput pagSeguroCryptoInput) {
        return Objects.nonNull(pagSeguroCryptoInput.getCardCvv()) && Objects.nonNull(pagSeguroCryptoInput.getCardCvv().getValor()) ? pagSeguroCryptoInput.getCardCvv().getValor() : "";
    }

    protected byte[] encryptPagSeguroMethod2Trail1And2(PagSeguroCryptoInput pagSeguroCryptoInput, EncryptedDataFlags encryptedDataFlags) {
        logger.info("Realizando criptografia de dados para trilha 1 e 2");
        try {
            String trail1Bytes = ByteUtil.toZonedString(pagSeguroCryptoInput.getTrack1Data());
            String trail2Bytes = ByteUtil.toZonedString(pagSeguroCryptoInput.getTrack2Data());
            String binData = this.getBinData(pagSeguroCryptoInput);
            String data = String.format("%s%s%s%s", trail2Bytes, "23", binData, trail1Bytes);
            byte[] result = this.PKCSPadding(data);
            encryptedDataFlags.setTrack1(true);
            encryptedDataFlags.setTrack2(true);
            encryptedDataFlags.setChavePresente(true);
            return result;
        }
        catch (Exception e) {
            logger.error((Object)("Erro ao gerar bloco criptografado com m\u00e9todo 2, trilha 1 e 2, para PagSeguro: " + e.getMessage()), e);
            return null;
        }
    }

    protected byte[] encryptPagSeguroMethod2TypedTransaction(PagSeguroCryptoInput pagSeguroCryptoInput, EncryptedDataFlags encryptedDataFlags) {
        logger.info("Realizando criptografia de dados para transa\u00e7\u00f5es digitadas");
        try {
            String expireDateBytes = StringUtils.leftPad(ByteUtil.toZonedString(pagSeguroCryptoInput.getCardExpire()), 16, 'F');
            String binData = this.getBinData(pagSeguroCryptoInput);
            String data = String.format("%s%s%s", expireDateBytes, "23", binData);
            byte[] result = this.PKCSPadding(data);
            encryptedDataFlags.setPan(true);
            encryptedDataFlags.setChavePresente(true);
            return result;
        }
        catch (Exception e) {
            logger.error((Object)("Erro ao gerar bloco criptografado com m\u00e9todo 2, transa\u00e7\u00e3o digitada, para PagSeguro: " + e.getMessage()), e);
            return null;
        }
    }

    private void setEncryptedDataFlags(EntradaApiTefC inputApiTef, EncryptedDataFlags encryptedDataFlags) {
        if (inputApiTef != null) {
            inputApiTef.setEncryptedDataFlags(encryptedDataFlags);
        }
    }

    private byte[] xor(byte[] s1, byte[] s2) {
        if (s1.length != s2.length) {
            throw new IllegalArgumentException("Different sizes for parameters in XOR.");
        }
        byte[] result = new byte[s1.length];
        for (int i = 0; i < s1.length; ++i) {
            result[i] = (byte)(s1[i] ^ s2[i]);
        }
        return result;
    }

    private byte[] getFirstEightBytes(String s) {
        String hexString = ByteUtil.toZonedString(s.substring(0, 8));
        assert (hexString.length() == 16);
        byte[] result = new byte[8];
        try {
            result = ByteUtil.hexToByteArray(hexString);
        }
        catch (ExcecaoHexaInvalido excecaoHexaInvalido) {
            logger.warn("N\u00e3o foi poss\u00edvel converter converter para bytes: " + excecaoHexaInvalido.getMessage());
            logger.warn("Dados de entrada: " + hexString);
        }
        assert (result.length == 8);
        return result;
    }

    private byte[] getTransactionBytes(String transactionValue, String cardPan) {
        String transactionValuePadded = StringUtil.completeStringZERO(transactionValue, 10);
        String cardBin = cardPan.substring(0, 6);
        String binData = cardBin.concat(transactionValuePadded);
        assert (binData.length() == 16);
        byte[] binDataBytes = new byte[8];
        try {
            binDataBytes = ByteUtil.hexToByteArray(binData);
        }
        catch (ExcecaoHexaInvalido excecaoHexaInvalido) {
            logger.warn("N\u00e3o foi poss\u00edvel converter os dados da transa\u00e7\u00e3o para bytes: " + excecaoHexaInvalido.getMessage());
        }
        assert (binDataBytes.length == 8);
        return binDataBytes;
    }

    protected String getBinData(PagSeguroCryptoInput pagSeguroCryptoInput) {
        int cardPanSize = pagSeguroCryptoInput.getCardPan().length();
        String cardCvvBytes = StringUtils.leftPad(this.returnCodigoCvv2(pagSeguroCryptoInput), 5, 'F');
        String cardNumber = pagSeguroCryptoInput.getCardPan().substring(6, cardPanSize - 4);
        return StringUtils.rightPad(cardCvvBytes.concat(cardNumber), 16, '0');
    }
}

