/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.pagseguro;

import br.com.auttar.AuttarLogger;
import br.com.auttar.util.encrypted.CryptoInput;
import br.com.auttar.util.encrypted.EncryptedDataExecutor;
import br.com.auttar.util.pagseguro.PagSeguroCryptoInput;
import br.com.auttar.util.pagseguro.PagSeguroEncrypter;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;

public class PagSeguroEncryptedDataExecutor
extends EncryptedDataExecutor {
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(PagSeguroEncryptedDataExecutor.class);
    private static PagSeguroEncryptedDataExecutor instance;

    private PagSeguroEncryptedDataExecutor() {
    }

    public static PagSeguroEncryptedDataExecutor getInstance() {
        if (instance == null) {
            instance = new PagSeguroEncryptedDataExecutor();
        }
        return instance;
    }

    @Override
    public void execute(Process processData) throws ExcecaoPerifericos, ExcecaoNaoLocal {
        logger.info("Iniciando criptografia de dados PagSeguro");
        String establishmentLogicalNumber = Contexto.getContexto().getSaidaApiTefC().getEstablishmentLogicalNumber();
        if (StringUtils.isBlank(establishmentLogicalNumber)) {
            throw new ExcecaoNaoLocal("EDE9", "N\u00e3o foi poss\u00edvel encontrar um n\u00famero l\u00f3gico do estabelecimento v\u00e1lido.", "");
        }
        super.execute(processData);
        CryptoInput cryptoInput = this.cryptoInputBuilder(Contexto.getContexto().getEntradaApiTefC(), processData.getPerifericos().getPinpad(), establishmentLogicalNumber);
        this.encryptData(PagSeguroEncrypter.getInstance(), cryptoInput, processData.getPerifericos().getPinpad(), this.cryptographyType, this.masterKeyIndex);
        logger.info("Criptografia de dados realizada com sucesso");
    }

    @Override
    protected CryptoInput cryptoInputBuilder(EntradaApiTefC entradaApiTefC, PinEMV pin, String establishmentLogicalNumber) throws ExcecaoPerifericos {
        String cardExpiration = "";
        if (entradaApiTefC.getDataVencimento() != null) {
            cardExpiration = new SimpleDateFormat("yyMM").format(entradaApiTefC.getDataVencimento());
        }
        String track2AfterSentinel = "";
        if (entradaApiTefC.getInfo() != null) {
            try {
                track2AfterSentinel = entradaApiTefC.getInfo().split("=")[1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                logger.warn("Trilha 2 n\u00e3o possui caracter sentinela '=': " + e.getMessage());
                logger.warn("Repassando trilha completa para criptografia");
                track2AfterSentinel = entradaApiTefC.getInfo();
            }
        }
        return new PagSeguroCryptoInput(establishmentLogicalNumber, pin.getInfo().getNumSeriePinpad(), entradaApiTefC.getPAN(), entradaApiTefC.getCvv2(), cardExpiration, entradaApiTefC.getValorTransacao().movePointRight(2).toString(), entradaApiTefC.getTrilha1(), track2AfterSentinel);
    }
}

