/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.factories;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.EMVResponseCode;
import br.com.auttar.util.exceptions.PinpadOpenException;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloAbecs;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import org.apache.commons.lang3.ObjectUtils;

public class PinpadDriverFactory {
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(PinpadDriverFactory.class);
    public static final String HANDLER_DEFAULT = "com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhadaC";
    private static GenericPinpadController genericPinpadController;

    public static GenericPinpadController getInstance(String port, boolean openCommunication) throws ExcecaoPerifericos {
        return PinpadDriverFactory.buildDriver(port, ObjectUtils.defaultIfNull(GenericPinpadController.getHandler(), HANDLER_DEFAULT), openCommunication);
    }

    public static GenericPinpadController getInstance(String port) throws ExcecaoPerifericos {
        return PinpadDriverFactory.getInstance(port, true);
    }

    public static void terminateInstance() {
        genericPinpadController = null;
    }

    public static GenericPinpadController buildDriver(String port, String handler, boolean openCommunication) throws ExcecaoPerifericos {
        if (!openCommunication && genericPinpadController != null) {
            logger.info("Pulando validacao do driver de comunicacao com o pinpad.");
            return genericPinpadController;
        }
        try {
            return PinpadDriverFactory.getGenericPinpadController(new ProtocoloAbecs(port, handler), openCommunication);
        }
        catch (PinpadOpenException e) {
            logger.warn("N\u00e3o foi poss\u00edvel estabelecer a comunica\u00e7\u00e3o com pinpad ABECS" + e.getMessage());
            if (e.getOpenResult() != EMVResponseCode.PP_NOSEC.getId().intValue()) {
                throw e;
            }
        }
        catch (ExcecaoPerifericos e) {
            logger.warn(e);
        }
        return PinpadDriverFactory.getGenericPinpadController(new ProtocoloBibliotecaCompartilhada(port, handler), openCommunication);
    }

    private static GenericPinpadController getGenericPinpadController(GenericPinpadController pinpadController, boolean openCommunication) throws ExcecaoPerifericos {
        if (openCommunication) {
            pinpadController.openCommunication();
        }
        genericPinpadController = pinpadController;
        return pinpadController;
    }
}

