/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.encrypted;

import br.com.auttar.model.EncryptedDataFlags;
import br.com.auttar.util.cielo.CieloEncryptedDataExecutor;
import br.com.auttar.util.emv.CryptoKeyType;
import br.com.auttar.util.encrypted.CryptoInput;
import br.com.auttar.util.encrypted.Encrypter;
import br.com.auttar.util.pagseguro.PagSeguroEncryptedDataExecutor;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class EncryptedDataExecutor {
    protected int cryptographyType;
    protected int masterKeyIndex;

    public static EncryptedDataExecutor getInstance(SaidaApiTefC saidaApiTefC) throws ExcecaoNaoLocal {
        if (Objects.nonNull(saidaApiTefC)) {
            if (saidaApiTefC.isEnableCriptoPagSeguro()) {
                return PagSeguroEncryptedDataExecutor.getInstance();
            }
            if (saidaApiTefC.isEnableCriptoCielo()) {
                return CieloEncryptedDataExecutor.getInstance();
            }
        }
        throw new ExcecaoNaoLocal("EDE1", "Criptografia de dados n\u00e3o habilitada", "");
    }

    public void execute(Process dados) throws ExcecaoPerifericos, ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (perifericos == null || perifericos.getPinpad() == null) {
            throw new ExcecaoPerifericos("EDE2", "Periferico nao encontrado.");
        }
        SaidaApiTefC apiTefCOutput = Contexto.getContexto().getSaidaApiTefC();
        EntradaApiTefC apiTefCInput = Contexto.getContexto().getEntradaApiTefC();
        if (StringUtils.isBlank(apiTefCOutput.getTabelaCriptografia())) {
            throw new ExcecaoNaoLocal("EDE3", "N\u00e3o foram encontrados dados na tabela de Criptografia.", "");
        }
        PinEMV pin = Objects.requireNonNull(perifericos).getPinpad();
        TabelaCriptografia encryptTable = ControladorCriptografia.getTabelaCriptografia(apiTefCOutput);
        if (encryptTable == null) {
            throw new ExcecaoNaoLocal("EDE4", "N\u00e3o foi poss\u00edvel recuperar a tabela de criptografia.", "");
        }
        RegistroCriptografia encryptData = encryptTable.getCriptografiaDadosPrincipal();
        if (encryptData == null) {
            throw new ExcecaoNaoLocal("EDE5", "N\u00e3o foi poss\u00edvel recuperar registros de criptografia da tabela de criptografia.", "");
        }
        if (encryptData.getAlgoritmo() != 5) {
            throw new ExcecaoNaoLocal("EDE6", "Algoritmo de Criptografia n\u00e3o \u00e9 suportado", "Algoritmo de Criptografia encontrado: " + encryptData.getAlgoritmo());
        }
        if (!((BibliotecaPinpad)pin).isPinpadAbecs()) {
            throw new ExcecaoNaoLocal("EDE7", "PinPan n\u00e3o \u00e9 Abecs ", "");
        }
        this.cryptographyType = encryptData.getAlgoritmo();
        this.masterKeyIndex = encryptData.getIndiceMasterKey();
        if (!pin.containsKey(this.cryptographyType, CryptoKeyType.DATA, this.masterKeyIndex)) {
            apiTefCInput.setEncryptedDataFlags(new EncryptedDataFlags());
            throw new ExcecaoNaoLocal("EDE8", "Chaves de criptografia n\u00e3o encontradas", "");
        }
    }

    protected void encryptData(Encrypter encrypter, CryptoInput cryptoInput, PinEMV pin, int cryptographyType, int masterKeyIndex) throws ExcecaoPerifericos, ExcecaoNaoLocal {
        Cartao card = Contexto.getContexto().getCartao();
        EntradaApiTefC inputApiTef = Contexto.getContexto().getEntradaApiTefC();
        encrypter.encryptMethod(cryptoInput, pin, card, inputApiTef, cryptographyType, masterKeyIndex);
    }

    protected abstract CryptoInput cryptoInputBuilder(EntradaApiTefC var1, PinEMV var2, String var3) throws ExcecaoPerifericos;
}

