/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.emv.abecs;

import br.com.auttar.util.emv.abecs.CryptoBlockType;
import br.com.auttar.util.emv.abecs.CtfDataCryptoType;
import br.com.auttar.util.emv.abecs.DataCryptoType;
import com.csi.ctfclient.excecoes.ExcecaoDadoInvalido;
import com.csi.ctfclient.tools.devices.emv.ConstantesAbecs;
import com.csi.ctfclient.tools.devices.emv.ParamAbecs;

public class CryptoParamsService {
    private DataCryptoType dataCryptoType;
    private CryptoBlockType cryptoBlockType;

    private static String getDataEncryptionMethodString(int ctfCrypto) throws ExcecaoDadoInvalido {
        CtfDataCryptoType type = CtfDataCryptoType.toEnum(ctfCrypto);
        if (null == type) {
            throw new ExcecaoDadoInvalido(String.format("Tipo de criptografia do CTF %d nao reconhecido", ctfCrypto));
        }
        if (type.getCryptoType() == null || type.getCryptoBlockType() == null) {
            throw new ExcecaoDadoInvalido(String.format("Tipo de criptografia do CTF %d (%s) incompat\u00edvel com ABECS", type.getCtfType(), type.getDescription()));
        }
        return type.getCryptoType().getKey() + type.getCryptoBlockType().getKey();
    }

    public ParamAbecs<char[], byte[]> setInitializationVector(byte[] initializationVector) throws ExcecaoDadoInvalido {
        if (null == this.cryptoBlockType || this.cryptoBlockType != CryptoBlockType.CBC) {
            throw new ExcecaoDadoInvalido("SPE_IVCBC n\u00e3o pode ser definido porque o bloco de criptografia \u00e9 nulo ou inv\u00e1lido");
        }
        if (null == initializationVector) {
            return null;
        }
        if (initializationVector.length != 8) {
            throw new ExcecaoDadoInvalido("A quantidade de bytes do bloco de criptografia est\u00e1 inv\u00e1lida. Deve conter 8 bytes");
        }
        return new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_IVCBC, initializationVector);
    }

    public ParamAbecs<char[], byte[]> setEncryptedWorkingKey(byte[] workingKey) throws ExcecaoDadoInvalido {
        if (null == workingKey && DataCryptoType.MK_WK == this.dataCryptoType) {
            throw new ExcecaoDadoInvalido("A working key \u00e9 obrigat\u00f3ria para tag SPE_WKENC quando criptografia do tipo MK_WK");
        }
        return new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_WKENC, workingKey);
    }

    public ParamAbecs<char[], byte[]> setPublicKeyModule(byte[] rsaModule) throws ExcecaoDadoInvalido {
        if (null == rsaModule && DataCryptoType.TDES == this.dataCryptoType) {
            throw new ExcecaoDadoInvalido("M\u00f3dulo da chave p\u00fablica RSA \u00e9 obrigat\u00f3ria para tag SPE_PBKMOD, quando criptografia do tipo TDES");
        }
        if (null != rsaModule && rsaModule.length != 256) {
            throw new ExcecaoDadoInvalido("A quantidade de bytes do m\u00f3dulo RSA est\u00e1 inv\u00e1lida. Deve conter 256 bytes");
        }
        if (null == rsaModule) {
            return null;
        }
        return new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_PBKMOD, rsaModule);
    }

    public ParamAbecs<char[], byte[]> setPublicKeyExponent(byte[] rsaExponent) throws ExcecaoDadoInvalido {
        if (null == rsaExponent && DataCryptoType.TDES == this.dataCryptoType) {
            throw new ExcecaoDadoInvalido("Expoente da chave p\u00fablica RSA \u00e9 obrigat\u00f3ria para tag SPE_PBKEXP, quando criptografia do tipo TDES");
        }
        if (null != rsaExponent && rsaExponent.length > 3) {
            throw new ExcecaoDadoInvalido("A quantidade de bytes do expoente RSA est\u00e1 inv\u00e1lida. Deve conter no m\u00e1ximo 3 bytes");
        }
        if (null == rsaExponent) {
            return null;
        }
        return new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_PBKEXP, rsaExponent);
    }

    public ParamAbecs<char[], String> getDataEncryptMethod(int ctfCryptoType) throws ExcecaoDadoInvalido {
        String cryptoTypeString = CryptoParamsService.getDataEncryptionMethodString(ctfCryptoType);
        assert (cryptoTypeString.length() == 2);
        this.setCryptoType(cryptoTypeString);
        return new ParamAbecs<char[], String>(ConstantesAbecs.SPE_MTHDDAT, cryptoTypeString);
    }

    private void setCryptoType(String cryptoType) throws ExcecaoDadoInvalido {
        if (cryptoType.length() != 2) {
            throw new ExcecaoDadoInvalido("Tamanho do SPE_MTHDDAT informado diferente de 2");
        }
        this.dataCryptoType = DataCryptoType.toEnum(cryptoType.substring(0, 1));
        this.cryptoBlockType = CryptoBlockType.toEnum(cryptoType.substring(1));
        if (null == this.dataCryptoType) {
            throw new ExcecaoDadoInvalido("Tipo de criptografia informado em SPE_MTHDDAT inexistente");
        }
        if (null == this.cryptoBlockType) {
            throw new ExcecaoDadoInvalido("Bloco de criptografia informado em SPE_MTHDDAT inexistente");
        }
    }
}

