/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.emv;

import br.com.auttar.AuttarLogger;
import br.com.auttar.util.emv.CheckEventResult;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.emv.CardTechnologyType;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoUtil;
import com.csi.ctfclient.tools.devices.emv.PinpadKeyboardEventType;
import com.csi.ctfclient.tools.devices.emv.SaidaCheckEventEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardEMV;

public class CheckEventUtil {
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CheckEventUtil.class);

    public static CheckEventResult getCheckEventResult(SaidaCheckEventEMV saidaCheckEventEMV, SaidaGetCardEMV saidaCartaoMagneticoCheckEvent) {
        if (saidaCartaoMagneticoCheckEvent != null) {
            if (saidaCartaoMagneticoCheckEvent.getTamPAN() > 0) {
                logger.debug("setOutputCardMagneticCheckEvent: return {}", new Object[]{CheckEventResult.SUCCESS});
                return CheckEventResult.SUCCESS;
            }
            logger.debug("setOutputCardMagneticCheckEvent: return {}", new Object[]{CheckEventResult.CANCEL});
            return CheckEventResult.CANCEL;
        }
        if (LeitorCartaoUtil.isErrCommPinpad(saidaCheckEventEMV)) {
            logger.warn("getCheckEventResult: erro de pinpad");
            logger.debug("getCheckEventResult: return {}", new Object[]{CheckEventResult.CANCEL});
            return CheckEventResult.CANCEL;
        }
        logger.debug("getCheckEventResult: saidaCheckEventEMV.getCardTechnology() " + (Object)((Object)saidaCheckEventEMV.getCardTechnology()));
        if (saidaCheckEventEMV.getKeyboardEvent() != null) {
            if (saidaCheckEventEMV.getKeyboardEvent() == PinpadKeyboardEventType.KEYBOARD_CANCEL) {
                return CheckEventResult.CANCEL;
            }
            logger.info("getCheckEventResult: forcando novo ciclo devido a keyevent errado");
            return CheckEventResult.REDO;
        }
        if (CardTechnologyType.CTLS_TIMEOUT == saidaCheckEventEMV.getCardTechnology()) {
            logger.info("getCheckEventResult: forcando novo ciclo devido a timeout");
            logger.debug("getCheckEventResult: return {}", new Object[]{CheckEventResult.REDO});
            return CheckEventResult.REDO;
        }
        if (CardTechnologyType.CHIP_CARD_REMOVED == saidaCheckEventEMV.getCardTechnology()) {
            logger.debug("getCheckEventResult: return {}", new Object[]{CheckEventResult.REDO});
            return CheckEventResult.REDO;
        }
        logger.trace("getCheckEventResult: return " + (Object)((Object)CheckEventResult.SUCCESS));
        return CheckEventResult.SUCCESS;
    }
}

