/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.emv;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.model.Aid;
import com.csi.ctfclient.apitef.model.IdRedeIndiceTabela;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.StringUtil;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;

public abstract class AidUtils {
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public static boolean hasIdRedeIndConflicts(List<IdRedeIndiceTabela> listAID) {
        logger.debug("hasIdRedeIndConflicts - inicio - com parametro listAID={}", listAID);
        if (listAID == null || listAID.size() == 0) {
            logger.warn("Lista de AIDs nula ou vazia.");
            return false;
        }
        boolean result = false;
        HashSet<String> aidHash = new HashSet<String>();
        for (IdRedeIndiceTabela aid : listAID) {
            String uniqueId = String.format("%s%s", aid.getIdRede(), aid.getIndice());
            if (aidHash.add(uniqueId)) continue;
            logger.warn("Conflito na Lista de AIDs: Rede: {} | Indice: {}", aid.getIdRede(), aid.getIndice());
            result = true;
        }
        logger.debug("hasIdRedeIndConflicts - fim - result={}", result);
        return result;
    }

    public static boolean isContaclessOkForAmount(Aid aid, BigDecimal transactionAmount) {
        return aid != null && aid.isContactless() && (aid.getLimiteTransacionalContactless().compareTo(transactionAmount) >= 0 || aid.getLimiteTransacionalContactlessMobile().compareTo(transactionAmount) >= 0);
    }

    public static String formatIdRedeIndTabListAsString(List<IdRedeIndiceTabela> listIdRedIndTab) {
        int listIdRedIndTabSize = listIdRedIndTab != null ? listIdRedIndTab.size() : 0;
        logger.debug("formatIdRedeIndTabListAsString: listAID={}", listIdRedIndTab);
        StringBuilder retorno = new StringBuilder(StringUtil.completaString("" + listIdRedIndTabSize, 2, '0', 3));
        if (listIdRedIndTabSize > 0) {
            for (IdRedeIndiceTabela idRedIndTab : listIdRedIndTab) {
                retorno.append(StringUtil.completaString(idRedIndTab.getIdRede(), 2, '0', 3));
                retorno.append(StringUtil.completaString(idRedIndTab.getIndice(), 2, '0', 3));
            }
        }
        logger.debug("formatIdRedeIndTabListAsString: retorno={}", retorno);
        return retorno.toString();
    }
}

