/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.cielo;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.RandomString;
import br.com.auttar.util.encrypted.CryptoInput;
import br.com.auttar.util.encrypted.Encrypter;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoHexaInvalido;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaEncryptBufferEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class CieloEncrypter
extends Encrypter {
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CieloEncrypter.class);
    private static final RandomString random = new RandomString(16, new Random(), "0123456789");
    private static CieloEncrypter instance;

    private CieloEncrypter() {
    }

    public static CieloEncrypter getInstance() {
        if (instance == null) {
            instance = new CieloEncrypter();
        }
        return instance;
    }

    @Override
    protected byte[] encryptMethodInitializationVector(CryptoInput ignoredCieloCryptoInput) {
        logger.trace("encryptMethodInitializationVector: INICIO ");
        byte[] binDataBytes = new byte[8];
        try {
            binDataBytes = ByteUtil.hexToByteArray(random.nextString());
        }
        catch (ExcecaoHexaInvalido excecaoHexaInvalido) {
            logger.warn("N\u00e3o foi poss\u00edvel converter os dados " + excecaoHexaInvalido.getMessage());
        }
        logger.trace("encryptMethodInitializationVector: FIM ");
        return binDataBytes;
    }

    @Override
    protected void encryptMethod(CryptoInput cieloCryptoInput, PinEMV pin, Cartao card, EntradaApiTefC entradaApiTefC, int cryptographyType, int masterKeyIndex) throws ExcecaoPerifericos {
        SaidaEncryptBufferEMV saidaEncryptBufferEMV;
        byte[] result;
        logger.trace("encryptMethod: INICIO");
        byte[] IV = this.encryptMethodInitializationVector(cieloCryptoInput);
        entradaApiTefC.setVetorInicializacao(StringUtil.byteArrayToHexString(IV));
        if (StringUtils.isNotBlank(cieloCryptoInput.getTrack2Data())) {
            logger.trace("encryptMethod: Criptografando Trilha 2");
            result = this.dataTrail(cieloCryptoInput.getTrack2Data());
            saidaEncryptBufferEMV = this.getSaidaEncryptBufferEMV((BibliotecaPinpad)pin, cryptographyType, masterKeyIndex, IV, result);
            entradaApiTefC.setKsnTrilha2(saidaEncryptBufferEMV.getKeySerialNumber());
            entradaApiTefC.setTrilha2Criptografada(saidaEncryptBufferEMV.getDadosCriptografados());
            logger.trace("encryptMethod: Criptografia Trilha 2 Sucesso");
        }
        if (StringUtils.isNotBlank(cieloCryptoInput.getTrack1Data())) {
            logger.trace("encryptMethod: Criptografando Trilha 1");
            result = this.dataTrailZone(cieloCryptoInput.getTrack1Data());
            saidaEncryptBufferEMV = this.getSaidaEncryptBufferEMV((BibliotecaPinpad)pin, cryptographyType, masterKeyIndex, IV, result);
            entradaApiTefC.setKsnTrilha1(saidaEncryptBufferEMV.getKeySerialNumber());
            entradaApiTefC.setTrilha1Criptografada(saidaEncryptBufferEMV.getDadosCriptografados());
            logger.trace("encryptMethod: Criptografia Trilha 1 Sucesso");
        }
        if (StringUtils.isNotBlank(cieloCryptoInput.getCardPan())) {
            logger.trace("encryptMethod: Criptografando Pan");
            result = this.dataTrail(cieloCryptoInput.getCardPan());
            saidaEncryptBufferEMV = this.getSaidaEncryptBufferEMV((BibliotecaPinpad)pin, cryptographyType, masterKeyIndex, IV, result);
            entradaApiTefC.setKsnPan(saidaEncryptBufferEMV.getKeySerialNumber());
            entradaApiTefC.setCartaoCriptografado(saidaEncryptBufferEMV.getDadosCriptografados());
            logger.trace("encryptMethod: Criptografia Pan Sucesso");
        }
        logger.trace("encryptMethod: FIM");
    }

    private byte[] dataTrail(String trail) {
        byte[] dataByte = StringUtil.hexStringToNibble(trail);
        String dataString = StringUtil.byteArrayToHexString(dataByte);
        return this.PKCSPadding(dataString, "F");
    }

    private byte[] dataTrailZone(String trail) {
        String dataString = ByteUtil.toZonedString(trail);
        return this.PKCSPadding(dataString);
    }
}

