/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.util.cielo;

import br.com.auttar.AuttarLogger;
import br.com.auttar.util.cielo.CieloCryptoInput;
import br.com.auttar.util.cielo.CieloEncrypter;
import br.com.auttar.util.encrypted.CryptoInput;
import br.com.auttar.util.encrypted.EncryptedDataExecutor;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;

public class CieloEncryptedDataExecutor
extends EncryptedDataExecutor {
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CieloEncryptedDataExecutor.class);
    private static CieloEncryptedDataExecutor instance;

    public static CieloEncryptedDataExecutor getInstance() {
        if (instance == null) {
            instance = new CieloEncryptedDataExecutor();
        }
        return instance;
    }

    @Override
    public void execute(Process dados) throws ExcecaoPerifericos, ExcecaoNaoLocal {
        logger.info("execute: Iniciando criptografia de dados Cielo");
        super.execute(dados);
        CryptoInput cryptoInput = this.cryptoInputBuilder(Contexto.getContexto().getEntradaApiTefC(), dados.getPerifericos().getPinpad(), "");
        this.encryptData(CieloEncrypter.getInstance(), cryptoInput, dados.getPerifericos().getPinpad(), this.cryptographyType, this.masterKeyIndex);
        logger.info("execute: Criptografia de dados realizada com sucesso");
    }

    @Override
    protected CryptoInput cryptoInputBuilder(EntradaApiTefC entradaApiTefC, PinEMV pin, String ignoreEstablishmentLogicalNumber) {
        return new CieloCryptoInput(entradaApiTefC.getPAN(), entradaApiTefC.getTrilha1(), entradaApiTefC.getInfo());
    }
}

