/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.model.constants;

import br.com.auttar.model.constants.EMVMessageErrorCode;
import br.com.auttar.model.constants.EMVResponseCode;
import br.com.auttar.model.constants.IEMVMessageErrorCode;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.Arrays;

public enum EMVTopMessageErrorCode implements IEMVMessageErrorCode
{
    PP_CTLSSINVALIDAT(EMVResponseCode.PP_CTLSSINVALIDAT, MessageEnum.REMCAR_OPER_CTLSS_INVALIDAT_TOP, MessageEnum.REMCAR_PINPAD_CTLSS_INVALIDAT_TOP),
    PP_CTLSSPROBLEMS(EMVResponseCode.PP_CTLSSPROBLEMS, MessageEnum.REMCAR_OPER_CTLSS_PROBLEMS_TOP, MessageEnum.REMCAR_PINPAD_CTLSS_PROBLEMS_TOP),
    PP_CTLSSAPPNAV(EMVResponseCode.PP_CTLSSAPPNAV, MessageEnum.REMCAR_OPER_CTLSS_APP_NAV_TOP, MessageEnum.REMCAR_PINPAD_CTLSS_APP_NAV_TOP),
    PP_CTLSSAPPNAUT(EMVResponseCode.PP_CTLSSAPPNAUT, MessageEnum.REMCAR_OPER_CTLSS_APP_N_AUT_TOP, MessageEnum.REMCAR_PINPAD_CTLSS_APP_N_AUT_TOP),
    PP_CTLSIFCHG(EMVResponseCode.PP_CTLSIFCHG, MessageEnum.REMCAR_OPER_CTLSS_TOP, MessageEnum.REMCAR_PINPAD_CTLSS_TOP);

    private final MessageEnum consMsgDisplay;
    private final MessageEnum consMsgPinPad;
    private final EMVResponseCode emvResponseCode;

    private EMVTopMessageErrorCode(EMVResponseCode emvResponseCode, MessageEnum consMsgDisplay, MessageEnum consMsgPinPad) {
        this.emvResponseCode = emvResponseCode;
        this.consMsgDisplay = consMsgDisplay;
        this.consMsgPinPad = consMsgPinPad;
    }

    public static IEMVMessageErrorCode getEnumByKey(int id) {
        IEMVMessageErrorCode emvMesageErrorCodeFound = Arrays.stream(EMVTopMessageErrorCode.values()).filter(emvMesageErrorCode -> emvMesageErrorCode.getEmvResponseCode().getId() == id).findFirst().orElse(null);
        if (emvMesageErrorCodeFound == null) {
            return EMVMessageErrorCode.getEnumByKey(id);
        }
        return emvMesageErrorCodeFound;
    }

    @Override
    public String getMsgDisplay() {
        return InternacionalizacaoUtil.getInstance().getMessage(this.consMsgDisplay);
    }

    @Override
    public String getMsgPinPad() {
        return InternacionalizacaoUtil.getInstance().getMessage(this.consMsgPinPad);
    }

    @Override
    public EMVResponseCode getEmvResponseCode() {
        return this.emvResponseCode;
    }

    public String toString() {
        return "EMVTopMessageErrorCode{msgDisplay='" + this.getMsgDisplay() + '\'' + ", msgPinPad='" + this.getMsgPinPad() + '\'' + ", " + (Object)((Object)this.emvResponseCode) + '}';
    }
}

