/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.model.constants;

import java.util.Arrays;

public enum EMVResponseCode {
    PP_NONRESP(-2, "PP_NONRESP", "Erro n\u00e3o tratado"),
    PP_CONTINUE(-1, "PP_CONTINUE", ""),
    PP_OK(0, "PP_OK", "Comando executado com sucesso"),
    PP_PROCESSING(1, "PP_PROCESSING", "Comando em processamento"),
    PP_NOTIFY(2, "PP_NOTIFY", ""),
    PP_NOSEC(3, "PP_NOSEC", "Tentativa de uso de \"Comunicacao Segura\" quando esta nao foi estabelecida."),
    PP_F1(4, "PP_F1", ""),
    PP_F2(5, "PP_F2", ""),
    PP_F3(6, "PP_F3", ""),
    PP_F4(7, "PP_F4", ""),
    PP_BACKSP(8, "PP_BACKSP", "Pressionada tecla de limpar (\"backspace\")."),
    ST_ERRPKTSEC(9, "PP_ERRPKTSEC", "Erro na decodificacao dos dados recebidos via 'Comunicacao Segura' ou comando recebido 'em claro' com 'Comunicacao Segura' estabelecida."),
    PP_INVCALL(10, "PP_INVCALL", "Chamada invalida a funcao"),
    PP_INVPARM(11, "PP_INVPARM", "Parametro invalido passado a funcao"),
    PP_TIMEOUT(12, "PP_TIMEOUT", "Esgotado o tempo maximo estipulado para a operacao"),
    PP_CANCEL(13, "PP_CANCEL", ""),
    PP_ALREADYOPEN(14, "PP_ALREADYOPEN", "Pinpad ja aberto"),
    PP_NOTOPEN(15, "PP_NOTOPEN", "Pinpad nao foi aberto"),
    PP_EXECERR(16, "PP_EXECERR", "Erro interno de execucao"),
    PP_INVMODEL(17, "PP_INVMODEL", "Funcao nao suportada pelo modelo de pinpad"),
    PP_NOFUNC(18, "PP_NOFUNC", "Funcao nao disponivel na biblioteca do pinpad"),
    ST_MANDAT(19, "ST_MANDAT", "Um parametro mandatorio nao foi enviado pela automacao comercial."),
    PP_TABEXP(20, "PP_TABEXP", "Tabelas expiradas (pelo timestamp)"),
    PP_TABERR(21, "PP_TABERR", "Erro ao tentar gravar tabelas (falta de espa\u00e7o, por exemplo)"),
    PP_NOAPPLIC(22, "PP_NOAPPLIC", "Aplicacao da rede adquirente nao existe no pinpad"),
    PP_ERROR_23(23, "PP_ERROR_23", "ERROR 23"),
    PP_ERROR_24(24, "PP_ERROR_24", "ERROR 24"),
    PP_ERROR_25(25, "PP_ERROR_25", "ERROR 25"),
    PP_ERROR_26(26, "PP_ERROR_26", "ERROR 26"),
    PP_ERROR_27(27, "PP_ERROR_27", "ERROR 27"),
    PP_ERROR_28(28, "PP_ERROR_28", "ERROR 28"),
    PP_ERROR_29(29, "PP_ERROR_29", "ERROR 29"),
    PP_PORTERR(30, "PP_PORTERR", "Erro de comunicacao: porta de comunicacao provavelmente ocupada"),
    PP_COMMERR(31, "PP_COMMERR", "Erro de comunicacao: pinpad provavelmente desconectado ou problemas com a interface serial"),
    PP_UNKNOWNSTAT(32, "PP_UNKNOWNSTAT", "Status informado pelo pinpad n\u00e3o \u00e9 conhecido"),
    PP_RSPERR(33, "PP_RSPERR", "Mensagem recebida do pnpad possui formato errado"),
    PP_COMMTOUT(34, "PP_COMMTOUT", "Tempo esgotado ao esperar pela resposta do pinpad (no caso de comandos nao blocantes)"),
    PP_INTERR(40, "PP_INTERR", ""),
    PP_MCDATAERR(41, "PP_MCDATAERR", "Erro de leitura do cartao magnetico"),
    PP_ERRPIN(42, "PP_ERRPIN", "Erro na captura do PIN - Master Key pode n\u00e3o estar presente"),
    PP_NOCARD(43, "PP_NOCARD", "N\u00e3o ha cartao inteligente presente no acoplador"),
    PP_PINBUSY(44, "PP_PINBUSY", "Pinpad nao pode processar a captura de pin temporariamente devido a questoes de seguran\u00e7a (como qunado \u00e9 atingido o limite de capturas dentro de um intervalo de tempo)"),
    PP_RSPOVRFL(45, "PP_RSPOVRFL", "Montagem dos dados de resposta supera o tamanho m\u00e1ximo permitido"),
    PP_ERRCRYPT(46, "PP_ERRCRYPT", "Erro gen\u00e9rico de valida\u00e7\u00e3o criptogr\u00e1fica."),
    PP_SAMERR(50, "PP_SAMERR", "Erro gen\u00e9rico no m\u00f3dulo SAM"),
    PP_NOSAM(51, "PP_NOSAM", "SAM ausente, \"mudo\", ou com erro de comunicacao"),
    PP_SAMINV(52, "PP_SAMINV", "SAM inv\u00e1lido, desconhecido ou com problemas"),
    PP_DUMBCARD(60, "PP_DUMBCARD", "Cart\u00e3o nao responde ou chip nao presente"),
    PP_ERRCARD(61, "PP_ERRCARD", "Erro de comunicacao do pinpad com o cartao inteligente"),
    PP_CARDINV(62, "PP_CARDINV", "Cartao do tipo invalido ou desconhecido, nao pode ser tratado"),
    PP_CARDBLOCKED(63, "PP_CARDBLOCKED", "Cartao bloqueado por numero excessivo de senhas incorretas"),
    PP_CARDNAUTH(64, "PP_CARDNAUTH", "Cart\u00e3o TIBC v1 nao autenticado pelo modulo SAM"),
    PP_CARDEXPIRED(65, "PP_CARDEXPIRED", "Cartao TIBCv1 expirado"),
    PP_CARDERRSTRUCT(66, "PP_CARDERRSTRUCT", "Cartao com erro de estrutura - arquivos estao faltando"),
    PP_CARDINVALIDAT(67, "PP_CARDINVALIDAT", "O cartao foi invalidado"),
    PP_CARDPROBLEMS(68, "PP_CARDPROBLEMS", "Cartao com problemas"),
    PP_CARDINVDATA(69, "PP_CARDINVDATA", "Cartao comporta-se corretamente por\u00e9m possui dados invalidos ou inconsistentes"),
    PP_CARDAPPNAV(70, "PP_CARDAPPNAV", "Cartao sem nenhuma aplicacao disponivel para as condicoes pedidas"),
    PP_CARDAPPNAUT(71, "PP_CARDAPPNAUT", "A aplicacao selecionada nao pode ser utilizada neste terminal pois o GetProcessingOptions retornou status 6985"),
    PP_NOBALANCE(72, "PP_NOBALANCE", "O saldo do moedeiro \u00e9 insuficiente para a opera\u00e7\u00e3o"),
    PP_LIMITEXC(73, "PP_LIMITEXC", "O limite maximo para a opera\u00e7\u00e3o (com moedeiro) foi excedido"),
    PPC_CARDNOTEFFECT(74, "PPC_CARDNOTEFFECT", "Cart\u00e3o ainda n\u00e3o efetivo"),
    PPC_VCINVCURR(75, "PPC_VCINVCURR", "Moeda inv\u00e1lida"),
    PPC_ERRFALBACK(76, "PPC_ERRFALBACK", "Cart\u00e3o EMV, passivel de fallback"),
    ST_INVAMOUNT(77, "ST_INVAMOUNT", "Valor invalido para a transacao"),
    ST_ERRMAXAID(78, "ST_ERRMAXAID", "Numero de AIDs candidatos supera a capacidade de tratamento do Kernel EMV."),
    PPC_CARDBLOCKED(79, "ST_CARDBLOCKED", "Cart\u00e3o bloqueado"),
    PP_CTLSSMULTIPLE(80, "PP_CTLSSMULTIPLE", "Mais de um cart\u00e3o sem contato foi apresentado ao leitor (este c\u00f3digo de retorno \u00e9 opcional e depende da capacidade do equipamento em detectar esta situa\u00e7\u00e3o)"),
    PP_CTLSSCOMMERR(81, "PP_CTLSSCOMMERR", "Erro de comunica\u00e7\u00e3o entre o terminal (antena) e o cart\u00e3o com chip sem contato"),
    PP_CTLSSINVALIDAT(82, "PP_CTLSSINVALIDAT", "Cart\u00e3o foi invalidado (sele\u00e7\u00e3o de aplica\u00e7\u00e3o retornou status \u00916A81\u0092)"),
    PP_CTLSSPROBLEMS(83, "PP_CTLSSPROBLEMS", "Cart\u00e3o com problemas. Esse status \u00e9 v\u00e1lido para muitas ocorr\u00eancias no processamento de cart\u00f5es sem contato em que o cart\u00e3o n\u00e3o se comporta conforme o esperado e a transa\u00e7\u00e3o deve ser finalizada"),
    PP_CTLSSAPPNAV(84, "PP_CTLSSAPPNAV", "Cart\u00e3o sem nenhuma aplica\u00e7\u00e3o dispon\u00edvel para as condi\u00e7\u00f5es pedidas (nenhum AID encontrado)"),
    PP_CTLSSAPPNAUT(85, "PP_CTLSSAPPNAUT", "A aplica\u00e7\u00e3o selecionada n\u00e3o pode ser utilizada (o Get Processing Options retornou status \u00916985\u0092 ou houve erro no comando Select final), e n\u00e3o h\u00e1 outra aplica\u00e7\u00e3o compat\u00edvel na lista de candidatas"),
    PP_CTLSEXTCVM(86, "PP_CTLSEXTCVM", "Deve-se exibir no display do operador e do pinpad \" VERIFIQUE O TELEFONE \""),
    PP_CTLSIFCHG(87, "PP_CTLSIFCHG", "Deve exibir o display operador \" MODO INVALIDO, \\n USE CHIP/TARJA \" e o display pinpad \" MODO INVALIDO USE CHIP/TARJA \". Para o retorno PP_CTLSIFCHG 87, h\u00e1 necessidade de desabilitar o contactless na pr\u00f3xima leitura do cart\u00e3o"),
    ST_MFNFOUND(100, "ST_MFNFOUND", "Arquivo multimedia inexistente."),
    PP_DENIEDBYCARD(100, "PP_DENIEDBYCARD", "Transa\u00e7\u00e3o n\u00e3o autorizada pelo cart\u00e3o, usada na integra\u00e7\u00e3o com pin-pad PPVISA"),
    ST_MFERRFMT(101, "ST_MFERRFMT", "Erro no formato do arquivo multimedia."),
    ST_MFERR(102, "ST_MFERR", "Erro na carga do arquivo multimedia."),
    PPEMV_INVALIDINPUT(700, "PPEMV_INVALIDINPUT", "ERRO PINPAD"),
    PPEMV_INVALIDOUTPUT(701, "PPEMV_INVALIDOUTPUT", "CARTAO INVALIDO"),
    PPEMV_INVALIDRESPONSE(702, "PPEMV_INVALIDRESPONSE", "CARTAO INVALIDO"),
    PPEMV_MISSINGBYTES(703, "PPEMV_MISSINGBYTES", "CARTAO INVALIDO"),
    PPEMV_INVALIDOPERATION(704, "PPEMV_INVALIDOPERATION", "CARTAO INVALIDO"),
    PPEMV_CARDNOTIDENTIFIED(705, "PPEMV_CARDNOTIDENTIFIED", "Cart\u00e3o inv\u00e1lido ou com erro"),
    PPEMV_SMALLBUFFER(706, "PPEMV_SMALLBUFFER", "CARTAO INVALIDO"),
    PP_ERROCARTAOABORT(900, "PP_ERROCARTAOABORT", "Erro interno no CTFClient, abortar a opera\u00e7\u00e3o");

    private final Integer id;
    private final String code;
    private final String description;

    private EMVResponseCode(Integer id, String code, String description) {
        this.id = id;
        this.code = code;
        this.description = description;
    }

    public static EMVResponseCode getEnumByKey(Integer id) {
        return Arrays.stream(EMVResponseCode.values()).filter(emvResponseCode -> emvResponseCode.getId().equals(id)).findFirst().orElse(PP_NONRESP);
    }

    public Integer getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ResponseCode{id=" + this.id + ", code='" + this.code + '\'' + '}';
    }
}

