/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.model.constants;

import br.com.auttar.model.constants.EMVResponseCode;
import br.com.auttar.model.constants.IEMVMessageErrorCode;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.Arrays;

public enum EMVMessageErrorCode implements IEMVMessageErrorCode
{
    PP_NONRESP(EMVResponseCode.PP_NONRESP, MessageEnum.REMCAR_OPER_PINPAD_ERROR, MessageEnum.REMCAR_OPER_PINPAD_ERROR),
    PP_OK(EMVResponseCode.PP_OK, MessageEnum.REMCAR_OPER_REMOVE_DEFAULT, MessageEnum.REMCAR_PINPAD_REMOVE_DEFAULT),
    PP_CONTINUE(EMVResponseCode.PP_CONTINUE, null, null),
    PP_TABEXP(EMVResponseCode.PP_TABEXP, MessageEnum.REMCAR_OPER_REMOVE_DEFAULT, MessageEnum.REMCAR_PINPAD_REMOVE_DEFAULT),
    PP_NOAPPLIC(EMVResponseCode.PP_NOAPPLIC, MessageEnum.REMCAR_OPER_PINPAD_ERROR, MessageEnum.REMCAR_PINPAD_REMOVE_DEFAULT),
    PP_MCDATAERR(EMVResponseCode.PP_MCDATAERR, MessageEnum.REMCAR_OPER_DATAERR, MessageEnum.REMCAR_PINPAD_DATAERR),
    PP_NOCARD(EMVResponseCode.PP_NOCARD, MessageEnum.REMCAR_OPER_CARD_REMOVED, MessageEnum.REMCAR_PINPAD_CARD_REMOVED),
    PP_SAMERR(EMVResponseCode.PP_SAMERR, MessageEnum.REMCAR_OPER_SAM_ERROR, MessageEnum.REMCAR_PINPAD_SAM_ERROR),
    PP_DUMBCARD(EMVResponseCode.PP_DUMBCARD, MessageEnum.REMCAR_OPER_CARD_ERROR, MessageEnum.REMCAR_PINPAD_CARD_ERROR),
    PP_ERRCARD(EMVResponseCode.PP_ERRCARD, MessageEnum.REMCAR_OPER_CARD_ERROR, MessageEnum.REMCAR_PINPAD_CARD_ERROR),
    PP_CARDINV(EMVResponseCode.PP_CARDINV, MessageEnum.REMCAR_OPER_INVALID_CARD, MessageEnum.REMCAR_PINPAD_INVALID_CARD),
    PP_CARDBLOCKED(EMVResponseCode.PP_CARDBLOCKED, MessageEnum.REMCAR_OPER_CARD_BLOCKED, MessageEnum.REMCAR_PINPAD_CARD_BLOCKED),
    PP_CARDNAUTH(EMVResponseCode.PP_CARDNAUTH, MessageEnum.REMCAR_OPER_INVALID_CARD, MessageEnum.REMCAR_PINPAD_INVALID_CARD),
    PP_CARDEXPIRED(EMVResponseCode.PP_CARDEXPIRED, MessageEnum.REMCAR_OPER_CARD_EXPIRED, MessageEnum.REMCAR_PINPAD_CARD_EXPIRED),
    PP_CARDERRSTRUCT(EMVResponseCode.PP_CARDERRSTRUCT, MessageEnum.REMCAR_OPER_INVALID_CARD, MessageEnum.REMCAR_PINPAD_INVALID_CARD),
    PP_CARDINVALIDAT(EMVResponseCode.PP_CARDINVALIDAT, MessageEnum.REMCAR_OPER_INVALIDATED_CARD, MessageEnum.REMCAR_PINPAD_INVALIDATED_CARD),
    PP_CARDPROBLEMS(EMVResponseCode.PP_CARDPROBLEMS, MessageEnum.REMCAR_OPER_INVALID_CARD, MessageEnum.REMCAR_PINPAD_INVALID_CARD),
    PP_CARDINVDATA(EMVResponseCode.PP_CARDINVDATA, MessageEnum.REMCAR_OPER_INVALID_CARD, MessageEnum.REMCAR_PINPAD_INVALID_CARD),
    PP_CARDAPPNAV(EMVResponseCode.PP_CARDAPPNAV, MessageEnum.REMCAR_OPER_INVALID_MODE, MessageEnum.REMCAR_PINPAD_INVALID_MODE),
    PP_CARDAPPNAUT(EMVResponseCode.PP_CARDAPPNAUT, MessageEnum.REMCAR_OPER_NAUT_CARD, MessageEnum.REMCAR_PINPAD_NAUT_CARD),
    PP_NOBALANCE(EMVResponseCode.PP_NOBALANCE, MessageEnum.REMCAR_OPER_NO_BALANCE, MessageEnum.REMCAR_PINPAD_NO_BALANCE),
    PP_LIMITEXC(EMVResponseCode.PP_LIMITEXC, MessageEnum.REMCAR_OPER_LIM_EXCEEDED, MessageEnum.REMCAR_PINPAD_LIM_EXCEEDED),
    PPC_ERRFALBACK(EMVResponseCode.PPC_ERRFALBACK, MessageEnum.REMCAR_OPER_INVALID_CARD, MessageEnum.REMCAR_PINPAD_INVALID_CARD),
    PPC_CARDBLOCKED(EMVResponseCode.PPC_CARDBLOCKED, MessageEnum.REMCAR_OPER_CARD_BLOCKED, MessageEnum.REMCAR_PINPAD_CARD_BLOCKED),
    PP_CTLSSMULTIPLE(EMVResponseCode.PP_CTLSSMULTIPLE, MessageEnum.REMCAR_OPER_INVALID_CARD, MessageEnum.REMCAR_PINPAD_INVALID_CARD),
    PP_CTLSSCOMMERR(EMVResponseCode.PP_CTLSSCOMMERR, MessageEnum.REMCAR_OPER_CTLSS_COMM_ERROR, MessageEnum.REMCAR_PINPAD_CTLSS_COMM_ERROR),
    PP_CTLSSINVALIDAT(EMVResponseCode.PP_CTLSSINVALIDAT, MessageEnum.REMCAR_OPER_CTLSS_INVALIDAT, MessageEnum.REMCAR_PINPAD_CTLSS_INVALIDAT),
    PP_CTLSSPROBLEMS(EMVResponseCode.PP_CTLSSPROBLEMS, MessageEnum.REMCAR_OPER_CTLSS_PROBLEMS, MessageEnum.REMCAR_PINPAD_CTLSS_PROBLEMS),
    PP_CTLSSAPPNAV(EMVResponseCode.PP_CTLSSAPPNAV, MessageEnum.REMCAR_OPER_CTLSS_APP_NAV, MessageEnum.REMCAR_PINPAD_CTLSS_APP_NAV),
    PP_CTLSSAPPNAUT(EMVResponseCode.PP_CTLSSAPPNAUT, MessageEnum.REMCAR_OPER_CTLSS_APP_N_AUT, MessageEnum.REMCAR_PINPAD_CTLSS_APP_N_AUT),
    PP_CTLSEXTCVM(EMVResponseCode.PP_CTLSEXTCVM, MessageEnum.REMCAR_OPER_CTLS_EXT_CVM, MessageEnum.REMCAR_PINPAD_CTLS_EXT_CVM),
    PP_CTLSIFCHG(EMVResponseCode.PP_CTLSIFCHG, MessageEnum.REMCAR_OPER_CTLSS, MessageEnum.REMCAR_PINPAD_CTLSS),
    PP_DENIEDBYCARD(EMVResponseCode.PP_DENIEDBYCARD, MessageEnum.REMCAR_OPER_NAUT_CARD, MessageEnum.REMCAR_TRANS_NAO_AUT_CARTAO),
    PPEMV_INVALIDINPUT(EMVResponseCode.PPEMV_INVALIDINPUT, MessageEnum.REMCAR_OPER_PINPAD_ERROR, MessageEnum.REMCAR_PINPAD_REMOVE_DEFAULT),
    PPEMV_INVALIDOUTPUT(EMVResponseCode.PPEMV_INVALIDOUTPUT, MessageEnum.REMCAR_OPER_INVALID_CARD, MessageEnum.REMCAR_PINPAD_INVALID_CARD),
    PPEMV_INVALIDRESPONSE(EMVResponseCode.PPEMV_INVALIDRESPONSE, MessageEnum.REMCAR_OPER_INVALID_CARD, MessageEnum.REMCAR_PINPAD_INVALID_CARD),
    PPEMV_MISSINGBYTES(EMVResponseCode.PPEMV_MISSINGBYTES, MessageEnum.REMCAR_OPER_INVALID_CARD, MessageEnum.REMCAR_PINPAD_INVALID_CARD),
    PPEMV_INVALIDOPERATION(EMVResponseCode.PPEMV_INVALIDOPERATION, MessageEnum.REMCAR_OPER_INVALID_CARD, MessageEnum.REMCAR_PINPAD_INVALID_CARD),
    PPEMV_CARDNOTIDENTIFIED(EMVResponseCode.PPEMV_CARDNOTIDENTIFIED, MessageEnum.REMCAR_OPER_CART_INVAL, MessageEnum.REMCAR_PINPAD_CART_INVAL),
    PPEMV_SMALLBUFFER(EMVResponseCode.PPEMV_SMALLBUFFER, MessageEnum.REMCAR_OPER_INVALID_CARD, MessageEnum.REMCAR_PINPAD_INVALID_CARD);

    private final MessageEnum consMsgDisplay;
    private final MessageEnum consMsgPinPad;
    private final EMVResponseCode emvResponseCode;

    private EMVMessageErrorCode(EMVResponseCode emvResponseCode, MessageEnum consMsgDisplay, MessageEnum consMsgPinPad) {
        this.emvResponseCode = emvResponseCode;
        this.consMsgDisplay = consMsgDisplay;
        this.consMsgPinPad = consMsgPinPad;
    }

    public static IEMVMessageErrorCode getEnumByKey(int id) {
        return Arrays.stream(EMVMessageErrorCode.values()).filter(emvMesageErrorCode -> emvMesageErrorCode.getEmvResponseCode().getId() == id).findFirst().orElse(PP_NONRESP);
    }

    @Override
    public String getMsgDisplay() {
        return InternacionalizacaoUtil.getInstance().getMessage(this.consMsgDisplay);
    }

    @Override
    public String getMsgPinPad() {
        return InternacionalizacaoUtil.getInstance().getMessage(this.consMsgPinPad);
    }

    @Override
    public EMVResponseCode getEmvResponseCode() {
        return this.emvResponseCode;
    }

    public String toString() {
        return "EMVMessageCode{msgDisplay='" + this.getMsgDisplay() + '\'' + ", msgPinPad='" + this.getMsgPinPad() + '\'' + ", " + (Object)((Object)this.emvResponseCode) + '}';
    }
}

