/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.framework.socket;

import br.com.auttar.clientservices.handlers.socket.LocalClientSocketHandler;
import br.com.auttar.framework.socket.MessageSocketHandler;
import br.com.auttar.framework.socket.MonitorSocketEvent;
import br.com.auttar.framework.socket.MonitorSocketHandler;
import br.com.auttar.framework.socket.SocketHandler;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerSocket
implements Runnable,
MonitorSocketHandler {
    private Log log = LogFactory.getLog(ServerSocket.class);
    private ServerSocketChannel server;
    private boolean started = false;
    private String host = null;
    private int port;
    private Class<? extends SocketHandler> socketHandler;
    private Class<? extends MessageSocketHandler> messageSocketHandler;
    private Selector selector = null;
    private ExecutorService executor;
    private List<SocketHandler> handlers = new LinkedList<SocketHandler>();

    public <M extends MessageSocketHandler> ServerSocket(String host, int porta, Class<M> messageSocketHandler) {
        this(host, porta, messageSocketHandler, LocalClientSocketHandler.class);
    }

    public <S extends SocketHandler, M extends MessageSocketHandler> ServerSocket(String host, int porta, Class<M> messageSocketHandler, Class<S> socketHandler) {
        this.host = host;
        this.port = porta;
        this.socketHandler = socketHandler;
        this.messageSocketHandler = messageSocketHandler;
        this.executor = Executors.newCachedThreadPool();
    }

    public void start() {
        try {
            this.log.info("ServerSocket -> port: " + this.port);
            this.server = ServerSocketChannel.open();
            this.server.configureBlocking(false);
            if (this.host == null || this.host.equals("*")) {
                this.server.socket().bind(new InetSocketAddress(this.port));
            } else {
                this.server.socket().bind(new InetSocketAddress(this.host, this.port));
            }
            new Thread(this).start();
            this.log.info("Servidor inicializado");
            this.started = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                for (SocketHandler socketHandler : this.handlers) {
                    socketHandler.close();
                }
                this.selector.close();
                this.server.close();
            }
            catch (IOException e) {
                this.log.error("nao foi possivel finalizar o ServerSocket.", e);
            }
        }
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.selector = this.server.provider().openSelector();
            this.server.register(this.selector, 16);
            this.log.trace("ouvinte de conexao registrado");
            while (this.started) {
                this.log.trace("aguardando select");
                this.selector.select();
                this.log.trace("evento recebido no select");
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> i = keys.iterator();
                while (i.hasNext()) {
                    SelectionKey key = i.next();
                    i.remove();
                    if (!key.isAcceptable()) continue;
                    ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                    SocketChannel socketChannel = ssc.accept();
                    socketChannel.configureBlocking(false);
                    try {
                        SocketHandler socketHandler = this.createSocketHandler(socketChannel);
                        this.executor.execute(socketHandler);
                        this.OnOpen(new MonitorSocketEvent(MonitorSocketEvent.OPEN, socketHandler));
                    }
                    catch (IllegalArgumentException e) {
                        this.log.error("nao foi possivel criar o SocketHandler", e);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof ClosedSelectorException) {
                this.log.error("socket desconectado...");
            } else if (ex instanceof BindException && ex.getLocalizedMessage().indexOf("Address already in use") >= 0) {
                this.log.error("nao foi possivel realizar bind na port " + this.port);
            } else {
                this.log.error("erro generico: ", ex);
            }
        }
        finally {
            try {
                this.selector.close();
            }
            catch (Exception exception) {}
        }
    }

    protected SocketHandler createSocketHandler(SocketChannel socketChannel) throws IllegalArgumentException {
        try {
            Class[] params = new Class[]{this.messageSocketHandler.getClass(), SocketChannel.class, MonitorSocketHandler.class};
            Class<?> clazz = Class.forName(this.socketHandler.getName());
            Constructor<?> cons = clazz.getConstructor(params);
            return (SocketHandler)cons.newInstance(this.messageSocketHandler, socketChannel, this);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void OnOpen(MonitorSocketEvent event) {
        this.handlers.add(event.getOrigem());
        this.log.trace("monitor sockethandler OnOpen. tam: " + this.handlers.size());
    }

    @Override
    public void OnClose(MonitorSocketEvent event) {
        this.handlers.remove(event.getOrigem());
        this.log.trace("monitor sockethandler OnClose. tam: " + this.handlers.size());
    }
}

