/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.framework.socket;

import br.com.auttar.framework.socket.MessageSocketHandler;
import br.com.auttar.framework.socket.MonitorSocketEvent;
import br.com.auttar.framework.socket.MonitorSocketHandler;
import br.com.auttar.framework.socket.SocketHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultSocketHandler
extends SocketHandler {
    private ByteBuffer sizeBuffer = null;
    private Selector selector;
    private ExecutorService executor;
    private MonitorSocketHandler monitorSocket;

    public <T extends MessageSocketHandler> DefaultSocketHandler(Class<T> messageSocketHandeler, SocketChannel socket, MonitorSocketHandler monitorSocket) {
        super(messageSocketHandeler, socket, monitorSocket);
        this.monitorSocket = monitorSocket;
        this.executor = new ThreadPoolExecutor(1, 40, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void run() {
        try {
            this.sizeBuffer = ByteBuffer.allocateDirect(8);
            this.selector = this.getSocketChannel().provider().openSelector();
            this.getSocketChannel().register(this.selector, 1);
            while (this.getSocketChannel().isOpen()) {
                this.selector.select();
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> i = keys.iterator();
                this.log.trace("preparar leitura de dados");
                while (i.hasNext()) {
                    SelectionKey key = i.next();
                    i.remove();
                    if (!key.isValid() || !key.isReadable()) continue;
                    this.log.debug("'select' valido para leitura");
                    this.doRead(key);
                }
            }
        }
        catch (Exception e) {
            this.log.error("erro na leitura do socket", e);
        }
    }

    protected byte[] doRead(SocketChannel client) throws Exception {
        this.sizeBuffer.clear();
        byte[] sizeMsg = this.read(client, 8, this.sizeBuffer);
        String strSize = new String(sizeMsg).substring(1, 7);
        int size = Integer.parseInt(new String(strSize));
        this.log.debug("dados a receber. tam: " + size);
        byte[] receivedBytes = this.read(client, size);
        return receivedBytes;
    }

    @Override
    public void send(byte[] buffer) {
        try {
            String message = new String(buffer);
            int tam = message.length();
            String strTam = tam + "";
            while (strTam.length() <= 6) {
                strTam = "0" + strTam;
            }
            strTam = 2 + strTam + 3;
            message = strTam + message;
            buffer = message.getBytes();
            buffer[0] = 2;
            buffer[7] = 3;
            this.getSocketChannel().write(ByteBuffer.wrap(buffer));
        }
        catch (IOException e) {
            this.log.error("nao foi possivel enviar mensagem.", e);
        }
        catch (Exception e) {
            this.log.error("erro no tratamento de envio da mensagem", e);
        }
    }

    private void doRead(SelectionKey key) {
        SocketChannel client = this.getSocketChannel();
        try {
            while (true) {
                byte[] receivedBytes;
                if ((receivedBytes = this.doRead(client)) == null || receivedBytes.length == 0) {
                    return;
                }
                this.log.trace("dados lidos. tam: " + receivedBytes.length);
                MessageSocketHandler messageSocketHandler = this.createMessageSocketHandler(receivedBytes);
                this.executor.execute(messageSocketHandler);
            }
        }
        catch (Exception ex) {
            key.cancel();
            this.close();
            return;
        }
    }

    private byte[] read(SocketChannel client, int size, ByteBuffer buffer) throws IOException {
        int count = 0;
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        while (count < size) {
            int chunkReceived = client.read(buffer);
            count += chunkReceived;
            if (chunkReceived < 0) {
                throw new IOException("socket desconectado");
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                outstream.write(buffer.get());
            }
            buffer.clear();
        }
        return outstream.toByteArray();
    }

    private byte[] read(SocketChannel client, int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        return this.read(client, size, buffer);
    }

    @Override
    public void close() {
        try {
            this.selector.close();
            this.getSocketChannel().close();
            List<Runnable> runnables = this.executor.shutdownNow();
            if (runnables != null && runnables.size() > 0) {
                for (Runnable runnable : runnables) {
                    MessageSocketHandler messageSocketHandler = (MessageSocketHandler)runnable;
                    messageSocketHandler.abort();
                }
            }
            this.executor.shutdown();
            this.monitorSocket.OnClose(new MonitorSocketEvent(MonitorSocketEvent.CLOSE, this));
        }
        catch (IOException e) {
            this.log.error("nao foi possivel fechar a conexao.", e);
        }
    }
}

