/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.framework.http;

import br.com.auttar.framework.http.Http;
import br.com.auttar.framework.http.HttpResponseHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;

public class HttpRequest {
    protected Log log = LogFactory.getLog(HttpRequest.class);
    private HttpResponseHandler httpResponseHandler;
    private Set<HttpRequestBase> requests;
    private HttpHost proxy;

    public HttpRequest(HttpResponseHandler httpResponseHandler) {
        this.httpResponseHandler = httpResponseHandler;
        this.requests = Collections.synchronizedSet(new LinkedHashSet());
    }

    public void execute(String method, String url, String data, Map<String, String> headers) {
        this.execute(method, url, data, headers, this.httpResponseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String method, String url, String data, Map<String, String> headers, HttpResponseHandler httpResponseHandler) {
        if (httpResponseHandler == null) {
            throw new IllegalArgumentException("HttpResposseHandler is null");
        }
        HttpRequestBase httpRequest = null;
        try {
            if ("GET".equals(method) || "DELETE".equals(method)) {
                try {
                    URI uri = Http.convertJsonToUriParameter(url, data);
                    if ("GET".equals(method)) {
                        httpRequest = new HttpGet(uri);
                    } else if ("DELETE".equals(method)) {
                        httpRequest = new HttpDelete(url);
                    }
                }
                catch (URISyntaxException e) {
                    this.log.error("erro na formatacao da url GET.", e);
                }
            } else if ("POST".equals(method) || "PUT".equals(method)) {
                if ("POST".equals(method)) {
                    httpRequest = new HttpPost(url);
                } else if ("PUT".equals(method)) {
                    httpRequest = new HttpPut(url);
                }
                StringEntity params = new StringEntity(data);
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(params);
                httpRequest.addHeader("content-type", "application/json");
            }
            this.preparaHeader(httpRequest, headers);
            CloseableHttpClient client = null;
            if (url.contains("https")) {
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(SSLContexts.createDefault(), new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
                client = HttpClientBuilder.create().setSSLSocketFactory(sslConnectionSocketFactory).build();
            } else {
                client = HttpClients.createDefault();
            }
            try {
                if (httpRequest != null) {
                    this.requests.add(httpRequest);
                }
                if (this.proxy != null) {
                    this.log.debug("proxy -> " + this.proxy.toHostString());
                    RequestConfig config = RequestConfig.custom().setProxy(this.proxy).build();
                    httpRequest.setConfig(config);
                }
                try (CloseableHttpResponse httpResponse = client.execute(httpRequest);){
                    this.log.debug("----------------------------------------");
                    this.log.debug(httpResponse.getStatusLine());
                    int httpStatusCode = httpResponse.getStatusLine().getStatusCode();
                    httpResponseHandler.handle(httpStatusCode, httpResponse);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                client.close();
            }
            this.requests.remove(httpRequest);
        }
        catch (Exception e) {
            httpResponseHandler.error(e);
        }
        finally {
            this.requests.remove(httpRequest);
        }
    }

    public void configProxy(String address) {
        if (address == null || "".endsWith(address.trim())) {
            this.proxy = null;
        } else {
            String[] array = address.split(":");
            if (array == null || array.length != 3) {
                this.log.error("endereco do proxy invalido.");
                return;
            }
            String host = array[1].replace("//", "");
            this.proxy = new HttpHost(host, (int)Integer.valueOf(array[2]), array[0]);
        }
    }

    public void abortAll() {
        if (this.requests != null) {
            for (HttpRequestBase httpRequestBase : this.requests) {
                httpRequestBase.abort();
            }
        }
    }

    private void preparaHeader(HttpRequestBase httpRequest, Map<String, String> header) {
        if (header != null && header.size() > 0) {
            Set<Map.Entry<String, String>> entries = header.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                httpRequest.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }
}

