/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.framework.http;

import br.com.auttar.clientservices.services.Configuration;
import br.com.auttar.clientservices.services.ampq.AMQPPublisherService;
import br.com.auttar.clientservices.util.JsonUtil;
import br.com.auttar.clientservices.util.builder.HttpExchangeBuilder;
import br.com.auttar.framework.http.HttpResponse;
import br.com.auttar.framework.http.HttpResponseBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpHandlerForPayment
implements HttpHandler {
    private AMQPPublisherService genericRabbitMQService;
    private Log logger = LogFactory.getLog(HttpHandlerForPayment.class);

    public HttpHandlerForPayment(Configuration configuration) {
        this.genericRabbitMQService = new AMQPPublisherService(configuration);
    }

    public void connect() throws Exception {
        this.genericRabbitMQService.startUp();
    }

    public void disconnect() throws Exception {
        this.genericRabbitMQService.endUp();
    }

    @Override
    public void handle(HttpExchange t) throws IOException {
        String response = "";
        try {
            URI uri = t.getRequestURI();
            String json = JsonUtil.queryToJson(uri.getQuery());
            String niche = HttpExchangeBuilder.buildNicheFromHttpExchange(t);
            this.logger.info("request: " + json);
            response = this.genericRabbitMQService.postGet("request.get.checkout_payments", niche, json);
            JsonObject o = new JsonParser().parse(response).getAsJsonObject();
            String status = o.get("status").toString();
            t.sendResponseHeaders(Integer.valueOf(status), response.getBytes().length);
        }
        catch (Exception e) {
            this.logger.error("Error when handling the http request: " + e.getMessage());
            HttpResponse httpResponse = HttpResponseBuilder.build(e);
            response = httpResponse.toJson();
            t.sendResponseHeaders(httpResponse.getStatus(), response.getBytes().length);
        }
        this.logger.info("response: " + response);
        OutputStream os = t.getResponseBody();
        os.write(response.getBytes());
        os.close();
    }
}

