/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.framework.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.utils.URIBuilder;

public class Http {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    public static final Integer GENERIC_ERROR = 500;
    public static final Integer REQUEST_TIMEOUT = 418;
    public static final Integer SUCCESS = 200;
    public static final Integer CREATED = 201;
    public static final Integer BAD_REQUEST = 400;

    public static URI convertJsonToUriParameter(String url, String json) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(url);
        try {
            JsonObject obj = new JsonParser().parse(json).getAsJsonObject();
            Set<Map.Entry<String, JsonElement>> entrySet = obj.entrySet();
            for (Map.Entry<String, JsonElement> entry : entrySet) {
                String key = entry.getKey();
                JsonElement jsonElement = entry.getValue();
                builder.addParameter(key, jsonElement.getAsString());
            }
            return builder.build();
        }
        catch (JsonSyntaxException e) {
            throw new URISyntaxException("error json to parameter. data: " + json, e.getMessage());
        }
    }
}

