/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.util.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.util.ArrayList;
import java.util.List;

public class TypeExclusionStrategy
implements ExclusionStrategy {
    private final Class<?> _class;
    private List<String> _atributos = new ArrayList<String>();

    public TypeExclusionStrategy(Class<?> clazz, String ... ignoreAtributos) {
        this._class = clazz;
        if (ignoreAtributos != null && ignoreAtributos.length > 0) {
            for (String atributo : ignoreAtributos) {
                this._atributos.add(atributo);
            }
        }
    }

    @Override
    public boolean shouldSkipClass(Class<?> clazz) {
        if (this._atributos.size() == 0) {
            return clazz == this._class;
        }
        return false;
    }

    @Override
    public boolean shouldSkipField(FieldAttributes fieldAttributes) {
        if (this._atributos.size() > 0) {
            if (fieldAttributes.getDeclaringClass().getName().equals(this._class.getName())) {
                return !this._atributos.contains(fieldAttributes.getName());
            }
        } else {
            return fieldAttributes.getDeclaringClass().getName().equals(this._class.getName());
        }
        return false;
    }
}

