/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.util.builder;

import br.com.auttar.clientservices.model.AutomationModel;
import br.com.auttar.clientservices.model.SettingsModel;
import br.com.auttar.clientservices.services.Configuration;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.util.Properties;

public class SettingsModelBuilder {
    public static SettingsModel buildFromPropertiesAndConfiguration(Properties properties, Configuration configuration) throws JsonParseException {
        SettingsModel settings = new SettingsModel();
        AutomationModel automation = new AutomationModel();
        automation.setName(properties.getProperty("automation.name"));
        automation.setProvider(properties.getProperty("automation.provider"));
        automation.setUrl(properties.getProperty("automation.url"));
        automation.setVersion(properties.getProperty("automation.version"));
        settings.setStoreName(properties.getProperty("store_name"));
        settings.setCompanyCode(configuration.getCompanyCode());
        settings.setStoreCode(configuration.getStoreCode());
        settings.setPosCode(configuration.getExternalCode());
        settings.setAutomation(automation);
        return settings;
    }

    public static SettingsModel buildFromJsonAndConfiguration(String json, Configuration configuration) throws JsonParseException {
        SettingsModel settings = new Gson().fromJson(json, SettingsModel.class);
        settings.setCompanyCode(configuration.getCompanyCode());
        settings.setStoreCode(configuration.getStoreCode());
        settings.setPosCode(configuration.getExternalCode());
        if (settings.getAutomation() == null) {
            throw new JsonParseException("Missing 'automation' field.");
        }
        if (settings.getAutomation().getUrl() == null) {
            throw new JsonParseException("Missing 'automation.url' field.");
        }
        if (settings.getAutomation().getName() == null) {
            throw new JsonParseException("Missing 'automation.name' field.");
        }
        if (settings.getAutomation().getProvider() == null) {
            throw new JsonParseException("Missing 'automation.provider' field.");
        }
        if (settings.getAutomation().getVersion() == null) {
            throw new JsonParseException("Missing 'automation.version' field.");
        }
        return settings;
    }
}

