/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.services.stomp;

import br.com.auttar.clientservices.services.SessionMessage;
import br.com.auttar.clientservices.services.SessionMessageType;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;

public class StompSessionMessage
implements SessionMessage {
    protected Log logger = LogFactory.getLog(SessionMessage.class);
    private String sessionId;
    private StompSession stompSession;
    private StompHeaders stompHeaders;
    private SessionMessageType type;

    public StompSessionMessage(String sessionId, StompHeaders stompHeaders, StompSession stompSession, SessionMessageType type) {
        this.sessionId = sessionId;
        this.stompHeaders = stompHeaders;
        this.stompSession = stompSession;
        this.type = type;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public SessionMessageType getType() {
        return this.type;
    }

    @Override
    public <Type extends Serializable> void send(Type object) {
        StompHeaders sendHeaders = new StompHeaders();
        sendHeaders.add("correlation-id", (String)this.stompHeaders.get((Object)"correlation-id").get(0));
        sendHeaders.add("destination", (String)this.stompHeaders.get((Object)"reply-to").get(0));
        Gson gson = new Gson();
        String json = gson.toJson(object);
        this.logger.trace(String.format("response -> %s (%s): %s", this.getType().name(), this.sessionId, json));
        this.stompSession.send(sendHeaders, (Object)json.getBytes());
        this.logger.info(String.format("response -> type: %s, sessionId: %s", this.type.name(), this.sessionId));
    }

    @Override
    public void send(JsonObject object) {
        StompHeaders sendHeaders = new StompHeaders();
        sendHeaders.add("correlation-id", (String)this.stompHeaders.get((Object)"correlation-id").get(0));
        sendHeaders.add("destination", (String)this.stompHeaders.get((Object)"reply-to").get(0));
        Gson gson = new Gson();
        String json = gson.toJson(object);
        this.logger.trace(String.format("response -> %s (%s): %s", this.getType().name(), this.sessionId, json));
        this.stompSession.send(sendHeaders, (Object)json.getBytes());
        this.logger.info(String.format("response -> type: %s, sessionId: %s", this.type.name(), this.sessionId));
    }
}

