/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.services.stomp;

import br.com.auttar.clientservices.model.Checkout;
import br.com.auttar.clientservices.model.Payment;
import br.com.auttar.clientservices.model.PaymentResult;
import br.com.auttar.clientservices.model.ResultModel;
import br.com.auttar.clientservices.model.SearchCheckout;
import br.com.auttar.clientservices.model.StatusCheck;
import br.com.auttar.clientservices.model.TaxReceiptRequest;
import br.com.auttar.clientservices.services.BaseService;
import br.com.auttar.clientservices.services.Configuration;
import br.com.auttar.clientservices.services.MessageService;
import br.com.auttar.clientservices.services.SessionMessage;
import br.com.auttar.clientservices.services.SessionMessageType;
import br.com.auttar.clientservices.services.stomp.StompSessionMessage;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.messaging.WebSocketStompClient;
import org.springframework.web.socket.sockjs.client.SockJsClient;
import org.springframework.web.socket.sockjs.client.WebSocketTransport;

public class StompMessageService
extends BaseService
implements MessageService {
    protected Log logger = LogFactory.getLog(MessageService.class);
    private final String STOMP_HOMOLOG = "https://mbroker-hom.auttar.com.br/stomp";
    private final String STOMP_PROD = "https://mbroker.auttar.com.br/stomp";
    private int retry = 0;
    private WebSocketHttpHeaders headers;
    private StompHeaders connectHeaders;
    private WebSocketStompClient stompClient;
    private static final int WEB_SOCKET_MAX_MESSAGE_SIZE = 5253125;

    public StompMessageService(Configuration configuration) {
        super(configuration);
    }

    private boolean configure() {
        WebSocketTransport webSocketTransport = new WebSocketTransport((WebSocketClient)new StandardWebSocketClient());
        List<WebSocketTransport> transports = Collections.singletonList(webSocketTransport);
        SockJsClient sockJsClient = new SockJsClient(transports);
        this.stompClient = new WebSocketStompClient((WebSocketClient)sockJsClient);
        this.stompClient.setMessageConverter((MessageConverter)new ByteArrayMessageConverter());
        this.stompClient.setInboundMessageSizeLimit(5253125);
        Configuration configuration = this.getConfiguration();
        String user = configuration.getUser();
        String password = configuration.getPassword();
        if ("https://mbroker-hom.auttar.com.br/stomp".equalsIgnoreCase(configuration.getHost())) {
            user = "svc_postef_nicho";
            password = "U6iz6PfrgIVWx2Ts35Ml";
        } else if ("https://mbroker.auttar.com.br/stomp".equalsIgnoreCase(configuration.getHost())) {
            user = "svc_postef_nicho";
            password = "<9d4<mNKfMtIt$L";
        }
        String plainCredentials = user + ":" + password;
        String base64Credentials = new String(Base64.encodeBase64(plainCredentials.getBytes()));
        this.headers = new WebSocketHttpHeaders();
        this.headers.add("Authorization", "Basic " + base64Credentials);
        this.connectHeaders = new StompHeaders();
        this.connectHeaders.set("login", user);
        this.connectHeaders.set("passcode", password);
        return true;
    }

    @Override
    public boolean isRunning() {
        return this.stompClient != null && this.stompClient.isRunning();
    }

    @Override
    public boolean connect() {
        if (!this.configure()) {
            this.logger.error("nao foi possivel configurar StompMessageService");
            return false;
        }
        try {
            this.logger.info("conectando ao hub de servicos...");
            ListenableFuture future = this.stompClient.connect(this.getConfiguration().getHost(), this.headers, this.connectHeaders, (StompSessionHandler)new HandlerAdapter(), new Object[0]);
            StompSession stompSession = (StompSession)future.get();
            this.logger.info("conectado ao hub de servicos.");
            if (this.getConfiguration().getMobilePosCode() != null) {
                this.subscribeGetPayment(stompSession, this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getMobilePosCode());
                this.subscribePaymentResult(stompSession, this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getMobilePosCode());
                this.subscribeStatusCheck(stompSession, this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getMobilePosCode());
            }
            if (this.getConfiguration().getExternalCode() != null && !"".equals(this.getConfiguration().getExternalCode())) {
                this.subscribeCheckoutRequest(stompSession, this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode());
                this.subscribeStartPayment(stompSession, this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getExternalCode());
                this.subscribeCancelPayment(stompSession, this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getExternalCode());
                this.subscribeTaxReceiptGenerate(stompSession, this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getExternalCode());
                this.subscribeGetTaxReceipt(stompSession, this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getExternalCode());
                this.subscribePostPayment(stompSession, this.getConfiguration().getCompanyCode(), this.getConfiguration().getStoreCode(), this.getConfiguration().getExternalCode());
            }
        }
        catch (InterruptedException e) {
            this.logger.error("InterruptedException when setting up the broker client:" + e.getMessage(), e);
            return false;
        }
        catch (ExecutionException e) {
            this.logger.error("ExecutionException when setting up the broker client:" + e.getMessage(), e);
            return false;
        }
        return true;
    }

    @Override
    public void disconnect() {
        this.stompClient.stop();
        this.retry = 0;
    }

    private SessionMessage createSession(StompHeaders stompHeaders, StompSession stompSession, SessionMessageType type) {
        String sessionId = UUID.randomUUID().toString();
        StompSessionMessage sessionMessage = new StompSessionMessage(sessionId, stompHeaders, stompSession, type);
        this.logger.info(String.format("request -> type: %s, sessionId: %s", sessionMessage.getType().name(), sessionMessage.getSessionId()));
        return sessionMessage;
    }

    private void trace(SessionMessage sessionMessage, String json) {
        this.logger.trace(String.format("request -> %s (%s): %s", sessionMessage.getType().name(), sessionMessage.getSessionId(), json));
    }

    private void subscribeGetPayment(final StompSession stompSession, String companyCode, String storeCode, String remotePOSTefCode) throws ExecutionException, InterruptedException {
        String channel = "/exchange/request.get.payment_request/company." + companyCode + ".store." + storeCode + ".payment_pos_code." + remotePOSTefCode;
        this.logger.info("channel get.payment_request: " + channel);
        stompSession.subscribe(channel, new StompFrameHandler(){

            public Type getPayloadType(StompHeaders stompHeaders) {
                return byte[].class;
            }

            public void handleFrame(StompHeaders stompHeaders, Object payload) {
                try {
                    if (stompHeaders.keySet().contains("reply-to")) {
                        String json = new String((byte[])payload);
                        SessionMessage sessionMessage = StompMessageService.this.createSession(stompHeaders, stompSession, SessionMessageType.get_payment_request);
                        StompMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        Checkout checkout = gson.fromJson(json, Checkout.class);
                        checkout.setJsonRawValue(json);
                        StompMessageService.this.firePaymenteRequestListener(sessionMessage, checkout);
                    }
                }
                catch (Exception e) {
                    StompMessageService.this.logger.error("erro no processamento handle 'get.payment_request' -> " + e.getMessage(), e);
                }
            }
        });
        this.logger.info("channel get.payment_request -> status: OK");
    }

    private void subscribePaymentResult(final StompSession stompSession, String companyCode, String storeCode, String remotePOSTefCode) throws ExecutionException, InterruptedException {
        String channel = "/exchange/request.post.payment_result/company." + companyCode + ".store." + storeCode + ".payment_pos_code." + remotePOSTefCode;
        this.logger.info("channel post.payment_result: " + channel);
        stompSession.subscribe(channel, new StompFrameHandler(){

            public Type getPayloadType(StompHeaders stompHeaders) {
                return byte[].class;
            }

            public void handleFrame(StompHeaders stompHeaders, Object payload) {
                try {
                    if (stompHeaders.keySet().contains("reply-to")) {
                        String json = new String((byte[])payload);
                        SessionMessage sessionMessage = StompMessageService.this.createSession(stompHeaders, stompSession, SessionMessageType.post_payment_result);
                        StompMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        PaymentResult paymentResult = gson.fromJson(json, PaymentResult.class);
                        paymentResult.setJsonRawValue(json);
                        StompMessageService.this.firePaymenteResultListener(sessionMessage, paymentResult);
                    }
                }
                catch (Exception e) {
                    StompMessageService.this.logger.error("erro no processamento do handle 'post.payment_result' -> " + e.getMessage(), e);
                }
            }
        });
        this.logger.info("channel post.payment_result -> status: OK");
    }

    public void subscribeStatusCheck(final StompSession stompSession, String companyCode, String storeCode, String remotePOSTefCode) throws ExecutionException, InterruptedException {
        String channel = "/exchange/request.get.pinpad_movel_status_check/company." + companyCode + ".store." + storeCode + ".payment_pos_code." + remotePOSTefCode;
        this.logger.info("channel get.pinpad_movel_status_check: " + channel);
        stompSession.subscribe(channel, new StompFrameHandler(){

            public Type getPayloadType(StompHeaders stompHeaders) {
                return byte[].class;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleFrame(StompHeaders stompHeaders, Object payload) {
                if (stompHeaders.keySet().contains("correlation-id") && stompHeaders.keySet().contains("reply-to")) {
                    ResultModel resultModel = new ResultModel();
                    SessionMessage sessionMessage = StompMessageService.this.createSession(stompHeaders, stompSession, SessionMessageType.get_pinpad_movel_status_check);
                    try {
                        String json = new String((byte[])payload);
                        StompMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        gson.fromJson(json, StatusCheck.class);
                        resultModel.setSucess();
                    }
                    catch (Exception e) {
                        StompMessageService.this.logger.error("erro no processamento do handle 'get.pinpad_movel_status_check' -> " + e.getMessage(), e);
                        resultModel.setGenericError();
                    }
                    finally {
                        sessionMessage.send(resultModel);
                    }
                }
            }
        });
        this.logger.info("channel pinpad_movel_status_check -> status: OK");
    }

    private void subscribeCheckoutRequest(final StompSession stompSession, String companyCode, String storeCode) throws ExecutionException, InterruptedException {
        String channel = "/exchange/request.get.checkout/company." + companyCode + ".store." + storeCode;
        this.logger.info("channel get.checkout: " + channel);
        stompSession.subscribe(channel, new StompFrameHandler(){

            public Type getPayloadType(StompHeaders stompHeaders) {
                return byte[].class;
            }

            public void handleFrame(StompHeaders stompHeaders, Object payload) {
                try {
                    if (stompHeaders.keySet().contains("correlation-id") && stompHeaders.keySet().contains("reply-to")) {
                        String json = new String((byte[])payload);
                        SessionMessage sessionMessage = StompMessageService.this.createSession(stompHeaders, stompSession, SessionMessageType.get_checkout);
                        StompMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        SearchCheckout checkout = gson.fromJson(json, SearchCheckout.class);
                        checkout.setJsonRawValue(json);
                        StompMessageService.this.fireCheckoutListener(sessionMessage, checkout);
                    }
                }
                catch (Exception e) {
                    StompMessageService.this.logger.error("erro no processamento do handle 'get.checkout' -> " + e.getMessage(), e);
                }
            }
        });
        this.logger.info("channel get.checkout -> status: OK");
    }

    private void subscribeStartPayment(final StompSession stompSession, String companyCode, String storeCode, String posCode) throws ExecutionException, InterruptedException {
        String channel = "/exchange/request.post.start_payment/company." + companyCode + ".store." + storeCode + ".pos." + posCode;
        this.logger.info("channel post.start_payment: " + channel);
        stompSession.subscribe(channel, new StompFrameHandler(){

            public Type getPayloadType(StompHeaders stompHeaders) {
                return byte[].class;
            }

            public void handleFrame(StompHeaders stompHeaders, Object payload) {
                try {
                    if (stompHeaders.keySet().contains("correlation-id") && stompHeaders.keySet().contains("reply-to")) {
                        String json = new String((byte[])payload);
                        SessionMessage sessionMessage = StompMessageService.this.createSession(stompHeaders, stompSession, SessionMessageType.post_checkout_start_payment);
                        StompMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        Checkout checkout = gson.fromJson(json, Checkout.class);
                        checkout.setJsonRawValue(json);
                        StompMessageService.this.fireCheckoutStartPaymentListener(sessionMessage, checkout);
                    }
                }
                catch (Exception e) {
                    StompMessageService.this.logger.error("erro no processamento do handle 'post.start_payment' -> " + e.getMessage(), e);
                }
            }
        });
        this.logger.info("channel post.start_payment -> status: OK");
    }

    private void subscribeCancelPayment(final StompSession stompSession, String companyCode, String storeCode, String posCode) throws ExecutionException, InterruptedException {
        String channel = "/exchange/request.post.cancel_payment/company." + companyCode + ".store." + storeCode + ".pos." + posCode;
        this.logger.info("channel post.cancel_payment: " + channel);
        stompSession.subscribe(channel, new StompFrameHandler(){

            public Type getPayloadType(StompHeaders stompHeaders) {
                return byte[].class;
            }

            public void handleFrame(StompHeaders stompHeaders, Object payload) {
                try {
                    if (stompHeaders.keySet().contains("correlation-id") && stompHeaders.keySet().contains("reply-to")) {
                        String json = new String((byte[])payload);
                        SessionMessage sessionMessage = StompMessageService.this.createSession(stompHeaders, stompSession, SessionMessageType.post_checkout_cancel_payment);
                        StompMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        Checkout checkout = gson.fromJson(json, Checkout.class);
                        checkout.setJsonRawValue(json);
                        StompMessageService.this.fireCheckoutCancelPaymentListener(sessionMessage, checkout);
                    }
                }
                catch (Exception e) {
                    StompMessageService.this.logger.error("erro no processamento do handle 'post.cancel_payment' -> " + e.getMessage(), e);
                }
            }
        });
        this.logger.info("channel post.cancel_payment -> status: OK");
    }

    private void subscribeTaxReceiptGenerate(final StompSession stompSession, String companyCode, String storeCode, String posCode) throws ExecutionException, InterruptedException {
        String channel = "/exchange/request.post.generate_tax_receipt/company." + companyCode + ".store." + storeCode + ".pos." + posCode;
        this.logger.info("channel post.generate_tax_receipt: " + channel);
        stompSession.subscribe(channel, new StompFrameHandler(){

            public Type getPayloadType(StompHeaders stompHeaders) {
                return byte[].class;
            }

            public void handleFrame(StompHeaders stompHeaders, Object payload) {
                try {
                    if (stompHeaders.keySet().contains("correlation-id") && stompHeaders.keySet().contains("reply-to")) {
                        String json = new String((byte[])payload);
                        SessionMessage sessionMessage = StompMessageService.this.createSession(stompHeaders, stompSession, SessionMessageType.post_tax_receipt_generate);
                        StompMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        TaxReceiptRequest taxReceiptRequest = gson.fromJson(json, TaxReceiptRequest.class);
                        taxReceiptRequest.setJsonRawValue(json);
                        StompMessageService.this.fireTaxReceiptListener(sessionMessage, taxReceiptRequest);
                    }
                }
                catch (Exception e) {
                    StompMessageService.this.logger.error("erro no processamento do handle 'post.generate_tax_receipt' -> " + e.getMessage(), e);
                }
            }
        });
        this.logger.info("channel post.generate_tax_receipt -> status: OK");
    }

    private void subscribeGetTaxReceipt(final StompSession stompSession, String companyCode, String storeCode, String posCode) throws ExecutionException, InterruptedException {
        String channel = "/exchange/request.get.tax_receipt/company." + companyCode + ".store." + storeCode + ".pos." + posCode;
        this.logger.info("channel get.tax_receip: " + channel);
        stompSession.subscribe(channel, new StompFrameHandler(){

            public Type getPayloadType(StompHeaders stompHeaders) {
                return byte[].class;
            }

            public void handleFrame(StompHeaders stompHeaders, Object payload) {
                try {
                    if (stompHeaders.keySet().contains("correlation-id") && stompHeaders.keySet().contains("reply-to")) {
                        String json = new String((byte[])payload);
                        SessionMessage sessionMessage = StompMessageService.this.createSession(stompHeaders, stompSession, SessionMessageType.get_tax_receipt);
                        StompMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        TaxReceiptRequest taxReceiptRequest = gson.fromJson(json, TaxReceiptRequest.class);
                        taxReceiptRequest.setJsonRawValue(json);
                        StompMessageService.this.fireTaxReceiptListener(sessionMessage, taxReceiptRequest);
                    }
                }
                catch (Exception e) {
                    StompMessageService.this.logger.error("erro no processamento do handle 'get.tax_receipt' -> " + e.getMessage(), e);
                }
            }
        });
        this.logger.info("channel get.tax_receip -> status: OK");
    }

    private void subscribePostPayment(final StompSession stompSession, String companyCode, String storeCode, String posCode) throws ExecutionException, InterruptedException {
        String channel = "/exchange/request.post.payment/company." + companyCode + ".store." + storeCode + ".pos." + posCode;
        this.logger.info("channel request.post.payment: " + channel);
        stompSession.subscribe(channel, new StompFrameHandler(){

            public Type getPayloadType(StompHeaders stompHeaders) {
                return byte[].class;
            }

            public void handleFrame(StompHeaders stompHeaders, Object payload) {
                try {
                    if (stompHeaders.keySet().contains("correlation-id") && stompHeaders.keySet().contains("reply-to")) {
                        String json = new String((byte[])payload);
                        SessionMessage sessionMessage = StompMessageService.this.createSession(stompHeaders, stompSession, SessionMessageType.post_payment);
                        StompMessageService.this.trace(sessionMessage, json);
                        Gson gson = new Gson();
                        Payment payment = gson.fromJson(json, Payment.class);
                        payment.setJsonRawValue(json);
                        StompMessageService.this.firePaymentListerner(sessionMessage, payment);
                    }
                }
                catch (Exception e) {
                    StompMessageService.this.logger.error("erro no processamento do handle 'request.post.payment' -> " + e.getMessage(), e);
                }
            }
        });
        this.logger.info("channel request.post.payment -> status: OK");
    }

    private boolean reconnect() {
        if (this.retry <= 5) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.logger.error("erro no sleep do retry");
            }
            ++this.retry;
            return true;
        }
        return false;
    }

    private class HandlerAdapter
    extends StompSessionHandlerAdapter {
        private HandlerAdapter() {
        }

        public void afterConnected(StompSession stompSession, StompHeaders stompHeaders) {
            StompMessageService.this.logger.info("Connected");
        }

        public void handleException(StompSession session, StompCommand command, StompHeaders headers, byte[] payload, Throwable exception) {
            StompMessageService.this.logger.error("handleException - " + exception.getMessage() + ": " + new String(payload));
            if (!session.isConnected()) {
                if (StompMessageService.this.reconnect()) {
                    StompMessageService.this.connect();
                } else {
                    StompMessageService.this.disconnect();
                }
            }
        }

        public void handleTransportError(StompSession session, Throwable exception) {
            StompMessageService.this.logger.error("handleTransportError - " + exception.getMessage());
            if (!session.isConnected()) {
                if (StompMessageService.this.reconnect()) {
                    StompMessageService.this.connect();
                } else {
                    StompMessageService.this.disconnect();
                }
            }
        }
    }
}

