/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.services.ampq;

import br.com.auttar.clientservices.services.SessionMessage;
import br.com.auttar.clientservices.services.SessionMessageType;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AMQPSessionMessage
implements SessionMessage {
    protected Log logger = LogFactory.getLog(SessionMessage.class);
    private String sessionId;
    private Channel channel;
    private AMQP.BasicProperties properties;
    private SessionMessageType type;

    public AMQPSessionMessage(String sessionId, Channel channel, AMQP.BasicProperties properties, SessionMessageType type) {
        this.sessionId = sessionId;
        this.channel = channel;
        this.properties = properties;
        this.type = type;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public SessionMessageType getType() {
        return this.type;
    }

    @Override
    public <Type extends Serializable> void send(Type object) {
        Gson gson = new Gson();
        String json = gson.toJson(object);
        this.logger.trace(String.format("response -> %s (%s): %s", this.getType().name(), this.sessionId, json));
        try {
            AMQP.BasicProperties.Builder propertiesBuilder = new AMQP.BasicProperties.Builder();
            propertiesBuilder.correlationId(this.properties.getCorrelationId());
            propertiesBuilder.replyTo(this.properties.getReplyTo());
            propertiesBuilder.contentType("application/json");
            propertiesBuilder.contentEncoding("UTF-8");
            AMQP.BasicProperties propertiesAMQP = propertiesBuilder.build();
            this.channel.basicPublish("", propertiesAMQP.getReplyTo(), propertiesAMQP, json.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.info(String.format("response -> type: %s, sessionId: %s", this.type.name(), this.sessionId));
    }

    @Override
    public void send(JsonObject object) {
        Gson gson = new Gson();
        String json = gson.toJson(object);
        this.logger.trace(String.format("response -> %s (%s): %s", this.getType().name(), this.sessionId, json));
        try {
            AMQP.BasicProperties.Builder propertiesBuilder = new AMQP.BasicProperties.Builder();
            propertiesBuilder.correlationId(this.properties.getCorrelationId());
            propertiesBuilder.replyTo(this.properties.getReplyTo());
            propertiesBuilder.contentType("application/json");
            propertiesBuilder.contentEncoding("UTF-8");
            AMQP.BasicProperties propertiesAMQP = propertiesBuilder.build();
            this.channel.basicPublish("", propertiesAMQP.getReplyTo(), propertiesAMQP, json.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.info(String.format("response -> type: %s, sessionId: %s", this.type.name(), this.sessionId));
    }
}

