/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.services.ampq;

import br.com.auttar.clientservices.services.BaseService;
import br.com.auttar.clientservices.services.Configuration;
import br.com.auttar.clientservices.services.ampq.AMQPException;
import br.com.auttar.clientservices.util.QueueNameBuilder;
import br.com.auttar.framework.http.Http;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AMQPPublisherService
extends BaseService {
    protected Connection conn;
    protected Channel channel;
    protected ConnectionFactory factory;
    private final String AMQP_HOMOLOG = "mqueue-hom.auttar.com.br";
    private final String AMQP_PROD = "mqueue.auttar.com.br";
    private final String AMQP_DEV = "gncashdl01055";
    private Log logger = LogFactory.getLog(AMQPPublisherService.class);

    public AMQPPublisherService(Configuration configuration) {
        super(configuration);
    }

    public String postGet(String exchangeName, String requestRoutingKey, String requestBody) throws Exception {
        String response = null;
        this.logger.info("request: " + requestBody);
        try {
            this.validateParameters(exchangeName, requestRoutingKey, requestBody);
            String corrId = UUID.randomUUID().toString();
            String responseQueueName = new QueueNameBuilder().buildResponseWithExchangeNameAndCorrId(exchangeName, corrId);
            this.declareListeningQueue(responseQueueName);
            ArrayBlockingQueue<String> responseQueue = new ArrayBlockingQueue<String>(1);
            String consumerTag = this.defineHandlerToListeningQueue(responseQueueName, corrId, responseQueue);
            this.postMessageToExchange(exchangeName, requestRoutingKey, requestBody, responseQueueName, corrId);
            response = (String)responseQueue.poll(10000L, TimeUnit.MILLISECONDS);
            this.channel.basicCancel(consumerTag);
            if (response == null) {
                throw new AMQPException(Http.REQUEST_TIMEOUT, 1, "Timeout na comunicacao");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            throw e;
        }
        this.logger.info("response: " + response);
        return response;
    }

    protected void validateParameters(String exchangeName, String requestRoutingKey, String requestBody) {
        if (requestBody == null) {
            requestBody = "";
        }
    }

    protected String declareListeningQueue(String responseQueueName) throws IOException {
        this.channel.queueDeclare(responseQueueName, false, true, true, null);
        return responseQueueName;
    }

    protected String defineHandlerToListeningQueue(String responseQueueName, final String corrId, final BlockingQueue<String> responseQueue) throws IOException, InterruptedException {
        String consumerTag = this.channel.basicConsume(responseQueueName, true, (Consumer)new DefaultConsumer(this.channel){

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                if (corrId == null || properties.getCorrelationId().equals(corrId)) {
                    responseQueue.offer(new String(body, "UTF-8"));
                }
            }
        });
        return consumerTag;
    }

    protected void postMessageToExchange(String exchangeName, String requestRoutingKey, String requestBody, String responseQueueName, String corrId) throws IOException {
        AMQP.BasicProperties.Builder propertiesBuilder = new AMQP.BasicProperties.Builder();
        if (corrId != null) {
            propertiesBuilder.correlationId(corrId);
        }
        if (responseQueueName != null) {
            propertiesBuilder.replyTo(responseQueueName);
        }
        AMQP.BasicProperties properties = propertiesBuilder.build();
        this.channel.basicPublish(exchangeName, requestRoutingKey, properties, requestBody.getBytes());
    }

    private boolean configure() {
        String host;
        Configuration configuration = this.getConfiguration();
        String user = configuration.getUser();
        String password = configuration.getPassword();
        int port = 0;
        if (configuration.getHost() != null && !"".equals(configuration.getHost().trim())) {
            String[] hosts = configuration.getHost().split(":");
            host = hosts[0];
            if (hosts.length == 2) {
                try {
                    port = Integer.parseInt(hosts[1]);
                }
                catch (Exception e) {
                    this.logger.error("porta invalida para conexao com o host.");
                    return false;
                }
            } else {
                this.logger.info("utilizando porta defaut para conexao com o host.");
            }
        } else {
            this.logger.error("host invalido para conexao.");
            return false;
        }
        if ("mqueue-hom.auttar.com.br".equalsIgnoreCase(host)) {
            user = "svc_postef_nicho";
            password = "U6iz6PfrgIVWx2Ts35Ml";
            port = port == 0 ? 35000 : port;
        } else if ("mqueue.auttar.com.br".equalsIgnoreCase(host)) {
            user = "svc_postef_nicho";
            password = "<9d4<mNKfMtIt$L";
            port = port == 0 ? 35000 : port;
        } else if ("gncashdl01055".equalsIgnoreCase(host)) {
            user = "svc_postef_nicho";
            password = "T3rHnahPxUkNWNpWqrAJ";
            port = 5671;
        }
        SSLContext sslContext = null;
        SSLSocketFactory sslSocketFactory = null;
        try {
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, null, null);
            SSLContext.setDefault(sslContext);
            sslSocketFactory = sslContext.getSocketFactory();
            SSLSocket socket = (SSLSocket)sslSocketFactory.createSocket();
            socket.getEnabledProtocols();
            socket.getEnabledCipherSuites();
        }
        catch (Exception e) {
            this.logger.error("nao foi possivel inicializar SSLContext TLSv1.2");
        }
        this.factory = new ConnectionFactory();
        this.factory.setSocketFactory((SocketFactory)sslSocketFactory);
        this.factory.setHost(host);
        this.factory.setUsername(user);
        this.factory.setPassword(password);
        this.factory.setPort(port);
        return true;
    }

    public boolean startUp() throws Exception {
        if (this.factory == null) {
            this.factory = new ConnectionFactory();
            if (!this.configure()) {
                this.logger.error("nao foi possivel configurar AMQPMessageService");
                return false;
            }
        }
        try {
            if (this.conn == null) {
                this.conn = this.factory.newConnection();
            }
            if (this.channel == null) {
                this.channel = this.conn.createChannel();
            }
        }
        catch (IOException e) {
            this.logger.error("nao foi possivel conectar no hub de servicos. " + e.getMessage());
            return false;
        }
        catch (TimeoutException e) {
            this.logger.error("timeout na conexao com hub de servicos. " + e.getMessage());
            return false;
        }
        return true;
    }

    public void endUp() throws Exception {
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }
}

