/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.services;

import br.com.auttar.clientservices.model.ListDataModel;
import br.com.auttar.clientservices.model.RequestPayloadModel;
import br.com.auttar.clientservices.model.ResultModel;
import br.com.auttar.clientservices.services.SessionMessage;
import br.com.auttar.clientservices.services.SessionMessageType;
import br.com.auttar.clientservices.util.gson.GsonBuilderUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModelFactory {
    private static Log log = LogFactory.getLog(ModelFactory.class);

    public static <T extends Serializable> T build(JsonObject jsonObject, Class<T> classOfT) {
        try {
            Gson gson = GsonBuilderUtils.getDefaultBuild().create();
            Type type = new TypeToken<T>(){}.getType();
            return (T)((Serializable)gson.fromJson((JsonElement)jsonObject, type));
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public static ResultModel buildFromResultModel(JsonObject jsonObject) {
        try {
            return ModelFactory.build(jsonObject, ResultModel.class);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public static <T extends Serializable> ListDataModel<T> buildFromListaDataModel(JsonObject jsonObject, Class<T> classOfT) {
        try {
            Gson gson = GsonBuilderUtils.getDefaultBuild().create();
            Type type = new TypeToken<ListDataModel<T>>(){}.getType();
            return (ListDataModel)gson.fromJson((JsonElement)jsonObject, type);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public static <T extends Serializable> RequestPayloadModel<T> buildFromRequestPayloadModel(SessionMessage sessionMessage, Class<T> classOfT, String id) {
        SessionMessageType sessionMessageType = sessionMessage.getType();
        RequestPayloadModel requestPayloadModel = new RequestPayloadModel(id);
        requestPayloadModel.setName(sessionMessageType.name());
        requestPayloadModel.setMethod(sessionMessageType.method());
        return requestPayloadModel;
    }
}

