/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.model;

import br.com.auttar.clientservices.model.CustomException;
import br.com.auttar.clientservices.model.ResponseCode;
import org.springframework.http.HttpStatus;

public class ServiceResponse {
    private Integer code;
    private Integer status;
    private String message;

    public ServiceResponse() {
    }

    public ServiceResponse(ResponseCode responseCode, HttpStatus status) {
        this.setCode(responseCode.getValue());
        this.setMessage(responseCode.getName());
        this.setStatus(status.value());
    }

    public ServiceResponse(CustomException ex) {
        this.setCode(ex.getCode().getValue());
        if (ex.getStatus() != null) {
            this.setStatus(ex.getStatus().value());
        } else {
            this.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        this.setMessage(ex.getCode().getName());
    }

    public ServiceResponse(Exception ex) {
        if (ex instanceof CustomException) {
            CustomException customException = (CustomException)ex;
            this.setCode(customException.getCode().getValue());
            if (customException.getStatus() != null) {
                this.setStatus(customException.getStatus().value());
            } else {
                this.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            }
            this.setMessage(customException.getCode().getName());
        } else {
            this.setCode(ResponseCode.GENERIC_ERROR.getValue());
            this.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            this.setMessage(ResponseCode.GENERIC_ERROR.getName());
        }
    }

    public void setSuccess() {
        this.setCode(ResponseCode.SUCCESS.getValue());
        this.setMessage(ResponseCode.SUCCESS.getName());
        this.setStatus(HttpStatus.OK.value());
    }

    public void setSuccessCreated() {
        this.setCode(ResponseCode.SUCCESS.getValue());
        this.setMessage(ResponseCode.SUCCESS.getName());
        this.setStatus(HttpStatus.CREATED.value());
    }

    public void setSuccessNoContent() {
        this.setCode(ResponseCode.SUCCESS.getValue());
        this.setMessage(ResponseCode.SUCCESS.getName());
        this.setStatus(HttpStatus.NO_CONTENT.value());
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String toJsonString() {
        return "";
    }
}

