/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.handlers.socket;

import br.com.auttar.clientservices.model.CancelTransaction;
import br.com.auttar.clientservices.model.Checkout;
import br.com.auttar.clientservices.model.Payment;
import br.com.auttar.clientservices.model.RequestPayloadModel;
import br.com.auttar.clientservices.model.SearchCheckout;
import br.com.auttar.clientservices.model.TaxReceiptRequest;
import br.com.auttar.clientservices.services.CheckoutListener;
import br.com.auttar.clientservices.services.ModelFactory;
import br.com.auttar.clientservices.services.PaymentListener;
import br.com.auttar.clientservices.services.SessionMessage;
import br.com.auttar.clientservices.services.TaxReceiptListener;
import br.com.auttar.framework.socket.DefaultSocketHandler;
import br.com.auttar.framework.socket.MessageSocketHandler;
import br.com.auttar.framework.socket.MonitorSocketHandler;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalClientSocketHandler
extends DefaultSocketHandler
implements CheckoutListener,
TaxReceiptListener,
PaymentListener {
    protected Log log = LogFactory.getLog(LocalClientSocketHandler.class);
    private Scanner scanner;
    private ConcurrentMap<String, SessionMessage> sessionsCache = new ConcurrentHashMap<String, SessionMessage>();

    public <T extends MessageSocketHandler> LocalClientSocketHandler(Class<T> messageSocketHandeler, SocketChannel socket, MonitorSocketHandler monitorSocket) {
        super(messageSocketHandeler, socket, monitorSocket);
    }

    @Override
    protected byte[] doRead(SocketChannel client) throws Exception {
        if (this.scanner == null) {
            this.scanner = new Scanner(client);
        }
        try {
            return this.read(this.scanner);
        }
        catch (Exception e) {
            this.scanner.close();
            this.log.error(e.getMessage(), e);
            throw e;
        }
    }

    private byte[] read(Scanner scanner) {
        String line = scanner.nextLine();
        return line.getBytes();
    }

    @Override
    public void send(byte[] message) {
        try {
            this.getSocketChannel().write(ByteBuffer.wrap((new String(message) + "\n").getBytes()));
        }
        catch (IOException e) {
            this.log.error("nao foi possivel enviar mensagem.", e);
        }
        catch (Exception e) {
            this.log.error("erro no tratamento de envio da mensagem", e);
        }
    }

    @Override
    public void close() {
        if (this.scanner != null) {
            this.scanner.close();
        }
        super.close();
    }

    protected final SessionMessage getSessionMessage(String id) {
        return (SessionMessage)this.sessionsCache.get(id);
    }

    protected final SessionMessage removeSessionMessage(String id) {
        return (SessionMessage)this.sessionsCache.remove(id);
    }

    @Override
    public void onGetCheckout(SessionMessage sessionMessage, SearchCheckout checkout) {
        this.eventHandler(sessionMessage, SearchCheckout.class, checkout);
    }

    @Override
    public void onPostStartPayment(SessionMessage sessionMessage, Checkout checkout) {
        this.eventHandler(sessionMessage, Checkout.class, checkout);
    }

    @Override
    public void onPostCancelPayment(SessionMessage sessionMessage, Checkout checkout) {
        this.eventHandler(sessionMessage, Checkout.class, checkout);
    }

    @Override
    public void onGetTaxReceipt(SessionMessage sessionMessage, TaxReceiptRequest taxReceiptRequest) {
        this.eventHandler(sessionMessage, TaxReceiptRequest.class, taxReceiptRequest);
    }

    @Override
    public void onTaxReceiptGenerate(SessionMessage sessionMessage, TaxReceiptRequest taxReceiptRequest) {
        this.eventHandler(sessionMessage, TaxReceiptRequest.class, taxReceiptRequest);
    }

    @Override
    public void onPayment(SessionMessage sessionMessage, Payment payment) {
        this.eventHandler(sessionMessage, Payment.class, payment);
    }

    @Override
    public void onCancelTransaction(SessionMessage sessionMessage, CancelTransaction cancelTransaction) {
        this.eventHandler(sessionMessage, CancelTransaction.class, cancelTransaction);
    }

    private <T extends Serializable> void eventHandler(SessionMessage sessionMessage, Class<T> classOfT, T payload) {
        RequestPayloadModel<T> requestPayload = ModelFactory.buildFromRequestPayloadModel(sessionMessage, classOfT, UUID.randomUUID().toString());
        if (requestPayload != null) {
            requestPayload.setPayload(payload);
            Gson gson = new Gson();
            String json = gson.toJson((Object)requestPayload, (Type)((Object)RequestPayloadModel.class));
            this.sessionsCache.put(requestPayload.getId(), sessionMessage);
            this.send(json.getBytes());
        } else {
            this.log.error("nao foi possivel tratar request_payload_model para evento do tipo '" + sessionMessage.getType().name() + "'");
        }
    }
}

