/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices.handlers.http;

import br.com.auttar.clientservices.handlers.HandlerConfiguration;
import br.com.auttar.clientservices.handlers.http.DefaultHttpResponseHandler;
import br.com.auttar.clientservices.model.RawPayload;
import br.com.auttar.clientservices.services.SessionMessage;
import br.com.auttar.framework.http.HttpResponseHandler;
import br.com.auttar.framework.http.SingleHttpRequest;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultHttpRequest<T extends Serializable>
implements Runnable {
    private Log log = LogFactory.getLog(DefaultHttpRequest.class);
    private T payload;
    private SessionMessage sessionMessage;
    private Properties properties;

    public DefaultHttpRequest(SessionMessage sessionMessage, T payload, HandlerConfiguration configuration) {
        this.sessionMessage = sessionMessage;
        this.payload = payload;
    }

    protected final SessionMessage getSessionMessage() {
        return this.sessionMessage;
    }

    protected final T getPayload() {
        return this.payload;
    }

    private boolean loadProperties() {
        this.properties = new Properties();
        String fileName = "clientservices-http.properties";
        try {
            this.properties.load(new FileInputStream(new File(fileName)));
        }
        catch (FileNotFoundException e) {
            this.log.error(String.format("arquivo de configuracao '%s' nao encontrado.", fileName));
            return false;
        }
        catch (IOException e) {
            this.log.error(String.format("erro na leitura das configuracoes do handler http -> '%s'.", fileName));
            return false;
        }
        return true;
    }

    protected void execute() {
        this.log.info(String.format("http request -> %s (%s)", this.sessionMessage.getType().name(), this.sessionMessage.getSessionId()));
        if (!this.loadProperties()) {
            this.log.error(String.format("nao foi possivel carregar configuracoes para request do servico '%s'.", this.getSessionMessage().getType().name()));
            return;
        }
        Gson gson = new Gson();
        String json = null;
        if (this.payload instanceof RawPayload) {
            json = ((RawPayload)this.payload).getJsonRawValue();
        }
        if (json == null) {
            json = gson.toJson(this.payload);
        }
        SingleHttpRequest executeSingleHttp = new SingleHttpRequest(this.getMethod(), this.getUrl(), this.getHeaders(), this.getHttpResponseHandler());
        if (this.getProxy() != null) {
            executeSingleHttp.configProxy(this.getProxy());
        }
        executeSingleHttp.execute(json);
    }

    protected String getUrl() {
        String url = this.properties.getProperty("automation.url");
        if (url == null) {
            url = this.properties.getProperty("default.url");
        }
        return url;
    }

    protected String getProxy() {
        return this.properties.getProperty("default.proxy", null);
    }

    protected Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.properties.containsKey("default.header@client_id")) {
            headers.put("client_id", this.properties.getProperty("default.header@client_id"));
        }
        if (this.properties.containsKey("default.header@client_secret")) {
            headers.put("client_secret", this.properties.getProperty("default.header@client_secret"));
        }
        return headers;
    }

    protected HttpResponseHandler getHttpResponseHandler() {
        return new DefaultHttpResponseHandler(this.sessionMessage);
    }

    private String getMethod() {
        return this.sessionMessage.getType().method();
    }

    @Override
    public void run() {
        this.execute();
    }
}

