/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.clientservices;

import br.com.auttar.clientservices.handlers.ExecutableHandler;
import br.com.auttar.clientservices.handlers.http.ExecutableHttpHandler;
import br.com.auttar.clientservices.services.Configuration;
import br.com.auttar.clientservices.services.MessageService;
import br.com.auttar.clientservices.services.PaymentRequestListener;
import br.com.auttar.clientservices.services.PaymentResultListener;
import br.com.auttar.clientservices.services.SettingsCashService;
import br.com.auttar.clientservices.services.ampq.AMQPMessageService;
import br.com.auttar.framework.http.HttpHandlerForPayment;
import br.com.auttar.framework.http.HttpHandlerForSettings;
import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuttarServicesClient {
    private Log logger = LogFactory.getLog(AuttarServicesClient.class);
    public static final String VERSION = "1.1.0";
    private Configuration configuration;
    private MessageService messageService;
    private HttpServer httpServer;
    private List<ExecutableHandler> handlers;

    public AuttarServicesClient(Configuration configuration) {
        this.configuration = configuration;
        this.handlers = new ArrayList<ExecutableHandler>();
    }

    private void initializeHandlers() {
        if (this.messageService == null) {
            this.logger.error("message service invalido para inicializacao dos handlers.");
        }
        this.handlers.add(new ExecutableHttpHandler(this.messageService, null));
        this.logger.info("handler: " + ExecutableHttpHandler.class.getName());
    }

    public boolean isRunning() {
        return this.messageService != null && this.messageService.isRunning();
    }

    public boolean connect() {
        try {
            this.logger.info("inicializando cliente de servicos Auttar...");
            this.logger.info("version: 1.1.0");
            if (this.messageService == null) {
                this.messageService = new AMQPMessageService(this.configuration);
                this.initializeHandlers();
                if (this.messageService.connect()) {
                    this.logger.info("cliente de servicos conectado com sucesso");
                    for (ExecutableHandler handler : this.handlers) {
                        handler.start();
                    }
                    return this.serverUp();
                }
                this.logger.error("nao foi possivel inicializar o cliente de servicos");
            }
        }
        catch (Exception e) {
            this.logger.error("InterruptedException when setting up the broker client:" + e.getMessage());
        }
        return false;
    }

    public boolean disconnect() {
        try {
            if (this.messageService != null) {
                this.messageService.disconnect();
                for (ExecutableHandler handler : this.handlers) {
                    handler.stop();
                }
                this.logger.info("cliente de servicos desconectado com sucesso");
                this.serverDown();
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("nao foi possivel desconectar do hub de servicos");
        }
        return false;
    }

    public boolean serverUp() {
        int port = 8000;
        String paymentContext = "/payment";
        String configurationContext = "/settings";
        HttpHandlerForPayment paymentHandler = new HttpHandlerForPayment(this.configuration);
        HttpHandlerForSettings configurationHandler = new HttpHandlerForSettings(this.configuration);
        try {
            paymentHandler.connect();
            configurationHandler.connect();
            SettingsCashService settingCash = new SettingsCashService(configurationHandler);
            settingCash.verify();
            this.httpServer = HttpServer.create(new InetSocketAddress(port), 0);
            this.httpServer.createContext(paymentContext, paymentHandler);
            this.httpServer.createContext(configurationContext, configurationHandler);
            this.httpServer.setExecutor(null);
            this.httpServer.start();
        }
        catch (Exception e) {
            this.logger.error("Exception when setting up the http server:" + e.getMessage());
            return false;
        }
        return true;
    }

    public void serverDown() {
        this.httpServer.stop(0);
    }

    public void addPaymentRequestListener(PaymentRequestListener paymentRequestListener) {
        this.messageService.addPaymentRequestListener(paymentRequestListener);
    }

    public void removePaymentRequestListener(PaymentRequestListener paymentRequestListener) {
        this.messageService.removePaymentRequestListener(paymentRequestListener);
    }

    public void addPaymentResultListener(PaymentResultListener listener) {
        this.messageService.addPaymentResultListener(listener);
    }

    public void removePaymentResultListener(PaymentResultListener listener) {
        this.messageService.removePaymentResultListener(listener);
    }
}

