/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar;

import br.com.auttar.AuttarLogger;
import br.com.auttar.QrCodeGenerator;
import br.com.auttar.util.factories.PinpadDriverFactory;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloAbecs;
import java.util.Objects;
import net.glxn.qrgen.core.image.ImageType;
import net.glxn.qrgen.javase.QRCode;

public class QrCodeGeneratorJavaSE
implements QrCodeGenerator {
    @Override
    public byte[] createQrCode(String qrCode) {
        int size = 0;
        AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
        try {
            ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
            GenericPinpadController protocol = GenericPinpadController.getInstance(config.getPinPad().getParametros()[0]);
            protocol.testCommunication();
            if (protocol.getInfoEMV().getGraphicDisplayColumnsNum() != null && protocol.getInfoEMV().getGraphicDisplayLinesNum() != null) {
                size = Math.min(protocol.getInfoEMV().getGraphicDisplayColumnsNum(), protocol.getInfoEMV().getGraphicDisplayLinesNum()) - 2;
            } else {
                logger.warn("Nao foi possivel definir o tamanho do QR Code pelo tamanho do display do pinpad");
            }
        }
        catch (Exception ex) {
            logger.warn(String.format("Erro em QrCodeGeneratorJavaSE.createQrCode(%s): %s", qrCode, ex.getMessage()));
        }
        if (size <= 0) {
            size = 130;
        }
        return this.createQrCodeWithSize(qrCode, size);
    }

    @Override
    public byte[] createQrCodeWithSize(String qrCode, int size) {
        return QRCode.from(qrCode).to(ImageType.PNG).withSize(size, size).stream().toByteArray();
    }

    @Override
    public void showQrCode(byte[] qrCode, String pinCode, String transactionValue, String transactionType) throws Exception {
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        GenericPinpadController protocol = GenericPinpadController.getInstance(config.getPinPad().getParametros()[0]);
        String pinpadCapacity = Objects.requireNonNull(protocol).getInfoEMV().getPinpadCapacity();
        if (pinpadCapacity == null) {
            throw new ExcecaoPerifericos("QRCG01", "Pinpad incompativel com protocoo ABECS");
        }
        if (pinpadCapacity.toCharArray()[1] != '2') {
            throw new ExcecaoPerifericos("QRCG02", "Pinpad sem display grafico", "pinpadCapacity = " + pinpadCapacity);
        }
        ProtocoloAbecs abecs = (ProtocoloAbecs)protocol;
        abecs.removeImage("qrcode01".toCharArray());
        abecs.displayImage("qrcode01".toCharArray(), "png".toCharArray(), qrCode);
    }

    @Override
    public void hideQrCode() throws Exception {
        this.hideQrCode(true);
    }

    @Override
    public void hideQrCode(boolean isCloseConnection) throws Exception {
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        ProtocoloAbecs abecs = (ProtocoloAbecs)PinpadDriverFactory.getInstance(config.getPinPad().getParametros()[0]);
        Objects.requireNonNull(abecs).removeImage("qrcode01".toCharArray());
        if (isCloseConnection) {
            abecs.closeConnection();
        }
    }
}

