/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceServiceConst;
import com.ibm.jpos.services.DeviceServiceState;
import com.ibm.jpos.services.InputDeviceServiceState;
import com.ibm.jpos.services.ibmprinter.MicrPrinterState;
import com.ibm.jpos.services.ibmprinter.PrintQueueManagerServiceState;
import jpos.JposException;

public class MICRServiceState
extends DeviceServiceState
implements InputDeviceServiceState,
PrintQueueManagerServiceState,
MicrPrinterState {
    private boolean autoDisable = false;
    private String accountNumber = "";
    private String amount = "";
    private String bankNumber = "";
    private int dataCount = 0;
    private boolean dataEventEnabled = false;
    private String epc = "";
    private String rawData = "";
    private String serialNumber = "";
    private String transitNumber = "";
    private int checkType = 99;
    private int countryCode = 99;
    private static final int MICR_SERVICE_VERSION = DeviceServiceConst.DEVICE_SERVICE_VERSION_NUMBER;
    private boolean recPresent = false;
    private boolean jrnPresent = false;
    private boolean slpPresent = true;
    private boolean coverOpen = false;
    private boolean flagidle = false;
    private boolean slpend = false;
    private boolean slpempty = false;

    MICRServiceState() {
    }

    public synchronized boolean getCapValidationDevice() {
        return false;
    }

    public synchronized boolean getAutoDisable() {
        return this.autoDisable;
    }

    public synchronized String getAccountNumber() {
        return this.accountNumber;
    }

    public synchronized String getAmount() {
        return this.amount;
    }

    public synchronized String getBankNumber() {
        return this.bankNumber;
    }

    public synchronized int getDataCount() {
        return this.dataCount;
    }

    public synchronized boolean getDataEventEnabled() {
        return this.dataEventEnabled;
    }

    public synchronized String getEPC() {
        return this.epc;
    }

    public synchronized String getRawData() {
        return this.rawData;
    }

    public synchronized String getSerialNumber() {
        return this.serialNumber;
    }

    public synchronized String getTransitNumber() {
        return this.transitNumber;
    }

    public synchronized int getCheckType() {
        return this.checkType;
    }

    public synchronized int getCountryCode() {
        return this.countryCode;
    }

    public synchronized void setAutoDisable(boolean b) {
        this.autoDisable = b;
    }

    public synchronized void setAccountNumber(String s) {
        this.accountNumber = s.trim();
    }

    public synchronized void setAmount(String s) {
        this.amount = s.trim();
    }

    public synchronized void setBankNumber(String s) {
        this.bankNumber = s.trim();
    }

    public synchronized void setDataCount(int i) throws JposException {
        this.checkNegativeValue(i);
        this.dataCount = i;
    }

    public synchronized void setDataEventEnabled(boolean b) {
        this.dataEventEnabled = b;
    }

    public synchronized void setEPC(String s) {
        this.epc = s.trim();
    }

    public synchronized void setRawData(String s) {
        this.rawData = s.toLowerCase();
    }

    public synchronized void setSerialNumber(String s) {
        this.serialNumber = s.trim();
    }

    public synchronized void setTransitNumber(String s) {
        this.transitNumber = s.trim();
        if (s.length() >= 8) {
            this.setBankNumber(this.transitNumber.substring(4, 8));
        }
    }

    public synchronized void setCheckType(int i) throws JposException {
        this.checkCheckTypeValue(i);
        this.checkType = i;
    }

    public synchronized void setCountryCode(int i) throws JposException {
        this.checkCountryCodeValue(i);
        this.countryCode = i;
    }

    public synchronized void setDeviceEnabled(boolean b) {
        super.setDeviceEnabled(b);
    }

    public void checkCheckTypeValue(int i) throws JposException {
        switch (i) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 99: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkCountryCodeValue(int i) throws JposException {
        switch (i) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 99: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    synchronized void initProperties() throws JposException {
        super.initProperties();
        this.setDeviceServiceVersion(MICR_SERVICE_VERSION);
        this.setAutoDisable(false);
        this.setDataCount(0);
        this.setDataEventEnabled(false);
        this.setAccountNumber("");
        this.setAmount("");
        this.setBankNumber("");
        this.setEPC("");
        this.setRawData("");
        this.setSerialNumber("");
        this.setTransitNumber("");
        this.setCheckType(99);
        this.setCountryCode(99);
    }

    public void setCapRecPresent(boolean x) {
        this.recPresent = x;
    }

    public void setCapJrnPresent(boolean x) {
        this.jrnPresent = x;
    }

    public void setCapSlpPresent(boolean x) {
        this.slpPresent = x;
    }

    public void setCoverOpen(boolean x) {
        this.coverOpen = x;
    }

    public void setFlagWhenIdle(boolean x) {
        this.flagidle = x;
    }

    public void setSlpNearEnd(boolean x) {
        this.slpend = x;
    }

    public void setSlpEmpty(boolean x) {
        this.slpempty = x;
    }

    public boolean getSlpNearEnd() {
        return this.slpend;
    }

    public boolean getSlpEmpty() {
        return this.slpempty;
    }

    public boolean getFlagWhenIdle() {
        return this.flagidle;
    }

    public boolean getAsyncMode() {
        return false;
    }

    public boolean getCapRecPresent() {
        return this.recPresent;
    }

    public boolean getCapJrnPresent() {
        return this.jrnPresent;
    }

    public boolean getCapSlpPresent() {
        return this.slpPresent;
    }

    public boolean getCoverOpen() {
        return this.coverOpen;
    }

    public void setErrorStation(int errorStation) throws JposException {
    }

    public void setErrorString(String errorString) {
    }

    public void setErrorLevel(int errorLevel) throws JposException {
    }

    public void setOutputID(int outputID) throws JposException {
    }
}

