/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.DeviceServiceConst;
import com.ibm.jpos.services.ServiceKey;
import com.ibm.jpos.services.ServiceRegistry;
import com.ibm.jpos.util.JposEntryInfo;
import jpos.JposException;

public class DeviceServiceState {
    private JposEntryInfo jposEntryInfo = null;
    private boolean zombified = false;
    private ServiceKey serviceKey = null;
    private DeviceService deviceService = null;
    private boolean capServiceAllowManagement = false;
    private String checkHealthText = "";
    private boolean deviceEnabled = false;
    private String deviceServiceDescription = "";
    private int deviceServiceVersion = DeviceServiceConst.DEVICE_SERVICE_VERSION_NUMBER;
    private boolean freezeEvents = false;
    private String physicalDeviceDescription = "";
    private String physicalDeviceName = "";
    private int state = 1;
    private int capPowerReporting = 0;
    private int powerNotify = 0;
    private int powerState = 2000;
    private int directIOMode = 0;
    private boolean capUpdateStatistics = false;
    private boolean capUpdateFirmware = false;
    private boolean capStatisticsReporting = false;
    private boolean capCompareFirmwareVersion = false;

    DeviceServiceState() {
    }

    public synchronized void isOpen() throws JposException {
        if (this.state == 1) {
            throw new JposException(101);
        }
    }

    public synchronized void isEnable() throws JposException {
        if (!this.deviceEnabled) {
            throw new JposException(105);
        }
        if (this.getDirectIOMode() != 0) {
            throw new JposException(106, "Illegal method call out of DirectIO.UPOS_MODE");
        }
    }

    public synchronized void isClaim() throws JposException {
        DeviceService claimedService = ServiceRegistry.getInstance().getClaimedService(this.getServiceKey());
        if (claimedService == this.getDeviceService()) {
            return;
        }
        if (claimedService == null) {
            throw new JposException(103);
        }
        throw new JposException(102);
    }

    public synchronized void isOpenEnable() throws JposException {
        this.isOpen();
        this.isEnable();
    }

    public synchronized void isOpenClaim() throws JposException {
        this.isOpen();
        this.isClaim();
    }

    public synchronized void isOpenClaimEnable() throws JposException {
        this.isOpen();
        this.isClaim();
        this.isEnable();
    }

    public synchronized boolean isZombified() {
        return this.zombified;
    }

    public synchronized JposEntryInfo getJposEntryInfo() {
        return this.jposEntryInfo;
    }

    synchronized void setJposEntryInfo(JposEntryInfo jInfo) {
        if (this.jposEntryInfo == null) {
            this.jposEntryInfo = jInfo;
        }
    }

    public synchronized ServiceKey getServiceKey() {
        return this.serviceKey;
    }

    synchronized DeviceService getDeviceService() {
        return this.deviceService;
    }

    public synchronized void setServiceKey(ServiceKey sKey) {
        if (this.serviceKey == null) {
            this.serviceKey = sKey;
        }
    }

    synchronized void setDeviceService(DeviceService dS) {
        this.deviceService = dS;
    }

    public synchronized boolean getCapServiceAllowManagement() {
        return this.capServiceAllowManagement;
    }

    public synchronized String getCheckHealthText() {
        return this.checkHealthText;
    }

    public synchronized boolean getClaimed() {
        DeviceService claimedService = ServiceRegistry.getInstance().getClaimedService(this.getServiceKey());
        return claimedService == this.getDeviceService();
    }

    public synchronized boolean getDeviceEnabled() {
        return this.deviceEnabled;
    }

    public synchronized String getDeviceServiceDescription() {
        return this.deviceServiceDescription;
    }

    public synchronized int getDeviceServiceVersion() {
        return this.deviceServiceVersion;
    }

    public synchronized boolean getFreezeEvents() {
        return this.freezeEvents;
    }

    public synchronized String getPhysicalDeviceDescription() {
        return this.physicalDeviceDescription;
    }

    public synchronized String getPhysicalDeviceName() {
        return this.physicalDeviceName;
    }

    public synchronized int getState() {
        return this.state;
    }

    public int getCapPowerReporting() {
        return this.capPowerReporting;
    }

    public int getPowerNotify() {
        return this.powerNotify;
    }

    public int getPowerState() {
        return this.powerState;
    }

    public int getDirectIOMode() {
        return this.directIOMode;
    }

    public boolean getCapUpdateStatistics() {
        return this.capUpdateStatistics;
    }

    public boolean getCapUpdateFirmware() {
        return this.capUpdateFirmware;
    }

    public boolean getCapStatisticsReporting() {
        return this.capStatisticsReporting;
    }

    public boolean getCapCompareFirmwareVersion() {
        return this.capCompareFirmwareVersion;
    }

    public synchronized void setCheckHealthText(String s) {
        this.checkHealthText = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setClaimed(boolean b) {
        ServiceRegistry serviceRegistry = ServiceRegistry.getInstance();
        synchronized (serviceRegistry) {
            DeviceService claimedService = ServiceRegistry.getInstance().getClaimedService(this.getServiceKey());
            if (b) {
                if (claimedService == this.getDeviceService()) {
                    return;
                }
                if (claimedService == null) {
                    ServiceRegistry.getInstance().setClaimedService(this.getServiceKey(), this.getDeviceService());
                }
            } else if (claimedService == this.getDeviceService() && this.getDeviceService() != null) {
                ServiceRegistry.getInstance().setClaimedService(this.getServiceKey(), null);
            }
        }
    }

    public synchronized void setDeviceEnabled(boolean b) {
        this.deviceEnabled = b;
    }

    public synchronized void setDeviceServiceDescription(String s) {
        this.deviceServiceDescription = s;
    }

    public synchronized void setDeviceServiceVersion(int i) {
        this.deviceServiceVersion = i;
    }

    synchronized void setFreezeEvents(boolean b) {
        this.freezeEvents = b;
    }

    public synchronized void setPhysicalDeviceDescription(String s) {
        this.physicalDeviceDescription = s;
    }

    public synchronized void setPhysicalDeviceName(String s) {
        this.physicalDeviceName = s;
    }

    public synchronized void setState(int i) throws JposException {
        this.checkStateValue(i);
        this.state = i;
    }

    public void setCapPowerReporting(int i) throws JposException {
        this.checkCapPowerReportingValue(i);
        this.capPowerReporting = i;
    }

    public void setPowerNotify(int i) throws JposException {
        this.checkPowerNotifyValue(i);
        this.powerNotify = i;
    }

    public void setPowerState(int i) throws JposException {
        this.checkPowerStateValue(i);
        this.powerState = i;
    }

    public void setDirectIOMode(int mode) {
        this.directIOMode = mode;
    }

    public void setCapCompareFirmwareVersion(boolean capCompareFirmwareVersion) {
        this.capCompareFirmwareVersion = capCompareFirmwareVersion;
    }

    public void setCapStatisticsReporting(boolean capStatisticsReporting) {
        this.capStatisticsReporting = capStatisticsReporting;
    }

    public void setCapUpdateFirmware(boolean capUpdateFirmware) {
        this.capUpdateFirmware = capUpdateFirmware;
    }

    public void setCapUpdateStatistics(boolean capUpdateStatistics) {
        this.capUpdateStatistics = capUpdateStatistics;
    }

    public void checkNegativeValue(int i) throws JposException {
        if (i < 0) {
            throw new JposException(106);
        }
    }

    public void checkNegativeOrZeroValue(int i) throws JposException {
        if (i == 0) {
            throw new JposException(106);
        }
        this.checkNegativeValue(i);
    }

    public void checkNullValue(Object obj) throws JposException {
        if (obj == null) {
            throw new JposException(106);
        }
    }

    public void checkStateValue(int i) throws JposException {
        switch (i) {
            case 3: {
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkCapPowerReportingValue(int i) throws JposException {
        switch (i) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkPowerNotifyValue(int i) throws JposException {
        switch (i) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkPowerStateValue(int i) throws JposException {
        switch (i) {
            case 2000: {
                break;
            }
            case 2001: {
                break;
            }
            case 2002: {
                break;
            }
            case 2003: {
                break;
            }
            case 2004: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    synchronized void setZombified(boolean b) {
        if (b) {
            this.zombified = b;
        }
    }

    synchronized void initProperties() throws JposException {
        this.setCheckHealthText("");
        this.setClaimed(false);
        this.setDeviceEnabled(false);
        this.setDeviceServiceDescription("");
        this.setDeviceServiceVersion(DeviceServiceConst.DEVICE_SERVICE_VERSION_NUMBER);
        this.setFreezeEvents(false);
        this.setPhysicalDeviceDescription("");
        this.setPhysicalDeviceName("");
        this.setState(1);
        this.setCapPowerReporting(0);
        this.setPowerNotify(0);
        this.setPowerState(2000);
        this.setCapCompareFirmwareVersion(false);
        this.setCapStatisticsReporting(true);
        this.setCapUpdateFirmware(false);
        this.setCapUpdateStatistics(false);
    }
}

