/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import sun.awt.image.URLImageSource;

public class NamedImageIcon
implements Icon,
Serializable {
    public static final int UNKNOWN = 0;
    public static final int FILE = 1;
    public static final int URL = 2;
    static Hashtable imgHash = new Hashtable();
    static final String genSep = "/";
    private static final long serialVersionUID = 6540177429020349730L;
    int fieldSource = 0;
    String fieldSourceFilename = null;
    String fieldResourceName = null;
    URL fieldSourceURL = null;
    String fieldDescription = null;
    transient ImageIcon imageIcon = null;

    public NamedImageIcon(String filename) {
        this(filename, filename);
    }

    public NamedImageIcon(String filename, String description) {
        this.fieldSource = 1;
        this.fieldSourceFilename = filename;
        this.fieldDescription = description;
    }

    public NamedImageIcon(URL location) {
        this(location, "");
    }

    public NamedImageIcon(URL location, String description) {
        this.fieldSource = 2;
        this.fieldSourceURL = location;
        this.fieldDescription = description;
        this.imageIcon = NamedImageIcon.makeImageIcon(location, new URLImageSource(location), description);
    }

    public String convertFilenameToResource() {
        String resourceName = "";
        if (this.fieldSourceFilename != null && this.fieldSourceFilename.length() > 0) {
            resourceName = this.fieldSourceFilename;
            if ((resourceName = resourceName.replace(File.separator.charAt(0), genSep.charAt(0))).startsWith("..")) {
                int nextSep = resourceName.indexOf(genSep, 3);
                if (nextSep < 3) {
                    nextSep = 2;
                }
                resourceName = resourceName.substring(nextSep);
            }
            if (!resourceName.startsWith(genSep)) {
                resourceName = genSep + resourceName;
            }
        }
        return resourceName;
    }

    public int getIconHeight() {
        return this.getImageIcon().getIconHeight();
    }

    public int getIconWidth() {
        return this.getImageIcon().getIconWidth();
    }

    protected ImageIcon getImageIcon() {
        if (this.imageIcon == null) {
            URL url;
            this.imageIcon = this.fieldSource == 1 ? ((url = this.getClass().getResource(this.getResourceName())) != null ? NamedImageIcon.makeImageIcon(this.fieldSourceFilename, new URLImageSource(url), this.fieldDescription) : new ImageIcon("", this.fieldDescription)) : (this.fieldSource == 2 ? NamedImageIcon.makeImageIcon(this.fieldSourceURL, new URLImageSource(this.fieldSourceURL), this.fieldDescription) : new ImageIcon());
        }
        return this.imageIcon;
    }

    public String getResourceName() {
        String result = null;
        if (this.fieldSource == 2) {
            result = this.getSourceName();
        } else if (this.fieldSource == 1) {
            if (this.fieldResourceName == null) {
                this.fieldResourceName = this.convertFilenameToResource();
            }
            result = this.fieldResourceName;
        }
        return result;
    }

    public int getSource() {
        return this.fieldSource;
    }

    public String getSourceName() {
        String result = null;
        if (this.fieldSource == 1) {
            result = this.fieldSourceFilename;
        } else if (this.fieldSource == 2 && this.fieldSourceURL != null) {
            result = this.fieldSourceURL.toExternalForm();
        }
        return result;
    }

    protected static ImageIcon makeImageIcon(Object key, ImageProducer source, String description) {
        ImageIcon anImageIcon = null;
        Image img = (Image)imgHash.get(key);
        if (img == null) {
            img = Toolkit.getDefaultToolkit().createImage(source);
            imgHash.put(key, img);
        }
        anImageIcon = new ImageIcon(img);
        anImageIcon.setDescription(description);
        return anImageIcon;
    }

    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        this.getImageIcon().paintIcon(c, g, x, y);
    }

    public void refreshFromSource() {
        Image img = null;
        if (this.fieldSource == 1) {
            img = Toolkit.getDefaultToolkit().createImage(new URLImageSource(this.getClass().getResource(this.getResourceName())));
            imgHash.put(this.fieldSourceFilename, img);
        } else if (this.fieldSource == 2) {
            img = Toolkit.getDefaultToolkit().createImage(new URLImageSource(this.fieldSourceURL));
            imgHash.put(this.fieldSourceURL, img);
        }
        if (this.imageIcon == null) {
            this.imageIcon = new ImageIcon();
        }
        this.imageIcon.setImage(img);
        this.imageIcon.setDescription(this.fieldDescription);
    }

    public String toString() {
        String result = null;
        if (this.fieldSource == 1) {
            result = this.fieldSourceFilename;
        } else if (this.fieldSource == 2) {
            result = this.fieldSourceURL.toExternalForm();
        } else if (this.imageIcon != null) {
            result = ((Object)this.imageIcon).toString();
        }
        return result;
    }
}

