/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uvm.abt.edit;

import com.ibm.uvm.abt.edit.BasicColorPropertyPage;
import com.ibm.uvm.abt.edit.RGBColorPropertyPage;
import com.ibm.uvm.abt.edit.SystemColorPropertyPage;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;

public class ColorPropertyEditor
extends Panel
implements ItemListener,
PropertyChangeListener {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("com/ibm/uvm/abt/edit/abtedit");
    private Color colorValue;
    private JRadioButton basicChoice = null;
    private JRadioButton systemChoice = null;
    private JRadioButton rgbChoice = null;
    private ButtonGroup buttonGroup = null;
    private JPanel pageHolder = null;
    private Panel pageSelector = null;
    private FlowLayout pageSelectorFlowLayout = null;
    private BasicColorPropertyPage basicColorPage = null;
    private SystemColorPropertyPage systemColorPage = null;
    private RGBColorPropertyPage rgbColorPage = null;
    private JPanel colorPreviewer = null;

    public ColorPropertyEditor() {
        this.initialize();
    }

    public ColorPropertyEditor(Color aColor) {
        this.initialize();
        this.setColorValue(aColor);
    }

    private void basicChoiceStateChanged() {
        this.switchToPage(this.getBasicColorPage());
        this.setPreviewerColor(this.getBasicColorPage().getColorValue());
    }

    private JRadioButton getBasicChoice() {
        if (this.basicChoice == null) {
            try {
                this.basicChoice = new JRadioButton();
                this.basicChoice.setName("Basic");
                this.basicChoice.setText(resabtedit.getString("Basic"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.basicChoice;
    }

    private BasicColorPropertyPage getBasicColorPage() {
        if (this.basicColorPage == null) {
            try {
                this.basicColorPage = new BasicColorPropertyPage();
                this.basicColorPage.setName("BasicColorPage");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.basicColorPage;
    }

    private ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            try {
                this.buttonGroup = new ButtonGroup();
                this.buttonGroup.add(this.getBasicChoice());
                this.buttonGroup.add(this.getSystemChoice());
                this.buttonGroup.add(this.getRGBChoice());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.buttonGroup;
    }

    public String getColorInitializationString() {
        if (this.getSystemColorPage().isVisible()) {
            return this.getSystemColorPage().getJavaInitializationString();
        }
        if (this.getBasicColorPage().isVisible()) {
            return this.getBasicColorPage().getJavaInitializationString();
        }
        return this.getRGBColorPage().getJavaInitializationString();
    }

    private JPanel getColorPreviewer() {
        if (this.colorPreviewer == null) {
            try {
                this.colorPreviewer = new JPanel();
                this.colorPreviewer.setName("ColorPreviewer");
                this.colorPreviewer.setLayout(new FlowLayout());
                this.colorPreviewer.setBorder(new EtchedBorder(0, SystemColor.controlShadow, SystemColor.controlLtHighlight));
                this.colorPreviewer.setBackground(SystemColor.window);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.colorPreviewer;
    }

    public Color getColorValue() {
        if (this.getSystemColorPage().isVisible()) {
            return this.getSystemColorPage().getColorValue();
        }
        if (this.getBasicColorPage().isVisible()) {
            return this.getBasicColorPage().getColorValue();
        }
        return this.getRGBColorPage().getColorValue();
    }

    private JPanel getPageHolder() {
        if (this.pageHolder == null) {
            try {
                this.pageHolder = new JPanel();
                this.pageHolder.setName("PageHolder");
                this.pageHolder.setLayout(new CardLayout());
                this.pageHolder.setBackground(SystemColor.window);
                this.pageHolder.add((Component)this.getBasicColorPage(), this.getBasicColorPage().getName());
                this.pageHolder.add((Component)this.getSystemColorPage(), this.getSystemColorPage().getName());
                this.pageHolder.add((Component)this.getRGBColorPage(), this.getRGBColorPage().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.pageHolder;
    }

    private Panel getPageSelector() {
        if (this.pageSelector == null) {
            try {
                this.pageSelector = new Panel();
                this.pageSelector.setName("PageSelector");
                this.pageSelector.setLayout(this.getPageSelectorFlowLayout());
                this.pageSelector.add((Component)this.getBasicChoice(), this.getBasicChoice().getName());
                this.pageSelector.add((Component)this.getSystemChoice(), this.getSystemChoice().getName());
                this.pageSelector.add((Component)this.getRGBChoice(), this.getRGBChoice().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.pageSelector;
    }

    private FlowLayout getPageSelectorFlowLayout() {
        FlowLayout pageSelectorFlowLayout = null;
        try {
            pageSelectorFlowLayout = new FlowLayout();
            pageSelectorFlowLayout.setAlignment(0);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return pageSelectorFlowLayout;
    }

    private JRadioButton getRGBChoice() {
        if (this.rgbChoice == null) {
            try {
                this.rgbChoice = new JRadioButton();
                this.rgbChoice.setName("RGB");
                this.rgbChoice.setText(resabtedit.getString("RGB"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.rgbChoice;
    }

    private RGBColorPropertyPage getRGBColorPage() {
        if (this.rgbColorPage == null) {
            try {
                this.rgbColorPage = new RGBColorPropertyPage();
                this.rgbColorPage.setName("RGBColorPage");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.rgbColorPage;
    }

    private JRadioButton getSystemChoice() {
        if (this.systemChoice == null) {
            try {
                this.systemChoice = new JRadioButton();
                this.systemChoice.setName("System");
                this.systemChoice.setText(resabtedit.getString("System"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.systemChoice;
    }

    private SystemColorPropertyPage getSystemColorPage() {
        if (this.systemColorPage == null) {
            try {
                this.systemColorPage = new SystemColorPropertyPage();
                this.systemColorPage.setName(resabtedit.getString("SystemColorPage"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.systemColorPage;
    }

    private void handleException(Throwable exception) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        exception.printStackTrace(System.out);
    }

    private void initConnections() {
        this.getButtonGroup();
        this.getBasicChoice().addItemListener(this);
        this.getSystemChoice().addItemListener(this);
        this.getRGBChoice().addItemListener(this);
        this.getBasicColorPage().addPropertyChangeListener(this);
        this.getSystemColorPage().addPropertyChangeListener(this);
        this.getRGBColorPage().addPropertyChangeListener(this);
    }

    private void initialize() {
        this.setName("ColorPropertyEditor");
        this.setLayout(new GridBagLayout());
        this.setBackground(SystemColor.control);
        GridBagConstraints constraintsPageSelector = new GridBagConstraints();
        constraintsPageSelector.gridx = 0;
        constraintsPageSelector.gridy = 0;
        constraintsPageSelector.gridwidth = 1;
        constraintsPageSelector.gridheight = 1;
        constraintsPageSelector.fill = 2;
        constraintsPageSelector.anchor = 17;
        constraintsPageSelector.weightx = 0.0;
        constraintsPageSelector.weighty = 0.0;
        this.add((Component)this.getPageSelector(), constraintsPageSelector);
        GridBagConstraints constraintsPageHolder = new GridBagConstraints();
        constraintsPageHolder.gridx = 0;
        constraintsPageHolder.gridy = 1;
        constraintsPageHolder.gridwidth = 1;
        constraintsPageHolder.gridheight = 1;
        constraintsPageHolder.fill = 1;
        constraintsPageHolder.anchor = 10;
        constraintsPageHolder.weightx = 0.0;
        constraintsPageHolder.weighty = 1.0;
        this.add((Component)this.getPageHolder(), constraintsPageHolder);
        GridBagConstraints constraintsColorPreviewer = new GridBagConstraints();
        constraintsColorPreviewer.gridx = 1;
        constraintsColorPreviewer.gridy = 1;
        constraintsColorPreviewer.gridwidth = 1;
        constraintsColorPreviewer.gridheight = 1;
        constraintsColorPreviewer.fill = 2;
        constraintsColorPreviewer.anchor = 10;
        constraintsColorPreviewer.weightx = 0.0;
        constraintsColorPreviewer.weighty = 1.0;
        constraintsColorPreviewer.ipadx = 70;
        constraintsColorPreviewer.ipady = 80;
        constraintsColorPreviewer.insets = new Insets(50, 35, 50, 35);
        this.add((Component)this.getColorPreviewer(), constraintsColorPreviewer);
        this.initConnections();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getBasicChoice()) {
            this.basicChoiceStateChanged();
        }
        if (e.getSource() == this.getSystemChoice()) {
            this.systemChoiceStateChanged();
        }
        if (e.getSource() == this.getRGBChoice()) {
            this.rgbChoiceStateChanged();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("colorValue")) {
            if (evt.getSource() == this.getBasicColorPage() && this.getBasicColorPage().isVisible()) {
                this.setPreviewerColor(this.getBasicColorPage().getColorValue());
            }
            if (evt.getSource() == this.getSystemColorPage() && this.getSystemColorPage().isVisible()) {
                this.setPreviewerColor(this.getSystemColorPage().getColorValue());
            }
            if (evt.getSource() == this.getRGBColorPage() && this.getRGBColorPage().isVisible()) {
                this.setPreviewerColor(this.getRGBColorPage().getColorValue());
            }
        }
    }

    private void rgbChoiceStateChanged() {
        this.switchToPage(this.getRGBColorPage());
        this.setPreviewerColor(this.getRGBColorPage().getColorValue());
    }

    public void setColorValue(Color newColor) {
        this.colorValue = newColor;
        if (newColor instanceof SystemColor) {
            this.getSystemColorPage().preselectColor(newColor);
            this.getSystemChoice().setSelected(true);
        } else if (BasicColorPropertyPage.isBasicColor(newColor)) {
            this.getBasicColorPage().preselectColor(newColor);
            this.getBasicChoice().setSelected(true);
        } else {
            this.getRGBColorPage().preselectColor(newColor);
            this.getRGBChoice().setSelected(true);
        }
        this.setPreviewerColor(newColor);
    }

    private void setPreviewerColor(Color aColor) {
        this.getColorPreviewer().setBackground(aColor);
        this.getColorPreviewer().repaint();
    }

    private void switchToPage(Component aPage) {
        CardLayout layout = (CardLayout)this.getPageHolder().getLayout();
        layout.show(this.getPageHolder(), aPage.getName());
    }

    private void systemChoiceStateChanged() {
        this.switchToPage(this.getSystemColorPage());
        this.setPreviewerColor(this.getSystemColorPage().getColorValue());
    }
}

