/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mask.itime;

import com.ibm.mask.itime.EditableCharacter;
import com.ibm.mask.itime.InvalidInputEvent;
import com.ibm.mask.itime.InvalidInputListener;
import com.ibm.mask.itime.TimeEvent;
import com.ibm.mask.itime.TimeListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class ITime
extends JTextField
implements KeyListener,
FocusListener,
Serializable {
    public static final EditableCharacter UNDERSCORE = EditableCharacter.UNDERSCORE;
    public static final EditableCharacter BLANK = EditableCharacter.BLANK;
    private StringBuffer mask;
    private StringBuffer time = new StringBuffer("00:00:00");
    private StringBuffer timeold;
    private String forenoon = "A.M.";
    private String afternoon = "P.M.";
    private String timeformat = "HHmmss";
    private String oldtimeformat = "HHmmss";
    private String separator = ":";
    private int[] validation = new int[]{23, 60, 60};
    private int[] size = new int[]{2, 2, 2};
    private int counter;
    private int countOfDelim = 2;
    private int startIndex;
    private int caretposition;
    private int hourmax = 23;
    private int markdif = 4;
    private String conc = "A.M.";
    private int hourpos;
    private int minpos = 1;
    private int secpos = 2;
    private int hour;
    private int min;
    private int sec;
    private static final long serialVersionUID = 4901905597561139695L;
    private boolean fore = true;
    private boolean beepOnError = true;
    private boolean selectOnFocus = true;
    private EditableCharacter oType = UNDERSCORE;
    private char editable = (char)95;
    private Vector invalidListeners = new Vector();
    private Vector timeListeners = new Vector();
    boolean insertStringValid = false;
    private Document defaultModel;
    private String oldTime;

    public ITime() {
        this("HH:mm:ss");
    }

    public ITime(String string) throws IllegalArgumentException {
        super.addKeyListener(this);
        this.enableEvents(16L);
        this.setBackground(Color.white);
        try {
            this.setMask(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(illegalArgumentException.getMessage());
        }
        this.requestFocus();
        this.hour = new GregorianCalendar().get(11);
        this.min = new GregorianCalendar().get(12);
        this.sec = new GregorianCalendar().get(13);
        this.constructTime(this.hour, this.min, this.sec);
        this.insertStringValid = true;
        super.setText(this.time.toString());
        this.insertStringValid = false;
        this.addFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.isSelectOnFocus()) {
            super.setCaretPosition(this.getText().length());
            super.moveCaretPosition(0);
            return;
        }
        super.setCaretPosition(0);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.counter <= this.countOfDelim && this.counter >= 0) {
            this.zeroAdjust(this.counter);
        }
        this.select(0, 0);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            mouseEvent.consume();
            return;
        }
        super.processMouseEvent(mouseEvent);
    }

    public void setText(String string) {
    }

    private void constructTime(int n, int n2, int n3) {
        this.timeold = new StringBuffer(this.time.toString());
        int n4 = this.hourmax;
        if (this.mask.toString().indexOf(72) == -1) {
            if (this.hourmax != 12) {
                this.hourmax = 12;
            }
        } else {
            this.hourmax = 23;
        }
        this.hourpos = -1;
        this.minpos = -1;
        this.secpos = -1;
        this.setValidation();
        int n5 = 0;
        this.time = new StringBuffer();
        while (n5 < this.countOfDelim) {
            this.modifyTime(n5++, n, n2, n3);
            this.time.append(this.separator);
        }
        this.modifyTime(n5++, n, n2, n3);
        if (this.mask.toString().indexOf(72) == -1) {
            if (n4 != 12) {
                if (n < 12) {
                    this.fore = true;
                    this.time.append(" " + this.forenoon);
                    return;
                }
                this.fore = false;
                this.time.append(" " + this.afternoon);
                return;
            }
            if (this.fore) {
                this.time.append(" " + this.forenoon);
                return;
            }
            this.time.append(" " + this.afternoon);
            return;
        }
        this.hourmax = 23;
    }

    private void modifyTime(int n, int n2, int n3, int n4) {
        if (n2 != -1 && this.hourpos == n) {
            int n5 = n2;
            if (this.mask.toString().indexOf(72) == -1) {
                if (n2 >= 13) {
                    n5 = n2 - 12;
                } else if (n2 == 0) {
                    n5 = n2 + 12;
                }
            } else if (this.timeold.toString().indexOf(this.afternoon) != -1) {
                if (n5 != 12) {
                    n5 = n2 + 12;
                }
            } else if (this.timeold.toString().indexOf(this.forenoon) != -1 && n5 == 12) {
                n5 = 0;
            }
            StringBuffer stringBuffer = new StringBuffer(new Integer(n5).toString());
            if (this.countOf('h', this.mask.toString().toLowerCase()) == 1 && n5 < 10) {
                stringBuffer.insert(0, this.editable);
            } else if (n5 < 10) {
                stringBuffer.insert(0, '0');
            }
            this.time.append((Object)stringBuffer);
        }
        if (n3 != -1 && this.minpos == n) {
            StringBuffer stringBuffer = new StringBuffer(new Integer(n3).toString());
            if (this.countOf('m', this.mask.toString().toLowerCase()) == 1 && n3 < 10) {
                stringBuffer.insert(0, this.editable);
            } else if (n3 < 10) {
                stringBuffer.insert(0, '0');
            }
            this.time.append((Object)stringBuffer);
        }
        if (n4 != -1 && this.secpos == n) {
            StringBuffer stringBuffer = new StringBuffer(new Integer(n4).toString());
            if (this.countOf('s', this.mask.toString().toLowerCase()) == 1 && n4 < 10) {
                stringBuffer.insert(0, this.editable);
            } else if (n4 < 10) {
                stringBuffer.insert(0, '0');
            }
            this.time.append((Object)stringBuffer);
        }
    }

    private int countOf(char c, String string) {
        int n = 0;
        int n2 = 0;
        while (string.indexOf(c, n) != -1) {
            ++n2;
            n += string.indexOf(c, n) + 1;
        }
        return n2;
    }

    public Dimension getPreferredSize() {
        return new Dimension(75, 25);
    }

    public Dimension getMinimumSize() {
        return new Dimension(75, 25);
    }

    public void setPreferredSize(Dimension dimension) {
        this.setSize(dimension);
    }

    public void setMinimumSize(Dimension dimension) {
        this.setSize(dimension);
    }

    public boolean isSelectOnFocus() {
        return this.selectOnFocus;
    }

    public void setSelectOnFocus(boolean bl) {
        boolean bl2 = this.selectOnFocus;
        this.selectOnFocus = bl;
        this.firePropertyChange("selectOnFocus", bl2, this.selectOnFocus);
    }

    public boolean isBeepOnError() {
        return this.beepOnError;
    }

    public void setBeepOnError(boolean bl) {
        boolean bl2 = this.beepOnError;
        this.beepOnError = bl;
        this.firePropertyChange("beepOnError", bl2, this.beepOnError);
    }

    public void setSession(boolean bl) {
        this.fore = bl;
        this.constructTime(this.getHour(), this.getMinute(), this.getSecond());
        this.insertStringValid = true;
        super.setText(this.time.toString());
        this.insertStringValid = false;
        this.fireTimeEvent();
    }

    public boolean getSession() {
        return this.fore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMaskCharacter(EditableCharacter editableCharacter) throws IllegalArgumentException {
        if (editableCharacter == null) {
            throw new IllegalArgumentException("Null MaskCharacter passed!");
        }
        EditableCharacter editableCharacter2 = this.oType;
        if (this.oType != editableCharacter) {
            if (editableCharacter == BLANK) {
                if (this.separator.charAt(0) == ' ') throw new IllegalArgumentException("masking character same as separator character");
                this.oType = editableCharacter;
                this.editable = (char)32;
                if (this.mask.toString().indexOf(104) == -1) {
                    this.setTime(this.time.toString().replace('_', ' '));
                } else {
                    if (this.fore) {
                        int n = 0;
                        while (n < this.time.length() - this.forenoon.length() - 1) {
                            if (this.time.charAt(n) == '_') {
                                this.time.setCharAt(n, ' ');
                            } else {
                                n = 0;
                                while (n < this.time.length() - this.afternoon.length() - 1) {
                                    if (this.time.charAt(n) == '_') {
                                        this.time.setCharAt(n, ' ');
                                    }
                                    ++n;
                                }
                            }
                            ++n;
                        }
                    }
                    this.insertStringValid = true;
                    super.setText(this.time.toString());
                    this.insertStringValid = false;
                }
            } else {
                if (this.separator.charAt(0) == '_') throw new IllegalArgumentException("masking character same as separator character");
                this.oType = editableCharacter;
                this.editable = (char)95;
                if (this.mask.toString().indexOf(104) == -1) {
                    this.setTime(this.time.toString().replace(' ', '_'));
                } else {
                    if (this.fore) {
                        int n = 0;
                        while (n < this.time.length() - this.forenoon.length() - 1) {
                            if (this.time.charAt(n) == ' ') {
                                this.time.setCharAt(n, '_');
                            } else {
                                n = 0;
                                while (n < this.time.length() - this.afternoon.length() - 1) {
                                    if (this.time.charAt(n) == ' ') {
                                        this.time.setCharAt(n, '_');
                                    }
                                    ++n;
                                }
                            }
                            ++n;
                        }
                    }
                    this.insertStringValid = true;
                    super.setText(this.time.toString());
                    this.insertStringValid = false;
                }
            }
        }
        this.firePropertyChange("maskCharacter", editableCharacter2, this.oType);
    }

    public EditableCharacter getMaskCharacter() {
        return this.oType;
    }

    private String getTimeformat() {
        return this.timeformat;
    }

    private void setTimeformat(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty timeformat encountered");
        }
        if (string.indexOf(72) != -1 && string.indexOf(104) != -1 || string.indexOf(77) != -1 && string.indexOf(109) != -1 || string.indexOf(83) != -1 && string.indexOf(115) != -1) {
            throw new IllegalArgumentException("capital and small of same letter encountered in timeformat");
        }
        String string2 = string.toLowerCase();
        if (string2.indexOf(104) == -1 || string2.indexOf(109) == -1) {
            throw new IllegalArgumentException("no hour or minute field");
        }
        int n = 0;
        while (n < string2.length()) {
            if (string2.charAt(n) != 'h' && string2.charAt(n) != 'm' && string2.charAt(n) != 's') {
                throw new IllegalArgumentException("invalid Character encountered in timeformat");
            }
            ++n;
        }
        if (this.countOf('h', string2) > 2 || this.countOf('m', string2) > 2 || this.countOf('s', string2) > 2) {
            throw new IllegalArgumentException("more than required no of valid character in timeformat");
        }
        if (string2.lastIndexOf(104) - string2.indexOf(104) > 1 || string2.lastIndexOf(109) - string2.indexOf(109) > 1 || string2.lastIndexOf(115) - string2.indexOf(115) > 1) {
            throw new IllegalArgumentException("unexpected position of valid character in timeformat");
        }
        this.oldtimeformat = this.timeformat;
        this.timeformat = string;
        this.makeMask(string, this.separator);
        this.constructTime(this.getHour(), this.getMinute(), this.getSecond());
        this.insertStringValid = true;
        super.setText(this.time.toString());
        this.insertStringValid = false;
        this.oldtimeformat = this.timeformat;
        this.fireTimeEvent();
        this.setSize();
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null separator");
        }
        if (string.length() != 1) {
            throw new IllegalArgumentException("invalid length of the Separator");
        }
        if (Character.isLetterOrDigit(string.charAt(0))) {
            throw new IllegalArgumentException("invalid value of the Separator");
        }
        if (string.charAt(0) == this.editable) {
            throw new IllegalArgumentException("separator same as masking character not allowed");
        }
        String string2 = this.separator;
        this.separator = string;
        this.makeMask(this.timeformat, string);
        this.constructTime(this.getHour(), this.getMinute(), this.getSecond());
        this.insertStringValid = true;
        super.setText(this.time.toString());
        this.insertStringValid = false;
        this.firePropertyChange("separator", string2, string);
        this.fireTimeEvent();
    }

    public String getForenoon() {
        return this.forenoon;
    }

    public void setForenoon(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty forenoon symbol");
        }
        if (!(string.length() < 1 || Character.isJavaIdentifierStart(string.charAt(0)) && string.charAt(0) != this.afternoon.charAt(0) && string.charAt(0) != this.separator.charAt(0) && string.charAt(0) != '$' && string.charAt(0) != this.editable)) {
            throw new IllegalArgumentException("invalid am symbol");
        }
        String string2 = this.forenoon;
        this.forenoon = string;
        this.makeMask(this.timeformat, this.separator);
        this.constructTime(this.getHour(), this.getMinute(), this.getSecond());
        this.insertStringValid = true;
        super.setText(this.time.toString());
        this.insertStringValid = false;
        this.firePropertyChange("forenoon", string2, string);
        this.fireTimeEvent();
    }

    public String getAfternoon() {
        return this.afternoon;
    }

    public void setAfternoon(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty afternoon symbol");
        }
        if (!(string.length() <= 0 || Character.isJavaIdentifierStart(string.charAt(0)) && string.charAt(0) != this.forenoon.charAt(0) && string.charAt(0) != this.separator.charAt(0) && string.charAt(0) != '$' && string.charAt(0) != this.editable)) {
            throw new IllegalArgumentException("invalid pm symbol");
        }
        String string2 = this.afternoon;
        this.afternoon = string;
        this.makeMask(this.timeformat, this.separator);
        this.constructTime(this.getHour(), this.getMinute(), this.getSecond());
        this.insertStringValid = true;
        super.setText(this.time.toString());
        this.insertStringValid = false;
        this.firePropertyChange("afternoon", string2, string);
        this.fireTimeEvent();
    }

    private void makeMask(String string, String string2) {
        this.countOfDelim = 0;
        this.mask = new StringBuffer(string);
        char c = string.charAt(0);
        int n = this.mask.toString().lastIndexOf(c);
        if (n == this.mask.length() - 1) {
            return;
        }
        ++this.countOfDelim;
        this.mask.insert(n + 1, string2);
        char c2 = string.charAt(n + 1);
        int n2 = this.mask.toString().lastIndexOf(c2);
        if (n2 != this.mask.length() - 1) {
            ++this.countOfDelim;
            this.mask.insert(n2 + 1, string2);
        }
    }

    public String getMask() {
        return this.mask.toString();
    }

    public void setMask(String string) throws IllegalArgumentException {
        if (!this.isEditable()) {
            this.insertStringValid = false;
            return;
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty mask encountered");
        }
        if (string.indexOf(77) != -1 || string.indexOf(83) != -1) {
            throw new IllegalArgumentException("Capital M and S characters should not be used");
        }
        if (string.indexOf(72) != -1 && string.indexOf(104) != -1 || string.indexOf(77) != -1 && string.indexOf(109) != -1 || string.indexOf(83) != -1 && string.indexOf(115) != -1) {
            throw new IllegalArgumentException("capital and small of same letter encountered in mask");
        }
        StringBuffer stringBuffer = this.mask;
        String string2 = string.toLowerCase();
        if (string2.indexOf(104) == -1 || string2.indexOf(109) == -1) {
            throw new IllegalArgumentException("no hour or minute field");
        }
        if (string2.charAt(0) != 'h' && string2.charAt(0) != 'm' && string2.charAt(0) != 's' || string2.charAt(string2.length() - 1) != 'h' && string2.charAt(string2.length() - 1) != 'm' && string2.charAt(string2.length() - 1) != 's') {
            throw new IllegalArgumentException("invalid first or last character in mask");
        }
        if (this.countOf('h', string2) > 2 || this.countOf('m', string2) > 2 || this.countOf('s', string2) > 2) {
            throw new IllegalArgumentException("more than required no of valid character in mask");
        }
        if (string2.lastIndexOf(104) - string2.indexOf(104) > 1 || string2.lastIndexOf(109) - string2.indexOf(109) > 1 || string2.lastIndexOf(115) - string2.indexOf(115) > 1) {
            throw new IllegalArgumentException("unexpected position of valid character in mask");
        }
        char c = string.charAt(0);
        int n = string.lastIndexOf(c);
        if (n == string.length() - 1) {
            this.mask = new StringBuffer(string);
            this.setTimeformat(string);
            this.countOfDelim = 0;
            this.constructTime(this.getHour(), this.getMinute(), this.getSecond());
            this.insertStringValid = true;
            super.setText(this.time.toString());
            this.insertStringValid = false;
            this.setSize();
            if (stringBuffer == null) {
                this.firePropertyChange("mask", stringBuffer, this.mask);
                return;
            }
            String string3 = new String(stringBuffer);
            String string4 = new String(this.mask);
            if (!string3.equals(string4)) {
                this.firePropertyChange("mask", string3, string4);
            }
            return;
        }
        String string5 = new Character(string.charAt(n + 1)).toString();
        if (Character.isLetterOrDigit(string5.charAt(0))) {
            throw new IllegalArgumentException("invalid value of the Separator");
        }
        if (string5.charAt(0) == this.editable) {
            throw new IllegalArgumentException("masking character as separator not allowed");
        }
        if (this.countOf(string5.charAt(0), string2) > 2) {
            throw new IllegalArgumentException("unexpected no of separators in mask");
        }
        int n2 = 0;
        while (n2 < string2.length()) {
            if (string2.charAt(n2) != 'h' && string2.charAt(n2) != 'm' && string2.charAt(n2) != 's' && string2.charAt(n2) != string5.charAt(0)) {
                throw new IllegalArgumentException("invalid Character encountered in mask");
            }
            ++n2;
        }
        if (string.charAt(n + 2) == string5.charAt(0)) {
            throw new IllegalArgumentException("unexpected position of valid character in mask");
        }
        char c2 = string.charAt(n + 2);
        int n3 = string.lastIndexOf(c2);
        if (n3 == string.length() - 1) {
            this.mask = new StringBuffer(string);
            StringBuffer stringBuffer2 = new StringBuffer(string);
            int n4 = stringBuffer2.toString().indexOf(string5.charAt(0), 0) + 1;
            while (n4 < stringBuffer2.length()) {
                stringBuffer2.setCharAt(n4 - 1, stringBuffer2.charAt(n4));
                ++n4;
            }
            stringBuffer2.setLength(stringBuffer2.length() - 1);
            this.setTimeformat(stringBuffer2.toString());
            this.setSeparator(string5);
            this.countOfDelim = 1;
            this.constructTime(this.getHour(), this.getMinute(), this.getSecond());
            this.insertStringValid = true;
            super.setText(this.time.toString());
            this.insertStringValid = false;
            this.setSize();
            if (stringBuffer == null) {
                this.firePropertyChange("mask", stringBuffer, this.mask);
                return;
            }
            String string6 = new String(stringBuffer);
            String string7 = new String(this.mask);
            if (!string6.equals(string7)) {
                this.firePropertyChange("mask", string6, string7);
            }
            return;
        }
        if (string5.charAt(0) != string.charAt(n3 + 1)) {
            throw new IllegalArgumentException("unexpected position of valid character in mask");
        }
        if (string.charAt(n3 + 2) == string5.charAt(0)) {
            throw new IllegalArgumentException("unexpected position of valid character in mask");
        }
        char c3 = string.charAt(n3 + 2);
        int n5 = string.lastIndexOf(c3);
        if (n5 == string.length() - 1) {
            this.mask = new StringBuffer(string);
            StringBuffer stringBuffer3 = new StringBuffer(string);
            int n6 = stringBuffer3.toString().indexOf(string5.charAt(0), 0) + 1;
            while (n6 < stringBuffer3.length()) {
                stringBuffer3.setCharAt(n6 - 1, stringBuffer3.charAt(n6));
                ++n6;
            }
            stringBuffer3.setLength(stringBuffer3.length() - 1);
            int n7 = stringBuffer3.toString().indexOf(string5.charAt(0), 0) + 1;
            while (n7 < stringBuffer3.length()) {
                stringBuffer3.setCharAt(n7 - 1, stringBuffer3.charAt(n7));
                ++n7;
            }
            stringBuffer3.setLength(stringBuffer3.length() - 1);
            this.setTimeformat(stringBuffer3.toString());
            this.setSeparator(string5);
            this.countOfDelim = 2;
            this.constructTime(this.getHour(), this.getMinute(), this.getSecond());
            this.insertStringValid = true;
            super.setText(this.time.toString());
            this.insertStringValid = false;
            this.setSize();
            if (stringBuffer == null) {
                this.firePropertyChange("mask", stringBuffer, this.mask);
                return;
            }
            String string8 = new String(stringBuffer);
            String string9 = new String(this.mask);
            if (!string8.equals(string9)) {
                this.firePropertyChange("mask", string8, string9);
            }
            return;
        }
        throw new IllegalArgumentException("unexpected mask");
    }

    public int getHour() {
        try {
            if (this.oldtimeformat.toString().toLowerCase().indexOf(104) != -1 && this.time.length() > this.hourpos * 3) {
                switch (this.countOf(this.editable, this.time.toString().substring(this.hourpos * 3, this.hourpos * 3 + 2))) {
                    case 0: {
                        return Integer.parseInt(this.time.toString().substring(this.hourpos * 3, this.hourpos * 3 + 2));
                    }
                    case 1: {
                        if (this.time.toString().substring(this.hourpos * 3, this.hourpos * 3 + 2).indexOf(this.editable) == 0) {
                            return Integer.parseInt(this.time.toString().substring(this.hourpos * 3 + 1, this.hourpos * 3 + 2));
                        }
                        return Integer.parseInt(this.time.toString().substring(this.hourpos * 3, this.hourpos * 3 + 1));
                    }
                    case 2: {
                        return 0;
                    }
                    default: {
                        return 0;
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(this.time.toString().substring(this.hourpos * 3 + 1, this.hourpos * 3 + 2));
        }
        return 0;
    }

    public void setHour(int n) throws IllegalArgumentException {
        if (this.timeformat.toString().toLowerCase().indexOf(104) != -1) {
            if (n != 0 && n == this.getHour()) {
                return;
            }
            try {
                if (this.countOf('h', this.timeformat.toLowerCase()) == 2) {
                    this.setField(n, this.hourpos, true);
                } else {
                    this.setField(n, this.hourpos, false);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("invalid value of hour");
            }
            this.insertStringValid = true;
            super.setText(this.time.toString());
            this.insertStringValid = false;
            this.fireTimeEvent();
        }
    }

    public int getMinute() {
        try {
            if (this.oldtimeformat.toString().toLowerCase().indexOf(109) != -1 && this.time.length() > this.minpos * 3) {
                switch (this.countOf(this.editable, this.time.toString().substring(this.minpos * 3, this.minpos * 3 + 2))) {
                    case 0: {
                        return Integer.parseInt(this.time.toString().substring(this.minpos * 3, this.minpos * 3 + 2));
                    }
                    case 1: {
                        if (this.time.toString().substring(this.minpos * 3, this.minpos * 3 + 2).indexOf(this.editable) == 0) {
                            return Integer.parseInt(this.time.toString().substring(this.minpos * 3 + 1, this.minpos * 3 + 2));
                        }
                        return Integer.parseInt(this.time.toString().substring(this.minpos * 3, this.minpos * 3 + 1));
                    }
                    case 2: {
                        return 0;
                    }
                    default: {
                        return 0;
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.parseInt(this.time.toString().substring(this.minpos * 3 + 1, this.minpos * 3 + 2));
        }
        return 0;
    }

    public void setMinute(int n) throws IllegalArgumentException {
        if (this.timeformat.toString().toLowerCase().indexOf(109) != -1) {
            if (n != 0 && n == this.getMinute()) {
                return;
            }
            try {
                if (this.countOf('m', this.timeformat.toLowerCase()) == 2) {
                    this.setField(n, this.minpos, true);
                } else {
                    this.setField(n, this.minpos, false);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("invalid value of minute");
            }
            this.insertStringValid = true;
            super.setText(this.time.toString());
            this.insertStringValid = false;
            this.fireTimeEvent();
        }
    }

    public int getSecond() {
        try {
            if (this.oldtimeformat.toString().toLowerCase().indexOf(115) != -1 && this.time.length() > this.secpos * 3) {
                switch (this.countOf(this.editable, this.time.toString().substring(this.secpos * 3, this.secpos * 3 + 2))) {
                    case 0: {
                        return Integer.parseInt(this.time.toString().substring(this.secpos * 3, this.secpos * 3 + 2));
                    }
                    case 1: {
                        if (this.time.toString().substring(this.secpos * 3, this.secpos * 3 + 2).indexOf(this.editable) == 0) {
                            return Integer.parseInt(this.time.toString().substring(this.secpos * 3 + 1, this.secpos * 3 + 2));
                        }
                        return Integer.parseInt(this.time.toString().substring(this.secpos * 3, this.secpos * 3 + 1));
                    }
                    case 2: {
                        return 0;
                    }
                    default: {
                        return 0;
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(numberFormatException);
        }
        return 0;
    }

    public void setSecond(int n) throws IllegalArgumentException {
        if (this.timeformat.toString().toLowerCase().indexOf(115) != -1) {
            if (n != 0 && n == this.getSecond()) {
                return;
            }
            try {
                if (this.countOf('s', this.timeformat.toLowerCase()) == 2) {
                    this.setField(n, this.secpos, true);
                } else {
                    this.setField(n, this.secpos, false);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("invalid value of second");
            }
            this.insertStringValid = true;
            super.setText(this.time.toString());
            this.insertStringValid = false;
            this.fireTimeEvent();
        }
    }

    public String getTime() {
        return this.time.toString();
    }

    public void setTime(String string) throws IllegalArgumentException {
        Comparable<StringBuffer> comparable;
        Character c;
        int n;
        int n2;
        Object object;
        if (string == null) {
            throw new IllegalArgumentException("Null Time passed!");
        }
        String string2 = this.forenoon;
        String string3 = this.fore ? this.forenoon : this.afternoon;
        if (string == null) {
            throw new IllegalArgumentException("null time string encountered");
        }
        if (this.getMask().indexOf(this.separator.charAt(0), 0) == 1 && string.indexOf(this.separator.charAt(0), 0) == 1) {
            object = new Character(this.getMaskCharacter().charValue());
            StringBuffer stringBuffer = new StringBuffer(((Character)object).toString());
            stringBuffer.append(string);
            string = stringBuffer.toString();
        }
        object = this.getMask();
        int n3 = ((String)object).indexOf(this.separator.charAt(0), 0);
        int n4 = ((String)object).indexOf(this.separator.charAt(0), n3 + 1);
        if (n4 - n3 == 2) {
            n2 = string.indexOf(this.separator.charAt(0), 0);
            n = string.indexOf(this.separator.charAt(0), n2 + 1);
            if (n - n2 == 2) {
                c = new Character(this.getMaskCharacter().charValue());
                comparable = new StringBuffer(string.substring(0, n2 + 1));
                ((StringBuffer)comparable).append(c.toString());
                ((StringBuffer)comparable).append(string.substring(n2 + 1, string.length()));
                string = ((StringBuffer)comparable).toString();
            }
        }
        object = this.getMask();
        n3 = ((String)object).indexOf(this.separator.charAt(0), 0);
        n4 = ((String)object).indexOf(this.separator.charAt(0), n3 + 1);
        if (((String)object).length() > n4 + 1 && ((String)object).length() - n4 == 2) {
            n2 = string.indexOf(this.separator.charAt(0), 0);
            n = string.indexOf(this.separator.charAt(0), n2 + 1);
            if (string.length() > n + 2) {
                char c2 = string.charAt(n + 2);
                if (!Character.isDigit(c2)) {
                    comparable = new Character(this.getMaskCharacter().charValue());
                    StringBuffer stringBuffer = new StringBuffer(string.substring(0, n + 1));
                    stringBuffer.append(((Character)comparable).toString());
                    stringBuffer.append(string.substring(n + 1, string.length()));
                    string = stringBuffer.toString();
                }
            } else {
                c = new Character(this.getMaskCharacter().charValue());
                comparable = new StringBuffer(string.substring(0, n + 1));
                ((StringBuffer)comparable).append(c.toString());
                ((StringBuffer)comparable).append(string.substring(n + 1, string.length()));
                string = ((StringBuffer)comparable).toString();
            }
        }
        if (((String)object).toString().indexOf(104) != -1) {
            if (string.indexOf(this.forenoon, this.time.length() - string3.length() - 1) == -1) {
                if (string.indexOf(this.afternoon, this.time.length() - string3.length() - 1) == -1) {
                    throw new IllegalArgumentException("invalid AM or PM symbol");
                }
                string2 = this.afternoon;
                this.fore = false;
                string = string.substring(0, this.time.length() - string3.length() - 1);
            } else {
                string2 = this.forenoon;
                this.fore = true;
                string = string.substring(0, this.time.length() - string3.length() - 1);
            }
        } else if (string.length() != this.time.length()) {
            throw new IllegalArgumentException("improper time string");
        }
        if (this.time.toString().equals(string)) {
            return;
        }
        if (string.charAt(0) == this.separator.charAt(0)) {
            throw new IllegalArgumentException("separator at the first position in time");
        }
        n2 = 0;
        while (n2 < string.length()) {
            this.countOf(this.separator.charAt(0), string);
            if (string.charAt(n2) != this.separator.charAt(0) && !Character.isDigit(string.charAt(n2)) && string.charAt(n2) != this.editable || this.countOf(this.separator.charAt(0), string) > 2) {
                throw new IllegalArgumentException("invalid char or invalid no of separators in time");
            }
            ++n2;
        }
        n = string.indexOf(this.separator.charAt(0), 0);
        if (n != -1) {
            if (n != 2) {
                throw new IllegalArgumentException("first field doesn't have req no of char in time");
            }
            int n5 = string.indexOf(this.separator.charAt(0), n + 1);
            if (n5 != -1 && n5 - n != 3) {
                throw new IllegalArgumentException("second field doesn't have req no fo char in time");
            }
            if (n5 != -1 && n5 + 2 != string.length() - 1) {
                throw new IllegalArgumentException("last field doesn't have two char in time");
            }
        } else if (string.length() != 2) {
            throw new IllegalArgumentException("first field doesn't have req no of char in time");
        }
        if (((String)object).toString().indexOf(104) != -1) {
            string = String.valueOf(string) + " " + string2;
        }
        this.timeold = new StringBuffer(string);
        try {
            this.counter = 0;
            while (this.counter <= this.countOfDelim) {
                if (!this.validateInput()) {
                    throw new IllegalArgumentException("Invalid time");
                }
                ++this.counter;
            }
            this.time = this.timeold;
            this.insertStringValid = true;
            super.setText(this.time.toString());
            this.insertStringValid = false;
            this.fireTimeEvent();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            int n6 = this.counter;
            try {
                this.counter = 0;
                while (this.counter <= this.countOfDelim) {
                    if (this.counter != n6 && !this.validateInput()) {
                        throw new IllegalArgumentException("invalid time");
                    }
                    ++this.counter;
                }
            }
            catch (NumberFormatException numberFormatException2) {
                int n7 = this.counter;
                try {
                    this.counter = 0;
                    while (this.counter <= this.countOfDelim) {
                        if (this.counter != n6 && this.counter != n7 && !this.validateInput()) {
                            throw new IllegalArgumentException("invalid time");
                        }
                        ++this.counter;
                    }
                }
                catch (NumberFormatException numberFormatException3) {}
            }
        }
        this.time = this.timeold;
        this.insertStringValid = true;
        super.setText(this.time.toString());
        this.insertStringValid = false;
        this.fireTimeEvent();
    }

    private void setField(int n, int n2, boolean bl) throws IllegalArgumentException {
        this.timeold = new StringBuffer(this.time.toString());
        String string = new Integer(n).toString();
        if (string.length() == 1) {
            this.timeold.setCharAt(n2 * 3 + 1, string.charAt(0));
            if (bl) {
                this.timeold.setCharAt(n2 * 3, '0');
            } else {
                this.timeold.setCharAt(n2 * 3, this.editable);
            }
            this.time = this.timeold;
            return;
        }
        if (string.length() == 2) {
            this.timeold.setCharAt(n2 * 3 + 1, string.charAt(1));
            this.timeold.setCharAt(n2 * 3, string.charAt(0));
            this.counter = n2;
            if (this.validateInput()) {
                this.time = this.timeold;
                return;
            }
            throw new IllegalArgumentException("invalid value of field");
        }
        throw new IllegalArgumentException("invalid value of field");
    }

    public void updateTime(TimeEvent timeEvent) {
        try {
            this.setTime(timeEvent.getTime());
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
            return;
        }
    }

    public void updateHour(TimeEvent timeEvent) {
        try {
            this.setHour(timeEvent.getHour());
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
            return;
        }
    }

    public void updateMinute(TimeEvent timeEvent) {
        try {
            this.setMinute(timeEvent.getMinute());
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
            return;
        }
    }

    public void updateSecond(TimeEvent timeEvent) {
        try {
            this.setSecond(timeEvent.getSecond());
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
            return;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        block49: {
            this.insertStringValid = true;
            StringBuffer stringBuffer = null;
            boolean bl = false;
            if (!this.isEditable()) {
                this.insertStringValid = false;
                return;
            }
            if ((keyEvent.getModifiers() == 8 || keyEvent.getModifiers() == 2 || keyEvent.getModifiers() == 1 || keyEvent.getModifiers() == 4) && this.getSeparator().charAt(0) != keyEvent.getKeyChar()) {
                this.insertStringValid = false;
                return;
            }
            if (keyEvent.getKeyCode() == 16) {
                this.insertStringValid = false;
                return;
            }
            int n = this.counter;
            this.counter = this.getCounter(super.getCaretPosition());
            if (n != this.counter && n != -1) {
                this.zeroAdjust(n);
            }
            char c = keyEvent.getKeyChar();
            this.timeold = new StringBuffer(this.time.toString());
            this.caretposition = super.getCaretPosition();
            if (c == this.separator.charAt(0)) {
                if (this.caretposition != 0 && this.time.charAt(this.caretposition - 1) != this.separator.charAt(this.separator.length() - 1)) {
                    this.changeField();
                }
                keyEvent.consume();
                this.insertStringValid = false;
                return;
            }
            if (this.lengthCheck() && (this.timeold.charAt(this.caretposition) == this.forenoon.charAt(0) || this.timeold.charAt(this.caretposition) == this.afternoon.charAt(0)) && Character.isDigit(c)) {
                if (this.isBeepOnError()) {
                    Toolkit.getDefaultToolkit().beep();
                }
                this.fireInvalidInputEvent(keyEvent);
                keyEvent.consume();
                this.insertStringValid = false;
                return;
            }
            this.markdif = this.fore ? this.forenoon.length() : this.afternoon.length();
            if (this.mask.toString().indexOf(104) != -1 && this.caretposition > this.timeold.length() - this.markdif) {
                if (this.handleSpecificKeys(keyEvent)) {
                    keyEvent.consume();
                }
                this.insertStringValid = false;
                return;
            }
            if (!Character.isDigit(c)) {
                boolean bl2 = true;
                if (this.mask.toString().indexOf(104) != -1) {
                    boolean bl3 = this.fore;
                    if (c == this.forenoon.charAt(0)) {
                        this.fore = true;
                        this.conc = this.forenoon;
                    }
                    if (c == this.afternoon.charAt(0)) {
                        this.fore = false;
                        this.conc = this.afternoon;
                    }
                    if (c == this.forenoon.charAt(0) || c == this.afternoon.charAt(0)) {
                        if (c == this.forenoon.charAt(0)) {
                            this.markdif = bl3 ? this.forenoon.length() : this.afternoon.length();
                        } else if (c == this.afternoon.charAt(0)) {
                            this.markdif = !bl3 ? this.afternoon.length() : this.forenoon.length();
                        }
                        this.time = this.timeold = new StringBuffer(this.timeold.toString().substring(0, this.timeold.length() - this.markdif).concat(this.conc));
                        this.insertStringValid = true;
                        super.setText(this.time.toString());
                        this.insertStringValid = false;
                        this.fireTimeEvent();
                        if (this.caretposition != this.getDocument().getLength()) {
                            super.setCaretPosition(this.caretposition);
                        }
                        keyEvent.consume();
                        this.insertStringValid = false;
                        return;
                    }
                    bl2 = this.handleSpecificKeys(keyEvent);
                } else {
                    bl2 = this.handleSpecificKeys(keyEvent);
                }
                if (bl2) {
                    keyEvent.consume();
                }
                this.insertStringValid = false;
                return;
            }
            try {
                this.caretposition = super.getCaretPosition();
                if (this.getSelectionStart() - this.getSelectionEnd() != 0) {
                    this.handleSelection();
                }
                if (this.lengthCheck()) {
                    if (this.caretposition != 0) {
                        if (this.timeold.charAt(this.caretposition) == this.separator.charAt(0) || this.timeold.charAt(this.caretposition) == ' ' && (this.timeold.charAt(this.caretposition + 1) == this.forenoon.charAt(0) || this.timeold.charAt(this.caretposition + 1) == this.afternoon.charAt(0))) {
                            this.timeold.setCharAt(this.caretposition - 2, this.timeold.charAt(this.caretposition - 1));
                            this.timeold.setCharAt(this.caretposition - 1, c);
                        } else {
                            stringBuffer = new StringBuffer(this.timeold.toString());
                            bl = true;
                            this.timeold.setCharAt(this.caretposition, c);
                        }
                    } else {
                        stringBuffer = new StringBuffer(this.timeold.toString());
                        bl = true;
                        this.timeold.setCharAt(this.caretposition, c);
                    }
                } else if (this.caretposition == this.timeold.length() || this.mask.toString().indexOf(104) != -1 && this.caretposition == this.timeold.length() - (this.markdif + 2)) {
                    this.timeold.setCharAt(this.caretposition - 2, this.timeold.charAt(this.caretposition - 1));
                    this.timeold.setCharAt(this.caretposition - 1, c);
                } else {
                    this.timeold.setCharAt(this.caretposition, c);
                }
                if (this.validateInput()) {
                    this.insertStringValid = true;
                    super.setText(this.time.toString());
                    this.insertStringValid = false;
                    this.fireTimeEvent();
                    if (this.lengthCheck()) {
                        if (this.timeold.charAt(this.caretposition + 1) == this.separator.charAt(0)) {
                            if (this.timeold.charAt(this.caretposition - 1) == this.editable) {
                                if (this.caretposition != this.getDocument().getLength()) {
                                    super.setCaretPosition(this.caretposition + 1);
                                }
                            } else {
                                ++this.counter;
                                this.zeroAdjust(this.counter - 1);
                                super.setCaretPosition(this.caretposition + this.separator.length() + 1);
                            }
                        } else {
                            if (this.caretposition != this.getDocument().getLength()) {
                                super.setCaretPosition(this.caretposition + 1);
                            }
                            if (this.timeold.length() > this.caretposition + 2 && this.timeold.charAt(this.caretposition + 1) == ' ' && (this.timeold.charAt(this.caretposition + 2) == this.forenoon.charAt(0) || this.timeold.charAt(this.caretposition + 2) == this.afternoon.charAt(0))) {
                                super.setCaretPosition(this.caretposition + 2);
                            }
                        }
                    } else if (this.caretposition != this.getDocument().getLength()) {
                        super.setCaretPosition(this.caretposition + 1);
                    }
                } else {
                    if (bl) {
                        this.timeold = new StringBuffer(stringBuffer.toString());
                        this.time = new StringBuffer(stringBuffer.toString());
                        bl = false;
                    }
                    if (this.isBeepOnError()) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    this.fireInvalidInputEvent(keyEvent);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                System.err.println(stringIndexOutOfBoundsException);
            }
            catch (NumberFormatException numberFormatException) {
                this.time = this.timeold;
                this.insertStringValid = true;
                super.setText(this.time.toString());
                this.insertStringValid = false;
                this.fireTimeEvent();
                if (this.caretposition != this.getDocument().getLength()) {
                    super.setCaretPosition(this.caretposition + 1);
                }
                if (!this.lengthCheck() || this.caretposition <= 1) break block49;
                if (this.timeold.charAt(this.caretposition) == this.separator.charAt(0) && this.timeold.charAt(this.caretposition - 2) == this.editable) {
                    super.setCaretPosition(this.caretposition);
                }
                if (this.timeold.length() <= this.caretposition + 1 || this.timeold.charAt(this.caretposition + 1) != this.forenoon.charAt(0) && this.timeold.charAt(this.caretposition + 1) != this.afternoon.charAt(0) || this.timeold.charAt(this.caretposition - 1) != this.editable && this.timeold.charAt(this.caretposition - 2) != this.editable) break block49;
                super.setCaretPosition(this.caretposition);
            }
        }
        keyEvent.consume();
        this.insertStringValid = false;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    private boolean handleSpecificKeys(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 37: {
                return this.leftKeyPressed(keyEvent);
            }
            case 39: {
                return this.rightKeyPressed(keyEvent);
            }
            case 38: {
                return this.upKeyPressed(this.counter);
            }
            case 40: {
                return this.downKeyPressed(this.counter);
            }
            case 127: {
                return this.delKeyPressed();
            }
            case 36: {
                return this.homeKeyPressed(keyEvent);
            }
            case 9: {
                return false;
            }
            case 10: {
                return false;
            }
            case 27: {
                return false;
            }
            case 35: {
                return this.endKeyPressed(keyEvent);
            }
            case 8: {
                return this.backspaceKeyPressed();
            }
            case 32: {
                return this.spaceKeyPressed();
            }
        }
        if (!keyEvent.isAltDown() && !keyEvent.isControlDown() && this.isBeepOnError()) {
            Toolkit.getDefaultToolkit().beep();
            this.fireInvalidInputEvent(keyEvent);
        }
        return true;
    }

    private boolean leftKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown()) {
            return false;
        }
        if (this.caretposition != 0) {
            if (this.timeold.charAt(this.caretposition - 1) == this.separator.charAt(this.separator.length() - 1) && this.caretposition <= this.timeold.length() - 1 - this.markdif) {
                this.zeroAdjust(this.counter);
                super.setCaretPosition(this.caretposition - 2);
            } else if (this.lengthCheck()) {
                if ((this.timeold.charAt(this.caretposition) == this.forenoon.charAt(0) || this.timeold.charAt(this.caretposition) == this.afternoon.charAt(0)) && this.timeold.charAt(this.caretposition - 1) == ' ') {
                    super.setCaretPosition(this.caretposition - 2);
                } else {
                    super.setCaretPosition(this.caretposition - 1);
                }
            } else {
                super.setCaretPosition(this.caretposition - 1);
            }
        }
        return true;
    }

    private boolean rightKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown()) {
            return false;
        }
        if (this.lengthCheck()) {
            super.setCaretPosition(this.caretposition + 1);
        } else {
            if (this.timeold.toString().indexOf(this.forenoon) != -1 && this.timeold.toString().indexOf(this.afternoon) != -1) {
                this.zeroAdjust(this.countOfDelim);
            }
            if (this.caretposition != this.getDocument().getLength()) {
                super.setCaretPosition(this.caretposition + 1);
            }
        }
        return true;
    }

    private boolean upKeyPressed(int n) {
        int n2 = 0;
        if (n >= 0 && n <= this.countOfDelim) {
            String string;
            switch (this.countOf(this.editable, this.timeold.toString().substring(n * 3, n * 3 + 2))) {
                case 0: {
                    n2 = Integer.parseInt(this.timeold.toString().substring(n * 3, n * 3 + 2));
                    break;
                }
                case 1: {
                    if (this.timeold.toString().substring(n * 3, n * 3 + 2).indexOf(this.editable) == 0) {
                        n2 = Integer.parseInt(this.timeold.toString().substring(n * 3 + 1, n * 3 + 2));
                        break;
                    }
                    n2 = Integer.parseInt(this.timeold.toString().substring(n * 3, n * 3 + 1));
                    break;
                }
                case 2: {
                    n2 = 0;
                    break;
                }
            }
            ++n2;
            if (n == this.hourpos) {
                if (this.hourmax == 12 && n2 == this.hourmax) {
                    string = this.fore ? this.forenoon : this.afternoon;
                    String string2 = this.forenoon;
                    if (this.timeold.toString().indexOf(this.forenoon) != -1) {
                        this.fore = false;
                        string2 = this.afternoon;
                    } else {
                        this.fore = true;
                        string2 = this.forenoon;
                    }
                    this.timeold = new StringBuffer(String.valueOf(this.timeold.toString().substring(0, this.time.length() - string.length() - 1)) + " " + string2);
                }
                if (n2 > this.hourmax) {
                    n2 = this.mask.toString().indexOf(72) == -1 ? 1 : 0;
                }
            }
            if (n == this.minpos && n2 > 59) {
                n2 = 0;
                this.upKeyPressed(this.hourpos);
            }
            if (n == this.secpos && n2 > 59) {
                n2 = 0;
                this.upKeyPressed(this.minpos);
            }
            if (n2 < 10) {
                this.timeold.setCharAt(n * 3, this.editable);
                this.timeold.setCharAt(n * 3 + 1, new Integer(n2).toString().charAt(0));
            } else {
                string = new Integer(n2).toString();
                this.timeold.setCharAt(n * 3, string.charAt(0));
                this.timeold.setCharAt(n * 3 + 1, string.charAt(1));
            }
            this.time = this.timeold;
            this.insertStringValid = true;
            super.setText(this.time.toString());
            this.insertStringValid = false;
            this.zeroAdjust(n);
            this.fireTimeEvent();
            super.setCaretPosition(this.caretposition);
        }
        return true;
    }

    private boolean downKeyPressed(int n) {
        int n2 = 0;
        if (n >= 0 && n <= this.countOfDelim) {
            switch (this.countOf(this.editable, this.timeold.toString().substring(n * 3, n * 3 + 2))) {
                case 0: {
                    n2 = Integer.parseInt(this.timeold.toString().substring(n * 3, n * 3 + 2));
                    break;
                }
                case 1: {
                    if (this.timeold.toString().substring(n * 3, n * 3 + 2).indexOf(this.editable) == 0) {
                        n2 = Integer.parseInt(this.timeold.toString().substring(n * 3 + 1, n * 3 + 2));
                        break;
                    }
                    n2 = Integer.parseInt(this.timeold.toString().substring(n * 3, n * 3 + 1));
                    break;
                }
                case 2: {
                    n2 = 0;
                    break;
                }
            }
            --n2;
            if (n == this.hourpos) {
                if (this.hourmax == 12 && n2 == this.hourmax - 1) {
                    String string = this.fore ? this.forenoon : this.afternoon;
                    String string2 = this.forenoon;
                    if (this.timeold.toString().indexOf(this.forenoon) != -1) {
                        this.fore = false;
                        string2 = this.afternoon;
                    } else {
                        this.fore = true;
                        string2 = this.forenoon;
                    }
                    this.timeold = new StringBuffer(String.valueOf(this.timeold.toString().substring(0, this.time.length() - string.length() - 1)) + " " + string2);
                }
                int n3 = 0;
                n3 = this.mask.toString().indexOf(72) == -1 ? 1 : 0;
                if (n2 < n3) {
                    n2 = this.hourmax;
                }
            }
            if (n == this.minpos && n2 < 0) {
                n2 = 59;
                this.downKeyPressed(this.hourpos);
            }
            if (n == this.secpos && n2 < 0) {
                n2 = 59;
                this.downKeyPressed(this.minpos);
            }
            if (n2 < 10) {
                this.timeold.setCharAt(n * 3, this.editable);
                this.timeold.setCharAt(n * 3 + 1, new Integer(n2).toString().charAt(0));
            } else {
                String string = new Integer(n2).toString();
                this.timeold.setCharAt(n * 3, string.charAt(0));
                this.timeold.setCharAt(n * 3 + 1, string.charAt(1));
            }
            this.time = this.timeold;
            this.insertStringValid = true;
            super.setText(this.time.toString());
            this.insertStringValid = false;
            this.zeroAdjust(n);
            this.fireTimeEvent();
            super.setCaretPosition(this.caretposition);
        }
        return true;
    }

    private boolean delKeyPressed() {
        if (this.getSelectionEnd() - this.getSelectionStart() != 0) {
            this.handleSelection();
            return true;
        }
        if (this.caretposition != this.timeold.length()) {
            if (this.caretposition >= this.timeold.length() - 1 - this.markdif && (this.timeold.toString().indexOf(this.forenoon) != -1 || this.timeold.toString().indexOf(this.afternoon) != -1) || this.timeold.charAt(this.caretposition) == this.editable || this.timeold.charAt(this.caretposition) == this.separator.charAt(0)) {
                this.setCaretPosition(this.caretposition + 1);
                return true;
            }
            this.timeold.setCharAt(this.caretposition, this.editable);
        }
        this.time = this.timeold;
        if (this.lengthCheck()) {
            if (this.timeold.charAt(this.caretposition + 1) == this.separator.charAt(0)) {
                this.zeroAdjust(this.counter);
                this.fireTimeEvent();
                super.setCaretPosition(this.caretposition + 2);
                return true;
            }
            this.insertStringValid = true;
            super.setText(this.time.toString());
            this.insertStringValid = false;
            this.fireTimeEvent();
            super.setCaretPosition(this.caretposition + 1);
            return true;
        }
        this.insertStringValid = true;
        super.setText(this.time.toString());
        this.insertStringValid = false;
        this.fireTimeEvent();
        if (this.caretposition != this.timeold.length()) {
            super.setCaretPosition(this.caretposition + 1);
        } else {
            super.setCaretPosition(this.caretposition);
        }
        return true;
    }

    private boolean homeKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown()) {
            return false;
        }
        if (this.counter <= 2 && this.counter >= 0) {
            this.zeroAdjust(this.counter);
        }
        super.setCaretPosition(0);
        return true;
    }

    private boolean endKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown()) {
            return false;
        }
        if (this.mask.toString().indexOf(104) == -1) {
            super.setCaretPosition(this.time.length());
        } else {
            super.setCaretPosition(this.timeold.length() - this.markdif);
        }
        return true;
    }

    private boolean backspaceKeyPressed() {
        if (this.getSelectionEnd() - this.getSelectionStart() != 0) {
            this.handleSelection();
            return true;
        }
        if (this.caretposition != 0) {
            if (this.caretposition > this.timeold.length() - this.markdif && (this.timeold.toString().indexOf(this.forenoon) != -1 || this.timeold.toString().indexOf(this.afternoon) != -1)) {
                return true;
            }
            if (this.lengthCheck() && this.timeold.charAt(this.caretposition - 1) == ' ' && (this.timeold.charAt(this.caretposition) == this.forenoon.charAt(0) || this.timeold.charAt(this.caretposition) == this.afternoon.charAt(0))) {
                this.timeold.setCharAt(this.caretposition - 2, this.editable);
                this.time = this.timeold;
                this.insertStringValid = true;
                super.setText(this.time.toString());
                this.insertStringValid = false;
                this.fireTimeEvent();
                super.setCaretPosition(this.caretposition - 2);
                return true;
            }
            if (this.timeold.charAt(this.caretposition - 1) == this.separator.charAt(this.separator.length() - 1)) {
                this.timeold.setCharAt(this.caretposition - 2, this.editable);
                this.time = this.timeold;
                this.zeroAdjust(this.counter);
                this.fireTimeEvent();
                super.setCaretPosition(this.caretposition - 2);
            } else {
                this.timeold.setCharAt(this.caretposition - 1, this.editable);
                this.time = this.timeold;
                this.insertStringValid = true;
                super.setText(this.time.toString());
                this.insertStringValid = false;
                this.fireTimeEvent();
                super.setCaretPosition(this.caretposition - 1);
            }
        }
        return true;
    }

    private void changeField() {
        if (this.counter < this.countOfDelim && this.counter >= 0) {
            this.zeroAdjust(this.counter);
            super.setCaretPosition(this.time.toString().indexOf(this.separator, this.caretposition) + 1);
            return;
        }
        if (this.mask.toString().indexOf(104) == -1) {
            this.zeroAdjust(this.countOfDelim);
            return;
        }
        if (this.caretposition <= this.timeold.length() - 1 - this.markdif) {
            this.zeroAdjust(this.countOfDelim);
            return;
        }
    }

    private boolean spaceKeyPressed() {
        if (this.getSelectionStart() - this.getSelectionEnd() != 0) {
            this.handleSelection();
            return true;
        }
        switch (this.counter) {
            case 0: {
                this.timeold.setCharAt(0, this.editable);
                this.timeold.setCharAt(1, this.editable);
                break;
            }
            case 1: {
                this.timeold.setCharAt(2 + this.separator.length(), this.editable);
                this.timeold.setCharAt(3 + this.separator.length(), this.editable);
                break;
            }
            case 2: {
                this.timeold.setCharAt(4 + 2 * this.separator.length(), this.editable);
                this.timeold.setCharAt(5 + 2 * this.separator.length(), this.editable);
                break;
            }
        }
        this.time = this.timeold;
        this.insertStringValid = true;
        super.setText(this.time.toString());
        this.insertStringValid = false;
        this.fireTimeEvent();
        super.setCaretPosition(this.caretposition);
        return true;
    }

    private boolean lengthCheck() {
        return this.caretposition + 1 < this.timeold.length();
    }

    private void setValidation() {
        String string = this.mask.toString().toLowerCase();
        this.startIndex = 0;
        int n = string.indexOf(this.separator.charAt(0));
        int n2 = string.indexOf(104);
        int n3 = string.indexOf(109);
        int n4 = string.indexOf(115);
        if (n2 != -1) {
            this.hourpos = this.getPos(n2, n);
            this.validation[this.hourpos] = this.hourmax;
        }
        if (n3 != -1) {
            this.minpos = this.getPos(n3, n);
            this.validation[this.minpos] = 59;
        }
        if (n4 != -1) {
            this.secpos = this.getPos(n4, n);
            this.validation[this.secpos] = 59;
        }
    }

    private void setSize() {
        String string = new String(this.mask.toString());
        int n = 0;
        int n2 = 0;
        while (string.indexOf(this.separator, n2) != -1) {
            this.size[n++] = 2;
            n2 = string.indexOf(this.separator, n2) + 1;
        }
        this.size[n] = 2;
        this.countOfDelim = n;
    }

    private int getPos(int n, int n2) {
        if (n - n2 < 1) {
            return 0;
        }
        if (n - n2 == 1) {
            return 1;
        }
        return 2;
    }

    private boolean validateInput() {
        String string;
        this.startIndex = 0;
        int n = 1;
        while (n <= this.counter) {
            this.startIndex += this.size[n - 1] + this.separator.length();
            ++n;
        }
        if (this.lengthCheck() && this.timeold.charAt(this.caretposition + 1) == this.editable && (this.mask.toString().indexOf(104) == -1 || this.caretposition != this.timeold.length() - (this.markdif + 2))) {
            new Character(this.timeold.charAt(this.caretposition));
            if (this.counter == this.hourpos) {
                string = new String();
                string = this.timeold.toString().substring(0, 2);
                if (this.hourmax == 12) {
                    Integer.parseInt(string);
                } else if (this.hourmax == 23) {
                    Integer.parseInt(string);
                }
            }
            if (this.counter == this.minpos || this.counter == this.secpos) {
                string = new String();
                string = this.timeold.toString().substring(0, 2);
                if (Integer.parseInt(string) > 59) {
                    return false;
                }
            }
        }
        if (!Character.isDigit((string = this.timeold.toString().substring(this.startIndex, this.startIndex + this.size[this.counter])).charAt(0)) && string.charAt(0) != this.editable) {
            return false;
        }
        if (this.counter == this.hourpos && this.hourmax == 12 && Integer.parseInt(string) == 0) {
            return false;
        }
        if (Integer.parseInt(string) <= this.validation[this.counter]) {
            if (this.getCaretPosition() == this.time.length() - 1) {
                this.counter = 0;
                this.startIndex = 0;
            }
            this.time = this.timeold;
            return true;
        }
        return false;
    }

    private int getCounter(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 <= this.countOfDelim) {
            if (n3 == this.countOfDelim) {
                if (n <= (n2 += this.size[n3])) {
                    return n3;
                }
            } else {
                n2 += this.size[n3] + this.separator.length();
            }
            if (n < n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private void handleSelection() {
        if (this.getSelectionEnd() - this.getSelectionStart() != 0) {
            int n = 0;
            int n2 = 0;
            n2 = this.getSelectionEnd();
            n = this.getSelectionStart();
            String string = this.getSelectedText();
            int n3 = 0;
            while (n3 < string.length()) {
                if (Character.isDigit(string.charAt(n3))) {
                    this.timeold.setCharAt(n + n3, this.editable);
                }
                ++n3;
            }
            this.time = this.timeold;
            this.insertStringValid = true;
            super.setText(this.time.toString());
            this.insertStringValid = false;
            this.fireTimeEvent();
            super.setCaretPosition(this.caretposition);
            return;
        }
    }

    private void zeroAdjust(int n) {
        if (n >= 0 && n <= this.countOfDelim) {
            boolean bl = false;
            String string = "  ";
            if (this.hourpos == n && this.countOf('h', this.mask.toString().toLowerCase()) == 2) {
                bl = true;
            }
            if (this.minpos == n && this.countOf('m', this.mask.toString()) == 2) {
                bl = true;
            }
            if (this.secpos == n && this.countOf('s', this.mask.toString()) == 2) {
                bl = true;
            }
            string = this.time.toString().substring(n * 3, n * 3 + 2);
            if (bl) {
                if (this.countOf(this.editable, string) == 1) {
                    if (string.indexOf(this.editable) == 1) {
                        this.time.setCharAt(n * 3 + 1, this.time.charAt(n * 3));
                    }
                    this.time.setCharAt(n * 3, '0');
                }
            } else if (this.countOf(this.editable, string) == 1) {
                if (string.indexOf(this.editable) == 1) {
                    this.time.setCharAt(n * 3 + 1, this.time.charAt(n * 3));
                }
                this.time.setCharAt(n * 3, this.editable);
            }
            int n2 = super.getCaretPosition();
            boolean bl2 = this.getSelectedText() != null;
            int n3 = 0;
            int n4 = 0;
            if (bl2) {
                n3 = this.getSelectionStart();
                if (n3 == n2) {
                    n4 = n3;
                    n3 = this.getSelectionEnd();
                } else {
                    n4 = this.getSelectionEnd();
                }
            }
            this.insertStringValid = true;
            super.setText(this.time.toString());
            this.insertStringValid = false;
            if (bl2) {
                this.select(n3, n4);
                return;
            }
            super.setCaretPosition(n2);
        }
    }

    private void fireInvalidInputEvent(KeyEvent keyEvent) {
        if (this.invalidListeners != null) {
            Vector vector = (Vector)this.invalidListeners.clone();
            int n = 0;
            while (n < vector.size()) {
                ((InvalidInputListener)vector.elementAt(n)).invalidCharacterEntered(new InvalidInputEvent(this, keyEvent.getKeyChar()));
                ++n;
            }
        }
    }

    private void firePropertyChangeEvents() {
        String string = new String(this.time.toString());
        if (this.oldTime == null) {
            this.oldTime = new String(this.time.toString());
        }
        if (!this.oldTime.equals(string)) {
            this.firePropertyChange("time", this.oldTime, string);
            this.oldTime = string;
        }
    }

    private void fireTimeEvent() {
        this.firePropertyChangeEvents();
        if (this.timeListeners != null) {
            Vector vector = (Vector)this.timeListeners.clone();
            TimeEvent timeEvent = new TimeEvent(this, this.getTime(), this.getHour(), this.getMinute(), this.getSecond());
            int n = 0;
            while (n < vector.size()) {
                ((TimeListener)vector.elementAt(n)).updateTime(timeEvent);
                ++n;
            }
        }
    }

    public synchronized void addInvalidInputListener(InvalidInputListener invalidInputListener) {
        if (invalidInputListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.invalidListeners == null) {
            this.invalidListeners = new Vector();
        }
        if (!this.invalidListeners.contains(invalidInputListener)) {
            this.invalidListeners.addElement(invalidInputListener);
        }
    }

    public synchronized void removeInvalidInputListener(InvalidInputListener invalidInputListener) {
        if (invalidInputListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.invalidListeners == null) {
            return;
        }
        if (this.invalidListeners.contains(invalidInputListener)) {
            this.invalidListeners.removeElement(invalidInputListener);
        }
    }

    public synchronized void addTimeListener(TimeListener timeListener) {
        if (timeListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.timeListeners == null) {
            this.timeListeners = new Vector();
        }
        if (!this.timeListeners.contains(timeListener)) {
            this.timeListeners.addElement(timeListener);
        }
    }

    public synchronized void removeTimeListener(TimeListener timeListener) {
        if (timeListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.timeListeners == null) {
            return;
        }
        if (this.timeListeners.contains(timeListener)) {
            this.timeListeners.removeElement(timeListener);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setSelectedTextColor(Color color) {
        super.setSelectedTextColor(color);
    }

    public void setSelectionStart(int n) {
        super.setSelectionStart(n);
    }

    public void setSelectionEnd(int n) {
        super.setSelectionEnd(n);
    }

    protected Document createDefaultModel() {
        return new InternalDocument();
    }

    public Document getDocument() {
        Document document = super.getDocument();
        if (document != null) {
            return document;
        }
        if (this.defaultModel == null) {
            this.defaultModel = this.createDefaultModel();
        }
        return this.defaultModel;
    }

    public void setDocument(Document document) {
        if (document != null && document instanceof InternalDocument) {
            super.setDocument(document);
            return;
        }
        throw new IllegalArgumentException("Only InternalDocument can be set!");
    }

    class InternalDocument
    extends PlainDocument {
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (ITime.this.insertStringValid) {
                super.insertString(n, string, attributeSet);
            }
        }

        public void remove(int n, int n2) throws BadLocationException {
            if (ITime.this.insertStringValid) {
                super.remove(n, n2);
            }
        }

        InternalDocument() {
            ITime.this = ITime.this;
        }
    }
}

