/*
 * Decompiled with CFR 0.152.
 */
package br.com.auttar.systray;

import java.io.File;
import java.io.IOException;

public class ServiceCommand {
    private Runtime rt = null;
    private Process proc = null;
    private String wrkDir = null;
    private String jreDir = null;
    private String[] params = null;
    private String app = null;

    private ServiceCommand(String wrkDir, String jreDir, String[] params, String app) {
        this.wrkDir = wrkDir;
        this.jreDir = jreDir;
        this.params = params;
        this.app = app;
        this.rt = Runtime.getRuntime();
    }

    public static ServiceCommand createInstance(String wrkDir, String jreDir, String[] params, String app) {
        return new ServiceCommand(wrkDir, jreDir, params, app);
    }

    public boolean start() {
        StringBuffer cmdLine = new StringBuffer();
        String javaCommand = "\"" + this.jreDir + File.separator + "bin" + File.separator + "java.exe\"";
        cmdLine.append(javaCommand);
        cmdLine.append(" -cp ");
        if (this.params != null && this.params.length > 0) {
            int i = 0;
            while (i < this.params.length) {
                cmdLine.append("\"" + this.params[i] + "\";");
                ++i;
            }
        }
        cmdLine.append(" ");
        cmdLine.append(this.app);
        try {
            File dir = new File(this.wrkDir);
            this.proc = this.rt.exec(cmdLine.toString(), null, dir);
        }
        catch (IOException io) {
            io.printStackTrace();
            return false;
        }
        return true;
    }

    public void stop() {
        this.proc.destroy();
        this.proc = null;
    }

    public boolean isAlive() {
        if (this.proc == null) {
            return false;
        }
        try {
            this.proc.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
        return false;
    }

    public void restart() {
        this.stop();
        this.start();
    }
}

