/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.swing;

import com.ibm.jutil.FileUtil;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.awt.Font;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class PropertiesEditor
extends JScrollPane {
    private String propertiesFileName;
    private JEditorPane editorPane;
    private boolean couldLoadProperties;
    private Tracer tracer = TracerFactory.getInstance().createTracer("POSCC", "PropertiesEditor");

    public PropertiesEditor(String propertiesFileName) {
        this.propertiesFileName = propertiesFileName == null ? "" : propertiesFileName;
        this.createEditorPane();
        this.setViewportView(this.editorPane);
    }

    public void loadProperties() throws IOException {
        InputStream is = null;
        byte[] fileContent = null;
        this.tracer.println("--> loadProperties ");
        try {
            is = FileUtil.loadFile(this.propertiesFileName, true, true);
            if (is != null) {
                fileContent = new byte[is.available()];
                is.read(fileContent);
                is.close();
            }
            this.editorPane.setText(new String(fileContent));
            this.editorPane.setCaretPosition(0);
            this.editorPane.setEditable(true);
            this.couldLoadProperties = true;
            this.tracer.println("file: " + this.propertiesFileName + " loaded.");
        }
        catch (IOException e) {
            this.couldLoadProperties = false;
            this.tracer.println(e.getMessage());
            throw e;
        }
        finally {
            this.tracer.println("<-- loadProperties ");
        }
    }

    public void saveProperties() throws IOException {
        if (this.couldLoadProperties) {
            try {
                FileOutputStream fos = new FileOutputStream(this.propertiesFileName);
                this.tracer.println("Saving file: " + this.propertiesFileName);
                fos.write(this.editorPane.getText().getBytes());
                fos.close();
            }
            catch (IOException ioe) {
                this.tracer.print(ioe);
                throw ioe;
            }
        }
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    private void createEditorPane() {
        this.editorPane = new JEditorPane();
        Font font = new Font("Monospaced", 0, 12);
        this.editorPane.setFont(font);
    }
}

