/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil.swing;

import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HtmlPane
extends JScrollPane {
    private Tracer tracer = TracerFactory.getInstance().createTracer("HtmlPane");
    private JEditorPane html;
    private String errorTitle = "";
    private URL mainPage = null;

    public HtmlPane(String htmlFileName) throws IOException {
        URL url = null;
        url = this.getClass().getResource(htmlFileName);
        if (url == null) {
            throw new IOException(htmlFileName + " cannot be accesed");
        }
        this.html = new JEditorPane(url);
        this.html.setEditable(false);
        this.html.addHyperlinkListener(new HyperlinkL());
        JViewport vp = this.getViewport();
        vp.add(this.html);
        this.setMainPage(this.html.getPage());
    }

    public void setErrorTitle(String title) {
        this.errorTitle = title;
    }

    public String getErrorTitle() {
        return this.errorTitle;
    }

    public void setMainPage() {
        try {
            this.html.setPage(this.getMainPage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void setMainPage(URL url) {
        this.mainPage = url;
    }

    protected URL getMainPage() {
        return this.mainPage;
    }

    protected void doHyperLinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e instanceof HTMLFrameHyperlinkEvent) {
                ((HTMLDocument)this.html.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
            } else {
                try {
                    this.html.setPage(e.getURL());
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this, ioe, this.getErrorTitle(), 0);
                    this.tracer.println("IOE: " + ioe);
                }
            }
        }
    }

    class HyperlinkL
    implements HyperlinkListener {
        HyperlinkL() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            HtmlPane.this.doHyperLinkUpdate(e);
        }
    }
}

