/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil;

import com.ibm.jutil.IntArrayCollector;
import com.ibm.jutil.patterns.factory.AbstractPoolFactory;
import com.ibm.jutil.patterns.factory.AbstractRecyclableObject;
import com.ibm.jutil.patterns.factory.RecyclableObject;
import com.ibm.jutil.patterns.factory.RecycleFactory;
import com.ibm.jutil.patterns.factory.RecycleFactoryException;
import com.ibm.jutil.tracing.Tracing;
import java.util.ConcurrentModificationException;

public class IntBuffer
extends AbstractRecyclableObject {
    protected int[] intArray;
    protected int intCount = 0;
    protected int capacityIncrement;
    protected int startIndex = 0;
    boolean recycled = false;
    private static final IntBufferFactory factory = new IntBufferFactory(new RecycleFactory.CreateMethod(){

        public RecyclableObject newRecyclableObject(RecycleFactory recycleFactory) {
            return new IntBuffer(recycleFactory);
        }

        public RecyclableObject newRecyclableObject(RecyclableObject.CtorArg[] ctorArgs, RecycleFactory recycleFactory) throws RecycleFactoryException {
            throw new RecycleFactoryException("Parameters not supported");
        }
    });

    public IntBuffer() {
        this(16, 16);
    }

    public IntBuffer(int initialCapacity, int capacityIncrement) {
        this(IntBuffer.getIntBufferFactory());
        this.intArray = IntArrayCollector.getCollector().getArray(initialCapacity);
        this.intCount = 0;
        this.capacityIncrement = capacityIncrement;
        this.startIndex = 0;
        this.recycled = false;
    }

    public IntBuffer(int initialCapacity) {
        this(initialCapacity, 16);
    }

    public IntBuffer(RecycleFactory recycleFactory) {
        super(recycleFactory);
        if (null == this.intArray) {
            int initialCapacity = 16;
            try {
                initialCapacity = ((IntBufferFactory)recycleFactory).getInitialCapacity();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.intArray = IntArrayCollector.getCollector().getArray(initialCapacity);
            this.intCount = 0;
            this.capacityIncrement = 16;
            this.startIndex = 0;
            this.recycled = false;
        }
    }

    public IntBuffer(int[] initArray) {
        this(16, 16);
        IntArrayCollector.getCollector().collect(this.intArray);
        this.intArray = initArray;
        this.setIntCount(this.intArray.length, false);
        this.recycled = false;
    }

    public int[] replace(int[] x) {
        int[] old = this.intArray;
        this.intArray = x;
        this.intCount = x.length;
        return old;
    }

    public void setIntCount(int size, boolean clear) {
        if (size > this.intArray.length) {
            int[] newIntArray = IntArrayCollector.getCollector().getArray(size);
            if (clear) {
                System.arraycopy(this.intArray, 0, newIntArray, 0, this.intCount);
            }
            IntArrayCollector.getCollector().collect(this.intArray);
            this.intArray = newIntArray;
        }
        if (clear) {
            for (int i = this.intCount; i < size; ++i) {
                this.intArray[i] = 0;
            }
        }
        this.intCount = size;
    }

    public boolean isRecycled() {
        return this.recycled;
    }

    public int getIntCount() {
        return this.intCount;
    }

    public void setStartIndex(int start) {
        this.startIndex = start;
        if (this.startIndex >= this.intArray.length) {
            this.setIntCount(this.startIndex + this.capacityIncrement, true);
        }
        this.intCount = this.startIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public IntBuffer append(int[] ints) {
        if (this.intCount + ints.length > this.intArray.length) {
            int xsize = this.intCount + ints.length + this.capacityIncrement;
            int[] newIntArray = IntArrayCollector.getCollector().getArray(xsize);
            System.arraycopy(this.intArray, 0, newIntArray, 0, this.intCount);
            IntArrayCollector.getCollector().collect(this.intArray);
            this.intArray = newIntArray;
        }
        System.arraycopy(ints, 0, this.intArray, this.intCount, ints.length);
        this.intCount += ints.length;
        return this;
    }

    public IntBuffer append(int[] ints, int beginIndex, int count) {
        block3: {
            if (this.intCount + count > this.intArray.length) {
                int xsize = this.intCount + count + this.capacityIncrement;
                int[] newIntArray = IntArrayCollector.getCollector().getArray(xsize);
                System.arraycopy(this.intArray, 0, newIntArray, 0, this.intCount);
                IntArrayCollector.getCollector().collect(this.intArray);
                this.intArray = newIntArray;
            }
            try {
                System.arraycopy(ints, beginIndex, this.intArray, this.intCount, count);
            }
            catch (Exception aa) {
                if (!Tracing.isOn()) break block3;
                Tracing.println("ERROR " + String.valueOf(ints.length) + "," + String.valueOf(beginIndex) + "," + String.valueOf(this.intArray.length) + "," + String.valueOf(this.intCount) + "," + String.valueOf(count));
            }
        }
        this.intCount += count;
        return this;
    }

    public IntBuffer insert(int b, int index) {
        int[] newIntArray;
        if (index < this.intCount) {
            int xsize = this.intCount + 1;
            if (xsize > this.intArray.length) {
                xsize += this.capacityIncrement;
            }
            newIntArray = IntArrayCollector.getCollector().getArray(xsize);
            System.arraycopy(this.intArray, 0, newIntArray, 0, index);
            newIntArray[index] = b;
            System.arraycopy(this.intArray, index, newIntArray, index + 1, this.intCount - index);
            IntArrayCollector.getCollector().collect(this.intArray);
            ++this.intCount;
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.intArray = newIntArray;
        return this;
    }

    public IntBuffer append(int b) {
        if (this.intCount + 1 > this.intArray.length) {
            int xsize = this.intCount + 1 + this.capacityIncrement;
            int[] newIntArray = IntArrayCollector.getCollector().getArray(xsize);
            System.arraycopy(this.intArray, 0, newIntArray, 0, this.intCount);
            IntArrayCollector.getCollector().collect(this.intArray);
            this.intArray = newIntArray;
        }
        this.intArray[this.intCount++] = b;
        return this;
    }

    public IntBuffer append(IntBuffer buf) {
        if (this.intCount + buf.getIntCount() > this.intArray.length) {
            int xsize = this.intCount + buf.getIntCount() + this.capacityIncrement;
            int[] newIntArray = IntArrayCollector.getCollector().getArray(xsize);
            System.arraycopy(this.intArray, 0, newIntArray, 0, this.intCount);
            IntArrayCollector.getCollector().collect(this.intArray);
            this.intArray = newIntArray;
        }
        System.arraycopy(buf.intArray, 0, this.intArray, this.intCount, buf.getIntCount());
        this.intCount += buf.getIntCount();
        return this;
    }

    public int[] getInts() {
        int[] newIntArray = IntArrayCollector.getCollector().getArray(this.intCount);
        System.arraycopy(this.intArray, 0, newIntArray, 0, this.intCount);
        return newIntArray;
    }

    public int[] getIntRef() {
        return this.intArray;
    }

    public void reset() {
        this.intCount = this.startIndex;
    }

    public void resize(int n) {
        if (null != this.intArray) {
            IntArrayCollector.getCollector().collect(this.intArray);
        }
        this.intArray = IntArrayCollector.getCollector().getArray(n);
    }

    public int intAt(int index) {
        if (index < this.intCount) {
            return this.intArray[index];
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public IntBuffer copy(int[] fromArray, int fromIndex, int toIndex, int count) {
        if (toIndex + count + 1 > this.intArray.length) {
            int xsize = toIndex + count + 1 + this.capacityIncrement;
            int[] newIntArray = IntArrayCollector.getCollector().getArray(xsize);
            System.arraycopy(this.intArray, 0, newIntArray, 0, this.intCount);
            IntArrayCollector.getCollector().collect(this.intArray);
            this.intArray = newIntArray;
        }
        System.arraycopy(fromArray, fromIndex, this.intArray, toIndex, count);
        this.intCount = toIndex + count > this.intCount ? toIndex + count : this.intCount;
        return this;
    }

    public IntBuffer setInt(int intValue, int index) {
        if (index >= this.intCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.intArray[index] = intValue;
        return this;
    }

    public void clean() {
        this.reset();
    }

    public void recycle() {
        if (null == this.getRecycleFactory()) {
            return;
        }
        super.recycle();
        this.recycled = true;
    }

    public static synchronized IntBufferFactory getIntBufferFactory() {
        return factory;
    }

    public static class IntBufferFactory
    extends AbstractPoolFactory {
        int initialCap = 16;

        public IntBufferFactory(RecycleFactory.CreateMethod cm) {
            super(cm, 1, 0, 1.0f);
        }

        public int getInitialCapacity() {
            return this.initialCap;
        }

        public void setInitialCapacity(int cap) {
            this.initialCap = cap;
        }

        public IntBuffer createIntBuffer() {
            IntBuffer ret = null;
            while (ret == null) {
                try {
                    ret = (IntBuffer)super.takeFromPool();
                }
                catch (ConcurrentModificationException cme) {
                    Tracing.print(cme);
                }
            }
            if (ret.intArray == null || this.initialCap != ret.intArray.length) {
                ret.resize(this.initialCap);
            }
            return ret;
        }

        public IntBuffer createIntBuffer(int initialSize) {
            this.initialCap = initialSize;
            IntBuffer ib = this.createIntBuffer();
            return ib;
        }
    }
}

