/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil;

import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;

public class FileUtil {
    protected static Tracer tracer = null;

    protected FileUtil() {
    }

    protected static synchronized List getCpDirList() {
        String classpath = System.getProperty("java.class.path");
        LinkedList<String> cpDirList = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String cpEntry = st.nextToken();
            if (cpEntry.toLowerCase().endsWith("jar") || cpEntry.toLowerCase().endsWith("zip")) {
                if (cpEntry.lastIndexOf(File.separator) == -1) continue;
                cpDirList.add(cpEntry.substring(0, cpEntry.lastIndexOf(File.separator)));
                continue;
            }
            cpDirList.add(cpEntry);
        }
        return cpDirList;
    }

    protected static synchronized List getJarList() {
        String classpath = System.getProperty("java.class.path");
        LinkedList<String> cpJarFilesList = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String cpEntry = st.nextToken();
            if (!cpEntry.toLowerCase().endsWith("jar") && !cpEntry.toLowerCase().endsWith("zip")) continue;
            cpJarFilesList.add(cpEntry);
        }
        return cpJarFilesList;
    }

    protected static synchronized JarEntry getJarEntry(JarFile jarFile, String fileName) {
        if (jarFile == null) {
            return null;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!jarEntry.getName().equals(fileName)) continue;
            return jarEntry;
        }
        return null;
    }

    protected static synchronized JarFile lookForFileInJars(String fileName) {
        return FileUtil.lookForFileInJars(fileName, null);
    }

    protected static synchronized JarFile lookForFileInJars(String fileName, FindFilePath path) {
        try {
            List cpJarFilesList = FileUtil.getJarList();
            for (int i = 0; i < cpJarFilesList.size(); ++i) {
                String jarFileName = (String)cpJarFilesList.get(i);
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(new File(jarFileName));
                }
                catch (ZipException ze) {
                    if (!FileUtil.getTracer().isOn()) continue;
                    FileUtil.getTracer().println("[FileUtil] The JarFile does not exist->" + jarFileName);
                    continue;
                }
                JarEntry jarEntry = FileUtil.getJarEntry(jarFile, fileName);
                if (jarEntry != null) {
                    if (null != path) {
                        path.setFoundPath(jarFile.getName());
                    }
                    return jarFile;
                }
                jarFile.close();
            }
            return null;
        }
        catch (Exception ioe) {
            return null;
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    protected static Tracer getTracer() {
        if (tracer == null) {
            tracer = TracerFactory.getInstance().createTracer("GlobalTracer", "FileUtil");
        }
        return tracer;
    }

    public static synchronized boolean locateFile(String fileName, boolean searchInClassPath, boolean searchInJarFile) {
        File file = FileUtil.findFile(fileName, searchInClassPath);
        if (file != null) {
            return true;
        }
        if (searchInJarFile) {
            JarFile jarFile = FileUtil.lookForFileInJars(fileName);
            if (jarFile == null && FileUtil.isWindows() && fileName.indexOf(File.separatorChar) != -1) {
                fileName = fileName.replace('\\', '/');
                jarFile = FileUtil.lookForFileInJars(fileName);
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                return true;
            }
        }
        return false;
    }

    public static synchronized File findFile(String fileName, boolean searchInClassPath) {
        return FileUtil.findFile(fileName, searchInClassPath, null);
    }

    public static synchronized File findFile(String fileName, boolean searchInClassPath, FindFilePath fPath) {
        try {
            File file = new File(fileName);
            if (file.exists()) {
                if (null != fPath) {
                    fPath.setFoundPath(file.getAbsolutePath());
                }
                return file;
            }
            List cpDirList = FileUtil.getCpDirList();
            if (searchInClassPath) {
                for (int i = 0; i < cpDirList.size(); ++i) {
                    String path = (String)cpDirList.get(i);
                    File file2 = new File(path + File.separator + fileName);
                    if (!file2.exists()) continue;
                    if (null != fPath) {
                        fPath.setFoundPath(file2.getAbsolutePath());
                    }
                    return file2;
                }
            }
            return null;
        }
        catch (Exception ioe) {
            return null;
        }
    }

    public static synchronized InputStream loadFile(String fileName, boolean searchInClassPath, boolean searchInJarFile) throws FileNotFoundException, IOException {
        return FileUtil.loadFile(fileName, searchInClassPath, searchInJarFile, null);
    }

    public static synchronized InputStream loadFile(String fileName, boolean searchInClassPath, boolean searchInJarFile, FindFilePath path) throws FileNotFoundException, IOException {
        JarEntry locatedJarEntry;
        File locatedFile = FileUtil.findFile(fileName, searchInClassPath);
        if (locatedFile != null) {
            if (null != path) {
                path.setFoundPath(locatedFile.getAbsolutePath());
            }
            return new FileInputStream(locatedFile);
        }
        if (locatedFile == null && !searchInJarFile) {
            throw new FileNotFoundException("Could not find file: " + fileName);
        }
        JarFile locatedJarFile = FileUtil.lookForFileInJars(fileName, path);
        if (locatedJarFile == null) {
            if (FileUtil.isWindows() && fileName.indexOf(File.separatorChar) != -1) {
                fileName = fileName.replace('\\', '/');
                locatedJarFile = FileUtil.lookForFileInJars(fileName, path);
            }
            if (locatedJarFile == null) {
                throw new FileNotFoundException("Could not find file: " + fileName);
            }
        }
        if ((locatedJarEntry = FileUtil.getJarEntry(locatedJarFile, fileName)) != null) {
            return locatedJarFile.getInputStream(locatedJarEntry);
        }
        throw new FileNotFoundException("Could not find file: " + fileName);
    }

    public static synchronized void copyFile(File inputFile, File outputFile) throws IOException, FileNotFoundException {
        int c;
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new IOException("Unable to create directory: " + outputFile.getParent());
        }
        FileReader in = new FileReader(inputFile);
        FileWriter out = new FileWriter(outputFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static synchronized void copyFile(InputStream inputStream, File outputFile) throws IOException, FileNotFoundException {
        int c;
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new IOException("Unable to create directory: " + outputFile.getParent());
        }
        BufferedInputStream in = new BufferedInputStream(inputStream);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static URL findURL(String fileName) throws FileNotFoundException {
        URL url = ClassLoader.getSystemResource(fileName);
        if (url == null) {
            if (FileUtil.isWindows() && fileName.indexOf(File.separatorChar) != -1) {
                fileName = fileName.replace('\\', '/');
                url = ClassLoader.getSystemResource(fileName);
            }
            if (url == null) {
                throw new FileNotFoundException("Could not find URL for file: " + fileName);
            }
        }
        return url;
    }

    public static synchronized String getClasspathDirectory(String suffix) {
        String classpath = System.getProperty("java.class.path");
        String installDir = null;
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String cpEntry = st.nextToken();
            if (!(cpEntry = cpEntry.toLowerCase()).endsWith(suffix)) continue;
            installDir = cpEntry.substring(0, cpEntry.length() - suffix.length());
        }
        return installDir;
    }

    public static interface FindFilePath {
        public void setFoundPath(String var1);
    }
}

