/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jutil;

import com.ibm.jutil.DefaultStoreFileUtil;
import com.ibm.jutil.FileUtil;
import com.ibm.jutil.UtilProperties;
import com.ibm.jutil.tracing.Tracer;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class DefaultUtilProperties
implements UtilProperties {
    private Properties properties = null;
    private HashMap multiPropMap = new HashMap();
    private String fullPath = "null";
    private String loadedPropFileName = "";
    private String propFileName = "";
    private boolean loaded = false;
    private Exception lastException = null;
    private FindPropertyPath pathFinder = new FindPropertyPath();
    private static Comparator propComparator = null;

    public DefaultUtilProperties(String propFileName) {
        this.propFileName = propFileName;
    }

    public void loadProperties() {
        this.loadPropertiesByName(this.propFileName);
    }

    public void loadPropertiesByName(String propFileName) {
        this.loaded = false;
        this.lastException = null;
        this.properties = this.findProperties(propFileName);
        this.createMultiProperties();
    }

    public void storeProperties(String header, String fileName) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName);
        }
        catch (FileNotFoundException fnfe) {
            try {
                String path = fileName.substring(0, fileName.lastIndexOf("/"));
                String file = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
                DefaultStoreFileUtil storeFile = new DefaultStoreFileUtil(path);
                storeFile.create(file);
                out = (FileOutputStream)storeFile.getOutputStream();
            }
            catch (IOException ioe) {
                Tracer.getInstance().println("Could not write in " + fileName);
            }
        }
        try {
            if (out == null) {
                return;
            }
            this.getProperties().store(out, header);
            out.close();
        }
        catch (IOException e) {
            Tracer.getInstance().println("Unexpected error writting to file " + fileName);
        }
    }

    public void addProperty(String propName, String propValue) {
        this.getProperties().setProperty(propName, propValue);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public String getPropertyString(String propName) {
        String propValue = "";
        if (System.getProperties().containsKey(propName)) {
            propValue = System.getProperties().getProperty(propName);
        } else if (this.properties != null && (propValue = this.getProperties().getProperty(propName)) != null && propValue.startsWith("<home>")) {
            String home = System.getProperties().getProperty("user.home");
            propValue = home + propValue.substring(propValue.lastIndexOf(">") + 1, propValue.length());
        }
        if (propValue != null) {
            propValue = propValue.trim();
        }
        return propValue;
    }

    public boolean getBooleanProperty(String propName) {
        String propValue = this.getPropertyString(propName);
        if (propValue == null) {
            return false;
        }
        if (propValue.equalsIgnoreCase("ON")) {
            return true;
        }
        return propValue.equalsIgnoreCase("TRUE");
    }

    public String getStringProperty(String propName) {
        return this.getPropertyString(propName);
    }

    public List getStringListProperty(String propName) {
        LinkedList<String> list = new LinkedList<String>();
        String stringList = this.getStringProperty(propName);
        if (stringList == null || stringList.equals("")) {
            return list;
        }
        StringTokenizer st = new StringTokenizer(stringList, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public long getLongProperty(String propName) {
        long l = 0L;
        String propValue = this.getStringProperty(propName);
        if (propValue == null || propValue.equals("")) {
            return 0L;
        }
        try {
            l = Long.parseLong(propValue);
        }
        catch (Exception e) {
            return 0L;
        }
        return l;
    }

    public int getIntProperty(String propName) {
        int i = 0;
        String propValue = this.getStringProperty(propName);
        if (propValue == null || propValue.equals("")) {
            return 0;
        }
        try {
            i = Integer.parseInt(propValue);
        }
        catch (Exception e) {
            return 0;
        }
        return i;
    }

    public boolean isPropertyDefined(String propName) {
        if (System.getProperties().containsKey(propName)) {
            return true;
        }
        if (this.properties != null) {
            Enumeration<Object> keys = this.properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.equals(propName)) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration getPropertyNames() {
        return this.getProperties().keys();
    }

    public UtilProperties.MultiProperty getMultiProperty(String multiPropName) {
        return (UtilProperties.MultiProperty)this.multiPropMap.get(multiPropName);
    }

    public boolean hasMultiProperty(String multiPropName) {
        return this.multiPropMap.containsKey(multiPropName);
    }

    public Iterator getProps() {
        ArrayList<Prop> list = new ArrayList<Prop>();
        Enumeration names = this.getPropertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = this.getPropertyString(name);
            Prop prop = new Prop(name, value);
            list.add(prop);
        }
        return list.iterator();
    }

    public int size() {
        return this.getProperties().size();
    }

    public String getLoadedPropFileName() {
        return this.loadedPropFileName;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.loadProperties();
        }
        return this.properties;
    }

    public String getPropertyFilePath() {
        return this.fullPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Properties findProperties(String propFileName) {
        Properties props;
        block12: {
            block13: {
                props = new Properties();
                if (propFileName.equals("")) {
                    return props;
                }
                this.loadedPropFileName = propFileName;
                InputStream is = null;
                try {
                    is = FileUtil.loadFile(this.loadedPropFileName, true, true, this.pathFinder);
                }
                catch (FileNotFoundException fne) {
                    this.loaded = false;
                    Tracer.getInstance().println("DefaultUtilProperties->" + propFileName + " file not found");
                }
                catch (IOException ioe) {
                    this.loaded = false;
                    Tracer.getInstance().println("DefaultUtilProperties-> Error Opening file " + propFileName);
                }
                if (is == null) break block13;
                is = new BufferedInputStream(is);
                props.load(is);
                this.loaded = true;
                Object var6_8 = null;
                try {
                    is.close();
                }
                catch (Exception e2) {
                    Tracer.getInstance().println("DefaultUtilProperties-> Unexpected exception while closing stream Exception.message = " + e2.getMessage());
                }
                break block12;
                {
                    catch (Exception e) {
                        this.loaded = false;
                        this.loadedPropFileName = "";
                        this.lastException = e;
                        Object var6_9 = null;
                        try {
                            is.close();
                        }
                        catch (Exception e2) {
                            Tracer.getInstance().println("DefaultUtilProperties-> Unexpected exception while closing stream Exception.message = " + e2.getMessage());
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    try {
                        is.close();
                    }
                    catch (Exception e2) {
                        Tracer.getInstance().println("DefaultUtilProperties-> Unexpected exception while closing stream Exception.message = " + e2.getMessage());
                    }
                    throw throwable;
                }
            }
            this.loaded = false;
            Tracer.getInstance().println("DefaultUtilProperties->" + propFileName + " Could not be loaded");
        }
        return props;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<UtilProperties>\n");
        Enumeration propNames = this.getPropertyNames();
        ArrayList list = new ArrayList();
        while (propNames.hasMoreElements()) {
            list.add(propNames.nextElement());
        }
        Collections.sort(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String propName = (String)iterator.next();
            String propValue = this.getPropertyString(propName);
            sb.append("<name = \"" + propName + "\"" + " value = \"" + propValue + "\" />\n");
        }
        sb.append("</UtilProperties>\n");
        return sb.toString();
    }

    public static Comparator propComparator() {
        if (propComparator == null) {
            propComparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (!(o1 instanceof UtilProperties.Prop)) {
                        return -1;
                    }
                    if (!(o2 instanceof UtilProperties.Prop)) {
                        return -1;
                    }
                    String o1Name = ((UtilProperties.Prop)o1).getName();
                    String o2Name = ((UtilProperties.Prop)o2).getName();
                    return o1Name.compareTo(o2Name);
                }
            };
        }
        return propComparator;
    }

    protected void createMultiProperties() {
        Enumeration<Object> propNames = this.getProperties().keys();
        while (propNames.hasMoreElements()) {
            MultiProp multiProp;
            String propName = (String)propNames.nextElement();
            String propValue = (String)this.getProperties().get(propName);
            if (!this.isMultiProp(propName)) continue;
            String multiPropBaseName = this.getMultiPropBaseName(propName);
            if (this.multiPropMap.containsKey(multiPropBaseName)) {
                multiProp = (MultiProp)this.multiPropMap.get(multiPropBaseName);
                multiProp.add(propName, propValue);
                continue;
            }
            multiProp = new MultiProp(multiPropBaseName);
            multiProp.add(propName, propValue);
            this.multiPropMap.put(multiPropBaseName, multiProp);
        }
    }

    protected boolean isMultiProp(String propName) {
        if (propName.indexOf(".") == -1) {
            return false;
        }
        int dotIndex = propName.lastIndexOf(".");
        String numberString = propName.substring(dotIndex + 1);
        int number = -1;
        try {
            number = Integer.parseInt(numberString);
        }
        catch (NumberFormatException nfe) {
            number = -1;
        }
        return number >= 0;
    }

    protected String getMultiPropBaseName(String propName) throws IllegalArgumentException {
        if (!this.isMultiProp(propName)) {
            throw new IllegalArgumentException("getMultiPropBaseName( propName ) expects a propName that is a MuliProp");
        }
        return propName.substring(0, propName.lastIndexOf("."));
    }

    public static class Prop
    implements UtilProperties.Prop {
        private String name = "";
        private String value = "";

        public Prop(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String s) {
            this.name = s;
        }

        public void setValue(String s) {
            this.value = s;
        }

        public int compareTo(UtilProperties.Prop other) {
            if (other == null) {
                return -1;
            }
            return this.getName().compareTo(other.getName());
        }

        public int compareTo(Object other) {
            return this.compareTo((UtilProperties.Prop)other);
        }

        public boolean equals(Object otherProp) {
            if (otherProp == null) {
                return false;
            }
            if (!(otherProp instanceof UtilProperties.Prop)) {
                return false;
            }
            UtilProperties.Prop prop = (UtilProperties.Prop)otherProp;
            return this.getName().equals(prop.getName()) && this.getValue().equals(prop.getValue());
        }

        public String toString() {
            return "<name = " + this.getName() + ", value = " + this.getValue() + ">";
        }
    }

    class MultiProp
    implements UtilProperties.MultiProperty {
        private String basePropName = "";
        private HashMap propMap = new HashMap();

        MultiProp(String s) {
            this.basePropName = s;
        }

        public String getBasePropertyName() {
            return this.basePropName;
        }

        public Iterator getPropertyNames() {
            return this.propMap.keySet().iterator();
        }

        public Iterator getSortedPropertyNames() {
            ArrayList namesList = new ArrayList(this.propMap.keySet());
            Collections.sort(namesList);
            return namesList.iterator();
        }

        public Iterator getPropertyValues() {
            return this.propMap.values().iterator();
        }

        public String getProperty(String propName) {
            return this.getPropertyString(propName);
        }

        public String getPropertyString(String propName) {
            return (String)this.propMap.get(propName);
        }

        public String getPropertyString(int i) throws IllegalArgumentException {
            if (i < 0) {
                throw new IllegalArgumentException("Cannot find property in multiprop with number i = " + i);
            }
            return this.getPropertyString(this.getBasePropertyName() + "." + i);
        }

        public int getNumberOfProperties() {
            return this.propMap.size();
        }

        public int propertyNumber(String propName) throws IllegalArgumentException {
            return this.validatePropName(propName);
        }

        int validatePropName(String propName) throws IllegalArgumentException {
            if (!propName.startsWith(this.getBasePropertyName() + ".")) {
                throw new IllegalArgumentException("propName = " + propName + " passed does not match base prop name of " + this.getBasePropertyName());
            }
            if (propName.endsWith(".")) {
                throw new IllegalArgumentException("propName = " + propName + " passed must end with a pattern .<number>");
            }
            String numberString = propName.substring(propName.lastIndexOf(".") + 1);
            int number = 0;
            try {
                number = Integer.parseInt(numberString);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("propName = " + propName + " passed must end with a pattern .<number>");
            }
            return number;
        }

        void add(String propName, String propValue) throws IllegalArgumentException {
            this.validatePropName(propName);
            this.propMap.put(propName, propValue);
        }

        String remove(String propName) {
            return (String)this.propMap.remove(propName);
        }
    }

    class FindPropertyPath
    implements FileUtil.FindFilePath {
        FindPropertyPath() {
        }

        public void setFoundPath(String path) {
            DefaultUtilProperties.this.fullPath = path;
        }
    }
}

