/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util.configuration;

import com.linx.touchkeyboard.configuration.Key;
import com.linx.touchkeyboard.configuration.KeyType;
import com.linx.touchkeyboard.configuration.Layout;
import com.linx.touchkeyboard.renderer.TouchKeyboardKey;
import com.linx.touchkeyboard.util.TouchKeyboardKeyControlUtil;
import com.linx.touchkeyboard.util.ValidateFieldUtil;
import com.linx.touchkeyboard.util.configuration.AlertDialog;
import com.linx.touchkeyboard.util.configuration.KeyConfigurationDialog;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyConfigurationDialogController
implements Initializable {
    Logger logger = LoggerFactory.getLogger(KeyConfigurationDialogController.class);
    private Stage stageParent;
    @FXML
    private TextField tfId;
    @FXML
    private CheckBox chkDisable;
    @FXML
    private CheckBox chkVisible;
    @FXML
    private TextField tfLabel;
    @FXML
    private TextField tfAscCode;
    @FXML
    private TextField tfCharCode;
    @FXML
    private TextField tfStyleId;
    @FXML
    private Button btOK;
    @FXML
    private Button btCancel;
    @FXML
    private ChoiceBox<String> selectType;
    @FXML
    private CheckBox chkDimensao;
    @FXML
    private TextField txtAltura;
    @FXML
    private TextField txtLargura;
    @FXML
    private HBox hboxDimensao;

    public TextField getTfId() {
        return this.tfId;
    }

    public TextField getTfLabel() {
        return this.tfLabel;
    }

    public TextField getTfAscCode() {
        return this.tfAscCode;
    }

    public TextField getTfCharCode() {
        return this.tfCharCode;
    }

    public TextField getTfStyleId() {
        return this.tfStyleId;
    }

    public ChoiceBox<String> getSelectType() {
        return this.selectType;
    }

    public CheckBox getChkVisible() {
        return this.chkVisible;
    }

    public CheckBox getChkDisable() {
        return this.chkDisable;
    }

    public Stage getStageParent() {
        return this.stageParent;
    }

    public void setStageParent(Stage stageParent) {
        this.stageParent = stageParent;
    }

    public CheckBox getChkDimensao() {
        return this.chkDimensao;
    }

    public void setChkDimensao(CheckBox chkDimensao) {
        this.chkDimensao = chkDimensao;
    }

    public TextField getTxtAltura() {
        return this.txtAltura;
    }

    public void setTxtAltura(TextField txtAltura) {
        this.txtAltura = txtAltura;
    }

    public TextField getTxtLargura() {
        return this.txtLargura;
    }

    public void setTxtLargura(TextField txtLargura) {
        this.txtLargura = txtLargura;
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.selectType.setItems(FXCollections.observableArrayList(KeyType.valuesAsArrayListString()));
        this.chkDimensao.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (arg2.booleanValue()) {
                    KeyConfigurationDialogController.this.hboxDimensao.setDisable(false);
                } else {
                    KeyConfigurationDialogController.this.hboxDimensao.setDisable(true);
                    KeyConfigurationDialogController.this.txtAltura.setText(null);
                    KeyConfigurationDialogController.this.txtLargura.setText(null);
                }
            }
        });
    }

    private ArrayList<String> validateFields() {
        this.logger.debug("Iniciando valida\u00e7\u00e3o de campos...");
        ArrayList<String> messages = new ArrayList<String>();
        boolean isDisable = this.chkDisable.isSelected();
        if (isDisable) {
            return messages;
        }
        if (this.tfId.getText() == null || this.tfId.getText().trim().equalsIgnoreCase("")) {
            this.logger.debug("Identidicador da tecla n\u00e3o informado.");
            messages.add("Identidicador da tecla n\u00e3o informado.");
            return messages;
        }
        TouchKeyboardKeyControlUtil.KeyInformation keyInformation = TouchKeyboardKeyControlUtil.getValuehashControl(this.tfId.getText());
        if (keyInformation != null) {
            this.logger.debug("ID informado est\u00e1 associado a Tecla " + keyInformation.getKeyName() + ", localizada no Layout " + keyInformation.getLayoutId());
            messages.add("ID informado est\u00e1 associado a Tecla " + keyInformation.getKeyName() + ", localizada no Layout " + keyInformation.getLayoutId());
            return messages;
        }
        if (this.tfAscCode.getText() == null || this.tfAscCode.getText().trim().equalsIgnoreCase("")) {
            this.logger.debug("C\u00f3digo ASC n\u00e3o informado.");
            messages.add("- C\u00f3digo ASC n\u00e3o informado.");
        } else {
            try {
                Integer.parseInt(this.tfAscCode.getText().trim());
            }
            catch (Exception e) {
                this.logger.error("C\u00f3digo ASC ' {} ' inv\u00e1lido. Por favor, informe somente caracteres num\u00e9ricos", (Object)this.tfAscCode.getText().trim());
                messages.add("- C\u00f3digo ASC '" + this.tfAscCode.getText() + "'" + " inv\u00e1lido. Por favor, informe somente caracteres num\u00e9ricos");
            }
        }
        if (this.tfCharCode.getText() != null && this.tfCharCode.getText().length() == 0) {
            this.logger.debug("Char Code n\u00e3o informado.");
            messages.add("- Char Code n\u00e3o informado.");
        }
        if (this.selectType == null || this.selectType.getSelectionModel() == null || this.selectType.getSelectionModel().getSelectedItem() == null) {
            this.logger.debug("Tipo de Tecla n\u00e3o selecionado.");
            messages.add("- Tipo de Tecla n\u00e3o selecionado.");
        }
        if (!(!this.chkDimensao.isSelected() || ValidateFieldUtil.isDigit(this.txtAltura.getText()) && ValidateFieldUtil.isDigit(this.txtLargura.getText()))) {
            this.logger.debug("Tipo de Tecla n\u00e3o selecionado.");
            messages.add("- A altura e largura devem possuir valores numericos, maiores do que 0");
        }
        this.logger.debug("Valida\u00e7\u00e3o de campos finalizada.");
        return messages;
    }

    @FXML
    public void confirmKeyEdit(ActionEvent event) {
        this.logger.debug("Iniciando tratamento do evento de modifica\u00e7\u00e3o de tecla.");
        Stage stage = (Stage)this.btOK.getScene().getWindow();
        ArrayList<String> errorMessages = this.validateFields();
        if (errorMessages == null || errorMessages.size() == 0) {
            this.logger.debug("Sem erros na valida\u00e7\u00e3o das informa\u00e7\u00f5es da tecla.");
            if (stage instanceof KeyConfigurationDialog) {
                KeyConfigurationDialog keyConfigDialog = (KeyConfigurationDialog)stage;
                Layout layout = keyConfigDialog.getLayout();
                TouchKeyboardKey touchKeyboardKey = keyConfigDialog.getTouchKeyboardKey();
                touchKeyboardKey.getKey().setId(this.tfId.getText());
                touchKeyboardKey.setId(this.tfId.getText());
                if (!this.chkDisable.isSelected()) {
                    touchKeyboardKey.getKey().setKeyCode(Integer.parseInt(this.tfAscCode.getText().trim()));
                    touchKeyboardKey.getKey().setKeyChar(this.tfCharCode.getText().charAt(0));
                }
                if (this.tfStyleId.getText() != null) {
                    touchKeyboardKey.getKey().setStyleId(this.tfStyleId.getText().trim());
                }
                touchKeyboardKey.setStyle(null);
                String keyTypeSelected = (String)this.selectType.getSelectionModel().getSelectedItem();
                touchKeyboardKey.getKey().setType(KeyType.getKeyType(keyTypeSelected));
                touchKeyboardKey.getKey().setLabel(this.tfLabel.getText());
                touchKeyboardKey.setText(this.tfLabel.getText());
                touchKeyboardKey.getKey().setVisible(this.chkVisible.isSelected());
                if (!this.chkVisible.isSelected()) {
                    touchKeyboardKey.setOpacity(0.3);
                } else {
                    touchKeyboardKey.setOpacity(1.0);
                }
                if (this.chkDimensao.isSelected()) {
                    touchKeyboardKey.getKey().setWidth((double)Double.valueOf(this.txtLargura.getText()));
                    touchKeyboardKey.getKey().setHeight((double)Double.valueOf(this.txtAltura.getText()));
                } else {
                    touchKeyboardKey.getKey().setWidth(null);
                    touchKeyboardKey.getKey().setHeight(null);
                }
                TouchKeyboardKeyControlUtil.KeyInformation keyInformation = new TouchKeyboardKeyControlUtil().new TouchKeyboardKeyControlUtil.KeyInformation();
                keyInformation.setKeyName(touchKeyboardKey.getKey().getLabel());
                keyInformation.setLayoutId(layout.getId());
                TouchKeyboardKeyControlUtil.putKeyHashControl(this.tfId.getText(), keyInformation);
                touchKeyboardKey.getKey().setDisable(this.chkDisable.isSelected());
                touchKeyboardKey.getKey().setValid(true);
                if (layout != null && layout.getKeys() != null) {
                    this.logger.debug("Atualizando layout com as modifica\u00e7\u00f5es da tecla.");
                    layout.getKeys().remove(new Key(touchKeyboardKey.getKey().getRow(), touchKeyboardKey.getKey().getColumn()));
                    layout.getKeys().add(touchKeyboardKey.getKey());
                    this.logger.debug("Layout atualizado.");
                }
            }
            this.getStageParent().hide();
        } else {
            this.logger.error("Erro na valida\u00e7\u00e3o das informa\u00e7\u00f5es da tecla: " + errorMessages);
            new AlertDialog(this.getStageParent(), errorMessages, null).showAndWait();
        }
        this.logger.debug("Finalizando tratamento do evento de modifica\u00e7\u00e3o de tecla.");
    }

    @FXML
    public void cancelKeyEdit(ActionEvent event) {
        this.getStageParent().hide();
    }

    @FXML
    public void limitAmountCharCode(KeyEvent event) {
        this.logger.debug("Iniciando tratamento de limite de tamanho. Campo: Char Code");
        if (this.tfCharCode != null && this.tfCharCode.getText() != null && this.tfCharCode.getText().length() > 0) {
            this.tfCharCode.setText(event.getText());
        }
        this.logger.debug("Finalizando tratamento de limite de tamanho. Campo: Char Code");
    }
}

