/*
 * Decompiled with CFR 0.152.
 */
package com.linx.touchkeyboard.util;

import com.linx.touchkeyboard.configuration.Key;
import com.linx.touchkeyboard.configuration.KeyboardConfiguration;
import com.linx.touchkeyboard.configuration.Layout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TouchKeyboardKeyControlUtil {
    private static Logger logger = LoggerFactory.getLogger(TouchKeyboardKeyControlUtil.class);
    private static Hashtable<String, KeyInformation> hashControlKeysId = new Hashtable();

    public static void loadHashControl(KeyboardConfiguration configuration) {
        if (configuration != null) {
            String SUFIXO = "_ADD";
            Map<String, Layout> mapLayouts = configuration.getLayouts();
            Collection<Layout> layouts = mapLayouts.values();
            if (layouts != null) {
                for (Layout layout : layouts) {
                    ArrayList<Key> keys;
                    if (layout == null || (keys = layout.getKeys()) == null) continue;
                    for (Key key : keys) {
                        TouchKeyboardKeyControlUtil touchKeyboardUtil = new TouchKeyboardKeyControlUtil();
                        KeyInformation keyInfo = touchKeyboardUtil.new KeyInformation();
                        keyInfo.setKeyName(key.getLabel());
                        keyInfo.setLayoutId(layout.getId());
                        if (!key.isDisable()) {
                            if (key.getId() == null || key.getId().trim().equalsIgnoreCase("")) {
                                key.setValid(false);
                                continue;
                            }
                            if (TouchKeyboardKeyControlUtil.existKeyHashControl(key.getId())) {
                                TouchKeyboardKeyControlUtil.putKeyHashControl(key.getId() + SUFIXO, keyInfo);
                                key.setValid(false);
                                continue;
                            }
                            TouchKeyboardKeyControlUtil.putKeyHashControl(key.getId(), keyInfo);
                            key.setValid(true);
                            continue;
                        }
                        key.setValid(true);
                    }
                }
            }
            logger.debug("Configura\u00e7\u00e3o de Layouts validada com sucesso!");
        }
    }

    public static void reLoadHashControl(KeyboardConfiguration configuration) {
        hashControlKeysId = new Hashtable();
        TouchKeyboardKeyControlUtil.loadHashControl(configuration);
    }

    public static void removeKeyHashControl(String keyId) {
        if (keyId != null && TouchKeyboardKeyControlUtil.existKeyHashControl(keyId = keyId.toUpperCase())) {
            hashControlKeysId.remove(keyId);
        }
    }

    public static void putKeyHashControl(String keyId, KeyInformation keyInformation) {
        if (keyId != null && !TouchKeyboardKeyControlUtil.existKeyHashControl(keyId = keyId.toUpperCase())) {
            hashControlKeysId.put(keyId.toUpperCase(), keyInformation);
        }
    }

    public static boolean existKeyHashControl(String keyId) {
        boolean result = false;
        if (keyId != null && hashControlKeysId != null) {
            keyId = keyId.toUpperCase();
            result = hashControlKeysId.containsKey(keyId);
        }
        return result;
    }

    public static KeyInformation getValuehashControl(String keyId) {
        KeyInformation keyInformation = null;
        if (keyId != null && TouchKeyboardKeyControlUtil.existKeyHashControl(keyId = keyId.toUpperCase())) {
            keyInformation = hashControlKeysId.get(keyId);
        }
        return keyInformation;
    }

    public class KeyInformation {
        private String layoutId;
        private String keyName;

        public String getLayoutId() {
            return this.layoutId;
        }

        public void setLayoutId(String layoutId) {
            this.layoutId = layoutId;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }
    }
}

