/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.poss;

import com.ibm.poss.Device;
import com.ibm.poss.DeviceConnection;
import com.ibm.poss.Errno;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosException;
import com.ibm.poss.PosQMsg;
import com.ibm.poss.PosScaleData;
import com.ibm.poss.PosmKbdStatusChangeListener;
import com.ibm.poss.PosmKbdWmCharListener;
import com.ibm.poss.PosmMsrDataAvailListener;
import com.ibm.poss.PosmPrnChaseCompleteListener;
import com.ibm.poss.PosmPrnDataAvailListener;
import com.ibm.poss.PosmPrnFiscalErrorListener;
import com.ibm.poss.PosmPrnFiscalStatusListener;
import com.ibm.poss.PosmPrnPrinterErrorListener;
import com.ibm.poss.PosmPrnRasStatusListener;
import com.ibm.poss.PosmPrnStatusChangeListener;
import com.ibm.poss.PosmRs232BreakDetectedListener;
import com.ibm.poss.PosmRs232DataAvailListener;
import com.ibm.poss.PosmRs232XmitAbortListener;
import com.ibm.poss.PosmRs232XmitCompleteListener;
import com.ibm.poss.PosmScanDataAvailListener;
import com.ibm.poss.PosmSysDeviceOfflineListener;
import com.ibm.poss.PosmSysDeviceOnlineListener;
import com.ibm.poss.PosmSysDeviceReleasedListener;
import com.ibm.poss.PosmTillClosedListener;
import com.ibm.poss.PosmTillOpenedListener;
import com.ibm.poss.PosmTouchDataListener;
import com.ibm.poss.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PosDevice
implements Device,
PosDef,
Errno {
    private static boolean trace = false;
    private static boolean debug = false;
    private static final boolean assert = true;
    private boolean acquired = false;
    private boolean unlocked = false;
    private Queue queue = new Queue();
    private DeviceConnection deviceConnection = null;
    private PosmKbdStatusChangeListener posmKbdStatusChangeListener = null;
    private PosmKbdWmCharListener posmKbdWmCharListener = null;
    private PosmMsrDataAvailListener posmMsrDataAvailListener = null;
    private PosmPrnChaseCompleteListener posmPrnChaseCompleteListener = null;
    private PosmPrnDataAvailListener posmPrnDataAvailListener = null;
    private PosmPrnFiscalErrorListener posmPrnFiscalErrorListener = null;
    private PosmPrnFiscalStatusListener posmPrnFiscalStatusListener = null;
    private PosmPrnPrinterErrorListener posmPrnPrinterErrorListener = null;
    private PosmPrnStatusChangeListener posmPrnStatusChangeListener = null;
    private PosmRs232BreakDetectedListener posmRs232BreakDetectedListener = null;
    private PosmRs232DataAvailListener posmRs232DataAvailListener = null;
    private PosmRs232XmitAbortListener posmRs232XmitAbortListener = null;
    private PosmRs232XmitCompleteListener posmRs232XmitCompleteListener = null;
    private PosmScanDataAvailListener posmScanDataAvailListener = null;
    private PosmSysDeviceOfflineListener posmSysDeviceOfflineListener = null;
    private PosmSysDeviceOnlineListener posmSysDeviceOnlineListener = null;
    private PosmSysDeviceReleasedListener posmSysDeviceReleasedListener = null;
    private PosmTillClosedListener posmTillClosedListener = null;
    private PosmTillOpenedListener posmTillOpenedListener = null;
    private PosmTouchDataListener posmTouchDataListener = null;
    private PosmPrnRasStatusListener posmPrnRasStatusListener;

    void setAcquired(boolean bl) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setAcquired");
        }
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setAcquired");
        }
        this.acquired = bl;
    }

    void setUnlocked(boolean bl) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setUnlocked");
        }
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setUnlocked");
        }
        this.unlocked = bl;
    }

    void deviceEventOccurred(PosQMsg posQMsg) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.deviceEventOccured");
        }
        this.queue.write(posQMsg);
        if (trace) {
            System.err.println("<-- Exit : PosDevice.deviceEventOccurred");
        }
    }

    public int getCodePage() throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosDevice.getCodePage");
        }
        if (this.deviceConnection == null) {
            throw new PosException(303, "PosIOCtl == -1, errno == 303");
        }
        if (trace) {
            System.err.println("<-- Exit : PosDevice.getCodePage");
        }
        return this.deviceConnection.getCodePage();
    }

    public int getDefaultCodePage() throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosDevice.getDefaultCodePage");
        }
        if (this.deviceConnection == null) {
            throw new PosException(303, "PosIOCtl == -1, errno == 303");
        }
        if (trace) {
            System.err.println("<-- Exit : PosDevice.getDefaultCodePage");
        }
        return this.deviceConnection.getDefaultCodePage();
    }

    public void setCodePage(int n) throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setCodePage");
        }
        if (this.deviceConnection == null) {
            throw new PosException(303, "PosIOCtl == -1, errno == 303");
        }
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setCodePage");
        }
        this.deviceConnection.setCodePage(n);
    }

    public boolean isOpened() {
        if (trace) {
            System.err.println("--> Entry: PosDevice.isOpened");
        }
        if (trace) {
            System.err.println("<-- Exit : PosDevice.isOpened");
        }
        return this.deviceConnection != null;
    }

    public boolean isAcquired() {
        if (trace) {
            System.err.println("--> Entry: PosDevice.isAcquired");
        }
        if (trace) {
            System.err.println("<-- Exit : PosDevice.isAcquired");
        }
        return this.acquired;
    }

    public boolean isUnlocked() {
        if (trace) {
            System.err.println("--> Entry: PosDevice.isUnlocked");
        }
        if (trace) {
            System.err.println("<-- Exit : PosDevice.isUnlocked");
        }
        return this.unlocked;
    }

    public synchronized void close() throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosDevice.close");
        }
        if (this.deviceConnection == null) {
            throw new PosException(303, "PosClose == -1, errno == 303");
        }
        this.deviceConnection.close(this);
        this.deviceConnection = null;
        byte[] byArray = new byte[16];
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        this.queue.clear();
        this.queue.write(new PosQMsg(byArray));
        if (trace) {
            System.err.println("<-- Exit : PosDevice.close");
        }
    }

    public synchronized void ioctl(int n) throws PosException {
        this.ioctl(n, null, 0);
    }

    public synchronized void ioctl(int n, PosArg[] posArgArray) throws PosException {
        this.ioctl(n, posArgArray, posArgArray.length);
    }

    public synchronized void ioctl(int n, PosArg[] posArgArray, int n2) throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosDevice.ioctl");
        }
        if (this.deviceConnection == null) {
            throw new PosException(303, "PosIOCtl == -1, errno == 303");
        }
        this.deviceConnection.ioctl(this, n, posArgArray, n2);
        if (trace) {
            System.err.println("<-- Exit : PosDevice.ioctl");
        }
    }

    public synchronized void open(String string, String string2, PosArg[] posArgArray) throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosDevice.open");
        }
        if (this.deviceConnection != null) {
            this.close();
        }
        this.deviceConnection = DeviceConnection.open(this, string, string2, posArgArray);
        new QueueReader().start();
        if (trace) {
            System.err.println("<-- Exit : PosDevice.open");
        }
    }

    public synchronized int read(byte[] byArray) throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosDevice.read");
        }
        if (this.deviceConnection == null) {
            throw new PosException(303, "PosRead == -1, errno == 303");
        }
        int n = this.deviceConnection.read(this, byArray);
        if (trace) {
            System.err.println("<-- Exit : PosDevice.read");
        }
        return n;
    }

    public synchronized int read(PosScaleData posScaleData) throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosDevice.read");
        }
        if (this.deviceConnection == null) {
            throw new PosException(303, "PosRead == -1, errno == 303");
        }
        int n = this.deviceConnection.read(this, posScaleData);
        if (trace) {
            System.err.println("<-- Exit : PosDevice.read");
        }
        return n;
    }

    public synchronized int write(byte[] byArray) throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosDevice.write");
        }
        if (this.deviceConnection == null) {
            throw new PosException(303, "PosWrite == -1, errno == 303");
        }
        int n = this.deviceConnection.write(this, byArray, byArray.length);
        if (trace) {
            System.err.println("<-- Exit : PosDevice.write");
        }
        return n;
    }

    public synchronized int write(byte[] byArray, int n) throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosDevice.write");
        }
        if (this.deviceConnection == null) {
            throw new PosException(303, "PosWrite == -1, errno == 303");
        }
        int n2 = this.deviceConnection.write(this, byArray, n);
        if (trace) {
            System.err.println("<-- Exit : PosDevice.write");
        }
        return n2;
    }

    public synchronized int write(String string) throws PosException {
        if (trace) {
            System.err.println("--> Entry: PosDevice.write");
        }
        if (this.deviceConnection == null) {
            throw new PosException(303, "PosWrite == -1, errno == 303");
        }
        int n = this.deviceConnection.write(this, string);
        if (trace) {
            System.err.println("<-- Exit : PosDevice.write");
        }
        return n;
    }

    public void setPosmKbdStatusChangeListener(PosmKbdStatusChangeListener posmKbdStatusChangeListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmKbdStatusChangeListener");
        }
        this.posmKbdStatusChangeListener = posmKbdStatusChangeListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmKbdStatusChangeListener");
        }
    }

    public void setPosmKbdWmCharListener(PosmKbdWmCharListener posmKbdWmCharListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmKbdWmCharListener");
        }
        this.posmKbdWmCharListener = posmKbdWmCharListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmKbdWmCharListener");
        }
    }

    public void setPosmMsrDataAvailListener(PosmMsrDataAvailListener posmMsrDataAvailListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmMsrDataAvailListener");
        }
        this.posmMsrDataAvailListener = posmMsrDataAvailListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmMsrDataAvailListener");
        }
    }

    public void setPosmPrnChaseCompleteListener(PosmPrnChaseCompleteListener posmPrnChaseCompleteListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmPrnChaseCompleteListener");
        }
        this.posmPrnChaseCompleteListener = posmPrnChaseCompleteListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmPrnChaseCompleteListener");
        }
    }

    public void setPosmPrnDataAvailListener(PosmPrnDataAvailListener posmPrnDataAvailListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmPrnDataAvailListener");
        }
        this.posmPrnDataAvailListener = posmPrnDataAvailListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmPrnDataAvailListener");
        }
    }

    public void setPosmPrnFiscalErrorListener(PosmPrnFiscalErrorListener posmPrnFiscalErrorListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmPrnFiscalErrorListener");
        }
        this.posmPrnFiscalErrorListener = posmPrnFiscalErrorListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmPrnFiscalErrorListener");
        }
    }

    public void setPosmPrnFiscalStatusListener(PosmPrnFiscalStatusListener posmPrnFiscalStatusListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmPrnFiscalStatusListener");
        }
        this.posmPrnFiscalStatusListener = posmPrnFiscalStatusListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmPrnFiscalStatusListener");
        }
    }

    public void setPosmPrnPrinterErrorListener(PosmPrnPrinterErrorListener posmPrnPrinterErrorListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmPrnPrinterErrorListener");
        }
        this.posmPrnPrinterErrorListener = posmPrnPrinterErrorListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmPrnPrinterErrorListener");
        }
    }

    public void setPosmPrnStatusChangeListener(PosmPrnStatusChangeListener posmPrnStatusChangeListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmPrnStatusChangeListener");
        }
        this.posmPrnStatusChangeListener = posmPrnStatusChangeListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmPrnStatusChangeListener");
        }
    }

    public void setPosmRs232BreakDetectedListener(PosmRs232BreakDetectedListener posmRs232BreakDetectedListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmRs232BreakDetectedListener");
        }
        this.posmRs232BreakDetectedListener = posmRs232BreakDetectedListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmRs232BreakDetectedListener");
        }
    }

    public void setPosmRs232DataAvailListener(PosmRs232DataAvailListener posmRs232DataAvailListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmRs232DataAvailListener");
        }
        this.posmRs232DataAvailListener = posmRs232DataAvailListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmRs232DataAvailListener");
        }
    }

    public void setPosmRs232XmitAbortListener(PosmRs232XmitAbortListener posmRs232XmitAbortListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmRs232XmitAbortListener");
        }
        this.posmRs232XmitAbortListener = posmRs232XmitAbortListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmRs232XmitAbortListener");
        }
    }

    public void setPosmRs232XmitCompleteListener(PosmRs232XmitCompleteListener posmRs232XmitCompleteListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmRs232XmitCompleteListener");
        }
        this.posmRs232XmitCompleteListener = posmRs232XmitCompleteListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmRs232XmitCompleteListener");
        }
    }

    public void setPosmScanDataAvailListener(PosmScanDataAvailListener posmScanDataAvailListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmScanDataAvailListener");
        }
        this.posmScanDataAvailListener = posmScanDataAvailListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmScanDataAvailListener");
        }
    }

    public void setPosmSysDeviceOfflineListener(PosmSysDeviceOfflineListener posmSysDeviceOfflineListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmSysDeviceOfflineListener");
        }
        this.posmSysDeviceOfflineListener = posmSysDeviceOfflineListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmSysDeviceOfflineListener");
        }
    }

    public void setPosmSysDeviceOnlineListener(PosmSysDeviceOnlineListener posmSysDeviceOnlineListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmSysDeviceOnlineListener");
        }
        this.posmSysDeviceOnlineListener = posmSysDeviceOnlineListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmSysDeviceOnlineListener");
        }
    }

    public void setPosmSysDeviceReleasedListener(PosmSysDeviceReleasedListener posmSysDeviceReleasedListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmSysDeviceReleasedListener");
        }
        this.posmSysDeviceReleasedListener = posmSysDeviceReleasedListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmSysDeviceReleasedListener");
        }
    }

    public void setPosmTillClosedListener(PosmTillClosedListener posmTillClosedListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmTillClosedListener");
        }
        this.posmTillClosedListener = posmTillClosedListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmTillClosedListener");
        }
    }

    public void setPosmTillOpenedListener(PosmTillOpenedListener posmTillOpenedListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmTillOpenedListener");
        }
        this.posmTillOpenedListener = posmTillOpenedListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmTillOpenedListener");
        }
    }

    public void setPosmTouchDataListener(PosmTouchDataListener posmTouchDataListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmTouchDataListener");
        }
        this.posmTouchDataListener = posmTouchDataListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmTouchDataListener");
        }
    }

    public void setPosmPrnRasStatusListener(PosmPrnRasStatusListener posmPrnRasStatusListener) {
        if (trace) {
            System.err.println("--> Entry: PosDevice.setPosmPrnRasStatusListener");
        }
        this.posmPrnRasStatusListener = posmPrnRasStatusListener;
        if (trace) {
            System.err.println("<-- Exit : PosDevice.setPosmPrnRasStatusListener");
        }
    }

    static {
        if (!System.getProperty("TracePosSubsystem", "false").equals("false")) {
            trace = true;
        }
        if (!System.getProperty("DebugPosSubsystem", "false").equals("false")) {
            debug = true;
            trace = true;
        }
        if (trace) {
            System.err.println("--> Entry: PosDevice.static");
        }
        try {
            Class.forName("com.ibm.poss.PosSubsystem");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (trace) {
            System.err.println("<-- Exit : PosDevice.static");
        }
    }

    private class QueueReader
    extends Thread {
        private QueueReader() {
        }

        public void run() {
            if (trace) {
                System.err.println("--> Entry: PosDevice$QueueReader.run");
            }
            PosQMsg posQMsg = null;
            while (true) {
                posQMsg = (PosQMsg)PosDevice.this.queue.read();
                if (trace) {
                    System.err.println("\tPosDevice$QueueReader: PosQMsg available");
                }
                switch (posQMsg.getMsg()) {
                    case 16897: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_KBD_STATUS_CHANGE");
                        }
                        try {
                            PosDevice.this.posmKbdStatusChangeListener.posmKbdStatusChange(posQMsg.getMp1TopShort(), posQMsg.getMp2());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16898: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_KBD_WM_CHAR");
                        }
                        if (!PosDevice.this.unlocked) break;
                        try {
                            PosDevice.this.posmKbdWmCharListener.posmKbdWmChar(posQMsg.getMp1TopShort(), posQMsg.getMp2TopShort(), posQMsg.getMp2BottomByte());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16899: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_MSR_DATA_AVAIL");
                        }
                        try {
                            PosDevice.this.posmMsrDataAvailListener.posmMsrDataAvail(posQMsg.getMp2BottomShort());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16900: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_PRN_CHASE_COMPLETE");
                        }
                        try {
                            PosDevice.this.posmPrnChaseCompleteListener.posmPrnChaseComplete(posQMsg.getMp1TopShort(), posQMsg.getMp2());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16912: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_PRN_DATA_AVAIL");
                        }
                        try {
                            PosDevice.this.posmPrnDataAvailListener.posmPrnDataAvail(posQMsg.getMp1TopShort(), posQMsg.getMp2BottomShort());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16913: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_PRN_FISCAL_ERROR");
                        }
                        try {
                            PosDevice.this.posmPrnFiscalErrorListener.posmPrnFiscalError(posQMsg.getMp1TopShort(), posQMsg.getMp2());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16914: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_PRN_FISCAL_STATUS");
                        }
                        try {
                            PosDevice.this.posmPrnFiscalStatusListener.posmPrnFiscalStatus(posQMsg.getMp2());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16901: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_PRN_PRINTER_ERROR");
                        }
                        try {
                            PosDevice.this.posmPrnPrinterErrorListener.posmPrnPrinterError(posQMsg.getMp1TopShort(), posQMsg.getMp2());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16902: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_PRN_STATUS_CHANGE");
                        }
                        try {
                            PosDevice.this.posmPrnStatusChangeListener.posmPrnStatusChange(posQMsg.getMp1TopShort(), posQMsg.getMp2());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16903: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_RS232_BREAK_DETECTED");
                        }
                        try {
                            PosDevice.this.posmRs232BreakDetectedListener.posmRs232BreakDetected();
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16904: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_RS232_DATA_AVAIL");
                        }
                        try {
                            PosDevice.this.posmRs232DataAvailListener.posmRs232DataAvail(posQMsg.getMp2BottomShort());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16905: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_RS232_XMIT_ABORT");
                        }
                        try {
                            PosDevice.this.posmRs232XmitAbortListener.posmRs232XmitAbort();
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16906: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_RS232_XMIT_COMPLETE");
                        }
                        try {
                            PosDevice.this.posmRs232XmitCompleteListener.posmRs232XmitComplete();
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16907: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_SCAN_DATA_AVAIL");
                        }
                        try {
                            PosDevice.this.posmScanDataAvailListener.posmScanDataAvail(posQMsg.getMp2BottomShort());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16908: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_SYS_DEVICE_OFFLINE");
                        }
                        try {
                            PosDevice.this.posmSysDeviceOfflineListener.posmSysDeviceOffline(posQMsg.getMp1BottomByte(), posQMsg.getMp2BottomByte());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16909: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_SYS_DEVICE_ONLINE");
                        }
                        try {
                            PosDevice.this.posmSysDeviceOnlineListener.posmSysDeviceOnline(posQMsg.getMp1BottomByte(), posQMsg.getMp2BottomByte());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16915: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_SYS_DEVICE_RELEASED");
                        }
                        try {
                            PosDevice.this.posmSysDeviceReleasedListener.posmSysDeviceReleased();
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16910: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_TILL_CLOSED");
                        }
                        try {
                            PosDevice.this.posmTillClosedListener.posmTillClosed();
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16911: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_TILL_OPENED");
                        }
                        try {
                            PosDevice.this.posmTillOpenedListener.posmTillOpened();
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16918: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_TOUCH_DATA");
                        }
                        try {
                            PosDevice.this.posmTouchDataListener.posmTouchData(posQMsg.getMp1TopShort(), posQMsg.getMp2TopShort(), posQMsg.getMp2BottomShort());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 16916: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: processing POSM_PRN_RAS_STATUS");
                        }
                        try {
                            PosDevice.this.posmPrnRasStatusListener.posmPrnRasStatusData(posQMsg.getMp1());
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case -1: {
                        if (trace) {
                            System.err.println("\tPosDevice$QueueReader: ate a poison cookie");
                        }
                        if (trace) {
                            System.err.println("<-- Exit : PosDevice$QueueReader.run");
                        }
                        return;
                    }
                    default: {
                        if (!trace) break;
                        System.err.println("\tPosDevice$QueueReader: processing unknown PosQMsg type");
                    }
                }
                if (!trace) continue;
                System.err.println("\tPosDevice$QueueReader: processing complete");
            }
        }
    }
}

