/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.ibmprinter;

import com.ibm.jpos.services.EventQueueManager;
import com.ibm.jpos.services.ibmprinter.BeginInsertionData;
import com.ibm.jpos.services.ibmprinter.BeginRemovalData;
import com.ibm.jpos.services.ibmprinter.CutPaperData;
import com.ibm.jpos.services.ibmprinter.DirectIOData;
import com.ibm.jpos.services.ibmprinter.EndInsertionData;
import com.ibm.jpos.services.ibmprinter.EndRemovalData;
import com.ibm.jpos.services.ibmprinter.PrintBarCodeData;
import com.ibm.jpos.services.ibmprinter.PrintBitmapData;
import com.ibm.jpos.services.ibmprinter.PrintImmediateData;
import com.ibm.jpos.services.ibmprinter.PrintNormalData;
import com.ibm.jpos.services.ibmprinter.PrintNormalDataVector;
import com.ibm.jpos.services.ibmprinter.PrintQueueData;
import com.ibm.jpos.services.ibmprinter.PrintQueueElement;
import com.ibm.jpos.services.ibmprinter.PrintQueueManagerCallback;
import com.ibm.jpos.services.ibmprinter.PrintQueueManagerServiceState;
import com.ibm.jpos.services.ibmprinter.PrintTwoNormalData;
import com.ibm.jpos.services.ibmprinter.RotatePrintData;
import com.ibm.jpos.services.ibmprinter.SetBitmapData;
import com.ibm.jpos.services.ibmprinter.SetCharacterSetData;
import com.ibm.jpos.services.ibmprinter.SetLogoData;
import com.ibm.jpos.services.ibmprinter.TransactionPrintData;
import com.ibm.jpos.services.ibmprinter.ValidateDataData;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.Tracer;
import java.util.Enumeration;
import java.util.Vector;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSPrinterConst;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;

public class PrintQueueManager
implements JposConst,
POSPrinterConst {
    private PrintQueueManagerServiceState serviceState;
    private EventQueueManager eventQueueManager;
    private Object eventSource;
    private PrintQueueManagerCallback serviceCallback;
    private PrintQueue printQueue = new PrintQueue();
    private PrintQueueReader printQueueReader = new PrintQueueReader();
    private SidewaysPrintContainer[] sidewaysPrintContainer = new SidewaysPrintContainer[]{null, null, null, null, null};
    private TransactionPrintContainer[] transactionPrintContainer = new TransactionPrintContainer[]{null, null, null, null, null};
    private int[] postingRotation = new int[]{1, 1, 1, 1, 1};
    private boolean bRotateInTransaction;
    private static final String className = "PrintQueueManager";
    private static final int TL_OFF = 0;
    private static final int TL_WARNING = 1;
    private static final int TL_METHOD = 2;
    private static final int TL_DETAIL = 3;
    private static final int TL_DEBUG = 4;
    private static final int TL_MAX = 4;

    public PrintQueueManager(PrintQueueManagerServiceState printQueueManagerServiceState, EventQueueManager eventQueueManager, Object object, PrintQueueManagerCallback printQueueManagerCallback) {
        this.serviceState = printQueueManagerServiceState;
        this.eventQueueManager = eventQueueManager;
        this.eventSource = object;
        this.serviceCallback = printQueueManagerCallback;
        this.printQueueReader.setName("IBMPrintQueueManager");
        this.printQueueReader.start();
        this.bRotateInTransaction = false;
    }

    public synchronized void clearOutput() throws JposException {
        this.printQueue.clear();
        int n = 0;
        while (n < this.transactionPrintContainer.length) {
            this.transactionPrintContainer[n] = null;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.sidewaysPrintContainer.length) {
            this.sidewaysPrintContainer[n2] = null;
            ++n2;
        }
        this.bRotateInTransaction = false;
        this.serviceState.setErrorLevel(1);
        this.serviceState.setErrorString("");
        this.serviceState.setState(2);
        if (this.serviceState.getFlagWhenIdle()) {
            this.serviceState.setFlagWhenIdle(false);
            this.eventQueueManager.postEvent((JposEvent)new StatusUpdateEvent(this.eventSource, 1001));
        }
    }

    public boolean isSidewaysMode(int n) {
        return this.sidewaysPrintContainer[n] != null;
    }

    public int getSidewaysModeRotation(int n) {
        if (this.sidewaysPrintContainer[n] != null) {
            return ((RotatePrintData)this.sidewaysPrintContainer[n].getEntryData()).getRotation();
        }
        return 1;
    }

    public int getPostingRotation(int n) {
        return this.postingRotation[n];
    }

    public synchronized void post(BeginInsertionData beginInsertionData) throws JposException {
        this.printQueue.post(beginInsertionData);
    }

    public synchronized void post(BeginRemovalData beginRemovalData) throws JposException {
        if (this.transactionPrintContainer[4] != null) {
            throw new JposException(113, "JPOS_E_BUSY: In transaction mode.");
        }
        if (this.sidewaysPrintContainer[4] != null) {
            throw new JposException(113, "JPOS_E_BUSY: In sideway mode.");
        }
        this.printQueue.post(beginRemovalData);
    }

    public synchronized void post(CutPaperData cutPaperData) throws JposException {
        if (this.transactionPrintContainer[2] != null) {
            this.transactionPrintContainer[2].addElement(cutPaperData);
        } else {
            this.printQueue.post(cutPaperData);
        }
    }

    public synchronized void post(DirectIOData directIOData) throws JposException {
        this.printQueue.post(directIOData);
    }

    public synchronized void post(EndInsertionData endInsertionData) throws JposException {
        this.printQueue.post(endInsertionData);
    }

    public synchronized void post(EndRemovalData endRemovalData) throws JposException {
        this.printQueue.post(endRemovalData);
    }

    public synchronized void post(PrintBarCodeData printBarCodeData) throws JposException {
        if (this.transactionPrintContainer[printBarCodeData.getStation()] != null) {
            this.transactionPrintContainer[printBarCodeData.getStation()].addElement(printBarCodeData);
        } else {
            this.printQueue.post(printBarCodeData);
        }
    }

    public synchronized void post(PrintBitmapData printBitmapData) throws JposException {
        if (this.transactionPrintContainer[printBitmapData.getStation()] != null) {
            this.transactionPrintContainer[printBitmapData.getStation()].addElement(printBitmapData);
        } else {
            this.printQueue.post(printBitmapData);
        }
    }

    public synchronized void post(PrintImmediateData printImmediateData) throws JposException {
        PrintQueueManager.trace(2, "post(PrintImmediateData)", "Entry");
        this.processPrintQueueElement(printImmediateData);
        if (printImmediateData.getJposException() != null) {
            throw printImmediateData.getJposException();
        }
        PrintQueueManager.trace(2, "post(PrintImmediateData)", "Exit");
    }

    public synchronized void post(PrintNormalData printNormalData) throws JposException {
        PrintQueueManager.trace(2, "post(PrintNormalData)", "Entry");
        if (this.sidewaysPrintContainer[printNormalData.getStation()] != null) {
            if (printNormalData.hasReversedLines()) {
                this.sidewaysPrintContainer[printNormalData.getStation()].insertElementAt(printNormalData, 0);
            } else {
                this.sidewaysPrintContainer[printNormalData.getStation()].addElement(printNormalData);
            }
        } else if (this.transactionPrintContainer[printNormalData.getStation()] != null) {
            if (printNormalData.hasReversedLines()) {
                this.transactionPrintContainer[printNormalData.getStation()].insertElementAt(printNormalData, 0);
            } else {
                this.transactionPrintContainer[printNormalData.getStation()].addElement(printNormalData);
            }
        } else {
            this.printQueue.post(printNormalData);
        }
        PrintQueueManager.trace(2, "post(PrintNormalData)", "Exit");
    }

    public synchronized void post(PrintTwoNormalData printTwoNormalData) throws JposException {
        int n;
        int n2;
        switch (printTwoNormalData.getStations()) {
            case 5: 
            case 32773: {
                n2 = 4;
                n = 1;
                break;
            }
            case 6: 
            case 32774: {
                n2 = 4;
                n = 2;
                break;
            }
            case 3: 
            case 32771: {
                n2 = 2;
                n = 1;
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
        if (this.getPostingRotation(n2) != 1 || this.getPostingRotation(n) != 1) {
            throw new JposException(106);
        }
        this.printQueue.post(printTwoNormalData);
    }

    public synchronized void post(RotatePrintData rotatePrintData) throws JposException {
        this.postingRotation[rotatePrintData.getStation()] = rotatePrintData.getRotation();
        switch (rotatePrintData.getRotation()) {
            case 257: 
            case 258: {
                if (this.sidewaysPrintContainer[rotatePrintData.getStation()] == null) {
                    if (this.transactionPrintContainer[rotatePrintData.getStation()] == null) {
                        this.sidewaysPrintContainer[rotatePrintData.getStation()] = new SidewaysPrintContainer(rotatePrintData);
                        PrintQueueManager.trace(2, "post(RotatePrintData)", "add element to sidewaysPrintContainer");
                        break;
                    }
                    this.transactionPrintContainer[rotatePrintData.getStation()].addElement(rotatePrintData);
                    this.bRotateInTransaction = true;
                    PrintQueueManager.trace(2, "post(RotatePrintData)", "add element to transactionPrintContainer");
                    break;
                }
                throw new JposException(106, "JPOS_E_ILLEGAL: Already in sideways mode.");
            }
            case 259: {
                if (this.transactionPrintContainer[rotatePrintData.getStation()] != null) {
                    this.transactionPrintContainer[rotatePrintData.getStation()].addElement(rotatePrintData);
                    break;
                }
                this.printQueue.post(rotatePrintData);
                break;
            }
            case 1: {
                if (this.sidewaysPrintContainer[rotatePrintData.getStation()] != null) {
                    SidewaysPrintContainer sidewaysPrintContainer = this.sidewaysPrintContainer[rotatePrintData.getStation()];
                    this.sidewaysPrintContainer[rotatePrintData.getStation()] = null;
                    sidewaysPrintContainer.setExitData(rotatePrintData);
                    this.printQueue.post(sidewaysPrintContainer);
                    PrintQueueManager.trace(2, "post(RotatePrintData)", "end of sideways mode - A");
                    break;
                }
                if (this.transactionPrintContainer[rotatePrintData.getStation()] != null) {
                    this.transactionPrintContainer[rotatePrintData.getStation()].addElement(rotatePrintData);
                    this.bRotateInTransaction = false;
                    PrintQueueManager.trace(2, "post(RotatePrintData)", "end of sideways print in transaction mode");
                    break;
                }
                this.printQueue.post(rotatePrintData);
                PrintQueueManager.trace(2, "post(RotatePrintData)", "end of sideways mode - B");
                break;
            }
            default: {
                throw new JposException(106, "JPOS_E_ILLEGAL: Unknown rotation value.");
            }
        }
    }

    public synchronized void post(SetBitmapData setBitmapData) throws JposException {
        this.printQueue.post(setBitmapData);
    }

    public synchronized void post(SetCharacterSetData setCharacterSetData) throws JposException {
        this.printQueue.post(setCharacterSetData);
    }

    public synchronized void post(SetLogoData setLogoData) throws JposException {
        this.printQueue.post(setLogoData);
    }

    public synchronized void post(TransactionPrintData transactionPrintData) throws JposException {
        switch (transactionPrintData.getControl()) {
            case 11: {
                if (this.transactionPrintContainer[transactionPrintData.getStation()] == null) {
                    if (this.sidewaysPrintContainer[transactionPrintData.getStation()] == null) {
                        this.transactionPrintContainer[transactionPrintData.getStation()] = new TransactionPrintContainer(transactionPrintData);
                        break;
                    }
                    throw new JposException(106, "JPOS_E_ILLEGAL: Transaction mode and sideways mode are mutually exclusive.");
                }
                throw new JposException(106, "JPOS_E_ILLEGAL: Already in transaction mode.");
            }
            case 12: {
                if (this.bRotateInTransaction) {
                    throw new JposException(106, "JPOS_E_ILLEGAL: Sideways mode is not end yet.");
                }
                if (this.transactionPrintContainer[transactionPrintData.getStation()] == null) break;
                TransactionPrintContainer transactionPrintContainer = this.transactionPrintContainer[transactionPrintData.getStation()];
                this.transactionPrintContainer[transactionPrintData.getStation()] = null;
                transactionPrintContainer.setExitData(transactionPrintData);
                this.printQueue.post(transactionPrintContainer);
                break;
            }
            default: {
                throw new JposException(106, "JPOS_E_ILLEGAL: Unknown control value.");
            }
        }
    }

    public synchronized void post(ValidateDataData validateDataData) throws JposException {
        this.printQueue.post(validateDataData);
    }

    public synchronized void shutdown() {
        this.printQueue.clear();
        try {
            this.printQueue.send(new Cyanide());
        }
        catch (JposException jposException) {
            // empty catch block
        }
        this.printQueue = null;
    }

    void processTransactionPrintContainer(TransactionPrintContainer transactionPrintContainer) throws JposException {
        try {
            this.serviceCallback.processTransactionPrint((TransactionPrintData)transactionPrintContainer.getEntryData());
        }
        catch (JposException jposException) {
            transactionPrintContainer.setErrorLevel(transactionPrintContainer.getEntryData().getErrorLevel());
            throw jposException;
        }
        Enumeration enumeration = transactionPrintContainer.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            try {
                if (e instanceof CutPaperData) {
                    this.serviceCallback.processCutPaper((CutPaperData)e);
                    continue;
                }
                if (e instanceof PrintBarCodeData) {
                    this.serviceCallback.processPrintBarCode((PrintBarCodeData)e);
                    continue;
                }
                if (e instanceof PrintBitmapData) {
                    this.serviceCallback.processPrintBitmap((PrintBitmapData)e);
                    continue;
                }
                if (e instanceof PrintNormalData) {
                    this.serviceCallback.processPrintNormal((PrintNormalData)e);
                    continue;
                }
                if (e instanceof PrintNormalDataVector) {
                    this.serviceCallback.processPrintNormalDataVector((PrintNormalDataVector)e);
                    continue;
                }
                if (e instanceof RotatePrintData) {
                    this.serviceCallback.processRotatePrint((RotatePrintData)e);
                    continue;
                }
                System.err.println("Internal Error: PrintQueueManager.processTransactionPrintContainer(): Unexpected type : " + e.getClass().getName());
            }
            catch (JposException jposException) {
                PrintNormalDataVector printNormalDataVector;
                int n = 0;
                if (e instanceof PrintQueueElement) {
                    n = ((PrintQueueElement)e).getErrorLevel();
                } else if (e instanceof PrintNormalDataVector && !(printNormalDataVector = (PrintNormalDataVector)e).isEmpty()) {
                    PrintQueueElement printQueueElement = (PrintQueueElement)printNormalDataVector.elementAt(0);
                    n = printQueueElement.getErrorLevel();
                }
                transactionPrintContainer.setErrorLevel(n);
                throw jposException;
            }
        }
        try {
            this.serviceCallback.processTransactionPrint((TransactionPrintData)transactionPrintContainer.getExitData());
        }
        catch (JposException jposException) {
            transactionPrintContainer.setErrorLevel(transactionPrintContainer.getExitData().getErrorLevel());
            throw jposException;
        }
    }

    void processSidewaysPrintContainer(SidewaysPrintContainer sidewaysPrintContainer) throws JposException {
        try {
            this.serviceCallback.processRotatePrint((RotatePrintData)sidewaysPrintContainer.getEntryData());
        }
        catch (JposException jposException) {
            sidewaysPrintContainer.setErrorLevel(sidewaysPrintContainer.getEntryData().getErrorLevel());
            throw jposException;
        }
        Enumeration enumeration = sidewaysPrintContainer.elements();
        while (enumeration.hasMoreElements()) {
            PrintQueueElement printQueueElement = (PrintQueueElement)enumeration.nextElement();
            try {
                if (printQueueElement instanceof PrintNormalData) {
                    this.serviceCallback.processPrintNormal((PrintNormalData)printQueueElement);
                    continue;
                }
                System.err.println("Internal Error: PrintQueueManager.processSidewaysPrintContainer(): Unexpected type: " + printQueueElement.getClass().getName());
            }
            catch (JposException jposException) {
                sidewaysPrintContainer.setErrorLevel(printQueueElement.getErrorLevel());
                throw jposException;
            }
        }
        try {
            this.serviceCallback.processRotatePrint((RotatePrintData)sidewaysPrintContainer.getExitData());
        }
        catch (JposException jposException) {
            sidewaysPrintContainer.setErrorLevel(sidewaysPrintContainer.getExitData().getErrorLevel());
            throw jposException;
        }
    }

    void processPrintQueueElement(PrintQueueElement printQueueElement) {
        PrintQueueManager.trace(2, "processPrintQueueElement()", "Entry");
        while (true) {
            try {
                if (printQueueElement instanceof BeginInsertionData) {
                    this.serviceCallback.processBeginInsertion((BeginInsertionData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof BeginRemovalData) {
                    this.serviceCallback.processBeginRemoval((BeginRemovalData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof CutPaperData) {
                    this.serviceCallback.processCutPaper((CutPaperData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof DirectIOData) {
                    this.serviceCallback.processDirectIO((DirectIOData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof EndInsertionData) {
                    this.serviceCallback.processEndInsertion((EndInsertionData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof EndRemovalData) {
                    this.serviceCallback.processEndRemoval((EndRemovalData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof PrintBarCodeData) {
                    this.serviceCallback.processPrintBarCode((PrintBarCodeData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof SetBitmapData) {
                    this.serviceCallback.processSetBitmap((SetBitmapData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof SetCharacterSetData) {
                    this.serviceCallback.processSetCharacterSet((SetCharacterSetData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof PrintBitmapData) {
                    this.serviceCallback.processPrintBitmap((PrintBitmapData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof PrintImmediateData) {
                    this.serviceCallback.processPrintImmediate((PrintImmediateData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof PrintNormalData) {
                    this.serviceCallback.processPrintNormal((PrintNormalData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof PrintTwoNormalData) {
                    this.serviceCallback.processPrintTwoNormal((PrintTwoNormalData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof RotatePrintData) {
                    this.serviceCallback.processRotatePrint((RotatePrintData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof SetLogoData) {
                    this.serviceCallback.processSetLogo((SetLogoData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof TransactionPrintContainer) {
                    this.processTransactionPrintContainer((TransactionPrintContainer)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof ValidateDataData) {
                    this.serviceCallback.processValidateData((ValidateDataData)printQueueElement);
                    break;
                }
                if (printQueueElement instanceof SidewaysPrintContainer) {
                    this.processSidewaysPrintContainer((SidewaysPrintContainer)printQueueElement);
                    break;
                }
                System.err.println("Internal Error: PrintQueueManager.processPrintQueueElementUnexpected type: " + printQueueElement.getClass().getName());
            }
            catch (Exception exception) {
                PrintQueueManager.trace(2, "processPrintQueueElement()", "Caught an exception");
                JposException jposException = exception instanceof JposException ? (JposException)((Object)exception) : new JposException(111, "JPOS_E_FAILURE: Unexpected Exception.", exception);
                printQueueElement.setJposException(jposException);
                if (!printQueueElement.isAsyncMode() || this.serviceState.getState() == 2 || printQueueElement instanceof PrintImmediateData) break;
                ErrorEvent errorEvent = new ErrorEvent(this.eventSource, jposException.getErrorCode(), jposException.getErrorCodeExtended(), 1, 11);
                int n = 2;
                if (printQueueElement instanceof PrintQueueData) {
                    n = ((PrintQueueData)printQueueElement).getStation();
                } else if (printQueueElement instanceof PrintQueueDataContainer) {
                    n = ((PrintQueueDataContainer)printQueueElement).getExitData().getStation();
                }
                POSPrinterErrorEventContainer pOSPrinterErrorEventContainer = new POSPrinterErrorEventContainer(errorEvent, this.serviceState, printQueueElement.getErrorLevel(), n, jposException.getMessage());
                this.eventQueueManager.postEvent((JposEventContainer)pOSPrinterErrorEventContainer);
                pOSPrinterErrorEventContainer.waitUntilDoneFiring();
                try {
                    this.serviceState.setErrorLevel(1);
                    this.serviceState.setErrorString("");
                }
                catch (JposException jposException2) {
                    System.err.println("PrintQueueManager.processPrintQueueElement(): Internal Error: Exception setting ErrorLevel or ErrorString property");
                }
                if (errorEvent.getErrorResponse() == 12) {
                    try {
                        this.clearOutput();
                    }
                    catch (JposException jposException3) {
                        // empty catch block
                    }
                    return;
                }
                printQueueElement.setErrorLevel(2);
                printQueueElement.setJposException(null);
                continue;
            }
            break;
        }
        if (printQueueElement.isAsyncMode() && !(printQueueElement instanceof PrintImmediateData) && !(printQueueElement instanceof RotatePrintData)) {
            this.eventQueueManager.postEvent((JposEvent)new OutputCompleteEvent(this.eventSource, printQueueElement.getOutputID()));
        } else {
            printQueueElement.notifyDone();
        }
    }

    private static final void trace(int n, String string, String string2) {
        if (n <= 4) {
            Tracer.trace((int)n, (String)className, (String)string, (String)string2);
        }
    }

    private class POSPrinterErrorEventContainer
    implements JposEventContainer {
        private ErrorEvent errorEvent;
        private PrintQueueManagerServiceState serviceState;
        private int errorLevel;
        private int errorStation;
        private String errorString;
        private boolean[] doneFiringMonitor;

        public POSPrinterErrorEventContainer(ErrorEvent errorEvent, PrintQueueManagerServiceState printQueueManagerServiceState, int n, int n2, String string) {
            this.errorEvent = errorEvent;
            this.serviceState = printQueueManagerServiceState;
            this.errorLevel = n;
            this.errorStation = n2;
            this.errorString = new String(string);
            this.doneFiringMonitor = new boolean[]{false};
        }

        public void prepareToFire() {
            try {
                this.serviceState.setErrorLevel(this.errorLevel);
                this.serviceState.setErrorStation(this.errorStation);
                this.serviceState.setErrorString(this.errorString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void doneFiring() {
            boolean[] blArray = this.doneFiringMonitor;
            synchronized (blArray) {
                this.doneFiringMonitor[0] = true;
                this.doneFiringMonitor.notifyAll();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void waitUntilDoneFiring() {
            boolean[] blArray = this.doneFiringMonitor;
            synchronized (blArray) {
                while (!this.doneFiringMonitor[0]) {
                    try {
                        this.doneFiringMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return;
            }
        }

        public JposEvent getJposEvent() {
            return this.errorEvent;
        }
    }

    class PrintQueue {
        private Vector v = new Vector();

        PrintQueue() {
        }

        public synchronized PrintQueueElement read() {
            while (this.v.isEmpty()) {
                PrintQueueManager.trace(3, "PrintQueue.read()", "blocked");
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            PrintQueueManager.trace(3, "PrintQueue.read()", "satisfied");
            PrintQueueElement printQueueElement = null;
            printQueueElement = (PrintQueueElement)this.v.elementAt(0);
            this.v.removeElementAt(0);
            return printQueueElement;
        }

        public void post(PrintQueueElement printQueueElement) throws JposException {
            PrintQueueManager.trace(2, "PrintQueue.post()", "Entry");
            PrintQueue printQueue = this;
            synchronized (printQueue) {
                this.v.addElement(printQueueElement);
                if (printQueueElement.isAsyncMode()) {
                    PrintQueueManager.this.serviceState.setState(3);
                }
                this.notify();
            }
            if (!printQueueElement.isAsyncMode()) {
                PrintQueueManager.trace(3, "PrintQueue.post()", "waiting for sync");
                printQueueElement.waitUntilDone();
                PrintQueueManager.trace(3, "PrintQueue.post()", "wait satisfied, checking for exception");
                if (printQueueElement.getJposException() != null) {
                    PrintQueueManager.trace(3, "PrintQueue.post()", "rethrowing exception");
                    throw printQueueElement.getJposException();
                }
                PrintQueueManager.trace(3, "PrintQueue.post()", "no exception");
            } else {
                PrintQueueManager.this.serviceState.setOutputID(printQueueElement.getOutputID());
            }
            PrintQueueManager.trace(2, "PrintQueue.post()", "Exit");
        }

        public void send(PrintQueueElement printQueueElement) throws JposException {
            PrintQueueManager.trace(2, "PrintQueue.send()", "Entry");
            PrintQueue printQueue = this;
            synchronized (printQueue) {
                this.v.insertElementAt(printQueueElement, 0);
                this.notify();
            }
            if (!printQueueElement.isAsyncMode() || printQueueElement instanceof PrintImmediateData) {
                PrintQueueManager.trace(3, "PrintQueue.send()", "waiting for sync");
                printQueueElement.waitUntilDone();
                if (printQueueElement.getJposException() != null) {
                    PrintQueueManager.trace(3, "PrintQueue.send()", "rethrowing exception");
                    throw printQueueElement.getJposException();
                }
                PrintQueueManager.trace(3, "PrintQueue.send()", "no exception");
            } else {
                PrintQueueManager.this.serviceState.setOutputID(printQueueElement.getOutputID());
            }
            PrintQueueManager.trace(2, "PrintQueue.send()", "Exit");
        }

        public final synchronized void clear() {
            this.v.removeAllElements();
        }

        public final int size() {
            return this.v.size();
        }

        public final boolean isEmpty() {
            return this.v.isEmpty();
        }
    }

    private class PrintQueueReader
    extends Thread {
        PrintQueueReader() {
        }

        public void run() {
            PrintQueueManager.trace(2, "PrintQueueManager$PrintQueueReader.run()", "Entry");
            try {
                PrintQueueManager.this.serviceState.setState(2);
            }
            catch (JposException jposException) {
                // empty catch block
            }
            if (PrintQueueManager.this.serviceState.getFlagWhenIdle()) {
                PrintQueueManager.this.serviceState.setFlagWhenIdle(false);
                PrintQueueManager.this.eventQueueManager.postEvent((JposEvent)new StatusUpdateEvent(PrintQueueManager.this.eventSource, 1001));
            }
            while (true) {
                PrintQueueManager.trace(2, "PrintQueueReader.run()", "reading queue...");
                PrintQueueElement printQueueElement = PrintQueueManager.this.printQueue.read();
                PrintQueueManager.trace(2, "PrintQueueReader.run()", "got one");
                if (printQueueElement instanceof Cyanide) {
                    PrintQueueManager.trace(2, "PrintQueueReader.run()", "Cyanide!");
                    return;
                }
                try {
                    PrintQueueManager.this.serviceState.setState(3);
                }
                catch (JposException jposException) {
                    // empty catch block
                }
                PrintQueueManager.this.processPrintQueueElement(printQueueElement);
                if (!PrintQueueManager.this.printQueue.isEmpty()) continue;
                try {
                    PrintQueueManager.this.serviceState.setState(2);
                }
                catch (JposException jposException) {
                    // empty catch block
                }
                if (!PrintQueueManager.this.serviceState.getFlagWhenIdle()) continue;
                PrintQueueManager.this.serviceState.setFlagWhenIdle(false);
                PrintQueueManager.this.eventQueueManager.postEvent((JposEvent)new StatusUpdateEvent(PrintQueueManager.this.eventSource, 1001));
            }
        }
    }

    private class Cyanide
    implements PrintQueueElement {
        private Cyanide() {
        }

        public boolean isAsyncMode() {
            return false;
        }

        public int getOutputID() {
            return -1;
        }

        public int getErrorLevel() {
            return -1;
        }

        public void setErrorLevel(int n) {
        }

        public JposException getJposException() {
            return null;
        }

        public void setJposException(JposException jposException) {
        }

        public void waitUntilDone() {
        }

        public void notifyDone() {
        }
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        public void run() {
            PrintQueueManager.this.printQueue.clear();
            try {
                PrintQueueManager.this.printQueue.send(new Cyanide());
            }
            catch (JposException jposException) {
                // empty catch block
            }
            PrintQueueManager.this.printQueue = null;
        }
    }

    private class PrintQueueDataContainer
    extends Vector
    implements PrintQueueElement {
        PrintQueueData entryData;
        PrintQueueData exitData;

        public PrintQueueDataContainer(PrintQueueData printQueueData) {
            this.entryData = printQueueData;
        }

        public PrintQueueData getEntryData() {
            return this.entryData;
        }

        public PrintQueueData getExitData() {
            return this.exitData;
        }

        public void setExitData(PrintQueueData printQueueData) {
            this.exitData = printQueueData;
        }

        public boolean isAsyncMode() {
            return this.exitData.isAsyncMode();
        }

        public int getOutputID() {
            return this.exitData.getOutputID();
        }

        public int getErrorLevel() {
            return this.exitData.getErrorLevel();
        }

        public void setErrorLevel(int n) {
            this.exitData.setErrorLevel(n);
        }

        public JposException getJposException() {
            return this.exitData.getJposException();
        }

        public void setJposException(JposException jposException) {
            this.exitData.setJposException(jposException);
        }

        public void waitUntilDone() {
            this.exitData.waitUntilDone();
        }

        public void notifyDone() {
            this.exitData.notifyDone();
        }
    }

    private class TransactionPrintContainer
    extends PrintQueueDataContainer {
        public TransactionPrintContainer(TransactionPrintData transactionPrintData) {
            super(transactionPrintData);
        }

        public synchronized void addElement(PrintQueueElement printQueueElement) {
            boolean bl = false;
            PrintNormalDataVector printNormalDataVector = null;
            if (printQueueElement instanceof PrintNormalData) {
                if (this.isEmpty()) {
                    printNormalDataVector = new PrintNormalDataVector();
                    this.addElement(printNormalDataVector);
                } else if (!(this.lastElement() instanceof PrintNormalDataVector)) {
                    printNormalDataVector = new PrintNormalDataVector();
                    this.addElement(printNormalDataVector);
                } else {
                    printNormalDataVector = (PrintNormalDataVector)this.lastElement();
                }
                if (printNormalDataVector.isEmpty()) {
                    printNormalDataVector.addElement(printQueueElement);
                    bl = true;
                } else {
                    PrintNormalData printNormalData = (PrintNormalData)printNormalDataVector.lastElement();
                    if (this.checkEquivalency(printNormalData, (PrintNormalData)printQueueElement)) {
                        printNormalDataVector.addElement(printQueueElement);
                        bl = true;
                    } else {
                        printNormalDataVector = new PrintNormalDataVector();
                        this.addElement(printNormalDataVector);
                        printNormalDataVector.addElement(printQueueElement);
                        bl = true;
                    }
                }
            }
            if (!bl) {
                super.addElement(printQueueElement);
            }
        }

        private boolean checkEquivalency(PrintNormalData printNormalData, PrintNormalData printNormalData2) {
            if (printNormalData.isAsyncMode() != printNormalData2.isAsyncMode()) {
                return false;
            }
            return printNormalData.hasReversedLines() == printNormalData2.hasReversedLines();
        }
    }

    private class SidewaysPrintContainer
    extends PrintQueueDataContainer {
        public SidewaysPrintContainer(RotatePrintData rotatePrintData) {
            super(rotatePrintData);
        }
    }
}

