/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.usb4java.libusb;

import de.ailis.usb4java.libusb.DeviceHandle;
import de.ailis.usb4java.libusb.LibUsb;
import de.ailis.usb4java.utils.DescriptorUtils;
import java.nio.ByteBuffer;
import javax.usb.UsbDeviceDescriptor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class DeviceDescriptor
implements UsbDeviceDescriptor {
    private ByteBuffer data;

    public ByteBuffer getData() {
        return this.data;
    }

    @Override
    public native byte bLength();

    @Override
    public native byte bDescriptorType();

    @Override
    public native short bcdUSB();

    @Override
    public native byte bDeviceClass();

    @Override
    public native byte bDeviceSubClass();

    @Override
    public native byte bDeviceProtocol();

    @Override
    public native byte bMaxPacketSize0();

    @Override
    public native short idVendor();

    @Override
    public native short idProduct();

    @Override
    public native short bcdDevice();

    @Override
    public native byte iManufacturer();

    @Override
    public native byte iProduct();

    @Override
    public native byte iSerialNumber();

    @Override
    public native byte bNumConfigurations();

    public String dump() {
        return this.dump(null);
    }

    public String dump(DeviceHandle handle) {
        String sManufacturer = LibUsb.getStringDescriptor(handle, this.iManufacturer());
        String sProduct = LibUsb.getStringDescriptor(handle, this.iProduct());
        String sSerialNumber = LibUsb.getStringDescriptor(handle, this.iSerialNumber());
        return DescriptorUtils.dump(this, sManufacturer, sProduct, sSerialNumber);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DeviceDescriptor other = (DeviceDescriptor)obj;
        return new EqualsBuilder().append(this.bDescriptorType(), other.bDescriptorType()).append(this.bLength(), other.bLength()).append(this.idProduct(), other.idProduct()).append(this.idVendor(), other.idVendor()).append(this.bcdDevice(), other.bcdDevice()).append(this.bcdUSB(), other.bcdUSB()).append(this.bDescriptorType(), other.bDescriptorType()).append(this.bDeviceClass(), other.bDeviceClass()).append(this.bDeviceProtocol(), other.bDeviceProtocol()).append(this.bDeviceSubClass(), other.bDeviceSubClass()).append(this.bLength(), other.bLength()).append(this.bMaxPacketSize0(), other.bMaxPacketSize0()).append(this.bNumConfigurations(), other.bNumConfigurations()).append(this.iManufacturer(), other.iManufacturer()).append(this.iProduct(), other.iProduct()).append(this.iSerialNumber(), other.iSerialNumber()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bLength()).append(this.bDescriptorType()).append(this.bcdUSB()).append(this.bDeviceClass()).append(this.bDeviceSubClass()).append(this.bDeviceProtocol()).append(this.bMaxPacketSize0()).append(this.idVendor()).append(this.idProduct()).append(this.bcdDevice()).append(this.iManufacturer()).append(this.iProduct()).append(this.iSerialNumber()).append(this.bNumConfigurations()).toHashCode();
    }

    public String toString() {
        return this.dump();
    }
}

