/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.os.windows;

import com.ibm.jusb.UsbConfigurationDescriptorImp;
import com.ibm.jusb.UsbConfigurationImp;
import com.ibm.jusb.UsbDeviceDescriptorImp;
import com.ibm.jusb.UsbDeviceImp;
import com.ibm.jusb.UsbEndpointDescriptorImp;
import com.ibm.jusb.UsbEndpointImp;
import com.ibm.jusb.UsbHubImp;
import com.ibm.jusb.UsbInterfaceDescriptorImp;
import com.ibm.jusb.UsbInterfaceImp;
import com.ibm.jusb.UsbPipeImp;
import com.ibm.jusb.os.UsbDeviceOsImp;
import com.ibm.jusb.os.UsbInterfaceOsImp;
import com.ibm.jusb.os.UsbPipeOsImp;
import com.ibm.jusb.os.windows.WindowsControlRequest;
import com.ibm.jusb.os.windows.WindowsDeviceOsImp;
import com.ibm.jusb.os.windows.WindowsDeviceProxy;
import com.ibm.jusb.os.windows.WindowsInterfaceOsImp;
import com.ibm.jusb.os.windows.WindowsPipeOsImp;
import com.ibm.jusb.os.windows.WindowsPipeRequest;
import com.ibm.jusb.os.windows.WindowsUsbServices;
import com.ibm.jusb.os.windows.util.WindowsUsbTracerNative;
import com.ibm.jusb.os.windows.util.WindowsUsbTracerStatic;
import javax.usb.UsbConfigurationDescriptor;
import javax.usb.UsbConst;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpointDescriptor;
import javax.usb.UsbException;
import javax.usb.UsbInterfaceDescriptor;

class JavaxUsb {
    public static final String ERROR_WHILE_LOADING_SHARED_LIBRARY = "Error while loading shared library";
    public static final String EXCEPTION_WHILE_LOADING_SHARED_LIBRARY = "Exception while loading shared library";
    public static final int TRACE_CRITICAL = 100;
    public static final int TRACE_ERROR = 200;
    public static final int TRACE_WARN = 300;
    public static final int TRACE_NOTICE = 400;
    public static final int TRACE_INFO = 500;
    public static final int TRACE_DEBUG = 600;
    public static final int TRACE_OFF = 0;
    private static final String NATIVETRACERNAME = "NATIVE";
    public static final String LIBRARY_NAME = "JavaxUsb";
    public static boolean log_enabled = false;
    public static int native_log_settings = 0;
    private static boolean libraryLoaded = false;
    private static final int SPEED_FULL = 2;
    private static final int SPEED_LOW = 1;
    private static final int SPEED_UNKNOWN = 0;
    private static String tracerClassName = null;
    private static WindowsUsbTracerNative nativeTracer = null;

    JavaxUsb() {
    }

    public static void connectUsbDeviceImp(UsbHubImp hub, int port, UsbDeviceImp device) {
        block2: {
            try {
                device.connect(hub, (byte)port);
            }
            catch (UsbException uE) {
                if (!WindowsUsbTracerStatic.getInstance().isOn()) break block2;
                WindowsUsbTracerStatic.getInstance().println(200, "[connectUsbDeviceImp]UsbException while connecting : " + uE.toString());
            }
        }
    }

    public static void setHubPorts(UsbHubImp hub, int ports) {
        hub.resize(ports);
    }

    public static int showDevice(UsbDeviceImp dev) {
        if (WindowsUsbTracerStatic.getInstance().isOn()) {
            WindowsUsbTracerStatic.getInstance().println("[showDevice]displaying jobject");
            try {
                System.out.println("[showDevice]" + ((WindowsDeviceOsImp)dev.getUsbDeviceOsImp()).getWindowsDeviceProxy().getKey());
            }
            catch (UsbException e) {
                System.out.println("[showDevice]excepcion en showdevice");
            }
        }
        try {
            return ((WindowsDeviceOsImp)dev.getUsbDeviceOsImp()).getWindowsDeviceProxy().getKey().length();
        }
        catch (UsbException e1) {
            return 0;
        }
    }

    public static UsbException errorToUsbException(int error) {
        return new UsbException(JavaxUsb.nativeGetErrorMessage(error));
    }

    public static UsbException errorToUsbException(int error, String string) {
        return new UsbException(string + " : " + JavaxUsb.nativeGetErrorMessage(error));
    }

    public static void loadLibrary() throws UsbException {
        if (libraryLoaded) {
            return;
        }
        try {
            System.loadLibrary(LIBRARY_NAME);
        }
        catch (Exception e) {
            throw new UsbException("Exception while loading shared library " + System.mapLibraryName(LIBRARY_NAME) + " : " + e.getMessage());
        }
        catch (Error e) {
            throw new UsbException("Error while loading shared library " + System.mapLibraryName(LIBRARY_NAME) + " : " + e.getMessage());
        }
    }

    public static int open_device(String key) {
        if (key == null || key.compareTo("") == 0) {
            return 0;
        }
        return JavaxUsb.openDevice(key);
    }

    public static void setTraceData(boolean enable) {
        log_enabled = enable;
    }

    public static void nativeSetTraceData() {
        JavaxUsb.setNativeLog(native_log_settings);
    }

    public static native int submitCancelPipeRequest(long var0, int var2, int var3);

    public static native int submitClaimInterfaceRequest(long var0, int var2, int var3, WindowsDeviceProxy var4);

    public static native int submitControlPipeRequest(long var0, int var2, byte var3, WindowsControlRequest var4, byte[] var5, int var6, byte var7, byte var8, byte var9, byte var10, short var11, short var12, WindowsDeviceProxy var13);

    public static native int submitInterruptPipeRequest(long var0, int var2, byte var3, WindowsPipeRequest var4, byte[] var5, int var6, WindowsDeviceProxy var7);

    public static native int submitIsClaimedInterfaceRequest(long var0, int var2, int var3, WindowsDeviceProxy var4);

    public static native int submitReleaseInterfaceRequest(long var0, int var2, int var3, WindowsDeviceProxy var4);

    public static native int submitSetConfigurationRequest(long var0, int var2, int var3, WindowsDeviceProxy var4);

    public static native int submitSetInterfaceRequest(long var0, int var2, int var3, int var4, WindowsDeviceProxy var5);

    private static void configureUsbDeviceImp(UsbDeviceImp targetDevice, byte length, byte type, byte deviceClass, byte deviceSubClass, byte deviceProtocol, byte maxDefaultEndpointSize, byte manufacturerIndex, byte productIndex, byte serialNumberIndex, byte numConfigs, short vendorId, short productId, short bcdDevice, short bcdUsb, int speed) {
        length = (byte)(length + 0);
        type = (byte)(type + 0);
        deviceClass = (byte)(deviceClass + 0);
        deviceSubClass = (byte)(deviceSubClass + 0);
        deviceProtocol = (byte)(deviceProtocol + 0);
        maxDefaultEndpointSize = (byte)(maxDefaultEndpointSize + 0);
        manufacturerIndex = (byte)(manufacturerIndex + 0);
        productIndex = (byte)(productIndex + 0);
        serialNumberIndex = (byte)(serialNumberIndex + 0);
        numConfigs = (byte)(numConfigs + 0);
        vendorId = (short)(vendorId + 0);
        productId = (short)(productId + 0);
        bcdDevice = (short)(bcdDevice + 0);
        bcdUsb = (short)(bcdUsb + 0);
        UsbDeviceDescriptorImp desc = new UsbDeviceDescriptorImp(length, type, bcdUsb, deviceClass, deviceSubClass, deviceProtocol, maxDefaultEndpointSize, vendorId, productId, bcdDevice, manufacturerIndex, productIndex, serialNumberIndex, numConfigs);
        targetDevice.setUsbDeviceDescriptor((UsbDeviceDescriptor)desc);
        switch (speed) {
            case 1: {
                targetDevice.setSpeed(UsbConst.DEVICE_SPEED_LOW);
                break;
            }
            case 2: {
                targetDevice.setSpeed(UsbConst.DEVICE_SPEED_FULL);
                break;
            }
            case 0: {
                targetDevice.setSpeed(UsbConst.DEVICE_SPEED_UNKNOWN);
                break;
            }
            default: {
                targetDevice.setSpeed(UsbConst.DEVICE_SPEED_UNKNOWN);
            }
        }
    }

    private static UsbConfigurationImp createUsbConfigurationImp(UsbDeviceImp device, byte length, byte type, short totalLen, byte numInterfaces, byte configValue, byte configIndex, byte attributes, byte maxPowerNeeded, boolean active) {
        length = (byte)(length + 0);
        type = (byte)(type + 0);
        numInterfaces = (byte)(numInterfaces + 0);
        configValue = (byte)(configValue + 0);
        configIndex = (byte)(configIndex + 0);
        attributes = (byte)(attributes + 0);
        maxPowerNeeded = (byte)(maxPowerNeeded + 0);
        UsbConfigurationDescriptorImp desc = new UsbConfigurationDescriptorImp(length, type, totalLen, numInterfaces, configValue, configIndex, attributes, maxPowerNeeded);
        UsbConfigurationImp config = new UsbConfigurationImp(device, (UsbConfigurationDescriptor)desc);
        if (active) {
            device.setActiveUsbConfigurationNumber(configValue);
        }
        return config;
    }

    private static UsbDeviceImp createUsbDeviceImp(String key) {
        UsbDeviceImp device = new UsbDeviceImp(null, null);
        WindowsDeviceOsImp windowsDeviceOsImp = new WindowsDeviceOsImp(device, new WindowsDeviceProxy(key));
        device.setUsbDeviceOsImp((UsbDeviceOsImp)windowsDeviceOsImp);
        return device;
    }

    private static UsbEndpointImp createUsbEndpointImp(UsbInterfaceImp iface, byte length, byte type, byte endpointAddress, byte attributes, byte interval, short maxPacketSize) {
        length = (byte)(length + 0);
        type = (byte)(type + 0);
        endpointAddress = (byte)(endpointAddress + 0);
        attributes = (byte)(attributes + 0);
        interval = (byte)(interval + 0);
        maxPacketSize = (short)(maxPacketSize + 0);
        UsbEndpointDescriptorImp desc = new UsbEndpointDescriptorImp(length, type, endpointAddress, attributes, interval, maxPacketSize);
        UsbEndpointImp ep = new UsbEndpointImp(iface, (UsbEndpointDescriptor)desc);
        UsbPipeImp pipe = null;
        WindowsInterfaceOsImp windowsInterfaceOsImp = (WindowsInterfaceOsImp)iface.getUsbInterfaceOsImp();
        pipe = new UsbPipeImp(ep, null);
        pipe.setUsbPipeOsImp((UsbPipeOsImp)new WindowsPipeOsImp(pipe, windowsInterfaceOsImp));
        return ep;
    }

    private static UsbHubImp createUsbHubImp(String key) {
        UsbHubImp hub = new UsbHubImp(null, null);
        WindowsDeviceOsImp windowsDeviceOsImp = new WindowsDeviceOsImp((UsbDeviceImp)hub, new WindowsDeviceProxy(key));
        hub.setUsbDeviceOsImp((UsbDeviceOsImp)windowsDeviceOsImp);
        return hub;
    }

    private static UsbHubImp createUsbHubImp(String key, int maxPorts) {
        UsbHubImp hub = new UsbHubImp(maxPorts, null, null);
        WindowsDeviceOsImp windowsDeviceOsImp = new WindowsDeviceOsImp((UsbDeviceImp)hub, new WindowsDeviceProxy(key));
        hub.setUsbDeviceOsImp((UsbDeviceOsImp)windowsDeviceOsImp);
        return hub;
    }

    private static UsbInterfaceImp createUsbInterfaceImp(UsbConfigurationImp config, byte length, byte type, byte interfaceNumber, byte alternateNumber, byte numEndpoints, byte interfaceClass, byte interfaceSubClass, byte interfaceProtocol, byte interfaceIndex, boolean active) {
        length = (byte)(length + 0);
        type = (byte)(type + 0);
        interfaceNumber = (byte)(interfaceNumber + 0);
        alternateNumber = (byte)(alternateNumber + 0);
        numEndpoints = (byte)(numEndpoints + 0);
        interfaceClass = (byte)(interfaceClass + 0);
        interfaceSubClass = (byte)(interfaceSubClass + 0);
        interfaceProtocol = (byte)(interfaceProtocol + 0);
        interfaceIndex = (byte)(interfaceIndex + 0);
        UsbInterfaceDescriptorImp desc = new UsbInterfaceDescriptorImp(length, type, interfaceNumber, alternateNumber, numEndpoints, interfaceClass, interfaceSubClass, interfaceProtocol, interfaceIndex);
        UsbInterfaceImp iface = new UsbInterfaceImp(config, (UsbInterfaceDescriptor)desc);
        if (config.isActive() && active) {
            iface.setActiveSettingNumber(iface.getUsbInterfaceDescriptor().bAlternateSetting());
        }
        WindowsDeviceOsImp windowsDeviceOsImp = (WindowsDeviceOsImp)iface.getUsbConfigurationImp().getUsbDeviceImp().getUsbDeviceOsImp();
        WindowsInterfaceOsImp windowsInterfaceOsImp = new WindowsInterfaceOsImp(iface, windowsDeviceOsImp);
        iface.setUsbInterfaceOsImp((UsbInterfaceOsImp)windowsInterfaceOsImp);
        return iface;
    }

    private static void jniPrint(int level, String st) {
        if (native_log_settings != 0) {
            if (nativeTracer == null) {
                nativeTracer = new WindowsUsbTracerNative(NATIVETRACERNAME, native_log_settings);
            }
            try {
                if (nativeTracer != null && nativeTracer.isOn()) {
                    nativeTracer.println(level, st);
                }
            }
            catch (Exception e) {
                System.out.println(st);
            }
        }
    }

    private static native int openDevice(String var0);

    static native String nativeGetErrorMessage(int var0);

    static native void setNativeLog(int var0);

    static native int nativeTopologyMonitor(WindowsUsbServices var0);

    static native int nativeTopologyBuilder(WindowsUsbServices var0);

    static native byte[] getCompleteBuffer(int var0);

    public static final void setTracerClassName(String name) {
        tracerClassName = name;
    }
}

