/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.poskbd.bus.ps2;

import com.ibm.poskbd.ClickCmd;
import com.ibm.poskbd.KeyboardDevInfo;
import com.ibm.poskbd.LedCmd;
import com.ibm.poskbd.MsrTracks;
import com.ibm.poskbd.ToneCmd;
import com.ibm.poskbd.TrapKeys;
import com.ibm.poskbd.bus.KeyboardAbstraction;
import com.ibm.poskbd.bus.KeyboardFunctionAbstraction;
import com.ibm.poskbd.bus.KeyboardFunctionImp;
import com.ibm.poskbd.bus.LedFunctionAbstraction;
import com.ibm.poskbd.bus.LedFunctionImp;
import com.ibm.poskbd.bus.MsrFunctionAbstraction;
import com.ibm.poskbd.bus.MsrFunctionImp;
import com.ibm.poskbd.bus.StatusFunctionAbstraction;
import com.ibm.poskbd.bus.StatusFunctionImp;
import com.ibm.poskbd.bus.ToneFunctionAbstraction;
import com.ibm.poskbd.bus.ToneFunctionImp;
import com.ibm.poskbd.bus.ps2.PS2PS2Proxy;
import com.ibm.poskbd.bus.ps2.PosKbd;

public class PS2FunctionImp
implements KeyboardFunctionImp,
MsrFunctionImp,
ToneFunctionImp,
StatusFunctionImp,
LedFunctionImp {
    private KeyboardAbstraction keyboardAbstraction = null;
    private KeyboardFunctionAbstraction keyboardFunction = null;
    private MsrFunctionAbstraction msrFunction = null;
    private StatusFunctionAbstraction statusFunction = null;
    private ToneFunctionAbstraction toneFunction = null;
    private LedFunctionAbstraction ledFunction = null;
    private PS2PS2Proxy ps2PS2Proxy = null;

    public void setEnabled(boolean enabled) {
        PosKbd.SetEnabledCommand command = new PosKbd.SetEnabledCommand(enabled);
        this.ps2PS2Proxy.executeCommand(command);
    }

    public void setClick(ClickCmd click) {
        PosKbd.SetClickCommand command = new PosKbd.SetClickCommand(click);
        this.ps2PS2Proxy.executeCommand(command);
    }

    public void setTypematic(boolean typematic) {
        PosKbd.SetTypematicCommand command = new PosKbd.SetTypematicCommand(typematic);
        this.ps2PS2Proxy.executeCommand(command);
    }

    public void codeUpdate(byte[] code) {
        PosKbd.CodeUpdateCommand command = new PosKbd.CodeUpdateCommand(code);
        this.ps2PS2Proxy.executeCommand(command);
    }

    public void setDoublekeys(byte[] keys) {
        PosKbd.SetDoublekeysCommand command = new PosKbd.SetDoublekeysCommand(keys);
        this.ps2PS2Proxy.executeCommand(command);
    }

    public void setTrapKeys(TrapKeys keys) {
        PosKbd.SetTrapKeysCommand command = new PosKbd.SetTrapKeysCommand(keys);
        this.ps2PS2Proxy.executeCommand(command);
    }

    public KeyboardDevInfo getDeviceInfo() {
        PosKbd.GetDeviceInfoCommand command = new PosKbd.GetDeviceInfoCommand();
        this.ps2PS2Proxy.executeCommand(command);
        return command.getKeyboardDevInfo();
    }

    public void setTone(ToneCmd tone) {
        PosKbd.SetToneCommand command = new PosKbd.SetToneCommand(tone);
        this.ps2PS2Proxy.executeCommand(command);
    }

    public void setLeds(LedCmd leds) {
        PosKbd.SetLedsCommand command = new PosKbd.SetLedsCommand(leds);
        this.ps2PS2Proxy.executeCommand(command);
    }

    public byte[] getStatus() {
        PosKbd.GetStatusCommand command = new PosKbd.GetStatusCommand();
        this.ps2PS2Proxy.executeCommand(command);
        return command.getStatus();
    }

    public void enableTracks(MsrTracks tracks) {
        PosKbd.EnableTracksCommand command = new PosKbd.EnableTracksCommand(tracks);
        this.ps2PS2Proxy.executeCommand(command);
    }

    public KeyboardFunctionAbstraction getKeyboardFunctionAbstraction() {
        return this.keyboardFunction;
    }

    public MsrFunctionAbstraction getMsrFunctionAbstraction() {
        return this.msrFunction;
    }

    public StatusFunctionAbstraction getStatusFunctionAbstraction() {
        return this.statusFunction;
    }

    public ToneFunctionAbstraction getToneFunctionAbstraction() {
        return this.toneFunction;
    }

    public void fireKbdStatus(byte[] status) {
        if (this.getStatusFunctionAbstraction() != null) {
            this.getStatusFunctionAbstraction().fireStatusEvent(status);
        }
    }

    public void fireMsrData(byte[] data) {
        if (this.getMsrFunctionAbstraction() != null) {
            this.getMsrFunctionAbstraction().fireMsrEvent(data);
        }
    }

    boolean init(KeyboardAbstraction keyboard) {
        this.ps2PS2Proxy = new PS2PS2Proxy(this);
        if (!this.ps2PS2Proxy.verifyLibLoaded()) {
            return false;
        }
        if (!this.ps2PS2Proxy.start()) {
            this.stop();
            return false;
        }
        this.keyboardAbstraction = keyboard;
        this.keyboardFunction = new KeyboardFunctionAbstraction(this);
        this.ledFunction = new LedFunctionAbstraction(this);
        this.keyboardAbstraction.addFunction(this.keyboardFunction);
        this.keyboardAbstraction.addFunction(this.ledFunction);
        if (this.getDeviceInfo().getKeyboardSubtype() != 4) {
            this.msrFunction = new MsrFunctionAbstraction(this);
            this.keyboardAbstraction.addFunction(this.msrFunction);
        }
        if (this.getDeviceInfo().getKeyboardSubtype() != 3 && this.getDeviceInfo().getKeyboardSubtype() != 5) {
            this.toneFunction = new ToneFunctionAbstraction(this);
            this.keyboardAbstraction.addFunction(this.toneFunction);
            this.statusFunction = new StatusFunctionAbstraction(this);
            this.keyboardAbstraction.addFunction(this.statusFunction);
        }
        return true;
    }

    void reinit(KeyboardAbstraction keyboard) {
        if (this.ps2PS2Proxy.isRunning()) {
            return;
        }
        this.init(keyboard);
    }

    void stop() {
        this.ps2PS2Proxy.stop();
        if (this.keyboardFunction != null) {
            this.keyboardAbstraction.removeFunction(this.keyboardFunction);
        }
        if (this.msrFunction != null) {
            this.keyboardAbstraction.removeFunction(this.msrFunction);
        }
        if (this.statusFunction != null) {
            this.keyboardAbstraction.removeFunction(this.statusFunction);
        }
        if (this.toneFunction != null) {
            this.keyboardAbstraction.removeFunction(this.toneFunction);
        }
        if (this.ledFunction != null) {
            this.keyboardAbstraction.removeFunction(this.ledFunction);
        }
    }
}

