/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jpos.config.JposConfigException;
import jpos.config.JposEntry;
import jpos.config.JposEntryConst;
import jpos.config.simple.SimpleEntry;
import jpos.config.simple.editor.AbstractPropsViewPanel;
import jpos.config.simple.editor.PropsViewPanel;
import jpos.util.JposEntryUtility;

class VendorPropsViewPanel
extends AbstractPropsViewPanel {
    private JButton addButton = new JButton("Add");
    private JButton removeButton = new JButton("Remove");
    private PropsTableModel propsTableModel = new PropsTableModel();
    private JTable propsTable = new JTable(this.propsTableModel);
    public static final JposEntry EMPTY_JPOSENTRY = new SimpleEntry();
    public static final String PROP_NAME_STRING = "Property Name";
    public static final String PROP_VALUE_STRING = "Property Value";
    public static final String PROP_TYPE_STRING = "Property Type";
    public static final String VENDOR_PROPS_TABLE_TITLE = "Vendor Properties";
    public static final String ADD_STRING = "Add";
    public static final String REMOVE_STRING = "Remove";
    public static final String ADD_BUTTON_TTEXT_STRING = "Add a new property";
    public static final String REMOVE_BUTTON_TTEXT_STRING = "Remove the selected property";
    public static final String CANNOT_ADD_STANDARD_PROPERTY_IN_VENDOR_PROPS_PANEL_MSG = "Cannot add a standard property in the Vendor Properties";
    public static final String CANNOT_ADD_RS232_PROPERTY_IN_VENDOR_PROPS_PANEL_MSG = "Cannot add an RS232 property in the Vendor Properties";
    public static final String CANNOT_ADD_PROP_WITH_EMPTY_NAME_MSG = "Cannot add a property with an empty name";
    public static final String REMOVE_SELECTED_PROPERTY_FROM_ENTRY_MSG = "Remove selected property from entry?";
    public static final String SAVE_CHANGES_TO_JPOSENTRY_QUESTION_MSG = "Save changes to JposEntry?";
    public static final String PROPERTY_BY_THIS_NAME_ALREADY_EXISTS_MSG = "A property by this name already exists...";
    public static final String PROPERTY_VALUE_IS_NOT_VALID_FOR_TYPE_MSG = "Property value is not valid for type selected...";
    public static final String PROPERTY_TYPE_IS_NOT_VALID_FOR_VALUE_MSG = "Property type is not valid for value selected...";
    public static final String SELECT_AN_OPTION_MSG = "Select an Option";
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;

    public VendorPropsViewPanel() {
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.propsTable, 22, 30);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), VENDOR_PROPS_TABLE_TITLE));
        this.add((Component)jScrollPane, "Center");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VendorPropsViewPanel.this.addButtonClicked();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VendorPropsViewPanel.this.removeButtonClicked();
            }
        });
        this.init();
    }

    private void init() {
        this.clearAll();
        this.setEditableAll(false);
        this.initCustomButtonPanel();
        this.initTable();
    }

    private void initTable() {
        TableColumn tableColumn = this.propsTable.getColumn(PROP_TYPE_STRING);
        tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<String>(JposEntryConst.PROP_TYPES_SHORT_NAMES)));
        this.propsTable.setRowHeight((int)((double)this.propsTable.getRowHeight() * 1.5));
    }

    private void initCustomButtonPanel() {
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.addButton.setToolTipText(ADD_BUTTON_TTEXT_STRING);
        this.removeButton.setToolTipText(REMOVE_BUTTON_TTEXT_STRING);
        this.customButtonPanel = new JPanel(new GridLayout(3, 1));
        this.customButtonPanel.add(new JPanel());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.addButton);
        this.customButtonPanel.add(jPanel);
        jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.removeButton);
        this.customButtonPanel.add(jPanel);
    }

    private void initFromJposEntry(JposEntry jposEntry) {
        this.propsTableModel.setJposEntry(jposEntry);
    }

    private void addButtonClicked() {
        this.propsTableModel.add();
    }

    private void removeButtonClicked() {
        int n;
        int n2 = JOptionPane.showConfirmDialog(this, REMOVE_SELECTED_PROPERTY_FROM_ENTRY_MSG, SELECT_AN_OPTION_MSG, 0);
        if (n2 == 0 && (n = this.propsTable.getSelectedRow()) != -1) {
            this.propsTableModel.delete(n);
        }
    }

    public JPanel getCustomButtonPanel() {
        return this.customButtonPanel;
    }

    public void clearAll() {
        this.propsTableModel.clearAll();
    }

    public void setEnabledAll(boolean bl) {
        this.propsTable.setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
    }

    public void setEditableAll(boolean bl) {
        this.propsTableModel.setEditable(bl);
    }

    public void setJposEntry(JposEntry jposEntry) {
        if (this.jposEntry != null) {
            this.cancelButtonClicked();
        }
        this.jposEntry = jposEntry;
        this.propsTableModel.setJposEntry(this.jposEntry);
    }

    public void aboutToLooseFocus() {
        if (this.jposEntry != null) {
            this.cancelButtonClicked();
        }
    }

    public void editButtonClicked() {
        this.propsTableModel.setEditable(true);
        this.propsTable.setEnabled(true);
        this.addButton.setEnabled(true);
        if (this.propsTableModel.props.size() > 0) {
            this.removeButton.setEnabled(true);
        }
    }

    public void okButtonClicked() {
        int n = this.propsTable.getEditingRow();
        int n2 = this.propsTable.getEditingColumn();
        if (n != -1 && n2 != -1) {
            this.propsTable.getCellEditor(n, n2).stopCellEditing();
        }
        if (n != -1 && this.propsTableModel.getValueAt(n, 0).toString().equals("")) {
            JOptionPane.showMessageDialog(this, CANNOT_ADD_PROP_WITH_EMPTY_NAME_MSG);
        }
        this.propsTableModel.setEditable(false);
        if (this.propsTableModel.isJposEntryModified()) {
            this.fireJposEntryChanged(new PropsViewPanel.Event(this));
        }
        this.propsTableModel.updateJposEntry();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    public void cancelButtonClicked() {
        int n;
        int n2 = this.propsTable.getEditingRow();
        int n3 = this.propsTable.getEditingColumn();
        if (this.propsTableModel.isJposEntryModified() && (n = JOptionPane.showConfirmDialog(this, SAVE_CHANGES_TO_JPOSENTRY_QUESTION_MSG, VENDOR_PROPS_TABLE_TITLE, 0)) == 0) {
            if (n2 != -1 && n3 != -1) {
                this.propsTable.getCellEditor(n2, n3).stopCellEditing();
            }
            if (this.propsTableModel.isJposEntryModified()) {
                this.fireJposEntryChanged(new PropsViewPanel.Event(this));
            }
            this.propsTableModel.updateJposEntry();
        }
        if (n2 != -1 && n3 != -1) {
            this.propsTable.getCellEditor(n2, n3).cancelCellEditing();
        }
        this.propsTableModel.cancelModifications();
        this.propsTableModel.setEditable(false);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PropsTableModel
    extends AbstractTableModel {
        private boolean editable = false;
        private JposEntry jposEntry = null;
        private List props = new ArrayList();
        private List changedProps = new ArrayList();
        private List addedProps = new ArrayList();
        private List removedProps = new ArrayList();
        private final String[] COLUMN_NAMES = new String[]{"Property Name", "Property Value", "Property Type"};

        PropsTableModel() {
        }

        public void setJposEntry(JposEntry jposEntry) {
            this.jposEntry = jposEntry;
            Enumeration enumeration = JposEntryUtility.getVendorPropNames(this.jposEntry);
            this.props.clear();
            this.addedProps.clear();
            this.removedProps.clear();
            this.changedProps.clear();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = this.jposEntry.getPropertyValue(string);
                this.props.add(new SimpleEntry.Prop(string, object));
                Collections.sort(this.props);
            }
            this.fireTableDataChanged();
        }

        public void add() {
            this.add("", "");
        }

        public void add(String string, Object object) {
            SimpleEntry.Prop prop = new SimpleEntry.Prop(string, object);
            this.props.add(prop);
            this.addedProps.add(prop);
            VendorPropsViewPanel.this.removeButton.setEnabled(true);
            this.fireTableDataChanged();
        }

        public void delete(int n) {
            if (n >= 0 && n < this.props.size()) {
                JposEntry.Prop prop = (JposEntry.Prop)this.props.remove(n);
                this.removedProps.add(prop);
                this.addedProps.remove(prop);
            }
            if (this.props.size() == 0) {
                VendorPropsViewPanel.this.removeButton.setEnabled(false);
            }
            this.fireTableDataChanged();
        }

        public void clearAll() {
            this.props.clear();
            this.addedProps.clear();
            this.removedProps.clear();
            this.changedProps.clear();
            this.jposEntry = EMPTY_JPOSENTRY;
            this.fireTableDataChanged();
        }

        public void setEditable(boolean bl) {
            this.editable = bl;
        }

        public void updateJposEntry() {
            Object object;
            Object object2;
            Iterator iterator = this.addedProps.iterator();
            while (iterator.hasNext()) {
                object2 = (JposEntry.Prop)iterator.next();
                if (object2.getName().equals("")) continue;
                this.jposEntry.add((JposEntry.Prop)object2);
            }
            object2 = this.removedProps.iterator();
            while (object2.hasNext()) {
                object = (JposEntry.Prop)object2.next();
                if (object.getName().equals("")) continue;
                this.jposEntry.remove((JposEntry.Prop)object);
            }
            object = this.changedProps.iterator();
            while (object.hasNext()) {
                JposEntry.Prop prop = (JposEntry.Prop)object.next();
                if (prop.getName().equals("")) continue;
                this.jposEntry.modifyPropertyValue(prop.getName(), prop.getValue());
            }
            this.setJposEntry(this.jposEntry);
        }

        public void cancelModifications() {
            this.setJposEntry(this.jposEntry);
        }

        public boolean isJposEntryModified() {
            return this.changedProps.size() > 0 || this.addedProps.size() > 0 || this.removedProps.size() > 0;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public int getRowCount() {
            return this.props.size();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n >= this.props.size()) {
                return;
            }
            JposEntry.Prop prop = (JposEntry.Prop)this.props.get(n);
            String string = this.getValueAt(n, 2).toString();
            if (n2 == 1) {
                String string2 = object.toString();
                try {
                    Class clazz = JposEntryUtility.propTypeFromString(string);
                    Object object2 = JposEntryUtility.parsePropValue(string2, clazz);
                    if (!JposEntryUtility.validatePropValue(object2, clazz)) {
                        JOptionPane.showMessageDialog(VendorPropsViewPanel.this, VendorPropsViewPanel.PROPERTY_VALUE_IS_NOT_VALID_FOR_TYPE_MSG);
                        return;
                    }
                    prop.setValue(object2);
                    if (!this.changedProps.contains(prop)) {
                        this.changedProps.add(prop);
                    }
                    this.fireTableDataChanged();
                }
                catch (JposConfigException jposConfigException) {
                    JOptionPane.showMessageDialog(VendorPropsViewPanel.this, VendorPropsViewPanel.PROPERTY_TYPE_IS_NOT_VALID_FOR_VALUE_MSG);
                }
            } else if (n2 == 2) {
                String string3 = this.getValueAt(n, 1).toString();
                Class clazz = null;
                Object object3 = null;
                try {
                    clazz = JposEntryUtility.propTypeFromString(object.toString());
                    object3 = JposEntryUtility.parsePropValue(string3, clazz);
                    if (JposEntryUtility.validatePropValue(object3, clazz)) {
                        prop.setValue(object3);
                    }
                    if (!this.changedProps.contains(prop)) {
                        this.changedProps.add(prop);
                    }
                    this.fireTableDataChanged();
                }
                catch (JposConfigException jposConfigException) {
                    try {
                        prop.setValue(JposEntryUtility.getDefaultValueForType(clazz));
                    }
                    catch (JposConfigException jposConfigException2) {}
                }
            } else {
                if (object.toString().equals("")) {
                    JOptionPane.showMessageDialog(VendorPropsViewPanel.this, VendorPropsViewPanel.CANNOT_ADD_PROP_WITH_EMPTY_NAME_MSG);
                    return;
                }
                if (JposEntryUtility.isRequiredPropName(object.toString())) {
                    JOptionPane.showMessageDialog(VendorPropsViewPanel.this, VendorPropsViewPanel.CANNOT_ADD_STANDARD_PROPERTY_IN_VENDOR_PROPS_PANEL_MSG);
                    return;
                }
                if (JposEntryUtility.isRS232PropName(object.toString())) {
                    JOptionPane.showMessageDialog(VendorPropsViewPanel.this, VendorPropsViewPanel.CANNOT_ADD_RS232_PROPERTY_IN_VENDOR_PROPS_PANEL_MSG);
                    return;
                }
                if (!prop.getName().equals(object.toString()) && this.isNameInUse(object.toString())) {
                    JOptionPane.showMessageDialog(VendorPropsViewPanel.this, VendorPropsViewPanel.PROPERTY_BY_THIS_NAME_ALREADY_EXISTS_MSG);
                    return;
                }
                if (!prop.getName().equals(object.toString())) {
                    if (!this.removedProps.contains(prop)) {
                        this.removedProps.add(prop.copy());
                    }
                    prop.setName(object.toString());
                    if (!this.addedProps.contains(prop)) {
                        this.addedProps.add(prop);
                    }
                }
                this.fireTableDataChanged();
            }
        }

        public Object getValueAt(int n, int n2) {
            JposEntry.Prop prop = (JposEntry.Prop)this.props.get(n);
            switch (n2) {
                case 0: {
                    return prop.getName();
                }
                case 1: {
                    return this.formatPropValue(prop);
                }
                case 2: {
                    return JposEntryUtility.shortClassName(prop.getType());
                }
            }
            throw new RuntimeException("Cannot have columnIndex > 2");
        }

        public boolean isCellEditable(int n, int n2) {
            return this.editable;
        }

        private String formatPropValue(JposEntry.Prop prop) {
            Class clazz = prop.getType();
            String string = "";
            if (!VendorPropsViewPanel.this.getMainFrame().getShowAsHexFlag()) {
                return prop.getValue().toString();
            }
            string = clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = VendorPropsViewPanel.class$("java.lang.Integer")) : class$java$lang$Integer) ? "0x" + Integer.toHexString((Integer)prop.getValue()).toUpperCase() : (clazz.equals(class$java$lang$Long == null ? (class$java$lang$Long = VendorPropsViewPanel.class$("java.lang.Long")) : class$java$lang$Long) ? "0x" + Long.toHexString((Long)prop.getValue()).toUpperCase() : (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = VendorPropsViewPanel.class$("java.lang.Byte")) : class$java$lang$Byte) ? "0x" + Integer.toHexString(((Byte)prop.getValue()).byteValue()).toUpperCase() : (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = VendorPropsViewPanel.class$("java.lang.Short")) : class$java$lang$Short) ? "0x" + Integer.toHexString(((Short)prop.getValue()).shortValue()).toUpperCase() : prop.getValue().toString())));
            return string;
        }

        private boolean isNameInUse(String string) {
            Iterator iterator = this.props.iterator();
            while (iterator.hasNext()) {
                if (!((JposEntry.Prop)iterator.next()).getName().equals(string)) continue;
                return true;
            }
            return false;
        }
    }
}

