/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.config.JposRegPopulator;
import jpos.config.simple.SimpleEntry;
import jpos.config.simple.SimpleRegPopulator;
import jpos.config.simple.editor.AboutDialog;
import jpos.config.simple.editor.AddJposEntryDialog;
import jpos.config.simple.editor.EditJposEntryDialog;
import jpos.config.simple.editor.InvalidEntryDialog;
import jpos.config.simple.editor.JposEntryEditorConfig;
import jpos.config.simple.editor.JposEntryEditorConfigDialog;
import jpos.config.simple.editor.JposEntryEditorFileFilter;
import jpos.config.simple.editor.JposEntryEditorMsg;
import jpos.config.simple.editor.JposEntryEditorUtility;
import jpos.config.simple.editor.JposEntryList;
import jpos.config.simple.editor.JposEntryMergerDialog;
import jpos.config.simple.editor.JposEntryPanel;
import jpos.config.simple.editor.JposEntryProp;
import jpos.config.simple.editor.JposEntryTreeEvent;
import jpos.config.simple.editor.JposEntryTreeListener;
import jpos.config.simple.editor.JposEntryTreePanel;
import jpos.config.simple.editor.PropertiesEditorFrame;
import jpos.config.simple.xml.XercesRegPopulator;
import jpos.config.simple.xml.XmlRegPopulator;
import jpos.loader.JposServiceLoader;
import jpos.util.FileUtil;
import jpos.util.JposEntryUtility;
import jpos.util.JposProperties;
import jpos.util.PopupListener;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

class MainFrame
extends JFrame {
    private String jposRegistryEntriesUrl = "";
    private JposRegPopulator xmlRegPopulator = new XercesRegPopulator();
    private JposRegPopulator serRegPopulator = new SimpleRegPopulator();
    private boolean registryMode = false;
    private boolean xmlEditorMode = true;
    private boolean entriesChanged = false;
    private boolean saved = false;
    private boolean closing = false;
    private boolean autoLoad = false;
    private boolean noFile = true;
    private JFileChooser jFileChooser = null;
    private JSplitPane vSplit = null;
    private JSplitPane hSplit = null;
    private JTextArea bottomTextArea = new JTextArea(3, 20);
    private JPanel bottomPanel = new JPanel();
    private JposEntryPanel jposEntryPanel = new JposEntryPanel(this);
    private JposEntryTreePanel jposEntryTreePanel = new JposEntryTreePanel();
    private EditJposEntryDialog editJposEntryDialog = null;
    private AddJposEntryDialog addJposEntryDialog = null;
    private InvalidEntryDialog invalidEntryDialog = null;
    private JDialog aboutDialog = null;
    private JposEntryEditorConfigDialog configDialog = null;
    private JposEntryMergerDialog jposEntryMergerDialog = null;
    private JposEntryEditorConfig jposEntryEditorConfig = JposEntryEditorConfig.getInstance();
    private JMenuItem newFileSubMenu = new JMenuItem(NEW_STRING);
    private JMenuItem openFileSubMenu = new JMenuItem(OPEN_STRING);
    private JMenuItem saveFileSubMenu = new JMenuItem(SAVE_STRING);
    private JMenuItem saveAsFileSubMenu = new JMenuItem(SAVEAS_STRING);
    private JMenuItem jposPropertiesSubMenu = new JMenuItem("JposProperties...");
    private JMenuItem loadJposRegistrySubMenu = new JMenuItem(LOADJPOSREGISTRY_STRING);
    private JMenuItem saveJposRegistrySubMenu = new JMenuItem(SAVEJPOSREGISTRY_STRING);
    private JMenuItem saveJposRegistryAsSubMenu = new JMenuItem("Save JposEntryRegistry As...");
    private JMenuItem closeJposRegistrySubMenu = new JMenuItem(CLOSEJPOSREGISTRY_STRING);
    private JMenuItem closeFileSubMenu = new JMenuItem(CLOSE_STRING);
    private JMenuItem exitSubMenu = new JMenuItem(EXIT_STRING);
    private JMenuItem addJposEntrySubMenu = new JMenuItem(ADD_STRING);
    private JMenuItem copyJposEntrySubMenu = new JMenuItem(COPY_STRING);
    private JMenuItem removeJposEntrySubMenu = new JMenuItem(DELETE_STRING);
    private JMenuItem aboutSubMenu = new JMenuItem(ABOUT_STRING);
    private JMenuItem configSubMenu = new JMenuItem(PREFERENCES_STRING);
    private ButtonGroup editorModeButtonGroup = new ButtonGroup();
    private JRadioButtonMenuItem xmlEditorModeMenuItem = new JRadioButtonMenuItem("XML");
    private JRadioButtonMenuItem serEditorModeMenuItem = new JRadioButtonMenuItem("Serialized");
    private JMenuItem jposEntryMergerSubMenu = new JMenuItem("JposEntry Merger...");
    private JMenuItem addJposEntryPopupSubMenu = new JMenuItem(ADD_STRING);
    private JMenuItem copyJposEntryPopupSubMenu = new JMenuItem(COPY_STRING);
    private JMenuItem removeJposEntryPopupSubMenu = new JMenuItem(DELETE_STRING);
    private JMenu treeViewMenu = new JMenu(TREEVIEW_STRING);
    private JRadioButtonMenuItem sortedRBMenuItem = new JRadioButtonMenuItem(SORTED_STRING);
    private JRadioButtonMenuItem categoryRBMenuItem = new JRadioButtonMenuItem(CATEGORY_STRING);
    private JRadioButtonMenuItem manufacturerRBMenuItem = new JRadioButtonMenuItem(MANUFACTURER_STRING);
    private JCheckBoxMenuItem autoExpandTreeMenuItem = new JCheckBoxMenuItem(AUTOEXPAND_STRING, false);
    private JToolBar toolbar = new JToolBar();
    private ImageIcon newFileIcon = JposEntryEditorUtility.getTreeImage("newfile_icon.gif");
    private ImageIcon openFileIcon = JposEntryEditorUtility.getTreeImage("openfile_icon.gif");
    private ImageIcon saveFileIcon = JposEntryEditorUtility.getTreeImage("savefile_icon.gif");
    private ImageIcon saveAsFileIcon = JposEntryEditorUtility.getTreeImage("saveas_icon.gif");
    private ImageIcon closeFileIcon = JposEntryEditorUtility.getTreeImage("closefile_icon.gif");
    private ImageIcon addEntryIcon = JposEntryEditorUtility.getTreeImage("addentry_icon.gif");
    private ImageIcon copyEntryIcon = JposEntryEditorUtility.getTreeImage("copyentry_icon.gif");
    private ImageIcon removeEntryIcon = JposEntryEditorUtility.getTreeImage("deleteentry_icon.gif");
    private ImageIcon configIcon = JposEntryEditorUtility.getTreeImage("config_icon.gif");
    private ImageIcon aboutIcon = JposEntryEditorUtility.getTreeImage("about_icon.gif");
    private JButton newFileButton = new JButton(this.newFileIcon);
    private JButton openFileButton = new JButton(this.openFileIcon);
    private JButton saveFileButton = new JButton(this.saveFileIcon);
    private JButton saveAsFileButton = new JButton(this.saveAsFileIcon);
    private JButton closeFileButton = new JButton(this.closeFileIcon);
    private JButton addEntryButton = new JButton(this.addEntryIcon);
    private JButton copyEntryButton = new JButton(this.copyEntryIcon);
    private JButton removeEntryButton = new JButton(this.removeEntryIcon);
    private JButton configButton = new JButton(this.configIcon);
    private JButton aboutButton = new JButton(this.aboutIcon);
    private int lookAndFeelSelected = 0;
    private PropertiesEditorFrame propEditorFrame = null;
    private JposEntryEditorFileFilter jposEntryEditorFileFilter = null;
    private boolean showAsHexFlag = this.jposEntryEditorConfig.getShowNumbersAsHexCheckBox();
    private boolean autoDeleteEntryOnCopy = this.jposEntryEditorConfig.getAutoDeleteEntryOnCopy();
    private boolean configReset = false;
    private Tracer tracer = TracerFactory.getInstance().createTracer("MainFrame");
    private static int newFileCount = 0;
    public static final String MAINFRAME_TITLE = "JposEntry Editor";
    public static final String XML_EXTENSION_STRING = ".xml";
    public static final String CFG_EXTENSION_STRING = ".cfg";
    public static final String JPOSENTRYEDITOR_STRING = JposEntryEditorMsg.JPOSENTRYEDITOR_STRING;
    public static final String FILE_STRING = JposEntryEditorMsg.FILE_STRING;
    public static final String NEW_STRING = JposEntryEditorMsg.NEW_STRING;
    public static final String OPEN_STRING = JposEntryEditorMsg.OPEN_STRING;
    public static final String SAVE_STRING = JposEntryEditorMsg.SAVE_STRING;
    public static final String SAVEAS_STRING = JposEntryEditorMsg.SAVEAS_STRING;
    public static final String LOADJPOSREGISTRY_STRING = JposEntryEditorMsg.LOADJPOSREGISTRY_STRING;
    public static final String SAVEJPOSREGISTRY_STRING = JposEntryEditorMsg.SAVEJPOSREGISTRY_STRING;
    public static final String CLOSEJPOSREGISTRY_STRING = JposEntryEditorMsg.CLOSEJPOSREGISTRY_STRING;
    public static final String CLOSE_STRING = JposEntryEditorMsg.CLOSE_STRING;
    public static final String EXIT_STRING = JposEntryEditorMsg.EXIT_STRING;
    public static final String EDIT_STRING = JposEntryEditorMsg.EDIT_STRING;
    public static final String ADD_STRING = JposEntryEditorMsg.ADD_STRING;
    public static final String COPY_STRING = JposEntryEditorMsg.COPY_STRING;
    public static final String DELETE_STRING = JposEntryEditorMsg.DELETE_STRING;
    public static final String MODIFY_STRING = JposEntryEditorMsg.MODIFY_STRING;
    public static final String PREFERENCES_STRING = JposEntryEditorMsg.PREFERENCES_STRING;
    public static final String HELP_STRING = JposEntryEditorMsg.HELP_STRING;
    public static final String ABOUT_STRING = JposEntryEditorMsg.ABOUT_STRING;
    public static final String JPOSENTRIES_STRING = JposEntryEditorMsg.JPOSENTRIES_STRING;
    public static final String PROPERTIES_STRING = JposEntryEditorMsg.PROPERTIES_STRING;
    public static final String IMPORTANTPROPERTIES_STRING = JposEntryEditorMsg.IMPORTANTPROPERTIES_STRING;
    public static final String CURRENTPROPERTY_STRING = JposEntryEditorMsg.CURRENTPROPERTY_STRING;
    public static final String PROPERTYNAME_STRING = JposEntryEditorMsg.PROPERTYNAME_STRING;
    public static final String PROPERTYVALUE_STRING = JposEntryEditorMsg.PROPERTYVALUE_STRING;
    public static final String PROPERTYTYPE_STRING = JposEntryEditorMsg.PROPERTYTYPE_STRING;
    public static final String OTHERPROPERTIES_STRING = JposEntryEditorMsg.OTHERPROPERTIES_STRING;
    public static final String MESSAGES_STRING = JposEntryEditorMsg.MESSAGES_STRING;
    public static final String TOPOFFILE_STRING = JposEntryEditorMsg.TOPOFFILE_STRING;
    public static final String NEWFILEMENU_STRING = JposEntryEditorMsg.NEWFILEMENU_STRING;
    public static final String NEWFILEBUTTON_STRING = JposEntryEditorMsg.NEWFILEBUTTON_STRING;
    public static final String OPENFILEMENU_STRING = JposEntryEditorMsg.OPENFILEMENU_STRING;
    public static final String OPENFILEBUTTON_STRING = JposEntryEditorMsg.OPENFILEBUTTON_STRING;
    public static final String SAVEFILEMENU_STRING = JposEntryEditorMsg.SAVEFILEMENU_STRING;
    public static final String SAVEFILEBUTTON_STRING = JposEntryEditorMsg.SAVEFILEBUTTON_STRING;
    public static final String SAVEASFILEMENU_STRING = JposEntryEditorMsg.SAVEFILEMENU_STRING;
    public static final String SAVEASFILEBUTTON_STRING = JposEntryEditorMsg.SAVEFILEBUTTON_STRING;
    public static final String LOADJPOSREGISTRYMENU_STRING = JposEntryEditorMsg.LOADJPOSREGISTRYMENU_STRING;
    public static final String SAVEJPOSREGISTRYMENU_STRING = JposEntryEditorMsg.SAVEJPOSREGISTRYMENU_STRING;
    public static final String CLOSEJPOSREGISTRYMENU_STRING = JposEntryEditorMsg.CLOSEJPOSREGISTRYMENU_STRING;
    public static final String CLOSEFILEMENU_STRING = JposEntryEditorMsg.CLOSEFILEMENU_STRING;
    public static final String CLOSEFILEBUTTON_STRING = JposEntryEditorMsg.CLOSEFILEBUTTON_STRING;
    public static final String EXITMENU_STRING = JposEntryEditorMsg.EXITMENU_STRING;
    public static final String ADDMENU_STRING = JposEntryEditorMsg.ADDMENU_STRING;
    public static final String COPYMENU_STRING = JposEntryEditorMsg.COPYMENU_STRING;
    public static final String ADDBUTTON_STRING = JposEntryEditorMsg.ADDBUTTON_STRING;
    public static final String DELETEMENU_STRING = JposEntryEditorMsg.DELETEMENU_STRING;
    public static final String DELETEBUTTON_STRING = JposEntryEditorMsg.DELETEBUTTON_STRING;
    public static final String MODIFYMENU_STRING = JposEntryEditorMsg.MODIFYMENU_STRING;
    public static final String MODIFYBUTTON_STRING = JposEntryEditorMsg.MODIFYBUTTON_STRING;
    public static final String ABOUTMENU_STRING = JposEntryEditorMsg.ABOUTMENU_STRING;
    public static final String ABOUTBUTTON_STRING = JposEntryEditorMsg.ABOUTBUTTON_STRING;
    public static final String CONFIGMENU_STRING = JposEntryEditorMsg.CONFIGMENU_STRING;
    public static final String CONFIGBUTTON_STRING = JposEntryEditorMsg.CONFIGBUTTON_STRING;
    public static final String TREEVIEW_STRING = JposEntryEditorMsg.TREEVIEW_STRING;
    public static final String SORTED_STRING = JposEntryEditorMsg.SORTED_STRING;
    public static final String CATEGORY_STRING = JposEntryEditorMsg.CATEGORY_STRING;
    public static final String MANUFACTURER_STRING = JposEntryEditorMsg.MANUFACTURER_STRING;
    public static final String AUTOEXPAND_STRING = JposEntryEditorMsg.AUTOEXPAND_STRING;
    public static final String SELECTENTRYTODELETE_STRING = JposEntryEditorMsg.SELECTENTRYTODELETE_STRING;
    public static final String DELETEENTRYWITHLOGNAM_STRING = JposEntryEditorMsg.DELETEENTRYWITHLOGNAM_STRING;
    public static final String DELETESELECTEDENTRIES_STRING = JposEntryEditorMsg.DELETE_STRING;
    public static final String SELECTENTRYTOMODIFY_STRING = JposEntryEditorMsg.SELECTENTRYTOMODIFY_STRING;
    public static final String ENTERNEWLOGICALNAME_STRING = JposEntryEditorMsg.ENTERNEWLOGICALNAME_STRING;
    public static final String VALIDNAME_STRING = JposEntryEditorMsg.VALIDNAME_STRING;
    public static final String USEDNAME_STRING = JposEntryEditorMsg.USEDNAME_STRING;
    public static final String SAVECURRENTCHANGES_STRING = JposEntryEditorMsg.SAVECURRENTCHANGES_STRING;
    public static final String OPENFILE_STRING = JposEntryEditorMsg.OPENFILE_STRING;
    public static final String NOENTRIES_STRING = JposEntryEditorMsg.NOENTRIES_STRING;
    public static final String ERROR_STRING = JposEntryEditorMsg.ERROR_STRING;
    public static final String CLOSECHANGES_STRING = JposEntryEditorMsg.CLOSECHANGES_STRING;
    public static final String CLOSEDFILE_STRING = JposEntryEditorMsg.CLOSEDFILE_STRING;
    public static final String CLOSEDFILEWITHCHANGES_STRING = JposEntryEditorMsg.CLOSEDFILEWITHCHANGES_STRING;
    public static final String SAVEDFILE_STRING = JposEntryEditorMsg.SAVEDFILE_STRING;
    public static final String ERRORSAVING_STRING = JposEntryEditorMsg.ERRORSAVING_STRING;
    public static final String SAVECHANGES_STRING = JposEntryEditorMsg.SAVECHANGES_STRING;
    public static final String CHANGESLOST_STRING = JposEntryEditorMsg.CHANGESLOST_STRING;
    public static final String LOADENTRIESJPOSREGISTRY_STRING = JposEntryEditorMsg.LOADENTRIESJPOSREGISTRY_STRING;
    public static final String NOENTRIESJPOSREGISTRY_STRING = JposEntryEditorMsg.NOENTRIESJPOSREGISTRY_STRING;
    public static final String ERRORSAVINGJPOSREGISTRY_STRING = JposEntryEditorMsg.ERRORSAVINGJPOSREGISTRY_STRING;
    public static final String SAVEDCHANGESTOREGISTRY_STRING = JposEntryEditorMsg.SAVEDCHANGESTOREGISTRY_STRING;
    public static final String SAVECHANGESJPOSREGISTRY_STRING = JposEntryEditorMsg.SAVECHANGESJPOSREGISTRY_STRING;
    public static final String CLOSEDJPOSREGISTRY_STRING = JposEntryEditorMsg.CLOSEDJPOSREGISTRY_STRING;
    public static final String METAL_STRING = JposEntryEditorMsg.METAL_STRING;
    public static final String JPOSPROPERTIES_STRING = "Shows the content of the jpos.properties...";
    public static final String JPOS_PROPERTIES_MENU_STRING = "JposProperties...";
    public static final String JPOSENTRY_MERGER_MENU_STRING = "JposEntry Merger...";
    public static final String JPOSENTRY_MERGER_TTTEXT_STRING = "XML<->Serialize JposEntry merger";
    public static final String ERROR_SAVING_ENTRIES_TO_FILE_MSG = "Error saving entries to file";
    public static final String ERROR_OPENING_ENTRIES_FILE_MSG = "Error opening entries file";
    public static final String ERROR_MESSAGE_TITLE_STRING = "Error loading entries";
    public static final String DELETE_OLD_ENTRY_WITH_LOGICAL_NAME_MSG = "Delete old entry with logical name = ";
    public static final String SAVEJPOSREGISTRYAS_STRING = "Save JposEntryRegistry As...";
    public static final String OVERWRITE_FILE_STRING = "File exists, overwrite?";
    public static final String EDITOR_MODE_MENU_STRING = "Editor mode";
    public static final String XML_EDITOR_MODE_MENU_STRING = "XML";
    public static final String SERIALIZED_EDITOR_MODE_MENU_STRING = "Serialized";
    public static final String XML_EDITOR_MODE_TTTEXT_STRING = "Switch editor mode to XML";
    public static final String SERIALIZED_EDITOR_MODE_TTTEXT_STRING = "Switch editor mode to Serialized";
    public static final String XML_EDITOR_MODE_TITLE_STRING = "[XML]";
    public static final String SER_EDITOR_MODE_TITLE_STRING = "[Serialized]";
    public static final String SELECTENTRYTOCOPY_STRING = "Select entry to copy.";
    public static final String SWITCH_EDITOR_MODE_MSG = "Switch editor mode and close file?";
    public static final String INVALID_SER_FILE_MSG = "Invalid or empty serialized file";

    public MainFrame() {
        super(MAINFRAME_TITLE);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.newFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.newFile();
            }
        });
        this.openFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.openFile();
            }
        });
        this.saveFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.saveFile();
            }
        });
        this.saveAsFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.saveAsFile();
            }
        });
        this.closeFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.registryMode) {
                    MainFrame.this.closeJposRegistry();
                } else {
                    MainFrame.this.closeFile();
                }
            }
        });
        this.addEntryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.addJposEntry();
            }
        });
        this.copyEntryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.copyJposEntry();
            }
        });
        this.removeEntryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.removeJposEntry();
            }
        });
        this.configButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.configDialog();
            }
        });
        this.aboutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.about();
            }
        });
        this.jposPropertiesSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.jposProperties();
            }
        });
        this.toolbar.add(this.newFileButton);
        this.toolbar.add(this.openFileButton);
        this.toolbar.add(this.saveFileButton);
        this.toolbar.add(this.saveAsFileButton);
        this.toolbar.add(this.closeFileButton);
        this.toolbar.add(new JToolBar.Separator());
        this.toolbar.add(this.addEntryButton);
        this.toolbar.add(this.copyEntryButton);
        this.toolbar.add(this.removeEntryButton);
        this.toolbar.add(new JToolBar.Separator());
        this.toolbar.add(this.configButton);
        this.toolbar.add(this.aboutButton);
        this.toolbar.setFloatable(false);
        jPanel.add((Component)this.toolbar, "West");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "North");
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), MESSAGES_STRING, 1, 1));
        this.bottomTextArea.setEditable(false);
        this.bottomTextArea.append(TOPOFFILE_STRING);
        this.bottomPanel.add((Component)this.bottomTextArea, "Center");
        this.hSplit = new JSplitPane(1, this.jposEntryTreePanel, this.jposEntryPanel);
        this.hSplit.setContinuousLayout(true);
        this.hSplit.setOneTouchExpandable(true);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.hSplit, "Center");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.bottomPanel);
        this.vSplit = new JSplitPane(0, jPanel2, jScrollPane);
        this.vSplit.setContinuousLayout(true);
        this.vSplit.setOneTouchExpandable(true);
        this.getContentPane().add((Component)this.vSplit, "Center");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(FILE_STRING);
        jMenu.add(this.newFileSubMenu);
        jMenu.add(this.openFileSubMenu);
        jMenu.add(this.saveFileSubMenu);
        jMenu.add(this.saveAsFileSubMenu);
        jMenu.addSeparator();
        jMenu.add(this.jposPropertiesSubMenu);
        jMenu.addSeparator();
        jMenu.add(this.loadJposRegistrySubMenu);
        jMenu.add(this.saveJposRegistrySubMenu);
        jMenu.add(this.saveJposRegistryAsSubMenu);
        jMenu.add(this.closeJposRegistrySubMenu);
        jMenu.addSeparator();
        jMenu.add(this.closeFileSubMenu);
        jMenu.addSeparator();
        jMenu.add(this.exitSubMenu);
        JMenu jMenu2 = new JMenu(EDIT_STRING);
        jMenu2.add(this.addJposEntrySubMenu);
        jMenu2.add(this.copyJposEntrySubMenu);
        jMenu2.add(this.removeJposEntrySubMenu);
        jMenu2.addSeparator();
        JMenu jMenu3 = new JMenu(EDITOR_MODE_MENU_STRING);
        this.editorModeButtonGroup.add(this.xmlEditorModeMenuItem);
        this.editorModeButtonGroup.add(this.serEditorModeMenuItem);
        jMenu3.add(this.xmlEditorModeMenuItem);
        jMenu3.add(this.serEditorModeMenuItem);
        jMenu2.add(jMenu3);
        jMenu2.addSeparator();
        jMenu2.add(this.jposEntryMergerSubMenu);
        jMenu2.addSeparator();
        jMenu2.add(this.configSubMenu);
        JMenu jMenu4 = new JMenu(HELP_STRING);
        jMenu4.add(this.aboutSubMenu);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu4);
        this.setJMenuBar(jMenuBar);
        this.initMenu();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.exit();
            }
        });
        this.jposEntryTreePanel.addJposEntryTreeListener(new JposEntryTreeListener(){

            public void newJposEntrySelected(JposEntryTreeEvent jposEntryTreeEvent) {
                MainFrame.this.newJposEntrySelected(jposEntryTreeEvent);
            }
        });
        this.newFileSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.newFile();
            }
        });
        this.openFileSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.openFile();
            }
        });
        this.saveFileSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.saveFile();
            }
        });
        this.saveAsFileSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.saveAsFile();
            }
        });
        this.jposPropertiesSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.jposProperties();
            }
        });
        this.loadJposRegistrySubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.loadJposRegistry();
            }
        });
        this.saveJposRegistrySubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.saveJposRegistry();
            }
        });
        this.saveJposRegistryAsSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.saveJposRegistryAs();
            }
        });
        this.closeJposRegistrySubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.closeJposRegistry();
            }
        });
        this.closeFileSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.closeFile();
            }
        });
        this.exitSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.exit();
            }
        });
        this.aboutSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.about();
            }
        });
        this.addJposEntrySubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.addJposEntry();
            }
        });
        this.copyJposEntrySubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.copyJposEntry();
            }
        });
        this.removeJposEntrySubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.removeJposEntry();
            }
        });
        this.addJposEntryPopupSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.addJposEntry();
            }
        });
        this.copyJposEntryPopupSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.copyJposEntry();
            }
        });
        this.removeJposEntryPopupSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.removeJposEntry();
            }
        });
        this.configSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.configDialog();
            }
        });
        this.jposEntryMergerSubMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.jposEntryMergerDialog();
            }
        });
        this.sortedRBMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.changeTreeView(0);
            }
        });
        this.categoryRBMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.changeTreeView(1);
            }
        });
        this.manufacturerRBMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.changeTreeView(2);
            }
        });
        this.autoExpandTreeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.autoExpandTreeSelected(MainFrame.this.autoExpandTreeMenuItem.getState());
            }
        });
        this.xmlEditorModeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.xmlEditorModeSelected();
            }
        });
        this.serEditorModeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.serEditorModeSelected();
            }
        });
        this.jposEntryTreePanel.setMainFrame(this);
        JPopupMenu jPopupMenu = new JPopupMenu();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sortedRBMenuItem);
        buttonGroup.add(this.categoryRBMenuItem);
        buttonGroup.add(this.manufacturerRBMenuItem);
        this.treeViewMenu.add(this.sortedRBMenuItem);
        this.treeViewMenu.add(this.categoryRBMenuItem);
        this.treeViewMenu.add(this.manufacturerRBMenuItem);
        this.treeViewMenu.addSeparator();
        this.treeViewMenu.add(this.autoExpandTreeMenuItem);
        jPopupMenu.add(this.treeViewMenu);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.addJposEntryPopupSubMenu);
        jPopupMenu.add(this.copyJposEntryPopupSubMenu);
        jPopupMenu.add(this.removeJposEntryPopupSubMenu);
        jPopupMenu.setBorderPainted(true);
        PopupListener popupListener = new PopupListener();
        this.jposEntryTreePanel.registerTreeForPopupMenu(jPopupMenu, popupListener);
        this.loadConfig();
    }

    private void loadConfig() {
        this.setLocation(this.jposEntryEditorConfig.getMainFrameLocation());
        this.setSize(this.jposEntryEditorConfig.getMainFrameSize());
        this.hSplit.setDividerLocation(this.jposEntryEditorConfig.getMainFrameHDividerLocation());
        this.vSplit.setDividerLocation(this.jposEntryEditorConfig.getMainFrameVDividerLocation());
        this.getConfigDialog().setExpandTreeCheckBox(this.jposEntryEditorConfig.getExpandTreeCheckBox());
        this.getConfigDialog().setShowAsHexCheckBox(this.jposEntryEditorConfig.getShowNumbersAsHexCheckBox());
        this.getConfigDialog().setAutoLoadCheckBox(this.jposEntryEditorConfig.getAutoLoadCheckBox());
        this.getConfigDialog().setLNFRadioButtonSelected(this.jposEntryEditorConfig.getCurrentLookAndFeel());
        this.getConfigDialog().setCurrentTreeViewButtonSelected(this.jposEntryEditorConfig.getCurrentTreeView());
        this.getConfigDialog().setAutoDeleteEntryOnCopy(this.jposEntryEditorConfig.getAutoDeleteEntryOnCopy());
        this.setCurrentTreeView(this.jposEntryEditorConfig.getCurrentTreeView());
        this.setExpandTreeFlag(this.jposEntryEditorConfig.getExpandTreeCheckBox());
        this.setAutoLoadFlag(this.jposEntryEditorConfig.getAutoLoadCheckBox());
        this.setShowAsHexFlag(this.jposEntryEditorConfig.getShowNumbersAsHexCheckBox());
        this.setLookAndFeel(this.jposEntryEditorConfig.getCurrentLookAndFeel());
        this.setAutoDeleteEntryOnCopy(this.jposEntryEditorConfig.getAutoDeleteEntryOnCopy());
        this.autoExpandTreeMenuItem.setState(this.jposEntryEditorConfig.getExpandTreeCheckBox());
        this.jposEntryPanel.initFromConfig();
        if (this.autoLoad) {
            this.loadJposRegistry();
        }
    }

    void saveConfig() {
        if (this.configReset) {
            return;
        }
        this.jposEntryEditorConfig.setMainFrameLocation(this.getLocation());
        this.jposEntryEditorConfig.setMainFrameSize(this.getSize());
        this.jposEntryEditorConfig.setMainFrameHDividerLocation(this.hSplit.getDividerLocation());
        this.jposEntryEditorConfig.setMainFrameVDividerLocation(this.vSplit.getDividerLocation());
        this.jposEntryEditorConfig.setCurrentTreeView(this.jposEntryTreePanel.getCurrentTreeView());
        this.jposEntryEditorConfig.setCurrentLookAndFeel(this.lookAndFeelSelected);
        this.jposEntryEditorConfig.setExpandTreeCheckBox(this.jposEntryTreePanel.getExpandTreeFlag());
        this.jposEntryEditorConfig.setShowNumbersAsHexCheckBox(this.jposEntryPanel.getJposEntryView().getShowNumbersAsHexFlag());
        this.jposEntryEditorConfig.setAutoLoadCheckBox(this.autoLoad);
        this.jposEntryEditorConfig.setAutoDeleteEntryOnCopy(this.getAutoDeleteEntryOnCopy());
        if (this.jFileChooser != null) {
            this.jposEntryEditorConfig.setFileDialogPath(this.jFileChooser.getCurrentDirectory().getAbsolutePath());
        }
        this.jposEntryEditorConfig.save();
    }

    private void initMenu() {
        this.newFileSubMenu.setEnabled(true);
        this.newFileButton.setEnabled(true);
        this.openFileSubMenu.setEnabled(true);
        this.openFileButton.setEnabled(true);
        this.saveFileSubMenu.setEnabled(false);
        this.saveFileButton.setEnabled(false);
        this.saveAsFileSubMenu.setEnabled(false);
        this.saveAsFileButton.setEnabled(false);
        this.loadJposRegistrySubMenu.setEnabled(true);
        this.saveJposRegistrySubMenu.setEnabled(false);
        this.closeJposRegistrySubMenu.setEnabled(false);
        this.closeFileSubMenu.setEnabled(false);
        this.closeFileButton.setEnabled(false);
        this.setEditMenuEnabled(false);
        this.exitSubMenu.setEnabled(true);
        this.aboutSubMenu.setEnabled(true);
        this.aboutButton.setEnabled(true);
        this.configSubMenu.setEnabled(true);
        this.configButton.setEnabled(true);
        this.newFileSubMenu.setToolTipText(NEWFILEMENU_STRING);
        this.newFileButton.setToolTipText(NEWFILEBUTTON_STRING);
        this.openFileSubMenu.setToolTipText(OPENFILEMENU_STRING);
        this.openFileButton.setToolTipText(OPENFILEBUTTON_STRING);
        this.saveFileSubMenu.setToolTipText(SAVEFILEMENU_STRING);
        this.saveFileButton.setToolTipText(SAVEFILEBUTTON_STRING);
        this.saveAsFileSubMenu.setToolTipText(SAVEASFILEMENU_STRING);
        this.saveAsFileButton.setToolTipText(SAVEASFILEBUTTON_STRING);
        this.jposPropertiesSubMenu.setToolTipText(JPOSPROPERTIES_STRING);
        this.loadJposRegistrySubMenu.setToolTipText(LOADJPOSREGISTRYMENU_STRING);
        this.saveJposRegistrySubMenu.setToolTipText(SAVEJPOSREGISTRYMENU_STRING);
        this.closeJposRegistrySubMenu.setToolTipText(CLOSEJPOSREGISTRYMENU_STRING);
        this.closeFileSubMenu.setToolTipText(CLOSEFILEMENU_STRING);
        this.closeFileButton.setToolTipText(CLOSEFILEBUTTON_STRING);
        this.exitSubMenu.setToolTipText(EXITMENU_STRING);
        this.addJposEntrySubMenu.setToolTipText(ADDMENU_STRING);
        this.addEntryButton.setToolTipText(ADDBUTTON_STRING);
        this.copyJposEntrySubMenu.setToolTipText(COPYMENU_STRING);
        this.copyEntryButton.setToolTipText(COPYMENU_STRING);
        this.removeJposEntrySubMenu.setToolTipText(DELETEMENU_STRING);
        this.removeEntryButton.setToolTipText(DELETEBUTTON_STRING);
        this.aboutSubMenu.setToolTipText(ABOUTMENU_STRING);
        this.aboutButton.setToolTipText(ABOUTBUTTON_STRING);
        this.configSubMenu.setToolTipText(CONFIGMENU_STRING);
        this.configButton.setToolTipText(CONFIGBUTTON_STRING);
        this.xmlEditorModeMenuItem.setToolTipText(XML_EDITOR_MODE_TTTEXT_STRING);
        this.serEditorModeMenuItem.setToolTipText(SERIALIZED_EDITOR_MODE_TTTEXT_STRING);
    }

    private void setEditMenuEnabled(boolean bl) {
        this.addJposEntrySubMenu.setEnabled(bl);
        this.addJposEntryPopupSubMenu.setEnabled(bl);
        this.addEntryButton.setEnabled(bl);
        this.copyJposEntrySubMenu.setEnabled(bl);
        this.copyJposEntryPopupSubMenu.setEnabled(bl);
        this.copyEntryButton.setEnabled(bl);
        this.removeJposEntrySubMenu.setEnabled(bl);
        this.removeJposEntryPopupSubMenu.setEnabled(bl);
        this.removeEntryButton.setEnabled(bl);
    }

    private void centerFrame() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
    }

    private boolean isEntriesChanged() {
        return this.entriesChanged;
    }

    private void addJposEntry() {
        JposEntry jposEntry;
        this.getAddJposEntryDialog().setModal(true);
        this.getAddJposEntryDialog().setVisible(true);
        if (!this.getAddJposEntryDialog().isCanceled() && (jposEntry = this.getAddJposEntryDialog().getJposEntry()) != null) {
            String string = (String)jposEntry.getPropertyValue("logicalName");
            this.jposEntryTreePanel.getJposEntryList().add(string, jposEntry);
            this.jposEntryPanel.clearAll();
            this.enableCopyDeleteSubMenus(false);
            this.jposEntryTreePanel.refreshTree();
            this.setEntriesChanged(true);
        }
    }

    private void removeJposEntry() {
        int n = this.jposEntryTreePanel.getSelectionCount();
        if (n <= 1) {
            this.removeJposEntry(this.jposEntryPanel.getJposEntry(), DELETEENTRYWITHLOGNAM_STRING + this.jposEntryPanel.getJposEntry().getLogicalName() + "?");
        } else {
            this.removeJposEntries(n, DELETESELECTEDENTRIES_STRING);
        }
    }

    private void removeJposEntry(JposEntry jposEntry, String string) {
        if (jposEntry == null) {
            JOptionPane.showMessageDialog(this, SELECTENTRYTODELETE_STRING, JPOSENTRYEDITOR_STRING, 0);
            return;
        }
        String string2 = jposEntry.getLogicalName();
        int n = JOptionPane.showConfirmDialog(this, string, JPOSENTRYEDITOR_STRING, 0, 3);
        if (n == 0) {
            this.jposEntryTreePanel.getJposEntryList().remove(string2);
            this.enableCopyDeleteSubMenus(false);
            this.jposEntryTreePanel.refreshTree();
            this.setEntriesChanged(true);
        }
    }

    private void removeJposEntries(int n, String string) {
        int n2 = JOptionPane.showConfirmDialog(this, string, JPOSENTRYEDITOR_STRING, 0, 3);
        if (n2 == 0) {
            TreePath[] treePathArray = this.jposEntryTreePanel.getSelectionPaths();
            for (int i = 0; i < n; ++i) {
                if (!this.jposEntryTreePanel.isSelectionPathValid(i, treePathArray)) continue;
                this.jposEntryTreePanel.setJposEntryToDelete(i, treePathArray);
                String string2 = this.jposEntryPanel.getJposEntry().getLogicalName();
                this.jposEntryTreePanel.getJposEntryList().remove(string2);
            }
            this.enableCopyDeleteSubMenus(false);
            this.jposEntryTreePanel.refreshTree();
            this.setEntriesChanged(true);
        }
    }

    private void copyJposEntry() {
        JposEntry jposEntry;
        JposEntry jposEntry2 = jposEntry = this.jposEntryPanel.getJposEntry();
        if (jposEntry == null) {
            JOptionPane.showMessageDialog(this, SELECTENTRYTOCOPY_STRING, JPOSENTRYEDITOR_STRING, 0);
            return;
        }
        String string = jposEntry.getLogicalName();
        String string2 = "";
        boolean bl = false;
        do {
            if ((string2 = JOptionPane.showInputDialog(this, ENTERNEWLOGICALNAME_STRING, JPOSENTRYEDITOR_STRING, 3)) == null) {
                return;
            }
            if (string2.equals("")) {
                JOptionPane.showMessageDialog(this, VALIDNAME_STRING, JPOSENTRYEDITOR_STRING, 0);
                continue;
            }
            if (this.jposEntryTreePanel.getJposEntryList().hasJposEntry(string2)) {
                JOptionPane.showMessageDialog(this, USEDNAME_STRING, JPOSENTRYEDITOR_STRING, 0);
                continue;
            }
            bl = true;
        } while (!bl);
        SimpleEntry simpleEntry = new SimpleEntry();
        simpleEntry.addProperty("logicalName", string2);
        simpleEntry.addProperty("serviceInstanceFactoryClass", jposEntry.getPropertyValue("serviceInstanceFactoryClass"));
        Enumeration enumeration = this.jposEntryPanel.getJposEntryView().getJposEntryProps();
        while (enumeration.hasMoreElements()) {
            JposEntryProp jposEntryProp = (JposEntryProp)enumeration.nextElement();
            simpleEntry.addProperty(jposEntryProp.getName(), jposEntryProp.getValue());
        }
        this.jposEntryTreePanel.getJposEntryList().add(string2, simpleEntry);
        this.jposEntryPanel.clearAll();
        this.enableCopyDeleteSubMenus(false);
        this.jposEntryTreePanel.refreshTree();
        this.setEntriesChanged(true);
        if (this.getAutoDeleteEntryOnCopy()) {
            this.removeJposEntry(jposEntry2, DELETE_OLD_ENTRY_WITH_LOGICAL_NAME_MSG + jposEntry2.getLogicalName() + "?");
        }
    }

    private void exit() {
        int n;
        this.saveConfig();
        if (this.isEntriesChanged() && (n = JOptionPane.showConfirmDialog(this, SAVECURRENTCHANGES_STRING, JPOSENTRYEDITOR_STRING, 0, 3)) == 0) {
            if (this.registryMode) {
                this.saveJposRegistry();
            } else {
                this.saveFile();
            }
        }
        if (this.getDefaultCloseOperation() == 3) {
            System.exit(0);
        } else if (this.getDefaultCloseOperation() == 1) {
            this.setVisible(false);
        } else if (this.getDefaultCloseOperation() == 2) {
            this.dispose();
        }
    }

    private void newFile() {
        if (this.jposEntryTreePanel.getJposEntryList() != null) {
            this.closeFile();
        }
        this.jposEntryPanel.clearAll();
        JposEntryList jposEntryList = new JposEntryList();
        if (this.xmlEditorMode) {
            jposEntryList.setRegPopulator(this.xmlRegPopulator);
        } else {
            jposEntryList.setRegPopulator(this.serRegPopulator);
        }
        this.jposEntryTreePanel.setJposEntryList(jposEntryList);
        this.updateTitle("JposEntry Editor- [NewFile<" + ++newFileCount + ">]");
        this.newFileSubMenu.setEnabled(false);
        this.newFileButton.setEnabled(false);
        this.openFileSubMenu.setEnabled(false);
        this.openFileButton.setEnabled(false);
        this.saveFileSubMenu.setEnabled(true);
        this.saveFileButton.setEnabled(true);
        this.saveAsFileSubMenu.setEnabled(true);
        this.saveAsFileButton.setEnabled(true);
        this.loadJposRegistrySubMenu.setEnabled(false);
        this.saveJposRegistrySubMenu.setEnabled(false);
        this.closeJposRegistrySubMenu.setEnabled(false);
        this.closeFileSubMenu.setEnabled(true);
        this.closeFileButton.setEnabled(true);
        this.addJposEntrySubMenu.setEnabled(true);
        this.addJposEntryPopupSubMenu.setEnabled(true);
        this.addEntryButton.setEnabled(true);
        this.copyJposEntrySubMenu.setEnabled(true);
        this.copyJposEntryPopupSubMenu.setEnabled(true);
        this.copyEntryButton.setEnabled(true);
        this.removeJposEntrySubMenu.setEnabled(false);
        this.removeJposEntryPopupSubMenu.setEnabled(false);
        this.removeEntryButton.setEnabled(false);
        this.setEntriesChanged(false);
        this.noFile = false;
    }

    private void openFile() {
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        JFileChooser jFileChooser = this.getJFileChooser();
        jFileChooser.setDialogTitle(OPEN_STRING);
        jFileChooser.setDialogType(0);
        jFileChooser.resetChoosableFileFilters();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(this.getJposEntryEditorFileFilter());
        if (jFileChooser.showOpenDialog(this) != 1) {
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                this.setCursor(cursor);
                return;
            }
            try {
                JposEntryList jposEntryList = new JposEntryList();
                if (this.xmlEditorMode) {
                    jposEntryList.setRegPopulator(this.xmlRegPopulator);
                } else {
                    jposEntryList.setRegPopulator(this.serRegPopulator);
                }
                jposEntryList.load(file.getAbsolutePath());
                if (!this.xmlEditorMode && jposEntryList.size() == 0) {
                    throw new Exception(INVALID_SER_FILE_MSG);
                }
                this.jposEntryPanel.clearAll();
                this.jposEntryTreePanel.setJposEntryList(jposEntryList);
                this.updateTitle("JposEntry Editor- [" + jposEntryList.getEntriesFileName() + "]");
                this.newFileSubMenu.setEnabled(false);
                this.newFileButton.setEnabled(false);
                this.openFileSubMenu.setEnabled(false);
                this.openFileButton.setEnabled(false);
                this.saveFileSubMenu.setEnabled(true);
                this.saveFileButton.setEnabled(true);
                this.saveAsFileSubMenu.setEnabled(true);
                this.saveAsFileButton.setEnabled(true);
                this.loadJposRegistrySubMenu.setEnabled(false);
                this.saveJposRegistrySubMenu.setEnabled(false);
                this.closeJposRegistrySubMenu.setEnabled(false);
                this.closeFileSubMenu.setEnabled(true);
                this.closeFileButton.setEnabled(true);
                this.addJposEntrySubMenu.setEnabled(true);
                this.addJposEntryPopupSubMenu.setEnabled(true);
                this.addEntryButton.setEnabled(true);
                this.copyJposEntrySubMenu.setEnabled(false);
                this.copyJposEntryPopupSubMenu.setEnabled(false);
                this.copyEntryButton.setEnabled(false);
                this.removeJposEntrySubMenu.setEnabled(false);
                this.removeJposEntryPopupSubMenu.setEnabled(false);
                this.removeEntryButton.setEnabled(false);
                this.setEntriesChanged(false);
                if (jposEntryList.size() > 0) {
                    Object[] objectArray = new Object[]{jposEntryList.getEntriesFileName(), new Integer(jposEntryList.size())};
                    this.println(MessageFormat.format(OPENFILE_STRING, objectArray));
                    this.jposEntryTreePanel.refreshTree();
                    this.jposEntryTreePanel.setTreeRootVisible(true);
                    this.jposEntryTreePanel.expandTree();
                } else {
                    this.println(NOENTRIES_STRING + jposEntryList.getEntriesFileName() + ".");
                }
            }
            catch (Exception exception) {
                String string = this.xmlEditorMode ? ERROR_OPENING_ENTRIES_FILE_MSG : INVALID_SER_FILE_MSG;
                JOptionPane.showMessageDialog(this, string, ERROR_MESSAGE_TITLE_STRING, 0);
                this.println(ERROR_STRING + file.getAbsolutePath());
            }
        }
        this.setCursor(cursor);
        this.noFile = false;
    }

    private void closeFile() {
        this.setClosing(true);
        this.jposEntryPanel.closingJposRegistryOrFile();
        if (this.isEntriesChanged() && !this.isSaved()) {
            int n = JOptionPane.showConfirmDialog(this, CLOSECHANGES_STRING, JPOSENTRYEDITOR_STRING, 0, 3);
            if (n == 0) {
                this.saveFile();
            } else {
                this.println(CLOSEDFILE_STRING);
            }
        }
        if (this.jposEntryTreePanel.getJposEntryList().getEntriesFileName() != "") {
            Object[] objectArray = new Object[]{this.jposEntryTreePanel.getJposEntryList().getEntriesFileName(), new Integer(this.jposEntryTreePanel.getJposEntryList().size())};
            this.println(MessageFormat.format(CLOSEDFILEWITHCHANGES_STRING, objectArray));
        }
        this.jposEntryPanel.setJposEntry(null);
        this.jposEntryPanel.clearAll();
        this.jposEntryPanel.setEnabledAll(false);
        this.jposEntryTreePanel.setJposEntryList(null);
        this.setEditMenuEnabled(false);
        this.updateTitle(MAINFRAME_TITLE);
        this.initMenu();
        this.setEntriesChanged(false);
        this.jposEntryTreePanel.setTreeRootVisible(false);
        this.setClosing(false);
        this.noFile = true;
    }

    private void saveFile() {
        if (!this.jposEntryTreePanel.getJposEntryList().isLoadedFromFile()) {
            this.saveAsFile();
            return;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            JposEntryList jposEntryList = this.jposEntryTreePanel.getJposEntryList();
            this.purgeJposEntryList(jposEntryList);
            jposEntryList.save();
            Object[] objectArray = new Object[]{jposEntryList.getEntriesFileName(), new Integer(jposEntryList.size())};
            this.println(MessageFormat.format(SAVEDFILE_STRING, objectArray));
            this.updateTitle("JposEntry Editor- [" + jposEntryList.getEntriesFileName() + "]");
            this.setSaved(true);
        }
        catch (Exception exception) {
            this.showErrorMessageToUser("Error saving entries to file: " + exception.getMessage());
            this.println(ERRORSAVING_STRING + this.jposEntryTreePanel.getJposEntryList().getEntriesFileName());
        }
        this.setCursor(cursor);
    }

    private boolean checkIfFileShouldBeOverwritten(String string) {
        File file = new File(string);
        if (file.exists()) {
            int n = JOptionPane.showConfirmDialog(this, OVERWRITE_FILE_STRING, JPOSENTRYEDITOR_STRING, 0, 3);
            return n == 0;
        }
        return true;
    }

    private void showErrorMessageToUser(String string) {
        JOptionPane.showMessageDialog(this, string, JPOSENTRYEDITOR_STRING, 0);
    }

    private void saveAsFile() {
        int n;
        if (this.jposEntryTreePanel.getJposEntryList() == null) {
            return;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        JFileChooser jFileChooser = this.getJFileChooser();
        jFileChooser.setDialogTitle(SAVEAS_STRING);
        jFileChooser.setDialogType(1);
        jFileChooser.resetChoosableFileFilters();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(this.getJposEntryEditorFileFilter());
        jFileChooser.setSelectedFile(null);
        if (jFileChooser.showSaveDialog(this) != 1) {
            boolean bl;
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                int n2 = JOptionPane.showConfirmDialog(this, SAVECHANGES_STRING, JPOSENTRYEDITOR_STRING, 0, 3);
                if (n2 == 0 && jFileChooser.getSelectedFile() != null) {
                    this.saveAsFile();
                } else {
                    this.jposEntryPanel.clearAll();
                    this.jposEntryTreePanel.setJposEntryList(null);
                    this.initMenu();
                    this.setEditMenuEnabled(false);
                    this.updateTitle(MAINFRAME_TITLE);
                    return;
                }
            }
            String string = file.getAbsolutePath();
            boolean bl2 = bl = this.registryMode ? this.isEditorInXmlMode() : this.xmlEditorMode;
            if (bl) {
                string = string.substring(string.length() - 4).equalsIgnoreCase(XML_EXTENSION_STRING) ? string : string + XML_EXTENSION_STRING;
            } else {
                String string2 = string = string.substring(string.length() - 4).equalsIgnoreCase(CFG_EXTENSION_STRING) ? string : string + CFG_EXTENSION_STRING;
            }
            if (!this.checkIfFileShouldBeOverwritten(string)) {
                this.setCursor(cursor);
                return;
            }
            this.jposEntryTreePanel.getJposEntryList().setEntriesFileName(string);
            try {
                JposEntryList jposEntryList = this.jposEntryTreePanel.getJposEntryList();
                this.purgeJposEntryList(jposEntryList);
                jposEntryList.save();
                Object[] objectArray = new Object[]{jposEntryList.getEntriesFileName(), new Integer(jposEntryList.size())};
                this.println(MessageFormat.format(SAVEDFILE_STRING, objectArray));
                this.updateTitle("JposEntry Editor- [" + jposEntryList.getEntriesFileName() + "]");
                this.setSaved(true);
                this.setEntriesChanged(false);
                this.addJposEntrySubMenu.setEnabled(true);
            }
            catch (Exception exception) {
                this.showErrorMessageToUser("Error saving entries to file: " + exception.getMessage());
                this.println(ERRORSAVING_STRING + this.jposEntryTreePanel.getJposEntryList().getEntriesFileName());
            }
        } else if (this.isClosing() && (n = JOptionPane.showConfirmDialog(this, CHANGESLOST_STRING, JPOSENTRYEDITOR_STRING, 0, 2)) == 1) {
            this.saveAsFile();
        }
        this.setCursor(cursor);
    }

    private void jposProperties() {
        this.getPropertiesEditorFrame().setProperties(JposServiceLoader.getManager().getProperties());
        this.getPropertiesEditorFrame().setVisible(true);
    }

    private void saveJposRegistryAs() {
        this.saveAsFile();
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.isEntriesChanged()) {
            this.saveJposRegistry();
        }
        this.loadJposRegistry();
        this.setCursor(cursor);
    }

    private void saveJposRegistry() {
        Object[] objectArray;
        JposEntryList jposEntryList;
        block9: {
            JposEntryRegistry jposEntryRegistry = JposServiceLoader.getManager().getEntryRegistry();
            this.jposEntryPanel.tabbedPaneStateChanged();
            try {
                Object object;
                Object object2;
                Object object3;
                jposEntryList = this.jposEntryTreePanel.getJposEntryList();
                objectArray = jposEntryList.getRemovedEntries();
                while (objectArray.hasMoreElements()) {
                    object3 = (JposEntry)objectArray.nextElement();
                    object2 = (String)object3.getPropertyValue("logicalName");
                    object = object3.getPropertyValue((String)object2);
                    if (!jposEntryRegistry.hasJposEntry((String)object2)) continue;
                    jposEntryRegistry.removeJposEntry((String)object2);
                }
                object3 = jposEntryList.getEntries();
                while (object3.hasMoreElements()) {
                    object2 = (JposEntry)object3.nextElement();
                    object = (String)object2.getPropertyValue("logicalName");
                    Object object4 = object2.getPropertyValue((String)object);
                    if (!this.verifyEntryValidity((JposEntry)object2)) {
                        this.jposEntryTreePanel.getJposEntryList().remove((String)object);
                        this.jposEntryTreePanel.refreshTree();
                        continue;
                    }
                    if (jposEntryRegistry.hasJposEntry((String)object)) {
                        if (jposEntryRegistry.getJposEntry((String)object).equals((JposEntry)object2)) continue;
                        jposEntryRegistry.modifyJposEntry((String)object, (JposEntry)object2);
                        continue;
                    }
                    jposEntryRegistry.addJposEntry((String)object, (JposEntry)object2);
                }
                try {
                    if (this.jposRegistryEntriesUrl != null && !this.jposRegistryEntriesUrl.equals("")) {
                        jposEntryRegistry.saveToFile(new File(new URL(this.jposRegistryEntriesUrl).getFile()));
                        break block9;
                    }
                    jposEntryRegistry.save();
                }
                catch (Exception exception) {
                    this.tracer.println("Exception while saving JposEntryRegistry exception.message=" + exception.getMessage());
                }
            }
            catch (Exception exception) {
                this.showErrorMessageToUser("Error saving entries to file: " + exception.getMessage());
                JOptionPane.showMessageDialog(this, ERRORSAVINGJPOSREGISTRY_STRING, JPOSENTRYEDITOR_STRING, 0);
                this.tracer.println(ERRORSAVINGJPOSREGISTRY_STRING);
            }
        }
        this.registryMode = true;
        this.setEntriesChanged(false);
        jposEntryList = this.jposEntryTreePanel.getJposEntryList();
        objectArray = new Object[]{new Integer(jposEntryList.size())};
        this.println(MessageFormat.format(SAVEDCHANGESTOREGISTRY_STRING, objectArray));
    }

    private void closeJposRegistry() {
        int n;
        this.jposEntryPanel.closingJposRegistryOrFile();
        if (this.isEntriesChanged() && (n = JOptionPane.showConfirmDialog(this, SAVECHANGESJPOSREGISTRY_STRING, JPOSENTRYEDITOR_STRING, 0, 3)) == 0) {
            this.saveJposRegistry();
        }
        this.newFileSubMenu.setEnabled(true);
        this.newFileButton.setEnabled(true);
        this.openFileSubMenu.setEnabled(true);
        this.openFileButton.setEnabled(true);
        this.saveFileSubMenu.setEnabled(false);
        this.saveFileButton.setEnabled(false);
        this.saveAsFileSubMenu.setEnabled(false);
        this.saveAsFileButton.setEnabled(false);
        this.loadJposRegistrySubMenu.setEnabled(true);
        this.saveJposRegistrySubMenu.setEnabled(false);
        this.saveJposRegistryAsSubMenu.setEnabled(false);
        this.closeJposRegistrySubMenu.setEnabled(false);
        this.closeFileButton.setEnabled(false);
        this.setEditMenuEnabled(false);
        this.jposEntryPanel.setJposEntry(null);
        this.jposEntryPanel.clearAll();
        this.jposEntryPanel.setEnabledAll(false);
        this.jposEntryTreePanel.setJposEntryList(null);
        this.registryMode = false;
        this.xmlEditorModeMenuItem.setEnabled(true);
        this.serEditorModeMenuItem.setEnabled(true);
        this.setEntriesChanged(false);
        this.setTitle(MAINFRAME_TITLE);
        if (this.xmlEditorMode) {
            this.xmlEditorModeMenuItem.setSelected(true);
        } else {
            this.serEditorModeMenuItem.setSelected(true);
        }
        this.updateTitle(this.getTitle());
        this.println(CLOSEDJPOSREGISTRY_STRING);
        this.jposEntryTreePanel.setTreeRootVisible(false);
    }

    private void loadJposRegistry() {
        Object object;
        this.newFileSubMenu.setEnabled(false);
        this.newFileButton.setEnabled(false);
        this.openFileSubMenu.setEnabled(false);
        this.openFileButton.setEnabled(false);
        this.saveFileSubMenu.setEnabled(false);
        this.saveFileButton.setEnabled(false);
        this.saveAsFileSubMenu.setEnabled(false);
        this.saveAsFileButton.setEnabled(false);
        this.loadJposRegistrySubMenu.setEnabled(false);
        this.saveJposRegistrySubMenu.setEnabled(true);
        this.saveJposRegistryAsSubMenu.setEnabled(true);
        this.closeJposRegistrySubMenu.setEnabled(true);
        this.closeFileSubMenu.setEnabled(false);
        this.closeFileButton.setEnabled(true);
        JposEntryRegistry jposEntryRegistry = JposServiceLoader.getManager().getEntryRegistry();
        JposEntryList jposEntryList = new JposEntryList();
        jposEntryRegistry.load();
        Enumeration enumeration = jposEntryRegistry.getEntries();
        while (enumeration.hasMoreElements()) {
            object = (JposEntry)enumeration.nextElement();
            if (!object.hasPropertyWithName("logicalName")) continue;
            jposEntryList.add(object.getLogicalName(), (JposEntry)object);
        }
        this.addJposEntrySubMenu.setEnabled(true);
        this.addJposEntryPopupSubMenu.setEnabled(true);
        this.addEntryButton.setEnabled(true);
        this.copyJposEntrySubMenu.setEnabled(false);
        this.copyJposEntryPopupSubMenu.setEnabled(false);
        this.copyEntryButton.setEnabled(false);
        this.removeJposEntrySubMenu.setEnabled(false);
        this.removeJposEntryPopupSubMenu.setEnabled(false);
        this.removeEntryButton.setEnabled(false);
        this.jposEntryPanel.clearAll();
        this.jposEntryTreePanel.setJposEntryList(jposEntryList);
        this.registryMode = true;
        this.xmlEditorModeMenuItem.setEnabled(false);
        this.serEditorModeMenuItem.setEnabled(false);
        if (jposEntryList.size() > 0) {
            object = new Object[]{new Integer(jposEntryList.size())};
            this.println(MessageFormat.format(LOADENTRIESJPOSREGISTRY_STRING, object));
            this.jposEntryTreePanel.refreshTree();
            this.jposEntryTreePanel.setTreeRootVisible(true);
            this.jposEntryTreePanel.expandTree();
        } else {
            this.println(NOENTRIESJPOSREGISTRY_STRING);
        }
        object = jposEntryRegistry.getRegPopulator().getEntriesURL().toExternalForm();
        this.jposRegistryEntriesUrl = this.updateEntriesUrl((String)object);
        this.setTitle("JposEntry Editor- [JposEntryRegistry] - " + this.jposRegistryEntriesUrl);
    }

    private String updateEntriesUrl(String string) {
        String string2 = string;
        try {
            JposProperties jposProperties;
            String string3 = "jpos.cfg";
            JposRegPopulator jposRegPopulator = JposServiceLoader.getManager().getEntryRegistry().getRegPopulator();
            if (jposRegPopulator instanceof XmlRegPopulator) {
                string3 = "jpos.xml";
            }
            if ((jposProperties = JposServiceLoader.getManager().getProperties()).isPropertyDefined("jpos.config.populatorFile")) {
                string3 = jposProperties.getPropertyString("jpos.config.populatorFile");
            } else if (jposProperties.isPropertyDefined("jpos.config.populatorFileURL")) {
                string3 = jposProperties.getPropertyString("jpos.config.populatorFileURL");
            }
            File file = FileUtil.findFile(string3, true);
            string2 = file.toURL().toExternalForm();
        }
        catch (Exception exception) {
            this.tracer.println("Error updating entries URL Exception.message = " + exception.getMessage());
        }
        return string2;
    }

    private boolean verifyEntryValidity(JposEntry jposEntry) {
        if (JposEntryUtility.isValidJposEntry(jposEntry)) {
            return true;
        }
        this.getInvalidEntryDialog().setInvalidEntry(jposEntry);
        this.getInvalidEntryDialog().setModal(true);
        this.getInvalidEntryDialog().setVisible(true);
        if (this.getInvalidEntryDialog().isSaveWithDefaultsButtonSelected()) {
            JposEntryUtility.addMissingRequiredProps(jposEntry);
            return true;
        }
        return false;
    }

    private void purgeJposEntryList(JposEntryList jposEntryList) {
        Enumeration enumeration = jposEntryList.getEntries();
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            String string = (String)jposEntry.getPropertyValue("logicalName");
            Object object = jposEntry.getPropertyValue(string);
            if (this.verifyEntryValidity(jposEntry)) continue;
            this.jposEntryTreePanel.getJposEntryList().remove(string);
            this.jposEntryTreePanel.refreshTree();
        }
    }

    private void about() {
        this.getAboutDialog().setVisible(true);
    }

    private void configDialog() {
        this.getConfigDialog().setVisible(true);
    }

    private void jposEntryMergerDialog() {
        this.getJposEntryMergerDialog().setVisible(true);
    }

    private JDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(this);
        }
        return this.aboutDialog;
    }

    public JposEntryEditorConfigDialog getConfigDialog() {
        if (this.configDialog == null) {
            this.configDialog = new JposEntryEditorConfigDialog(null);
        }
        this.configDialog.setMainFrame(this);
        return this.configDialog;
    }

    public JposEntryMergerDialog getJposEntryMergerDialog() {
        if (this.jposEntryMergerDialog == null) {
            this.jposEntryMergerDialog = new JposEntryMergerDialog(this);
        }
        return this.jposEntryMergerDialog;
    }

    private JFileChooser getJFileChooser() {
        if (this.jFileChooser == null) {
            this.jFileChooser = new JFileChooser();
            File file = null;
            try {
                file = new File(this.jposEntryEditorConfig.getFileDialogPath());
            }
            catch (Exception exception) {
                file = new File("");
                this.tracer.println("getJFileChooser: Exception.message = " + exception.getMessage());
            }
            this.jFileChooser.setCurrentDirectory(file);
        }
        return this.jFileChooser;
    }

    private PropertiesEditorFrame getPropertiesEditorFrame() {
        if (this.propEditorFrame == null) {
            this.propEditorFrame = new PropertiesEditorFrame();
        }
        return this.propEditorFrame;
    }

    private void newJposEntrySelected(JposEntryTreeEvent jposEntryTreeEvent) {
        JposEntry jposEntry = jposEntryTreeEvent.getJposEntry();
        if (jposEntry != null) {
            this.jposEntryPanel.tabbedPaneStateChanged();
            this.jposEntryPanel.setJposEntry(jposEntry);
            this.copyJposEntrySubMenu.setEnabled(true);
            this.copyJposEntryPopupSubMenu.setEnabled(true);
            this.copyEntryButton.setEnabled(true);
            this.removeJposEntrySubMenu.setEnabled(true);
            this.removeJposEntryPopupSubMenu.setEnabled(true);
            this.removeEntryButton.setEnabled(true);
        } else {
            this.jposEntryPanel.clearAll();
        }
    }

    private EditJposEntryDialog getEditJposEntryDialog() {
        if (this.editJposEntryDialog == null) {
            this.editJposEntryDialog = new EditJposEntryDialog(this);
        }
        return this.editJposEntryDialog;
    }

    private AddJposEntryDialog getAddJposEntryDialog() {
        if (this.addJposEntryDialog == null) {
            this.addJposEntryDialog = new AddJposEntryDialog(this);
        }
        return this.addJposEntryDialog;
    }

    private void newLnFSelected() {
        String string;
        String string2 = null;
        if (this.lookAndFeelSelected == 0 && this.isCurrentLnFMetal()) {
            return;
        }
        string2 = this.lookAndFeelSelected == 0 ? (string = UIManager.getCrossPlatformLookAndFeelClassName()) : (string = UIManager.getSystemLookAndFeelClassName());
        try {
            UIManager.setLookAndFeel(string2);
        }
        catch (Exception exception) {
            this.tracer.println("newLnFSelected: Exception.message=" + exception.getMessage());
        }
        this.updateLookAndFeel();
    }

    private boolean isCurrentLnFMetal() {
        return UIManager.getLookAndFeel().getID().equals(METAL_STRING);
    }

    private void setSaved(boolean bl) {
        this.saved = bl;
    }

    private boolean isSaved() {
        return this.saved;
    }

    private void setClosing(boolean bl) {
        this.closing = bl;
    }

    private boolean isClosing() {
        return this.closing;
    }

    private void changeTreeView(int n) {
        this.setCurrentTreeView(n);
        this.jposEntryEditorConfig.setCurrentTreeView(n);
        this.getConfigDialog().setCurrentTreeViewButtonSelected(n);
    }

    private void autoExpandTreeSelected(boolean bl) {
        this.setExpandTreeFlag(bl);
        this.jposEntryEditorConfig.setExpandTreeCheckBox(bl);
        this.getConfigDialog().setExpandTreeCheckBox(bl);
        this.jposEntryTreePanel.refreshTree();
    }

    private InvalidEntryDialog getInvalidEntryDialog() {
        if (this.invalidEntryDialog == null) {
            this.invalidEntryDialog = new InvalidEntryDialog(this);
        }
        return this.invalidEntryDialog;
    }

    private String getEditorModeSubtitleString() {
        if (this.xmlEditorMode) {
            return XML_EDITOR_MODE_TITLE_STRING;
        }
        return SER_EDITOR_MODE_TITLE_STRING;
    }

    private void updateTitle(String string) {
        String string2 = this.getEditorModeSubtitleString();
        String string3 = string;
        if (string.endsWith(XML_EDITOR_MODE_TITLE_STRING)) {
            string3 = string3.substring(0, string.length() - XML_EDITOR_MODE_TITLE_STRING.length());
        } else if (string.endsWith(SER_EDITOR_MODE_TITLE_STRING)) {
            string3 = string3.substring(0, string.length() - SER_EDITOR_MODE_TITLE_STRING.length());
        }
        this.setTitle((string3.endsWith(" ") ? string3 : string3 + " ") + string2);
    }

    private boolean okToSwithEditorMode() {
        int n = JOptionPane.showConfirmDialog(this, SWITCH_EDITOR_MODE_MSG, JPOSENTRYEDITOR_STRING, 0, 3);
        return n == 0;
    }

    private void xmlEditorModeSelected() {
        if (!this.noFile && !this.okToSwithEditorMode()) {
            this.serEditorModeMenuItem.setSelected(true);
            return;
        }
        this.closeFile();
        this.jposEntryTreePanel.getJposEntryList().setRegPopulator(this.xmlRegPopulator);
        this.xmlEditorMode = true;
        this.getJposEntryEditorFileFilter().setMode(0);
        this.updateTitle(this.getTitle());
    }

    private void serEditorModeSelected() {
        if (!this.noFile && !this.okToSwithEditorMode()) {
            this.xmlEditorModeMenuItem.setSelected(true);
            return;
        }
        this.closeFile();
        this.jposEntryTreePanel.getJposEntryList().setRegPopulator(this.serRegPopulator);
        this.xmlEditorMode = false;
        this.getJposEntryEditorFileFilter().setMode(1);
        this.updateTitle(this.getTitle());
    }

    void setEntriesChanged(boolean bl) {
        String string;
        String string2;
        this.entriesChanged = bl;
        if (bl) {
            this.setSaved(false);
        }
        if ((string2 = this.getTitle()).endsWith(string = this.getEditorModeSubtitleString())) {
            string2 = string2.substring(0, string2.length() - string.length());
        }
        if (bl && string2.endsWith("]") && !string2.endsWith("*]")) {
            string2 = string2.substring(0, string2.length() - 1) + "*]";
            this.updateTitle(string2);
        } else if (!bl && string2.endsWith("*]")) {
            string2 = string2.substring(0, string2.length() - 2) + "]";
            this.updateTitle(string2);
        }
    }

    void resetConfig() {
        this.jposEntryEditorConfig.reset();
        this.jposEntryEditorConfig.save();
        this.configReset = true;
    }

    public void updateLookAndFeel() {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        SwingUtilities.updateComponentTreeUI(this.getAboutDialog());
        SwingUtilities.updateComponentTreeUI(this.getJFileChooser());
        SwingUtilities.updateComponentTreeUI(this.getEditJposEntryDialog());
        SwingUtilities.updateComponentTreeUI(this.jposEntryTreePanel);
        SwingUtilities.updateComponentTreeUI(this.getConfigDialog());
        SwingUtilities.updateComponentTreeUI(this);
        this.invalidate();
        this.validate();
        this.repaint();
        this.setCursor(cursor);
    }

    public void print(String string) {
        this.bottomTextArea.append(string);
        this.bottomTextArea.moveCaretPosition(0);
        this.bottomTextArea.setCaretPosition(this.bottomTextArea.getText().length());
    }

    public void println(String string) {
        this.print(string + "\n");
        this.tracer.println(string);
    }

    public void enableCopyDeleteSubMenus(boolean bl) {
        this.copyJposEntrySubMenu.setEnabled(bl);
        this.copyJposEntryPopupSubMenu.setEnabled(bl);
        this.copyEntryButton.setEnabled(bl);
        this.removeJposEntrySubMenu.setEnabled(bl);
        this.removeJposEntryPopupSubMenu.setEnabled(bl);
        this.removeEntryButton.setEnabled(bl);
    }

    public JposEntryPanel getJposEntryPanel() {
        return this.jposEntryPanel;
    }

    public void setCurrentTreeView(int n) {
        this.jposEntryTreePanel.setCurrentTreeView(n);
    }

    public void setExpandTreeFlag(boolean bl) {
        this.jposEntryTreePanel.setExpandTreeFlag(bl);
    }

    public void setShowAsHexFlag(boolean bl) {
        this.jposEntryPanel.getJposEntryView().setShowNumbersAsHexFlag(bl);
        this.getEditJposEntryDialog().setShowNumbersAsHexFlag(bl);
        this.showAsHexFlag = bl;
    }

    public boolean getShowAsHexFlag() {
        return this.showAsHexFlag;
    }

    public void setAutoDeleteEntryOnCopy(boolean bl) {
        this.autoDeleteEntryOnCopy = bl;
    }

    public boolean getAutoDeleteEntryOnCopy() {
        return this.autoDeleteEntryOnCopy;
    }

    public void setAutoLoadFlag(boolean bl) {
        this.autoLoad = bl;
    }

    public void setLookAndFeel(int n) {
        this.lookAndFeelSelected = n;
        this.newLnFSelected();
    }

    public void setShowJCL12PropView(boolean bl) {
        this.jposEntryPanel.setShowJCL12PropView(bl);
    }

    public JposEntryEditorFileFilter getJposEntryEditorFileFilter() {
        if (this.jposEntryEditorFileFilter == null) {
            this.jposEntryEditorFileFilter = new JposEntryEditorFileFilter();
        }
        return this.jposEntryEditorFileFilter;
    }

    public boolean isEditorInXmlMode() {
        JposProperties jposProperties = JposServiceLoader.getManager().getProperties();
        return jposProperties.isPropertyDefined("jpos.config.regPopulatorClass") && jposProperties.getPropertyString("jpos.config.regPopulatorClass").endsWith("SimpleXmlRegPopulator");
    }
}

